/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.FlattenedList;
import thunderheadeng.util.theUtil;

public class ElementGroup<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final Entry<ElemT>[] entries;
    public final int numPrims;
    public final IElemSource<ElemT> defSrc;
    private transient SoftReference<int[]> d_entryOffsets = null;

    public ElementGroup(Entry[] entryArray, int n, IElemSource<ElemT> iElemSource) {
        assert (entryArray.length > 0);
        this.entries = entryArray;
        this.numPrims = n;
        this.defSrc = iElemSource;
    }

    protected int[] getEntryOffsets() {
        int[] nArray;
        if (this.d_entryOffsets != null && (nArray = this.d_entryOffsets.get()) != null) {
            return nArray;
        }
        nArray = this.calcEntryOffsets();
        this.d_entryOffsets = new SoftReference<int[]>(nArray);
        return nArray;
    }

    private int[] calcEntryOffsets() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Entry<ElemT> entry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Entry<ElemT> entry2 = this.entries[i];
            if (entry == null && entry2.primBegin > 0 || entry != null && entry2.primBegin > entry.primEnd) {
                arrayList.add(-i - 1);
            }
            arrayList.add(i);
            entry = entry2;
        }
        if (this.entries.length > 0 && this.numPrims > this.entries[this.entries.length - 1].primEnd) {
            arrayList.add(-this.entries.length - 1);
        }
        return theUtil.toIntArray(arrayList);
    }

    @Override
    public int getNumPrims() {
        return this.numPrims;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public ElementGroup<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        Entry[] entryArray = theUtil.lazyTransform(this.entries, Entry.class, entry -> entry.transform(clazz, unaryOperator));
        IElemSource<ElemT> iElemSource = this.defSrc.transform(clazz, unaryOperator);
        return entryArray == this.entries && iElemSource == this.defSrc ? this : new ElementGroup<ElemT>(entryArray, this.numPrims, iElemSource);
    }

    private int findIx(int n) {
        assert (n >= 0);
        int n2 = Arrays.binarySearch(this.entries, (Object)n);
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return n2;
    }

    private Entry<ElemT> find(int n) {
        int n2 = this.findIx(n);
        if (n2 < 0) {
            return null;
        }
        Entry<ElemT> entry = this.entries[n2];
        return n >= entry.primEnd ? null : entry;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int n) {
        int n2 = this.findIx(n);
        if (n2 < 0) {
            return this.defSrc;
        }
        Entry<ElemT> entry = this.entries[n2];
        if (n >= entry.primEnd) {
            return this.defSrc;
        }
        return entry.gen.getPrimSource(n - entry.primBegin);
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int n) {
        return new PrimIt(n);
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        int n3 = this.findIx(n);
        if (n3 < 0) {
            return this.defSrc.getPrimVertElement(0, n2);
        }
        Entry<ElemT> entry = this.entries[n3];
        if (n >= entry.primEnd) {
            return this.defSrc.getPrimVertElement(0, n2);
        }
        return entry.gen.getPrimVertElement(n - entry.primBegin, n2);
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        if (n == 0 && n2 == this.numPrims) {
            return this;
        }
        int n3 = n + n2 - 1;
        int n4 = this.findIx(n);
        if (n4 < 0 || n >= this.entries[n4].primEnd) {
            if (n4 >= this.entries.length - 1) {
                return this.defSrc;
            }
            Entry<ElemT> entry = this.entries[n4 + 1];
            if (n3 < entry.primBegin) {
                return this.defSrc;
            }
        } else if (n3 < this.entries[n4].primEnd) {
            Entry<ElemT> entry = this.entries[n4];
            return entry.gen.subset(n - entry.primBegin, n2);
        }
        return new ElementSubList(this, n, n2);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        return new FlattenedList(new EList(clazz, list, iElemSource, iPropsSrc));
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final Class<ElemT> type;
        private final List<? extends IPolygon> prims;
        private final IElemSource<Elements.Orient> primOrients;
        private final IPropsSrc props;

        public EList(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
            this.type = clazz;
            this.prims = list;
            this.primOrients = iElemSource;
            this.props = iPropsSrc;
        }

        @Override
        public int size() {
            return ElementGroup.this.getEntryOffsets().length;
        }

        @Override
        public List<ElemT> get(int n) {
            int n2 = ElementGroup.this.getEntryOffsets()[n];
            if (n2 >= 0) {
                Entry entry = ElementGroup.this.entries[n2];
                int n3 = entry.primEnd - entry.primBegin;
                return ElementGroup.this.entries[n2].gen.generate(this.type, this.prims.subList(entry.primBegin, entry.primEnd), this.primOrients.subset(entry.primBegin, n3), this.props.subset(entry.primBegin, n3));
            }
            int n4 = -n2 - 2;
            int n5 = n4 + 1;
            int n6 = n4 < 0 ? 0 : ElementGroup.this.entries[n4].primEnd;
            int n7 = n5 >= ElementGroup.this.entries.length ? ElementGroup.this.numPrims : ElementGroup.this.entries[n5].primBegin;
            int n8 = n7 - n6;
            return ElementGroup.this.defSrc.generate(this.type, this.prims.subList(n6, n7), this.primOrients.subset(n6, n8), this.props.subset(n6, n8));
        }
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private int ix;
        private int eix;
        private Iterator<IElemSource<ElemT>> entryit;

        private PrimIt(int n) {
            this.ix = n;
            this.eix = ElementGroup.this.findIx(n);
            this.entryit = this.eix < 0 || n >= ElementGroup.this.entries[this.eix].primEnd ? null : ElementGroup.this.entries[this.eix].gen.getPrimIterator(n - ElementGroup.this.entries[this.eix].primBegin);
        }

        @Override
        public boolean hasNext() {
            return this.ix < ElementGroup.this.numPrims;
        }

        @Override
        public IElemSource<ElemT> next() {
            IElemSource iElemSource;
            if (this.eix < 0) {
                iElemSource = ElementGroup.this.defSrc;
                ++this.ix;
                if (ElementGroup.this.entries.length > 0 && this.ix >= ElementGroup.this.entries[0].primBegin) {
                    this.eix = 0;
                    this.entryit = ElementGroup.this.entries[0].gen.getPrimIterator(0);
                }
            } else {
                Entry entry = ElementGroup.this.entries[this.eix];
                if (this.ix >= entry.primEnd) {
                    iElemSource = ElementGroup.this.defSrc;
                    ++this.ix;
                    this.tryEnterNextRange();
                } else {
                    iElemSource = this.entryit.next();
                    ++this.ix;
                    if (this.ix >= entry.primEnd && !this.tryEnterNextRange()) {
                        this.entryit = null;
                    }
                }
            }
            return iElemSource;
        }

        private boolean tryEnterNextRange() {
            if (this.eix < ElementGroup.this.entries.length - 1 && this.ix >= ElementGroup.this.entries[this.eix + 1].primBegin) {
                ++this.eix;
                this.entryit = ElementGroup.this.entries[this.eix].gen.getPrimIterator(0);
                return true;
            }
            return false;
        }
    }

    public static class Entry<ElemT>
    implements Serializable,
    Comparable<Integer> {
        static final long serialVersionUID = 1L;
        public final int primBegin;
        public final int primEnd;
        public IElemSource<ElemT> gen;

        public Entry(IElemSource<ElemT> iElemSource, int n, int n2) {
            this.primBegin = n;
            this.primEnd = n2;
            this.gen = iElemSource;
        }

        @Override
        public int compareTo(Integer n) {
            return this.primBegin - n;
        }

        public Entry<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
            IElemSource<ElemT> iElemSource = this.gen.transform(clazz, unaryOperator);
            return iElemSource == this.gen ? this : new Entry<ElemT>(iElemSource, this.primBegin, this.primEnd);
        }
    }
}

