/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.FlattenedList;
import thunderheadeng.util.theUtil;

public class ElementFlattened<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    private final IElemSource<ElemT>[] d_prims;

    public ElementFlattened(IElemSource<ElemT>[] iElemSourceArray) {
        this.d_prims = iElemSourceArray;
        assert (Stream.of(iElemSourceArray).noneMatch(iElemSource -> iElemSource instanceof ElementMesh && ((ElementMesh)iElemSource).getNumPrims() > 1));
    }

    public IElemSource<ElemT>[] getArray() {
        return this.d_prims;
    }

    @Override
    public int getNumPrims() {
        return this.d_prims.length;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public ElementFlattened<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        IElemSource[] iElemSourceArray = theUtil.lazyTransform(this.d_prims, IElemSource.class, iElemSource -> iElemSource.transform(clazz, unaryOperator));
        return iElemSourceArray == this.d_prims ? this : new ElementFlattened<ElemT>(iElemSourceArray);
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        if (n == 0 && n2 == this.d_prims.length) {
            return this;
        }
        if (n2 == 1) {
            return this.getPrimSource(n);
        }
        return new ElementSubList(this, n, n2);
    }

    @Override
    public IElemSource getPrimSource(int n) {
        return this.d_prims[n];
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        return this.d_prims[n].getPrimVertElement(0, n2);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        assert (list.size() == this.d_prims.length);
        return new FlattenedList(new EList(clazz, list, iPropsSrc, iElemSource));
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final List<? extends IPolygon> d_primList;
        private final Class<ElemT> d_type;
        private final IPropsSrc d_props;
        private final IElemSource<Elements.Orient> d_primOrients;

        private EList(Class<ElemT> clazz, List<? extends IPolygon> list, IPropsSrc iPropsSrc, IElemSource<Elements.Orient> iElemSource) {
            this.d_type = clazz;
            this.d_primList = list;
            this.d_props = iPropsSrc;
            this.d_primOrients = iElemSource;
        }

        @Override
        public List<ElemT> get(int n) {
            IPrimProps iPrimProps = this.d_props.get(n);
            return ElementFlattened.this.d_prims[n].generate(this.d_type, this.d_primList.subList(n, n + 1), this.d_primOrients.subset(n, n + 1), (IPropsSrc)new UniformProps(iPrimProps));
        }

        @Override
        public int size() {
            return ElementFlattened.this.d_prims.length;
        }

        @Override
        public Iterator<List<ElemT>> iterator() {
            return new It();
        }

        private class It
        implements Iterator<List<ElemT>> {
            private Iterator<? extends IPolygon> primit;
            private Iterator<IPrimProps> propit;
            private Iterator<IElemSource<Elements.Orient>> orientit;
            private int d_ix;

            private It() {
                this.primit = EList.this.d_primList.iterator();
                this.propit = EList.this.d_props.iterator();
                this.orientit = EList.this.d_primOrients.getPrimIterator();
                this.d_ix = 0;
            }

            @Override
            public boolean hasNext() {
                return this.d_ix < ElementFlattened.this.d_prims.length;
            }

            @Override
            public List<ElemT> next() {
                List list = ElementFlattened.this.d_prims[this.d_ix].generate(EList.this.d_type, Collections.singletonList(this.primit.next()), this.orientit.next(), (IPropsSrc)new UniformProps(this.propit.next()));
                ++this.d_ix;
                return list;
            }
        }
    }
}

