/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.ElementGroup;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.util.theUtil;

public class ElementBuilder<ElemT> {
    private final IElemSource<ElemT> d_emptySrc;
    private final Deque<BEntry<ElemT>> d_entries;

    public ElementBuilder(IElemSource<ElemT> iElemSource) {
        this.d_emptySrc = iElemSource;
        this.d_entries = new ArrayDeque<BEntry<ElemT>>();
    }

    private static <ElemT> void addEntry(Deque<BEntry<ElemT>> deque, List<IElemSource<ElemT>> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = deque.isEmpty() ? 0 : deque.getLast().primEnd;
        IElemSource iElemSource = list.size() == 1 ? list.get(0) : new ElementFlattened(theUtil.toArray(list, IElemSource.class));
        deque.addLast(new BEntry(iElemSource, n, n + list.size()));
    }

    public IElemSource<ElemT> finish() {
        if (this.d_entries.isEmpty()) {
            return this.d_emptySrc;
        }
        ArrayDeque<BEntry<ElemT>> arrayDeque = new ArrayDeque<BEntry<ElemT>>();
        ArrayList<IElemSource<ElemT>> arrayList = new ArrayList<IElemSource<ElemT>>();
        for (BEntry<ElemT> object2 : this.d_entries) {
            if (object2.primEnd - object2.primBegin == 1) {
                arrayList.add(object2.gen);
                continue;
            }
            if (!arrayList.isEmpty()) {
                ElementBuilder.addEntry(arrayDeque, arrayList);
                arrayList.clear();
            }
            arrayDeque.add(object2);
        }
        ElementBuilder.addEntry(arrayDeque, arrayList);
        if (arrayDeque.size() == 1) {
            return ((BEntry)arrayDeque.getFirst()).gen;
        }
        int n = arrayDeque.isEmpty() ? 0 : ((BEntry)arrayDeque.getLast()).primEnd;
        ArrayList arrayList2 = new ArrayList(arrayDeque.size());
        for (BEntry bEntry : arrayDeque) {
            if (bEntry.gen == this.d_emptySrc) continue;
            arrayList2.add(bEntry.toEntry());
        }
        return new ElementGroup<ElemT>(theUtil.toArray(arrayList2, ElementGroup.Entry.class), n, this.d_emptySrc);
    }

    public void add(Iterator<? extends IElemSource<ElemT>> iterator, int n) {
        for (int i = 0; i < n; ++i) {
            assert (iterator.hasNext());
            this.add(iterator.next(), 1);
        }
    }

    public void add(List<? extends IElemSource<ElemT>> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.add(list.get(i), 1);
        }
    }

    public void add(IElemSource<ElemT> iElemSource, int n) {
        if (n <= 0) {
            return;
        }
        assert (iElemSource.isUnbounded() || iElemSource.getNumPrims() >= n);
        if (iElemSource instanceof ElementGroup) {
            int n2;
            int n3 = n;
            ElementGroup elementGroup = (ElementGroup)iElemSource;
            for (int i = 0; i < elementGroup.entries.length && n3 > 0; n3 -= n2, ++i) {
                ElementGroup.Entry entry = elementGroup.entries[i];
                int n4 = n - n3;
                int n5 = Math.min(entry.primBegin - n4, n3);
                if (n5 > 0) {
                    this.add(elementGroup.defSrc, n5);
                    if ((n3 -= n5) == 0) break;
                }
                n2 = Math.min(entry.primEnd - entry.primBegin, n3);
                this.add(entry.gen, n2);
            }
            if (n3 > 0) {
                this.add(elementGroup.defSrc, n3);
            }
            return;
        }
        if (iElemSource.isComposite()) {
            Iterator<IElemSource<ElemT>> iterator = iElemSource.getPrimIterator();
            for (int i = 0; i < n; ++i) {
                this.add(iterator.next(), 1);
            }
            return;
        }
        if (!this.d_entries.isEmpty()) {
            BEntry<ElemT> bEntry = this.d_entries.getLast();
            if (iElemSource.isUnbounded() && bEntry.gen.isUnbounded() && bEntry.gen.equals(iElemSource)) {
                bEntry.primEnd += n;
                return;
            }
            IElemSource iElemSource2 = bEntry.gen.postConcatenate(iElemSource);
            if (iElemSource2 != null) {
                bEntry.gen = iElemSource2;
                bEntry.primEnd += n;
                return;
            }
            iElemSource2 = iElemSource.preConcatenate(bEntry.gen);
            if (iElemSource2 != null) {
                bEntry.gen = iElemSource2;
                bEntry.primEnd += n;
                return;
            }
        }
        int n6 = this.d_entries.isEmpty() ? 0 : this.d_entries.getLast().primEnd;
        int n7 = n6 + n;
        this.d_entries.add(new BEntry<ElemT>(iElemSource, n6, n7));
    }

    public int getNumPrims() {
        return this.d_entries.isEmpty() ? 0 : this.d_entries.getLast().primEnd;
    }

    private static class BEntry<ElemT> {
        public final int primBegin;
        public int primEnd;
        public IElemSource<ElemT> gen;

        public BEntry(IElemSource<ElemT> iElemSource, int n, int n2) {
            this.primBegin = n;
            this.primEnd = n2;
            this.gen = iElemSource;
        }

        public ElementGroup.Entry<ElemT> toEntry() {
            return new ElementGroup.Entry<ElemT>(this.gen, this.primBegin, this.primEnd);
        }
    }
}

