/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class Triangle
extends AFace
implements IPolygon {
    private static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public Triangle(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        this.p1 = point3d;
        this.p2 = point3d2;
        this.p3 = point3d3;
    }

    @Override
    public Triangle optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p1);
        Point3d point3d2 = iPointOptimizer.getExisting(this.p2);
        Point3d point3d3 = iPointOptimizer.getExisting(this.p3);
        return point3d != this.p1 || point3d2 != this.p2 || point3d3 != this.p3 ? new Triangle(point3d, point3d2, point3d3) : this;
    }

    @Override
    public Triangle flipOrient() {
        return new Triangle(this.p3, this.p2, this.p1);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.p1);
        aABox.add(this.p2);
        aABox.add(this.p3);
        return aABox;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public Triangle transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        return new Triangle(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2), Util3D.xform(matrix4d, this.p3));
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int n) {
        return 3;
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        return null;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    @Override
    public Vector3d getNormalIfValid(boolean bl) {
        return Util3D.simplePolygonNormal(Arrays.asList(this.p1, this.p2, this.p3), bl, 0.0);
    }

    @Override
    public Plane3d getPlane(boolean bl) {
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3), bl, 0.0);
        if (plane3d != null) {
            return plane3d;
        }
        return new Plane3d(GeomConstants.VEC3D_ZERO, this.p1);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean bl) {
        return Util3D.simplePolygonPlane(Arrays.asList(this.p1, this.p2, this.p3), bl, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
        Point3d[] point3dArray = new Point3d[]{this.p1, this.p2, this.p3};
        int[] nArray = new int[]{0, 1, 2};
        return new Pair<Mesh, Boolean>(new Mesh(point3dArray, nArray, 2), bl);
    }

    @Override
    public Supplier<Point3d> getPointGenerator(Random random) {
        return () -> Util3D.getRandomPointInTri(this.p1, this.p2, this.p3, random);
    }
}

