/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class Sphere
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Point3d center;
    public final double radius;

    public Sphere(Point3d point3d, double d) {
        this.center = point3d;
        this.radius = d;
    }

    @Override
    public Sphere transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        Point3d point3d = new Point3d(this.center);
        Point3d point3d2 = new Point3d(this.center.x + this.radius, this.center.y, this.center.z);
        matrix4d.transform(point3d);
        matrix4d.transform(point3d2);
        double d = point3d2.distance(point3d);
        if (point3d.equals(this.center) && d == this.radius) {
            return this;
        }
        return new Sphere(point3d, d);
    }

    @Override
    public IFace optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.center);
        if (point3d == this.center) {
            return this;
        }
        return new Sphere(point3d, this.radius);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBoundary(List<ICurve> list) {
    }

    @Override
    public Point3d project(Point3d point3d) {
        Vector3d vector3d = Util3D.vector(this.center, point3d);
        double d = Util3D.safeNormalize(vector3d, 1.0E-9);
        if (d == 0.0) {
            return new Point3d(this.center.x + this.radius, this.center.y, this.center.z);
        }
        vector3d.scale(this.radius);
        return Util3D.add(this.center, (Tuple3d)vector3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return IFace.PointClassify.INSIDE;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(new AABox(this.center.x - this.radius, this.center.y - this.radius, this.center.z - this.radius, this.center.x + this.radius, this.center.y + this.radius, this.center.z + this.radius));
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public Sphere flipOrient() {
        return this;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
    }
}

