/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AreaUtil;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ShapeGeom
implements IGeom {
    static final long serialVersionUID = 1L;
    public final transient Shape shape;
    public final Matrix4d lwXform;
    private transient SoftReference<Matrix4d> d_wlXform;

    public ShapeGeom(Shape shape, Matrix4d matrix4d) {
        this.shape = shape;
        this.lwXform = matrix4d;
    }

    public ShapeGeom(Shape shape, Plane3d plane3d) {
        this(shape, Util.getLocalToWorldXform(plane3d));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ShapeUtil.writeShape(objectOutputStream, this.shape);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Shape shape = ShapeUtil.readShape(objectInputStream);
        try {
            theUtil.assignFinalField(this, ShapeGeom.class, "shape", shape);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private static Matrix4d invert(Matrix4d matrix4d) {
        Matrix4d matrix4d2 = new Matrix4d(matrix4d);
        matrix4d2.invert();
        return matrix4d2;
    }

    public Matrix4d getWLXform() {
        Matrix4d matrix4d;
        Matrix4d matrix4d2 = matrix4d = this.d_wlXform != null ? this.d_wlXform.get() : null;
        if (matrix4d == null) {
            matrix4d = ShapeGeom.invert(this.lwXform);
            this.d_wlXform = new SoftReference<Matrix4d>(matrix4d);
        }
        return matrix4d;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public IGeom optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        AABox aABox2 = ShapeUtil.getBounds(this.shape, this.lwXform);
        aABox.add(aABox2);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = new Matrix4d(transformInfo.getMatrix());
        matrix4d.mul(this.lwXform);
        return new ShapeGeom(this.shape, matrix4d);
    }

    @Override
    public int getNumPrims(int n) {
        if (this.shape instanceof Area) {
            return (n & 1) != 0 ? 1 : 0;
        }
        if ((n & 2) != 0) {
            int n2 = 0;
            int n3 = 0;
            double[] dArray = new double[6];
            PathIterator pathIterator = this.shape.getPathIterator(null);
            while (!pathIterator.isDone()) {
                int n4 = pathIterator.currentSegment(dArray);
                switch (n4) {
                    case 0: {
                        if (n3 > 0) {
                            ++n2;
                        }
                        n3 = 0;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
                pathIterator.next();
            }
            if (n3 > 0) {
                ++n2;
            }
            return n2;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        if (this.shape instanceof Area) {
            collection.add(new AreaFace((Area)this.shape, this.lwXform, this.getWLXform(), false));
        } else {
            ShapeGeom.getCurves(collection, this.shape, this.lwXform, this.getWLXform());
        }
        return collection;
    }

    private static void getCurves(Collection<? super ICurve> collection, Shape shape, Matrix4d matrix4d, Matrix4d matrix4d2) {
        int n = 0;
        double[] dArray = new double[6];
        Path2D.Double double_ = new Path2D.Double();
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 == 0) {
                if (n > 0) {
                    collection.add(new ShapeCurve(double_, matrix4d, matrix4d2));
                    double_ = new Path2D.Double();
                }
                n = 0;
            } else {
                ++n;
            }
            switch (n2) {
                case 0: {
                    ((Path2D)double_).moveTo(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    ((Path2D)double_).lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    ((Path2D)double_).quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    ((Path2D)double_).curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    double_.closePath();
                }
            }
            pathIterator.next();
        }
        if (n > 0) {
            collection.add(new ShapeCurve(double_, matrix4d, matrix4d2));
        }
    }

    private static Point3d xform(Matrix4d matrix4d, Point2d point2d) {
        Point3d point3d = new Point3d(point2d.x, point2d.y, 0.0);
        matrix4d.transform(point3d);
        return point3d;
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        new GeomGroup(this.explode(new ArrayList<IGeom>())).pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.explode(new ArrayList<IGeom>())) {
            iGeom.find(iTest, iResult);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.explode(new ArrayList<IGeom>())) {
            iGeom.getAll(iResult);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        new GeomGroup(this.explode(new ArrayList<IGeom>())).pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    private static void pickPoints(IPrimitive iPrimitive, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest, Shape shape, Matrix4d matrix4d, Matrix4d matrix4d2) {
        boolean bl;
        GeomType geomType;
        GeomType geomType2;
        GeomType geomType3;
        if (shape instanceof Area) {
            geomType3 = GeomType.FACE_VERTEX;
            geomType2 = GeomType.FACE_EDGE;
            geomType = GeomType.FACE;
        } else {
            geomType3 = GeomType.EDGE_VERTEX;
            geomType2 = GeomType.EDGE;
            geomType = null;
        }
        boolean bl2 = iIsectFilter.acceptGeomType(object, geomType3);
        boolean bl3 = iIsectFilter.acceptGeomType(object, geomType2);
        boolean bl4 = bl = geomType != null && iIsectFilter.acceptGeomType(object, geomType);
        if (!(bl2 || bl3 || bl)) {
            return;
        }
        if (bl3 || bl) {
            point3d = Util3D.xform(matrix4d2, point3d);
            point3d2 = Util3D.xform(matrix4d2, point3d2);
            vector3d = Util3D.xform(matrix4d2, vector3d);
            vector3d.normalize();
        }
        if (bl2) {
            ShapeGeom.getVerts(iPrimitive, iIsectCollector, object, geomType3, shape, matrix4d);
        }
        if (bl3) {
            ShapeGeom.getClosestToEdges(iPrimitive, iIsectCollector, object, point3d, point3d2, vector3d, geomType2, shape, matrix4d);
        }
        if (bl) {
            ShapeGeom.getFaceIsect((IFace)iPrimitive, iIsectCollector, object, point3d, point3d2, vector3d, shape, matrix4d);
        }
    }

    private static void getVerts(IPrimitive iPrimitive, IIsectCollector iIsectCollector, Object object, GeomType geomType, Shape shape, Matrix4d matrix4d) {
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: 
                case 1: {
                    iIsectCollector.addNonFace(object, ShapeUtil.extract3d(matrix4d, dArray, 0), geomType);
                }
            }
            pathIterator.next();
        }
    }

    private static void getClosestToEdges(IPrimitive iPrimitive, IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, GeomType geomType, Shape shape, Matrix4d matrix4d) {
        Point3d point3d3 = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(point3d3, point3d, vector3d, 0.0, 1.0E-9)) {
            return;
        }
        Point2d point2d = new Point2d(point3d3.x, point3d3.y);
        double[] dArray = new double[6];
        Point2d point2d2 = null;
        Tuple2d tuple2d = null;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    point2d2 = ShapeUtil.extract2d(dArray, 0);
                    tuple2d = point2d2;
                    break;
                }
                case 1: {
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d4 = Inter2D.nearestToLineSeg(point2d, (Point2d)tuple2d, point2d3);
                    iIsectCollector.addNonFace(object, ShapeUtil.xform(matrix4d, point2d4.x, point2d4.y), geomType);
                    tuple2d = point2d3;
                    break;
                }
                case 2: {
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d4 = ShapeUtil.extract2d(dArray, 2);
                    Point2d point2d5 = ShapeGeom.nearestToQuadraticSpline(point2d, (Point2d)tuple2d, point2d3, point2d4);
                    iIsectCollector.addNonFace(object, ShapeUtil.xform(matrix4d, point2d5.x, point2d5.y), geomType);
                    tuple2d = point2d4;
                    break;
                }
                case 3: {
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d4 = ShapeUtil.extract2d(dArray, 2);
                    Point2d point2d5 = ShapeUtil.extract2d(dArray, 4);
                    Point2d point2d6 = ShapeGeom.nearestToCubicSpline(point2d, (Point2d)tuple2d, point2d3, point2d4, point2d5);
                    iIsectCollector.addNonFace(object, ShapeUtil.xform(matrix4d, point2d6.x, point2d6.y), geomType);
                    tuple2d = point2d5;
                    break;
                }
                case 4: {
                    if (tuple2d.equals(point2d2)) break;
                    Point2d point2d3 = Inter2D.nearestToLineSeg(point2d, (Point2d)tuple2d, point2d2);
                    iIsectCollector.addNonFace(object, ShapeUtil.xform(matrix4d, point2d3.x, point2d3.y), geomType);
                }
            }
            pathIterator.next();
        }
    }

    private static Point2d nearestToQuadraticSpline(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        Spline2D.Quadratic quadratic = new Spline2D.Quadratic(point2d2, point2d3, point2d4);
        double d = quadratic.getClosestT(point2d);
        return quadratic.get(d);
    }

    private static Point2d nearestToCubicSpline(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, Point2d point2d5) {
        Spline2D.Cubic cubic = new Spline2D.Cubic(point2d2, point2d3, point2d4, point2d5);
        double d = cubic.getClosestT(point2d);
        return cubic.get(d);
    }

    private static void getFaceIsect(IFace iFace, IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, Shape shape, Matrix4d matrix4d) {
        Point3d point3d3 = new Point3d();
        if (Inter3D.lineZPlaneIntersection(point3d3, point3d, vector3d, 0.0, 1.0E-9) && shape.contains(new Point2D.Double(point3d3.x, point3d3.y))) {
            iIsectCollector.addFace(object, ShapeUtil.xform(matrix4d, point3d3.x, point3d3.y), 0, () -> iFace, () -> {
                Vector3d vector3d = iFace instanceof AreaFace && ((AreaFace)iFace).flipped ? GeomConstants.VEC3D_ZNEG : GeomConstants.VEC3D_ZPOS;
                return Util3D.xform(matrix4d, vector3d);
            });
        }
    }

    public static class ShapeCurve
    extends ShapePrimitive<Shape>
    implements ICurve {
        private static final long serialVersionUID = -7694351870829991193L;

        public ShapeCurve(Shape shape, Matrix4d matrix4d, Matrix4d matrix4d2) {
            super(shape, matrix4d, matrix4d2);
        }

        @Override
        protected int getPrimType() {
            return 2;
        }

        @Override
        public ICurve optimize(IPointOptimizer iPointOptimizer) {
            return this;
        }

        @Override
        public ShapeCurve reverse() {
            return new ShapeCurve(ShapeUtil.reverseBoundary(this.shape), this.lwXform, this.wlXform);
        }

        @Override
        public Point3d project(Point3d point3d, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICurve transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = new Matrix4d(transformInfo.getMatrix());
            matrix4d.mul(this.lwXform);
            return new ShapeCurve(this.shape, matrix4d, ShapeGeom.invert(matrix4d));
        }

        @Override
        public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
            if (iIsectFilter.acceptGeomType(object, GeomType.EDGE) || iIsectFilter.acceptGeomType(object, GeomType.EDGE_VERTEX)) {
                this.getSegments(0.001).pickBox(object, iIsectFilter, convexHull, iBoxCollector);
            }
        }

        @Override
        public Mesh getSegments(double d) {
            int n;
            double[] dArray = new double[6];
            Point3d point3d = null;
            ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
            Point3d[] point3dArray = ShapeUtil.getPathIterator(this.shape, null, d);
            while (!point3dArray.isDone()) {
                n = point3dArray.currentSegment(dArray);
                switch (n) {
                    case 0: {
                        assert (arrayList.isEmpty());
                        point3d = ShapeUtil.extract3d(this.lwXform, dArray, 0);
                        arrayList.add(point3d);
                        break;
                    }
                    case 4: {
                        arrayList.add(point3d);
                        break;
                    }
                    case 1: {
                        arrayList.add(ShapeUtil.extract3d(this.lwXform, dArray, 0));
                    }
                }
                point3dArray.next();
            }
            point3dArray = arrayList.toArray(new Point3d[arrayList.size()]);
            n = point3dArray.length - 1;
            int[] nArray = new int[n * 2];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                nArray[n2++] = i;
                nArray[n2++] = i + 1;
            }
            return new Mesh(point3dArray, nArray, 1);
        }
    }

    public static class AreaFace
    extends ShapePrimitive<Area>
    implements IPlanarFace {
        private static final long serialVersionUID = 1L;
        public final boolean flipped;

        public AreaFace(Area area, Matrix4d matrix4d, Matrix4d matrix4d2, boolean bl) {
            super(area, matrix4d, matrix4d2);
            this.flipped = bl;
        }

        @Override
        public IFace optimize(IPointOptimizer iPointOptimizer) {
            return this;
        }

        @Override
        public IFace flipOrient() {
            Area area = ShapeUtil.reverseBoundary((Area)this.shape);
            return new AreaFace(area, this.lwXform, this.wlXform, !this.flipped);
        }

        @Override
        public IPolygon toPoly(double d) {
            IPolygon iPolygon = AreaUtil.toPoly((Area)this.shape, this.lwXform, d);
            if (this.flipped) {
                iPolygon = iPolygon.flipOrient();
            }
            return iPolygon;
        }

        @Override
        public Plane3d getPlaneIfValid(boolean bl) {
            Plane3d plane3d = Util.getPlane(this.lwXform);
            if (this.flipped == bl) {
                plane3d = plane3d.negate();
            }
            return plane3d;
        }

        @Override
        protected int getPrimType() {
            return 1;
        }

        @Override
        public Point3d project(Point3d point3d) {
            return Util.getPlane(this.lwXform).projectOntoPlane(point3d);
        }

        @Override
        public IFace.PointClassify classify(Point3d point3d, double d) {
            Matrix4d matrix4d = this.wlXform;
            point3d = Util3D.xform(matrix4d, point3d);
            return ((Area)this.shape).contains(point3d.x, point3d.y) ? IFace.PointClassify.INSIDE : IFace.PointClassify.OUTSIDE;
        }

        @Override
        public void getBoundary(List<ICurve> list) {
            ShapeGeom.getCurves(list, this.shape, this.lwXform, this.wlXform);
        }

        @Override
        public IFace transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = new Matrix4d(transformInfo.getMatrix());
            matrix4d.mul(this.lwXform);
            return new AreaFace((Area)this.shape, matrix4d, ShapeGeom.invert(matrix4d), this.flipped);
        }

        @Override
        public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
            if (iIsectFilter.acceptGeomType(object, GeomType.FACE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) {
                IPolygon iPolygon = AreaUtil.toPoly((Area)this.shape, this.lwXform, 0.001);
                iPolygon.pickBox(object, iIsectFilter, convexHull, iBoxCollector);
            }
        }

        @Override
        public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
            IPolygon iPolygon = AreaUtil.toPoly((Area)this.shape, this.lwXform, d);
            return iPolygon.triangulate(d, bl);
        }
    }

    public static abstract class ShapePrimitive<T extends Shape>
    extends APrimitive {
        private static final long serialVersionUID = 7214927285832809884L;
        public final T shape;
        public final Matrix4d lwXform;
        public final Matrix4d wlXform;

        public ShapePrimitive(T t, Matrix4d matrix4d, Matrix4d matrix4d2) {
            this.shape = t;
            this.lwXform = matrix4d;
            this.wlXform = matrix4d2;
        }

        @Override
        public AABox getBoundingBox(AABox aABox) {
            AABox aABox2 = ShapeUtil.getBounds(this.shape, this.lwXform);
            aABox.add(aABox2);
            return aABox;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.FREE;
        }

        @Override
        public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
            ShapeGeom.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest, this.shape, this.lwXform, this.wlXform);
        }
    }
}

