/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.util.HashPool;

public class PoolOptimizer
implements IPointOptimizer {
    public final HashPool<Point3d> point3dPool;
    public final HashPool<Vector3d> vector3dPool;
    public final HashPool<Point2d> point2dPool;
    public final HashPool<Vector2d> vector2dPool;

    public PoolOptimizer() {
        this(new HashPool<Point3d>(), new HashPool<Vector3d>(), new HashPool<Point2d>(), new HashPool<Vector2d>());
    }

    public PoolOptimizer(HashPool<Point3d> hashPool, HashPool<Vector3d> hashPool2, HashPool<Point2d> hashPool3, HashPool<Vector2d> hashPool4) {
        this.point2dPool = hashPool3;
        this.vector3dPool = hashPool2;
        this.point3dPool = hashPool;
        this.vector2dPool = hashPool4;
    }

    @Override
    public <T extends Tuple2d> T getExisting(T t) {
        if (t instanceof Point2d) {
            return (T)this.point2dPool.getExisting((Point2d)t);
        }
        return (T)this.vector2dPool.getExisting((Vector2d)t);
    }

    @Override
    public <T extends Tuple3d> T getExisting(T t) {
        if (t instanceof Point3d) {
            return (T)this.point3dPool.getExisting((Point3d)t);
        }
        return (T)this.vector3dPool.getExisting((Vector3d)t);
    }
}

