/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeneralPoly;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class PolyUtil {
    public static IPolygon newPoly(Point3d ... point3dArray) {
        return PolyUtil.newPoly(false, point3dArray);
    }

    public static IPolygon newPoly(boolean bl, Point3d ... point3dArray) {
        if (point3dArray.length == 3) {
            return new Triangle(point3dArray[0], point3dArray[1], point3dArray[2]);
        }
        if (point3dArray.length == 4 && Util3D.isConvex(1.0E-9, point3dArray)) {
            return new Quad(point3dArray[0], point3dArray[1], point3dArray[2], point3dArray[3]);
        }
        return new NGon(bl ? Arrays.copyOf(point3dArray, point3dArray.length) : point3dArray);
    }

    public static IPolygon newPoly(boolean bl, boolean bl2, Point3d ... point3dArray) {
        if (point3dArray.length == 3) {
            return new Triangle(point3dArray[0], point3dArray[1], point3dArray[2]);
        }
        if (point3dArray.length == 4 && bl2) {
            return new Quad(point3dArray[0], point3dArray[1], point3dArray[2], point3dArray[3]);
        }
        return new NGon(bl ? Arrays.copyOf(point3dArray, point3dArray.length) : point3dArray);
    }

    public static IPolygon newPoly(Point3d[] point3dArray, int[] nArray) {
        if (nArray.length <= 1) {
            return PolyUtil.newPoly(point3dArray);
        }
        return new GeneralPoly(point3dArray, nArray);
    }

    public static IPolygon newPoly(Point3d[][] point3dArray) {
        if (point3dArray.length == 0) {
            return new NGon(new Point3d[0]);
        }
        if (point3dArray.length == 1) {
            return PolyUtil.newPoly(point3dArray[0]);
        }
        return new GeneralPoly(point3dArray);
    }

    public static boolean polysEqual(IPolygon iPolygon, IPolygon iPolygon2) {
        int n = iPolygon.getNumLoops();
        if (n != iPolygon2.getNumLoops()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = iPolygon.getNumPoints(i);
            if (n3 != iPolygon2.getNumPoints(i)) {
                return false;
            }
            if (n3 == 0) {
                return true;
            }
            int n4 = -1;
            Point3d point3d = iPolygon.getPoint(i, 0);
            for (n2 = 0; n2 < n3; ++n2) {
                if (!point3d.equals(iPolygon2.getPoint(i, n2))) continue;
                n4 = n2;
                break;
            }
            if (n4 == -1) {
                return false;
            }
            int n5 = (n4 + 1) % n3;
            for (n2 = 1; n2 < n3; ++n2) {
                Point3d point3d2;
                Point3d point3d3 = iPolygon.getPoint(i, n2);
                if (!point3d3.equals(point3d2 = iPolygon2.getPoint(i, n5))) {
                    return false;
                }
                n5 = (n5 + 1) % n3;
            }
        }
        return true;
    }

    public static void getBoundary(List<ICurve> list, IPolygon iPolygon) {
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            Point3d[] point3dArray = new Point3d[iPolygon.getNumPoints(i) + 1];
            for (int j = 0; j < point3dArray.length - 1; ++j) {
                point3dArray[j] = iPolygon.getPoint(i, j);
            }
            point3dArray[point3dArray.length - 1] = point3dArray[0];
            list.add(new PolyLine(point3dArray));
        }
    }

    public static Point3d[] getAllVerts(IPolygon iPolygon, boolean bl) {
        if (!bl && iPolygon instanceof NGon) {
            return ((NGon)iPolygon).points;
        }
        if (!bl && iPolygon instanceof GeneralPoly) {
            return ((GeneralPoly)iPolygon).points;
        }
        int n = PolyUtil.getNumVerts(iPolygon);
        int n2 = 0;
        Point3d[] point3dArray = new Point3d[n];
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            int n3 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n3; ++j) {
                point3dArray[n2++] = iPolygon.getPoint(i, j);
            }
        }
        return point3dArray;
    }

    public static int getNumVerts(IPolygon iPolygon) {
        int n = 0;
        int n2 = iPolygon.getNumLoops();
        for (int i = 0; i < n2; ++i) {
            n += iPolygon.getNumPoints(i);
        }
        return n;
    }

    public static Point3d[][] getLoops(IPolygon iPolygon, boolean bl) {
        if (!bl && iPolygon instanceof NGon) {
            return new Point3d[][]{((NGon)iPolygon).points};
        }
        Point3d[][] point3dArray = new Point3d[iPolygon.getNumLoops()][];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = PolyUtil.getLoop(iPolygon, i, bl);
        }
        return point3dArray;
    }

    public static int[] getLoopOffsets(IPolygon iPolygon, boolean bl) {
        if (!bl && iPolygon instanceof GeneralPoly) {
            return ((GeneralPoly)iPolygon).loopOffsets;
        }
        int[] nArray = new int[iPolygon.getNumLoops()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
            n += iPolygon.getNumPoints(i);
        }
        return nArray;
    }

    public static Point3d[] getLoop(IPolygon iPolygon, int n, boolean bl) {
        if (!bl && iPolygon instanceof NGon) {
            assert (n == 0);
            return ((NGon)iPolygon).points;
        }
        int n2 = iPolygon.getNumPoints(n);
        Point3d[] point3dArray = new Point3d[n2];
        for (int i = 0; i < n2; ++i) {
            point3dArray[i] = iPolygon.getPoint(n, i);
        }
        return point3dArray;
    }

    public static boolean isConvex(IPolygon iPolygon) {
        if (iPolygon.getNumLoops() != 1) {
            return false;
        }
        if (iPolygon instanceof Triangle || iPolygon.getNumPoints(0) == 3) {
            return true;
        }
        Point3d[] point3dArray = PolyUtil.getLoop(iPolygon, 0, false);
        return Util3D.isConvex(1.0E-6, point3dArray);
    }

    public static void pickBox(Object object, int n, IPolygon iPolygon, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        block12: {
            block10: {
                block11: {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.FACE)) break block10;
                    if (!PolyUtil.isConvex(iPolygon)) break block11;
                    assert (iPolygon.getNumLoops() == 1);
                    int n2 = iPolygon.getNumPoints(0);
                    Point3d[] point3dArray = new Point3d[n2];
                    for (int i = 0; i < n2; ++i) {
                        point3dArray[i] = iPolygon.getPoint(0, i);
                    }
                    Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(point3dArray), true);
                    if (plane3d == null || !convexHull.intersectsConvexPoly(1.0E-6, plane3d, point3dArray)) break block12;
                    iBoxCollector.addFace(object, n, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(point3dArray), plane3d.getNormal()));
                    break block12;
                }
                Mesh mesh = iPolygon.triangulate(1.0E-6);
                Point3d[] point3dArray = new Point3d[3];
                Plane3d plane3d = new Plane3d();
                int n3 = 0;
                while (n3 < mesh.indices.length) {
                    point3dArray[0] = mesh.vertices[mesh.indices[n3++]];
                    point3dArray[1] = mesh.vertices[mesh.indices[n3++]];
                    point3dArray[2] = mesh.vertices[mesh.indices[n3++]];
                    plane3d.set(true, point3dArray);
                    if (!plane3d.isValid() || !convexHull.intersectsConvexPoly(1.0E-6, plane3d, point3dArray)) continue;
                    Vector3d vector3d = plane3d.getNormal();
                    iBoxCollector.addFace(object, n, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(point3dArray), vector3d));
                }
                break block12;
            }
            if (iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) {
                int n4 = iPolygon.getNumLoops();
                for (int i = 0; i < n4; ++i) {
                    int n5 = iPolygon.getNumPoints(i);
                    for (int j = 0; j < n5; ++j) {
                        Point3d point3d;
                        Point3d point3d2 = iPolygon.getPoint(i, j);
                        if (!convexHull.intersectsLineSeg(point3d2, point3d = iPolygon.getPoint(i, (j + 1) % n5), 1.0E-6)) continue;
                        iBoxCollector.addNonFace(object);
                    }
                }
            } else if (iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) {
                int n6 = iPolygon.getNumLoops();
                for (int i = 0; i < n6; ++i) {
                    int n7 = iPolygon.getNumPoints(i);
                    for (int j = 0; j < n7; ++j) {
                        if (!convexHull.contains(iPolygon.getPoint(i, j), 1.0E-6)) continue;
                        iBoxCollector.addNonFace(object);
                    }
                }
            }
        }
    }

    public static void pickPoints(IPolygon iPolygon, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE)) {
            Plane3d plane3d = iPolygon.getPlane(true);
            if (!plane3d.isValid()) {
                return;
            }
            Point3d point3d3 = PolyUtil.getFaceIsect(iPolygon, plane3d, object, point3d, point3d2, vector3d);
            if (point3d3 != null) {
                iIsectCollector.addFace(object, point3d3, 0, () -> iPolygon, plane3d::getNormal);
            }
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) {
            PolyUtil.getFaceVertices(iPolygon, object, iIsectCollector);
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) {
            PolyUtil.getClosestToEdges(iPolygon, object, iIsectCollector, point3d, point3d2, vector3d);
        }
    }

    private static void getFaceVertices(IPolygon iPolygon, Object object, IIsectCollector iIsectCollector) {
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n2; ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                iIsectCollector.addNonFace(object, point3d, GeomType.FACE_VERTEX);
            }
        }
    }

    private static void getClosestToEdges(IPolygon iPolygon, Object object, IIsectCollector iIsectCollector, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = new Point3d();
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            if (n2 == 0) continue;
            Point3d point3d4 = iPolygon.getPoint(i, 0);
            for (int j = 1; j <= n2; ++j) {
                Point3d point3d5 = iPolygon.getPoint(i, j % n2);
                boolean bl = Inter3D.lineLineSegProximity(null, point3d3, point3d, vector3d, point3d4, point3d5);
                if (bl) {
                    iIsectCollector.addNonFace(object, new Point3d(point3d3), GeomType.FACE_EDGE);
                }
                point3d4 = point3d5;
            }
        }
    }

    private static Point3d getFaceIsect(IPolygon iPolygon, Plane3d plane3d, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, plane3d, 1.0E-6);
        if (point3d3 == null) {
            return null;
        }
        return iPolygon.classify((Point3d)point3d3, (double)1.0E-6).positive ? point3d3 : null;
    }

    public static IPolygon reverse(IPolygon iPolygon) {
        int n = iPolygon.getNumLoops();
        Point3d[][] point3dArray = new Point3d[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            Point3d[] point3dArray2 = new Point3d[n2];
            for (int j = 0; j < n2; ++j) {
                point3dArray2[n2 - 1 - j] = iPolygon.getPoint(i, j);
            }
            point3dArray[i] = point3dArray2;
        }
        return PolyUtil.newPoly(point3dArray);
    }

    protected static IFace.PointClassify classify(IPolygon iPolygon, Point3d point3d, double d) {
        int n;
        if (iPolygon.getNumLoops() == 0 || iPolygon.getNumPoints(0) == 0) {
            return IFace.PointClassify.OUTSIDE;
        }
        if (iPolygon.getNumLoops() == 1 && (n = iPolygon.getNumPoints(0)) == 3) {
            return PolyUtil.convert(Inter3D.classifyConvexPolyPoint(d, point3d, iPolygon.getPoint(0, 0), iPolygon.getPoint(0, 1), iPolygon.getPoint(0, 2)));
        }
        Plane3d plane3d = new Plane3d(iPolygon.getNormal(true), iPolygon.getPoint(0, 0));
        Point3d[][] point3dArray = PolyUtil.getLoops(iPolygon, false);
        return PolyUtil.convert(Inter3D.classifySimplePolyPoint(1.0E-6, point3d, plane3d, point3dArray));
    }

    private static IFace.PointClassify convert(Inter3D.PointClassify pointClassify) {
        switch (pointClassify) {
            case INSIDE: {
                return IFace.PointClassify.INSIDE;
            }
            case ON_BOUNDARY: {
                return IFace.PointClassify.ON_BOUNDARY;
            }
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public static Collection<? extends IHandle> generateManipHandles(IPolygon iPolygon) {
        ArrayList<IHandle> arrayList = new ArrayList<IHandle>();
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n2; ++j) {
                arrayList.add(new VertHandle(iPolygon, i, j));
            }
        }
        arrayList.add(new OffsetHandle(iPolygon));
        return arrayList;
    }

    private static class OffsetHandle
    extends APlaneHandle<IPolygon> {
        public OffsetHandle(IPolygon iPolygon) {
            super(iPolygon);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof OffsetHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode((IGeom)this.getManipGeom());
        }

        @Override
        protected Vector3d getPlaneNormal(IPolygon iPolygon) {
            return iPolygon.getNormal(true);
        }

        @Override
        protected IPolygon modify(IPolygon iPolygon, double d) {
            Vector3d vector3d = iPolygon.getNormal(true);
            ITransform iTransform = TransformUtil.translate(vector3d.x * d, vector3d.y * d, vector3d.z * d);
            return iPolygon.transform(iTransform.getInfo(), 1);
        }
    }

    private static class VertHandle
    implements IHandle {
        private IPolygon geom;
        private final int loop;
        private final int vert;
        private Point3d[][] d_loops;

        public VertHandle(IPolygon iPolygon, int n, int n2) {
            this.geom = iPolygon;
            this.loop = n;
            this.vert = n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof VertHandle)) {
                return false;
            }
            VertHandle vertHandle = (VertHandle)object;
            return vertHandle.loop == this.loop && vertHandle.vert == this.vert;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.getLocation()));
        }

        protected Point3d getLocation() {
            return this.geom.getPoint(this.loop, this.vert);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            Plane3d plane3d = this.geom.getPlane(true);
            return new PlanarConstraint(plane3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.d_loops = PolyUtil.getLoops(this.geom, true);
        }

        @Override
        public IPolygon modify(Point3d point3d) throws ManipException {
            this.d_loops[this.loop][this.vert] = point3d;
            this.geom = PolyUtil.newPoly(this.d_loops);
            return this.geom;
        }

        @Override
        public Object end() {
            this.d_loops = null;
            return this.geom;
        }
    }
}

