/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public class PolyLine
extends ACurve
implements ILinearCurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d[] verts;

    public PolyLine(Point3d ... point3dArray) {
        this.verts = point3dArray;
        assert (point3dArray.length > 1);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.verts);
        return aABox;
    }

    @Override
    public PolyLine reverse() {
        return new PolyLine(GeomUtil.reverse(this.verts, Point3d.class));
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public int getNumVerts() {
        return this.verts.length;
    }

    @Override
    public Point3d getVert(int n) {
        return this.verts[n];
    }

    @Override
    public ILinearCurve optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.verts.length];
        for (int i = 0; i < this.verts.length; ++i) {
            Point3d point3d = this.verts[i];
            Point3d point3d2 = iPointOptimizer.getExisting(point3d);
            bl |= point3d2 != point3d;
            point3dArray[i] = point3d2;
        }
        return bl ? new PolyLine(point3dArray) : this;
    }

    @Override
    public ILinearCurve transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        return new PolyLine(GeomUtil.xformVerts(this.verts, transformInfo.getMatrix()));
    }

    @Override
    public Mesh getSegments(double d) {
        int[] nArray = new int[(this.verts.length - 1) * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.verts.length - 1) {
            nArray[n++] = n2++;
            nArray[n++] = n2;
        }
        return new Mesh(this.verts, nArray, 1);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        block3: {
            block2: {
                if (!iIsectFilter.acceptGeomType(object, GeomType.EDGE)) break block2;
                for (int i = 0; i < this.verts.length - 1; ++i) {
                    Point3d point3d = this.verts[i];
                    Point3d point3d2 = this.verts[i + 1];
                    if (!convexHull.intersectsLineSeg(point3d, point3d2, 1.0E-6)) continue;
                    iBoxCollector.addNonFace(object);
                }
                break block3;
            }
            if (!iIsectFilter.acceptGeomType(object, GeomType.EDGE_VERTEX)) break block3;
            for (Point3d point3d : this.verts) {
                if (!convexHull.contains(point3d, 1.0E-6)) continue;
                iBoxCollector.addNonFace(object);
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE_VERTEX)) {
            for (Point3d object2 : this.verts) {
                iIsectCollector.addNonFace(object, object2, GeomType.EDGE_VERTEX);
            }
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
            for (int i = 0; i < this.verts.length - 1; ++i) {
                Point3d point3d3 = this.verts[i];
                Point3d point3d4 = this.verts[i + 1];
                double[] dArray = Inter3D.getNearestTLinesegLineSeg(point3d, point3d2, point3d3, point3d4, 1.0E-6);
                if (dArray == null || dArray[1] == 1.0 && i < this.verts.length - 2) continue;
                iIsectCollector.addNonFace(object, Util3D.linesegPoint(point3d3, point3d4, dArray[1]), GeomType.EDGE);
            }
        }
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        Point3d point3d2 = null;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.verts.length - 1; ++i) {
            Point3d point3d3 = this.verts[i];
            Point3d point3d4 = this.verts[i + 1];
            Point3d point3d5 = Inter3D.nearestPointOnLineSeg(point3d3, point3d4, point3d);
            double d3 = point3d.distanceSquared(point3d5);
            if (!(d3 < d2)) continue;
            d2 = d3;
            point3d2 = point3d5;
        }
        return point3d2;
    }

    @Override
    public ILinearCurve newCurve(Point3d ... point3dArray) {
        return new PolyLine(point3dArray);
    }
}

