/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class Point
extends APrimitive
implements IPrimitive,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;

    public Point(Point3d point3d) {
        this.loc = point3d;
    }

    @Override
    public Point optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.loc);
        return point3d != this.loc ? new Point(point3d) : this;
    }

    public int hashCode() {
        return 65087 + this.loc.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Point && ((Point)object).loc.equals(this.loc);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.loc);
        return aABox;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IPrimitive transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        return new Point(Util3D.xform(transformInfo.getMatrix(), this.loc));
    }

    @Override
    protected int getPrimType() {
        return 4;
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX) && convexHull.contains(this.loc, 1.0E-6)) {
            iBoxCollector.addNonFace(object);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) {
            iIsectCollector.addNonFace(object, this.loc, GeomType.VERTEX);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private Point geom;

        public Handle(Point point) {
            this.geom = point;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            this.geom = new Point(point3d);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

