/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PlanarSurface
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;
    private static final AABox s_infBox = new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public PlanarSurface(Plane3d plane3d) {
        this.plane = plane3d;
    }

    @Override
    public PlanarSurface flipOrient() {
        return new PlanarSurface(this.plane.negate());
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        boolean bl = theUtil.eq0(this.plane.x, 1.0E-9);
        boolean bl2 = theUtil.eq0(this.plane.y, 1.0E-9);
        if (bl && bl2) {
            aABox.add(new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.z * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.z * this.plane.w));
            return aABox;
        }
        boolean bl3 = theUtil.eq0(this.plane.z, 1.0E-9);
        if (bl && bl3) {
            aABox.add(new AABox(Double.NEGATIVE_INFINITY, -this.plane.y * this.plane.w, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.y * this.plane.w, Double.POSITIVE_INFINITY));
            return aABox;
        }
        if (bl2 && bl3) {
            aABox.add(new AABox(-this.plane.x * this.plane.w, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.x * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            return aABox;
        }
        aABox.add(s_infBox);
        return aABox;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IFace optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    @Override
    public IFace transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        return new PlanarSurface(this.plane.transformBy(transformInfo.getMatrix()));
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
        return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2), bl);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE)) {
            // empty if block
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Point3d point3d3;
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE) && (point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, this.plane, 1.0E-6)) != null) {
            iIsectCollector.addFace(object, point3d3, 0, () -> this, this.plane::getNormal);
        }
    }

    @Override
    public Point3d project(Point3d point3d) {
        return this.plane.projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return IFace.PointClassify.INSIDE;
    }
}

