/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class NGon
extends AFace
implements IPolygon {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;

    public NGon(Collection<Point3d> collection) {
        this(collection.toArray(new Point3d[collection.size()]));
    }

    public NGon(Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        this.points = point3dArray;
    }

    @Override
    public NGon flipOrient() {
        return new NGon(GeomUtil.reverse(this.points, Point3d.class));
    }

    @Override
    public NGon optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.points[i]);
            bl |= point3dArray[i] != this.points[i];
        }
        return bl ? new NGon(point3dArray) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.points);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public NGon transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = Util3D.xform(matrix4d, this.points[i]);
        }
        return new NGon(point3dArray);
    }

    @Override
    public IPolygon toPoly(double d) {
        return this;
    }

    @Override
    public Plane3d getPlane(boolean bl) {
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.points), bl, 0.0);
        if (plane3d != null) {
            return plane3d;
        }
        if (this.points.length == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        return new Plane3d(GeomConstants.VEC3D_ZERO, this.points[0]);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean bl) {
        return Util3D.simplePolygonPlane(Arrays.asList(this.points), bl, 0.0);
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int n) {
        return this.points.length;
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        return this.points[n2];
    }

    @Override
    public Vector3d getNormalIfValid(boolean bl) {
        return Util3D.simplePolygonNormal(Arrays.asList(this.points), bl, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
        int n;
        Cloneable cloneable;
        Point2d point2d;
        int n2;
        HashMap<Point2d, Point3d> hashMap = new HashMap<Point2d, Point3d>();
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.points), true, 0.0);
        if (plane3d == null) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point2d[] point2dArray = new Point2d[this.points.length];
        MeshBuilder meshBuilder = new MeshBuilder(1.0E-6);
        for (n2 = 0; n2 < this.points.length; ++n2) {
            point2d = Util3D.xform2d(matrix4d, this.points[n2]);
            hashMap.put(point2d, this.points[n2]);
            point2dArray[n2] = point2d;
        }
        for (n2 = 0; n2 < this.points.length; ++n2) {
            point2d = point2dArray[n2];
            cloneable = point2dArray[(n2 + 1) % this.points.length];
            meshBuilder.addEdge(point2d, (Point2d)cloneable);
        }
        thunderheadeng.delaunay.Mesh mesh = meshBuilder.build();
        boolean bl2 = mesh.triangulateEvenOdd(0, 0.0);
        if (!bl2) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        cloneable = new LinkedHashMap();
        TriangulatorInfo triangulatorInfo = mesh.getOutput();
        int[] nArray = new int[triangulatorInfo.points.length];
        for (n = 0; n < triangulatorInfo.points.length; ++n) {
            Integer n3;
            Point2d point2d2 = triangulatorInfo.points[n];
            Point3d point3d = (Point3d)hashMap.get(point2d2);
            if (point3d == null) {
                point3d = Util3D.xform(matrix4d2, new Point3d(point2d2.x, point2d2.y, 0.0));
            }
            if ((n3 = (Integer)cloneable.get(point3d)) == null) {
                n3 = cloneable.size();
                cloneable.put(point3d, n3);
            }
            nArray[n] = n3;
        }
        for (n = 0; n < triangulatorInfo.triangles.length; ++n) {
            triangulatorInfo.triangles[n] = nArray[triangulatorInfo.triangles[n]];
        }
        Mesh mesh2 = new Mesh(cloneable.keySet().toArray(new Point3d[cloneable.size()]), triangulatorInfo.triangles, 2);
        return new Pair<Mesh, Boolean>(mesh2, true);
    }
}

