/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Mesh
implements IGeom,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte PT_POINTS = 0;
    public static final byte PT_LINESEGS = 1;
    public static final byte PT_TRIANGLES = 2;
    public static final byte PT_QUADS = 3;
    public static final int FLAG_SMOOTHNORMALS = 2;
    public static final int FLAG_SOLID = 4;
    public final byte primtype;
    public final Point3d[] vertices;
    public final int[] indices;
    public final int flags;

    public Mesh(Point3d[] point3dArray, int[] nArray, byte by) {
        this(point3dArray, nArray, by, 0);
    }

    public Mesh(Point3d[] point3dArray, int[] nArray, byte by, int n) {
        assert (nArray.length % Mesh.getNumVertsPerElement(by) == 0);
        this.vertices = point3dArray;
        this.indices = nArray;
        this.flags = n;
        this.primtype = by;
    }

    @Override
    public IGeom optimize(IPointOptimizer iPointOptimizer) {
        int n = this.getNumPrims(7);
        if (n == 1) {
            return this.getPrimitive(0).optimize(iPointOptimizer);
        }
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.vertices[i]);
            bl |= point3dArray[i] != this.vertices[i];
        }
        return bl ? new Mesh(point3dArray, this.indices, this.primtype, this.flags) : this;
    }

    public Mesh toSolid() {
        if (this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags | 4);
    }

    public Mesh toShell() {
        if (!this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags & 0xFFFFFFFB);
    }

    public boolean testFlag(int n) {
        return (this.flags & n) == n;
    }

    public int getNumVertsPerPrim() {
        return Mesh.getNumVertsPerElement(this.primtype);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.vertices);
        return aABox;
    }

    @Override
    public boolean getBakeTransform() {
        return this.getNumPrims(7) == 1;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        return new Mesh(GeomUtil.xformVerts(this.vertices, transformInfo.getMatrix()), this.indices, this.primtype, this.flags);
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        return !this.testFlag(4);
    }

    public static int getNumVertsPerElement(byte by) {
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        if ((n & 1) != 0 && (this.primtype == 2 || this.primtype == 3)) {
            return this.indices.length / Mesh.getNumVertsPerElement(this.primtype);
        }
        if ((n & 2) != 0 && this.primtype == 1) {
            return this.indices.length / 2;
        }
        if ((n & 4) != 0 && this.primtype == 0) {
            return this.indices.length;
        }
        return 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        Point3d[] point3dArray = this.vertices;
        switch (this.primtype) {
            case 0: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    collection.add(new Point(point3d));
                }
                break;
            }
            case 1: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d2 = point3dArray[this.indices[n++]];
                    collection.add(new LineSeg(point3d, point3d2));
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d3 = point3dArray[this.indices[n++]];
                    Point3d point3d4 = point3dArray[this.indices[n++]];
                    collection.add(new Triangle(point3d, point3d3, point3d4));
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d5 = point3dArray[this.indices[n++]];
                    Point3d point3d6 = point3dArray[this.indices[n++]];
                    Point3d point3d7 = point3dArray[this.indices[n++]];
                    collection.add(new Quad(point3d, point3d5, point3d6, point3d7));
                }
                break;
            }
        }
        return collection;
    }

    public boolean isValid() {
        for (int n : this.indices) {
            if (n < this.vertices.length && n >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.testClosed().v1 == ClosedTest.CLOSED;
    }

    public Pair<ClosedTest, Object> testClosed() {
        Object object;
        int n;
        int n2;
        if (this.primtype != 2 && this.primtype != 3) {
            return new Pair<ClosedTest, Object>(ClosedTest.WRONG_TYPE, null);
        }
        int n3 = n2 = this.primtype == 2 ? 3 : 4;
        if (this.indices.length == n2) {
            return new Pair<ClosedTest, Object>(ClosedTest.ONE_FACE, null);
        }
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        for (int i = 0; i < this.indices.length; i += n2) {
            for (int j = 0; j < n2; ++j) {
                n = this.indices[i + j];
                int n4 = this.indices[i + (j + 1) % n2];
                object = new EdgeHash(n, n4);
                Integer n5 = (Integer)linkedHashMap.get(object);
                n5 = n5 == null ? Integer.valueOf(1) : Integer.valueOf(n5 + 1);
                linkedHashMap.put(object, n5);
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            n = (Integer)entry.getValue();
            if (n > 1) continue;
            Point3d point3d = this.vertices[((EdgeHash)entry.getKey()).e1];
            object = this.vertices[((EdgeHash)entry.getKey()).e2];
            return new Pair<ClosedTest, Point3d[]>(ClosedTest.EDGE_OPEN, new Point3d[]{point3d, object});
        }
        return new Pair<ClosedTest, Object>(ClosedTest.CLOSED, null);
    }

    public static Mesh merge(Mesh ... meshArray) {
        if (meshArray.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 0);
        }
        byte by = meshArray[0].primtype;
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Mesh mesh : meshArray) {
            assert (mesh.primtype == by);
            int[] nArray = new int[mesh.vertices.length];
            for (int i = 0; i < mesh.vertices.length; ++i) {
                Point3d point3d = mesh.vertices[i];
                Integer n = (Integer)linkedHashMap.get(point3d);
                if (n == null) {
                    n = linkedHashMap.size();
                    linkedHashMap.put(point3d, n);
                }
                nArray[i] = n;
            }
            for (int n : mesh.indices) {
                arrayList.add(nArray[n]);
            }
        }
        return new Mesh(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), theUtil.toIntArray(arrayList), by);
    }

    public List<IPrimitive> getPrimitives() {
        return new PrimList(this);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        switch (this.primtype) {
            case 0: {
                if (!iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) break;
                for (int i = 0; i < this.indices.length; ++i) {
                    if (!convexHull.contains(this.vertices[this.indices[i]])) continue;
                    iBoxCollector.addNonFace(object);
                }
                break;
            }
            case 1: {
                if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
                    int n = 0;
                    while (n < this.indices.length) {
                        Point3d point3d;
                        Point3d point3d2;
                        if (!convexHull.intersectsLineSeg(point3d2 = this.vertices[this.indices[n++]], point3d = this.vertices[this.indices[n++]], 1.0E-6)) continue;
                        iBoxCollector.addNonFace(object);
                    }
                } else {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.EDGE_VERTEX)) break;
                    for (Point3d point3d : this.vertices) {
                        if (!convexHull.contains(point3d, 1.0E-6)) continue;
                        iBoxCollector.addNonFace(object);
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (iIsectFilter.acceptGeomType(object, GeomType.FACE)) {
                    Point3d[] point3dArray = new Point3d[Mesh.getNumVertsPerElement(this.primtype)];
                    int n = 0;
                    Plane3d plane3d = new Plane3d();
                    int n2 = 0;
                    while (n2 < this.indices.length) {
                        for (int i = 0; i < point3dArray.length; ++i) {
                            point3dArray[i] = this.vertices[this.indices[n2++]];
                        }
                        plane3d.set(true, point3dArray);
                        if (plane3d.isValid() && convexHull.intersectsConvexPoly(1.0E-6, plane3d, point3dArray)) {
                            Point3d[] point3dArray2 = Arrays.copyOf(point3dArray, point3dArray.length);
                            Vector3d vector3d = plane3d.getNormal();
                            iBoxCollector.addFace(object, n, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(point3dArray2), vector3d));
                        }
                        ++n;
                    }
                } else if (iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) {
                    int n = Mesh.getNumVertsPerElement(this.primtype);
                    for (int i = 0; i < this.indices.length; i += n) {
                        for (int j = 0; j < n; ++j) {
                            Point3d point3d = this.vertices[this.indices[i + j]];
                            Point3d point3d3 = this.vertices[this.indices[i + (j + 1) % n]];
                            if (!convexHull.intersectsLineSeg(point3d, point3d3, 1.0E-6)) continue;
                            iBoxCollector.addNonFace(object);
                        }
                    }
                } else {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) break;
                    for (Point3d point3d : this.vertices) {
                        if (!convexHull.contains(point3d)) continue;
                        iBoxCollector.addNonFace(object);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        GeomType geomType = null;
        GeomType geomType2 = null;
        GeomType geomType3 = null;
        switch (this.primtype) {
            case 0: {
                geomType = GeomType.VERTEX;
                break;
            }
            case 1: {
                geomType = GeomType.EDGE_VERTEX;
                geomType2 = GeomType.EDGE;
                break;
            }
            case 2: 
            case 3: {
                geomType = GeomType.FACE_VERTEX;
                geomType2 = GeomType.FACE_EDGE;
                geomType3 = GeomType.FACE;
            }
        }
        if (geomType != null && iIsectFilter.acceptGeomType(object, geomType)) {
            this.pickVerts(iIsectCollector, object, geomType);
        }
        if (geomType2 != null && iIsectFilter.acceptGeomType(object, geomType2)) {
            this.pickEdges(iIsectCollector, object, point3d, point3d2, vector3d, iTest);
        }
        if (geomType3 != null && iIsectFilter.acceptGeomType(object, geomType3)) {
            this.pickFaces(iIsectCollector, object, point3d, point3d2, vector3d, iTest);
        }
    }

    private void pickVerts(IIsectCollector iIsectCollector, Object object, GeomType geomType) {
        for (Point3d point3d : this.vertices) {
            iIsectCollector.addNonFace(object, point3d, geomType);
        }
    }

    private void pickEdges(IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        AABox aABox = new AABox();
        if (this.primtype == 1) {
            int n = 0;
            while (n < this.indices.length) {
                Point3d point3d3 = this.vertices[this.indices[n++]];
                Point3d point3d4 = this.vertices[this.indices[n++]];
                aABox.reset();
                aABox.add(point3d3, point3d4);
                if (!iTest.test((AABox)aABox).positive) continue;
                double[] dArray = Inter3D.getNearestTLinesegLineSeg(point3d, point3d2, point3d3, point3d4, 1.0E-6);
                if (dArray != null) {
                    iIsectCollector.addNonFace(object, Util3D.linesegPoint(point3d3, point3d4, dArray[1]), GeomType.EDGE);
                    continue;
                }
                iIsectCollector.getProgress().check();
            }
        } else {
            int n = this.getNumVertsPerPrim();
            for (int i = 0; i < this.indices.length; i += n) {
                for (int j = 0; j < n; ++j) {
                    int n2 = this.indices[i + j];
                    int n3 = this.indices[i + (j + 1) % n];
                    Point3d point3d5 = this.vertices[n2];
                    Point3d point3d6 = this.vertices[n3];
                    aABox.reset();
                    aABox.add(point3d5, point3d6);
                    if (!iTest.test((AABox)aABox).positive) continue;
                    double[] dArray = Inter3D.getNearestTLinesegLineSeg(point3d, point3d2, point3d5, point3d6, 1.0E-6);
                    if (dArray != null) {
                        iIsectCollector.addNonFace(object, Util3D.linesegPoint(point3d5, point3d6, dArray[1]), GeomType.FACE_EDGE);
                        continue;
                    }
                    iIsectCollector.getProgress().check();
                }
            }
        }
    }

    private void pickFaces(IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Plane3d plane3d = new Plane3d();
        int n = this.getNumVertsPerPrim();
        Point3d[] point3dArray = new Point3d[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.indices.length) {
            for (int i = 0; i < n; ++i) {
                point3dArray[i] = this.vertices[this.indices[n3 + i]];
            }
            plane3d.set(0.0, true, point3dArray);
            if (plane3d.isValid()) {
                Point3d point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, plane3d, 1.0E-6);
                if (point3d3 != null && Inter3D.pointInPoly(1.0E-6, point3d3, point3dArray)) {
                    Vector3d vector3d2 = plane3d.getNormal();
                    Point3d[] point3dArray2 = Arrays.copyOf(point3dArray, point3dArray.length);
                    iIsectCollector.addFace(object, point3d3, n2, () -> PolyUtil.newPoly(point3dArray2), () -> vector3d2);
                } else {
                    iIsectCollector.getProgress().check();
                }
            }
            n3 += n;
            ++n2;
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        AABox aABox = new AABox();
        for (IGeom iGeom : this.explode(new ArrayList<IGeom>(this.getNumPrims(7)))) {
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            Containment containment = iTest.test(aABox);
            if (!containment.positive) continue;
            iResult.mark((IPrimitive)iGeom, containment);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.explode(new ArrayList<IGeom>(this.getNumPrims(7)))) {
            iResult.mark((IPrimitive)iGeom, Containment.INSIDE);
        }
    }

    public Fixer getFixes() {
        if (this.primtype != 3) {
            return new Fixer();
        }
        Point3d[] point3dArray = new Point3d[4];
        Fixer fixer = new Fixer(this.indices.length);
        int n = 0;
        int n2 = 0;
        while (n2 < this.indices.length) {
            int n3;
            for (n3 = 0; n3 < 4; ++n3) {
                point3dArray[n3] = this.vertices[this.indices[n2++]];
            }
            n3 = 0;
            for (int i = 0; i < 4; ++i) {
                Point3d point3d = point3dArray[i];
                Point3d point3d2 = point3dArray[GeomUtil.PLUS1MOD4[i]];
                if (!point3d.equals(point3d2)) continue;
                fixer.addMerge(n, i);
                n3 = 1;
            }
            if (n3 == 0 && !Util3D.areCoplanar(1.0E-6, point3dArray)) {
                fixer.addSplit(n);
            }
            ++n;
        }
        return fixer;
    }

    public Mesh fix() {
        Fixer fixer = this.getFixes();
        return fixer.fix(this);
    }

    private static int addTri(int[] nArray, int n, int n2) {
        nArray[n++] = n2;
        return n;
    }

    private static int addTri(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[n++] = n2;
        nArray[n++] = n3;
        nArray[n++] = n4;
        return n;
    }

    public IPrimitive getPrimitive(int n) {
        int n2 = Mesh.getNumVertsPerElement(this.primtype);
        int n3 = n2 * n;
        switch (this.primtype) {
            case 0: {
                return new Point(this.vertices[this.indices[n3]]);
            }
            case 1: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d2 = this.vertices[this.indices[n3++]];
                return new LineSeg(point3d, point3d2);
            }
            case 2: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d3 = this.vertices[this.indices[n3++]];
                Point3d point3d4 = this.vertices[this.indices[n3++]];
                return new Triangle(point3d, point3d3, point3d4);
            }
            case 3: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d5 = this.vertices[this.indices[n3++]];
                Point3d point3d6 = this.vertices[this.indices[n3++]];
                Point3d point3d7 = this.vertices[this.indices[n3++]];
                return new Quad(point3d, point3d5, point3d6, point3d7);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<VertHandle> arrayList = new ArrayList<VertHandle>(this.vertices.length);
        for (int i = 0; i < this.vertices.length; ++i) {
            arrayList.add(new VertHandle(this, i));
        }
        return arrayList;
    }

    private static class VertHandle
    implements IHandle {
        private Mesh d_geom;
        private final int d_vertIx;
        private Point3d[] t_verts;

        public VertHandle(Mesh mesh, int n) {
            this.d_geom = mesh;
            this.d_vertIx = n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof VertHandle && ((VertHandle)object).d_vertIx == this.d_vertIx;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.d_geom.vertices[this.d_vertIx]));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.vertices, this.d_geom.vertices.length);
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            this.t_verts[this.d_vertIx] = point3d;
            this.d_geom = new Mesh(this.t_verts, this.d_geom.indices, this.d_geom.primtype, this.d_geom.flags);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }

    public static class Fixer {
        private final int d_numIxes;
        private int[] d_mergePrims = null;
        private int d_numMerges = 0;

        private Fixer() {
            this(0);
        }

        private Fixer(int n) {
            this.d_numIxes = n;
        }

        private void addMerge(int n, int n2) {
            if (this.d_mergePrims == null) {
                this.d_mergePrims = new int[this.d_numIxes / 4];
                Arrays.fill(this.d_mergePrims, -1);
            }
            this.d_mergePrims[n] = n2;
            if (n2 != -1) {
                ++this.d_numMerges;
            }
        }

        private void addSplit(int n) {
            this.addMerge(n, -1);
        }

        public Mesh fix(Mesh mesh) {
            int[] nArray = this.fixMeshIndices(ElementMesh.Mapping.PER_PRIM_VERTEX, mesh.indices, null);
            if (nArray == mesh.indices) {
                return mesh;
            }
            return new Mesh(mesh.vertices, nArray, 2, mesh.flags);
        }

        public <ElemT> ElementMesh<ElemT> fixVertElements(ElementMesh<ElemT> elementMesh) {
            return this.fixElements(elementMesh, null);
        }

        public <ElemT> ElementMesh<ElemT> fixEdgeElements(ElementMesh<ElemT> elementMesh, IntUnaryOperator intUnaryOperator) {
            return this.fixElements(elementMesh, intUnaryOperator);
        }

        private <ElemT> ElementMesh<ElemT> fixElements(ElementMesh<ElemT> elementMesh, IntUnaryOperator intUnaryOperator) {
            int[] nArray = this.fixMeshIndices(elementMesh.mapping, elementMesh.indices, intUnaryOperator);
            if (nArray == elementMesh.indices) {
                return elementMesh;
            }
            return new ElementMesh(elementMesh.mapping, elementMesh.elements, nArray, 3);
        }

        public boolean needsMeshCorrection() {
            return this.d_mergePrims != null;
        }

        private int[] fixMeshIndices(ElementMesh.Mapping mapping, int[] nArray, IntUnaryOperator intUnaryOperator) {
            if (this.d_mergePrims == null || mapping == ElementMesh.Mapping.ALL_SAME) {
                return nArray;
            }
            int n = this.d_numIxes / 4 - this.d_numMerges;
            if (n == 0 && mapping != ElementMesh.Mapping.PER_PRIM_VERTEX) {
                return nArray;
            }
            assert (nArray.length == this.d_numIxes || nArray.length == 0);
            int n2 = this.d_numMerges + n * 2;
            int[] nArray2 = new int[mapping == ElementMesh.Mapping.PER_PRIM ? n2 : n2 * 3];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n5 < this.d_numIxes) {
                block0 : switch (mapping) {
                    case PER_PRIM: {
                        int n7;
                        switch (nArray.length) {
                            case 0: {
                                n7 = n5++;
                                break;
                            }
                            default: {
                                n7 = nArray[n5++];
                            }
                        }
                        switch (this.d_mergePrims[n4]) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                n3 = Mesh.addTri(nArray2, n3, n7);
                                break block0;
                            }
                        }
                        n3 = Mesh.addTri(nArray2, n3, n7);
                        n3 = Mesh.addTri(nArray2, n3, n7);
                        break;
                    }
                    case PER_PRIM_VERTEX: {
                        int n8;
                        int n9;
                        int n10;
                        int n7;
                        switch (nArray.length) {
                            case 0: {
                                n7 = n5++;
                                n10 = n5++;
                                n9 = n5++;
                                n8 = n5++;
                                break;
                            }
                            default: {
                                n7 = nArray[n5++];
                                n10 = nArray[n5++];
                                n9 = nArray[n5++];
                                n8 = nArray[n5++];
                            }
                        }
                        switch (this.d_mergePrims[n4]) {
                            case 0: {
                                n3 = Mesh.addTri(nArray2, n3, n7, n9, n8);
                                break block0;
                            }
                            case 1: {
                                n3 = Mesh.addTri(nArray2, n3, n7, n10, n8);
                                break block0;
                            }
                            case 2: {
                                n3 = Mesh.addTri(nArray2, n3, n7, n10, n9);
                                break block0;
                            }
                            case 3: {
                                n3 = Mesh.addTri(nArray2, n3, n7, n10, n9);
                                break block0;
                            }
                        }
                        if (intUnaryOperator != null) {
                            int n11 = intUnaryOperator.applyAsInt(n6 + 2);
                            int n12 = intUnaryOperator.applyAsInt(n6);
                            n3 = Mesh.addTri(nArray2, n3, n7, n10, n11);
                            n3 = Mesh.addTri(nArray2, n3, n12, n9, n8);
                            break;
                        }
                        n3 = Mesh.addTri(nArray2, n3, n7, n10, n9);
                        n3 = Mesh.addTri(nArray2, n3, n7, n9, n8);
                        break;
                    }
                }
                ++n4;
                n6 += 4;
            }
            assert (n3 == nArray2.length);
            return nArray2;
        }

        public boolean needsPropFix() {
            if (this.d_mergePrims == null) {
                return false;
            }
            int n = this.d_numIxes / 4 - this.d_numMerges;
            return n > 0;
        }

        public <T> void fixProps(Iterator<T> iterator, Consumer<T> consumer) {
            int n = this.d_numIxes / 4;
            for (int i = 0; iterator.hasNext() && i < n; ++i) {
                T t = iterator.next();
                consumer.accept(t);
                if (this.d_mergePrims == null || this.d_mergePrims[i] != -1) continue;
                consumer.accept(t);
            }
        }
    }

    private static class PrimList
    extends AbstractList<IPrimitive> {
        public final Mesh mesh;
        public final int primCount;

        public PrimList(Mesh mesh) {
            this.mesh = mesh;
            this.primCount = mesh.getNumPrims(7);
        }

        @Override
        public int size() {
            return this.primCount;
        }

        @Override
        public IPrimitive get(int n) {
            return this.mesh.getPrimitive(n);
        }
    }

    private static class EdgeHash {
        private int e1;
        private int e2;

        public EdgeHash() {
        }

        public EdgeHash(int n, int n2) {
            this.e1 = n;
            this.e2 = n2;
        }

        public void set(int n, int n2) {
            this.e1 = n;
            this.e2 = n2;
        }

        public int hashCode() {
            return this.e1 + this.e2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EdgeHash)) {
                return false;
            }
            EdgeHash edgeHash = (EdgeHash)object;
            return object instanceof EdgeHash && edgeHash.e1 == this.e1 && edgeHash.e2 == this.e2 || edgeHash.e1 == this.e2 && edgeHash.e2 == this.e1;
        }
    }

    public static enum ClosedTest {
        CLOSED,
        WRONG_TYPE,
        ONE_FACE,
        EDGE_OPEN;

    }
}

