/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.TaskProgress;

public class ManifoldSolid {
    public final IGeom solid;
    public final AABox bounds;
    public final RTree<IFace> search;
    private static final TaskProgress s_progress = new TaskProgress();
    private static final Object s_dummySrc = new Object();
    private static final IIsectFilter s_faceIsectFilter = new IIsectFilter(){

        @Override
        public boolean acceptPickObject(Object object) {
            return true;
        }

        @Override
        public boolean acceptPickObjType(Class clazz) {
            return true;
        }

        @Override
        public boolean acceptIntersection(IsectInfo isectInfo) {
            return true;
        }

        @Override
        public boolean acceptGeomType(Object object, GeomType geomType) {
            return geomType == GeomType.FACE;
        }
    };

    public ManifoldSolid(IGeom iGeom, boolean bl) {
        this(iGeom, iGeom.getBoundingBox(new AABox()), bl);
    }

    public ManifoldSolid(IGeom iGeom, AABox aABox, boolean bl) {
        this(iGeom, aABox, bl ? ManifoldSolid.calcRTree(iGeom) : null);
    }

    public ManifoldSolid(IGeom iGeom, AABox aABox, RTree<IFace> rTree) {
        this.solid = iGeom;
        this.bounds = aABox;
        this.search = rTree;
    }

    public Collection<IFace> find(ITest<AABox> iTest) {
        if (this.search != null) {
            ArrayList<IFace> arrayList = new ArrayList<IFace>();
            this.search.find(iTest, (iFace, containment) -> {
                if (containment.positive) {
                    arrayList.add((IFace)iFace);
                }
            });
            return arrayList;
        }
        return GeomUtil.explode(this.solid, IFace.class);
    }

    private static RTree<IFace> calcRTree(IGeom iGeom) {
        RTree<IFace> rTree = new RTree<IFace>();
        for (IFace iFace : GeomUtil.explode(iGeom, IFace.class)) {
            AABox aABox = iFace.getBoundingBox(new AABox());
            if (!aABox.isValid()) continue;
            rTree.insert(aABox, iFace);
        }
        return rTree;
    }

    public PointClassify classify(Point3d point3d, double d) {
        Random random = new Random(1L);
        Vector3d vector3d = Util3D.newRandomVector(random);
        return ManifoldSolid.classify(this, point3d, vector3d, d);
    }

    private static PointClassify classify(ManifoldSolid manifoldSolid, Point3d point3d, Vector3d vector3d, double d) {
        AABox aABox = manifoldSolid.bounds;
        if (!aABox.contains(point3d, d)) {
            return PointClassify.OUTSIDE;
        }
        double[] dArray = Inter3D.rayAABoxIsect(point3d, vector3d, aABox.getMin(), aABox.getMax(), d);
        if (dArray != null) {
            Collection<IFace> collection;
            ITest<AABox> iTest;
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, dArray[1]);
            if (point3d.epsilonEquals(point3d2, d)) {
                iTest = new AABox(point3d);
                collection = manifoldSolid.find(iTest);
            } else {
                iTest = new LineSegRTreeTest(point3d, point3d2);
                collection = manifoldSolid.find(iTest);
            }
            double d2 = Math.max(1.0, dArray[1] * 2.0);
            return ManifoldSolid.classify(collection, new LineSeg3D(point3d, Util3D.linePoint(point3d, vector3d, d2)), iTest, d);
        }
        return PointClassify.OUTSIDE;
    }

    private static PointClassify classify(Collection<IFace> collection, LineSeg3D lineSeg3D, ITest<AABox> iTest, double d) {
        int n = 0;
        final ArrayList arrayList = new ArrayList();
        IIsectCollector iIsectCollector = new IIsectCollector(){

            @Override
            public TaskProgress getProgress() {
                return s_progress;
            }

            @Override
            public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
            }

            @Override
            public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                arrayList.add(point3d);
            }

            @Override
            public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                arrayList.add(point3d);
            }
        };
        Vector3d vector3d = lineSeg3D.getDir();
        Util3D.safeNormalize(vector3d, d);
        for (IFace iFace : collection) {
            arrayList.clear();
            iFace.pickPoints(iIsectCollector, s_faceIsectFilter, s_dummySrc, lineSeg3D.p1, lineSeg3D.p2, vector3d, iTest);
            if (arrayList.isEmpty()) continue;
            double d2 = arrayList.stream().mapToDouble(point3d -> Util3D.tOnLineSeg(lineSeg3D.p1, lineSeg3D.p2, point3d)).min().getAsDouble();
            if (lineSeg3D.get(d2).epsilonEquals(lineSeg3D.p1, d)) {
                return PointClassify.ON_BOUNDARY;
            }
            n += arrayList.size();
        }
        return n % 2 != 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static enum PointClassify {
        INSIDE(true),
        ON_BOUNDARY(true),
        OUTSIDE(false);

        public final boolean positive;

        private PointClassify(boolean bl) {
            this.positive = bl;
        }
    }
}

