/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IParametricCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public class LineSeg
extends ACurve
implements ILinearCurve,
IManipulatable,
IParametricCurve {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg(Point3d point3d, Point3d point3d2) {
        this.p1 = point3d;
        this.p2 = point3d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSeg)) {
            return false;
        }
        return this.equals((LineSeg)object, true);
    }

    public boolean equals(LineSeg lineSeg, boolean bl) {
        if (lineSeg == this) {
            return true;
        }
        if (!bl) {
            return this.p1.equals(lineSeg.p1) && this.p2.equals(lineSeg.p2) || this.p1.equals(lineSeg.p2) && this.p2.equals(lineSeg.p1);
        }
        return this.p1.equals(lineSeg.p1) && this.p2.equals(lineSeg.p2);
    }

    @Override
    public int getNumVerts() {
        return 2;
    }

    @Override
    public Point3d getVert(int n) {
        return n == 0 ? this.p1 : this.p2;
    }

    public double getT(Point3d point3d) {
        return Util3D.tOnLineSeg(this.p1, this.p2, point3d);
    }

    @Override
    public Point3d get(double d) {
        return Util3D.linesegPoint(this.p1, this.p2, d);
    }

    @Override
    public LineSeg optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p1);
        Point3d point3d2 = iPointOptimizer.getExisting(this.p2);
        return point3d != this.p1 || point3d2 != this.p2 ? new LineSeg(point3d, point3d2) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.p1);
        aABox.add(this.p2);
        return aABox;
    }

    @Override
    public Vector3d getTangent(double d, ICurve.Orient orient, boolean bl) {
        Vector3d vector3d;
        switch (orient) {
            case POSITIVE: {
                vector3d = Util3D.vector(this.p1, this.p2);
                break;
            }
            default: {
                vector3d = Util3D.vector(this.p2, this.p1);
            }
        }
        if (bl) {
            Util3D.safeNormalize(vector3d, 1.0E-9);
        }
        return vector3d;
    }

    public Point3d evaluate(double d) {
        if (d == 0.0) {
            return new Point3d(this.p1);
        }
        if (d == 1.0) {
            return new Point3d(this.p2);
        }
        return Util3D.linesegPoint(this.p1, this.p2, d);
    }

    public LineSeg negate() {
        return new LineSeg(this.p2, this.p1);
    }

    public LineSeg trim(double d, double d2) {
        if (d == 0.0 && d2 == 1.0) {
            return this;
        }
        return new LineSeg(this.evaluate(d), this.evaluate(d2));
    }

    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public LineSeg transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        return new LineSeg(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2));
    }

    @Override
    public Mesh getSegments(double d) {
        Point3d[] point3dArray = new Point3d[]{this.p1, this.p2};
        return new Mesh(point3dArray, new int[]{0, 1}, 1);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE) && convexHull.intersectsLineSeg(this.p1, this.p2, 1.0E-6)) {
            iBoxCollector.addNonFace(object);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        double[] dArray;
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE_VERTEX)) {
            iIsectCollector.addNonFace(object, this.p1, GeomType.EDGE_VERTEX);
            iIsectCollector.addNonFace(object, this.p2, GeomType.EDGE_VERTEX);
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE) && (dArray = Inter3D.getNearestTLinesegLineSeg(point3d, point3d2, this.p1, this.p2, 1.0E-6)) != null) {
            Point3d point3d3 = Util3D.linesegPoint(this.p1, this.p2, dArray[1]);
            iIsectCollector.addNonFace(object, point3d3, GeomType.EDGE);
        }
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        return Inter3D.nearestPointOnLineSeg(this.p1, this.p2, point3d);
    }

    @Override
    public ILinearCurve newCurve(Point3d ... point3dArray) {
        assert (point3dArray.length == 2);
        return new LineSeg(point3dArray[0], point3dArray[1]);
    }

    @Override
    public LineSeg reverse() {
        return new LineSeg(this.p2, this.p1);
    }
}

