/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.TriSurface;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public interface IPolygon
extends IPlanarFace,
IManipulatable {
    public int getNumLoops();

    public int getNumPoints(int var1);

    public Point3d getPoint(int var1, int var2);

    default public Vector3d getNormal(boolean bl) {
        Vector3d vector3d = this.getNormalIfValid(bl);
        if (vector3d != null) {
            return vector3d;
        }
        return GeomConstants.VEC3D_ZERO;
    }

    public Vector3d getNormalIfValid(boolean var1);

    @Override
    public IPolygon transform(TransformInfo var1, int var2);

    @Override
    public IPolygon optimize(IPointOptimizer var1);

    @Override
    public IPolygon flipOrient();

    @Override
    default public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        PolyUtil.pickBox(object, 0, this, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    default public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        PolyUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    default public Point3d project(Point3d point3d) {
        return this.getPlane(true).projectOntoPlane(point3d);
    }

    @Override
    default public IFace.PointClassify classify(Point3d point3d, double d) {
        return PolyUtil.classify(this, point3d, d);
    }

    @Override
    default public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }

    @Override
    default public IPolygon toPoly(double d) {
        return this;
    }

    @Override
    default public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    default public int getNumVerts() {
        return PolyUtil.getNumVerts(this);
    }

    @Override
    default public boolean getBakeTransform() {
        return true;
    }

    default public Supplier<Point3d> getPointGenerator(Random random) {
        Mesh mesh = this.triangulate(0.0);
        TriSurface triSurface = new TriSurface();
        triSurface.addTris(mesh.vertices, mesh.indices);
        return triSurface.getPointGenerator(random);
    }

    default public Supplier<Point3d> getPointGenerator(Random random, boolean bl, double d) {
        Supplier<Point3d> supplier = this.getPointGenerator(random);
        if (bl) {
            return supplier;
        }
        return () -> {
            for (int i = 0; i < 10; ++i) {
                IFace.PointClassify pointClassify;
                Point3d point3d = (Point3d)supplier.get();
                if (point3d == null || (pointClassify = this.classify(point3d, d)) != IFace.PointClassify.INSIDE) continue;
                return point3d;
            }
            return null;
        };
    }
}

