/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public interface IDOF {
    public static final IDOF FREE = new IDOF(){

        @Override
        public boolean accept(TransformInfo transformInfo) {
            return true;
        }

        @Override
        public void describeRules(Set<String> set) {
        }

        public String toString() {
            return "FREE";
        }
    };
    public static final IDOF ALIGNED = new IDOF(){

        @Override
        public boolean accept(TransformInfo transformInfo) {
            return GeomUtil.isAxisAligned(transformInfo, 1.0E-6);
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Rotation must be in 90 degree increments about the X, Y, or Z axis."));
        }

        public String toString() {
            return "ALIGNED";
        }
    };
    public static final IDOF NONE = new IDOF(){

        @Override
        public boolean accept(TransformInfo transformInfo) {
            return GeomUtil.isTranslateScaleOnly(transformInfo, 1.0E-6);
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Rotation and mirroring are not allowed."));
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final IDOF INVERTIBLE = new IDOF(){

        @Override
        public boolean accept(TransformInfo transformInfo) {
            return transformInfo.isInvertible();
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Transformation must be invertible."));
        }

        public String toString() {
            return "INVERTIBLE";
        }
    };

    public boolean accept(TransformInfo var1);

    public void describeRules(Set<String> var1);

    public static IDOF group(Collection<? extends IDOF> collection) {
        if (collection.isEmpty()) {
            return FREE;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        HashSet<IDOF> hashSet = new HashSet<IDOF>();
        CompositeDOF.flatten(collection, hashSet);
        if (hashSet.isEmpty()) {
            return FREE;
        }
        if (hashSet.size() == 1) {
            return (IDOF)hashSet.iterator().next();
        }
        return new CompositeDOF(hashSet);
    }

    public static IDOF group(IDOF ... iDOFArray) {
        return IDOF.group(Arrays.asList(iDOFArray));
    }

    public static class CompositeDOF
    implements IDOF {
        public final Set<? extends IDOF> dofs;

        private CompositeDOF(Set<? extends IDOF> set) {
            this.dofs = set;
        }

        public static void flatten(Collection<? extends IDOF> collection, Collection<IDOF> collection2) {
            for (IDOF iDOF : collection) {
                if (iDOF instanceof CompositeDOF) {
                    CompositeDOF.flatten(((CompositeDOF)iDOF).dofs, collection2);
                    continue;
                }
                collection2.add(iDOF);
            }
        }

        public int hashCode() {
            return 0xFA923F ^ this.dofs.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            CompositeDOF compositeDOF = (CompositeDOF)object;
            return compositeDOF.dofs.equals(this.dofs);
        }

        @Override
        public boolean accept(TransformInfo transformInfo) {
            for (IDOF iDOF : this.dofs) {
                if (iDOF.accept(transformInfo)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void describeRules(Set<String> set) {
            for (IDOF iDOF : this.dofs) {
                iDOF.describeRules(set);
            }
        }
    }
}

