/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.ISearchVol;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.CatmullRomSpline;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyCurve;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomUtil {
    public static final int[] PLUS1MOD3 = new int[]{1, 2, 0};
    public static final int[] PLUS2MOD3 = new int[]{2, 0, 1};
    public static final int[] PLUS1MOD4 = new int[]{1, 2, 3, 0};
    public static final int[] PLUS2MOD4 = new int[]{2, 3, 0, 1};
    public static final int[] PLUS3MOD4 = new int[]{3, 0, 1, 2};
    public static final int[] MINUS1MOD3 = PLUS2MOD3;
    public static final int[] MINUS1MOD4 = PLUS3MOD4;
    public static final int[] MINUS2MOD4 = PLUS2MOD4;
    public static final Vector3d[] AXIS_VECS = new Vector3d[]{new Vector3d(-1.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 0.0, 1.0)};

    public static List<IPrimitive> explodeToTypes(IGeom iGeom, int n) {
        return GeomUtil.explodeToTypes(Arrays.asList(iGeom), n);
    }

    public static List<IPrimitive> explodeToTypes(Collection<? extends IGeom> collection, int n) {
        Class<? extends IPrimitive>[] classArray = GeomUtil.getPrimClasses(n);
        int n2 = 0;
        for (IGeom iGeom : collection) {
            n2 += iGeom.getNumPrims(n);
        }
        ArrayList arrayList = new ArrayList(n2);
        GeomUtil.explodeToTypes(collection, classArray, arrayList);
        assert (arrayList.size() == n2);
        return arrayList;
    }

    public static <T extends IPrimitive> List<T> explode(IGeom iGeom, Class<? extends T> ... classArray) {
        return GeomUtil.explode(Arrays.asList(iGeom), classArray);
    }

    public static <T extends IPrimitive> List<T> explode(Collection<? extends IGeom> collection, Class<? extends T> ... classArray) {
        ArrayList arrayList = new ArrayList();
        GeomUtil.explodeToTypes(collection, classArray, arrayList);
        return arrayList;
    }

    private static <T extends IPrimitive> void explodeToTypes(Collection<? extends IGeom> collection, Class<? extends T>[] classArray, List<T> list) {
        for (IGeom iGeom : collection) {
            if (GeomUtil.isType(iGeom, classArray)) {
                list.add((IPrimitive)iGeom);
                continue;
            }
            if (!iGeom.canExplode()) continue;
            Collection<IGeom> collection2 = iGeom.explode(new ArrayList<IGeom>());
            GeomUtil.explodeToTypes(collection2, classArray, list);
        }
    }

    public static boolean isEmpty(IGeom iGeom) {
        return iGeom == EmptyGeom.INSTANCE || iGeom.getNumPrims(7) == 0;
    }

    private static Class<? extends IPrimitive>[] getPrimClasses(int n) {
        int n2 = Integer.bitCount(n &= 7);
        Class[] classArray = new Class[n2];
        int n3 = 0;
        if ((n & 1) != 0) {
            classArray[n3++] = IFace.class;
        }
        if ((n & 2) != 0) {
            classArray[n3++] = ICurve.class;
        }
        if ((n & 4) != 0) {
            classArray[n3++] = Point.class;
        }
        return classArray;
    }

    public static <T> void reverse(T[] TArray, int n, T[] TArray2, int n2, int n3) {
        int n4 = n + n3 - 1;
        for (int i = 0; i < n3; ++i) {
            TArray2[n2 + i] = TArray[n4 - i];
        }
    }

    public static <T> T[] reverse(T[] TArray, Class<T> clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length);
        GeomUtil.reverse(TArray, 0, objectArray, 0, TArray.length);
        return objectArray;
    }

    public static boolean isType(Object object, Class ... classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static IPolygon newPoly(Point3d[] point3dArray) {
        return PolyUtil.newPoly(point3dArray);
    }

    public static IPolygon newPoly(Point3d[] point3dArray, int[] nArray) {
        return PolyUtil.newPoly(point3dArray, nArray);
    }

    public static IPolygon newPoly(Point3d[][] point3dArray) {
        return PolyUtil.newPoly(point3dArray);
    }

    public static boolean polysEqual(IPolygon iPolygon, IPolygon iPolygon2) {
        return PolyUtil.polysEqual(iPolygon, iPolygon2);
    }

    public static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean isTranslateScaleOnly(TransformInfo transformInfo, double d) {
        return GeomUtil.isTranslateScaleOnly(transformInfo.xform, d) || GeomUtil.isTranslateScaleOnly(transformInfo.getMatrix(), d);
    }

    public static boolean isTranslateScaleOnly(ITransform iTransform2, double d) {
        return GeomUtil.testTransforms(iTransform2, translateXform -> true, mirrorXform -> mirrorXform.isIdentity(), rotateXform -> rotateXform.isIdentity(), scaleXform -> scaleXform.x >= 0.0 && scaleXform.y >= 0.0 && scaleXform.z >= 0.0, matrixXform -> GeomUtil.isTranslateScaleOnly(matrixXform, d), iTransform -> iTransform.isIdentity());
    }

    public static boolean isTranslateScaleOnly(Matrix4d matrix4d, double d) {
        return matrix4d.m00 > 0.0 && matrix4d.m01 == 0.0 && matrix4d.m02 == 0.0 && matrix4d.m10 == 0.0 && matrix4d.m11 > 0.0 && matrix4d.m12 == 0.0 && matrix4d.m20 == 0.0 && matrix4d.m21 == 0.0 && matrix4d.m22 > 0.0 && matrix4d.m30 == 0.0 && matrix4d.m31 == 0.0 && matrix4d.m32 == 0.0 && matrix4d.m33 > 0.0;
    }

    public static boolean isAxisAligned(TransformInfo transformInfo, double d) {
        return GeomUtil.isAxisAligned(transformInfo.xform, d) || GeomUtil.isAxisAligned(transformInfo.getMatrix(), d);
    }

    public static boolean isAxisAligned(ITransform iTransform2, double d) {
        return GeomUtil.testTransforms(iTransform2, translateXform -> GeomUtil.isAxisAligned(translateXform, d), mirrorXform -> GeomUtil.isAxisAligned(mirrorXform, d), rotateXform -> GeomUtil.isAxisAligned(rotateXform, d), scaleXform -> GeomUtil.isAxisAligned(scaleXform, d), matrixXform -> GeomUtil.isAxisAligned(matrixXform, d), iTransform -> iTransform.isIdentity());
    }

    public static boolean isAxisAligned(TranslateXform translateXform, double d) {
        return true;
    }

    public static boolean isAxisAligned(ScaleXform scaleXform, double d) {
        return true;
    }

    public static boolean isAxisAligned(MatrixXform matrixXform, double d) {
        return GeomUtil.isAxisAligned(matrixXform.xform, d);
    }

    public static boolean isAxisAligned(MirrorXform mirrorXform, double d) {
        return GeomUtil.isAxisAligned(mirrorXform.plane, d);
    }

    public static boolean isAxisAligned(RotateXform rotateXform, double d) {
        return GeomUtil.isAxisAligned(rotateXform.getAxisAngle(), d);
    }

    public static boolean isAxisAligned(ConcatTransform concatTransform, double d) {
        return GeomUtil.isAxisAligned(concatTransform.left, d) && GeomUtil.isAxisAligned(concatTransform.right, d);
    }

    public static boolean isAxisAligned(Plane3d plane3d, double d) {
        return GeomUtil.isAxisAligned(plane3d.x, plane3d.y, plane3d.z, d);
    }

    public static boolean isAxisAligned(Vector3d vector3d, double d) {
        return GeomUtil.isAxisAligned(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public static boolean isAxisAlignedAxis(AxisAngle4d axisAngle4d, double d) {
        return GeomUtil.isAxisAligned(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, d);
    }

    public static boolean isAxisAligned(double d, double d2, double d3, double d4) {
        d = Math.abs(d);
        d2 = Math.abs(d2);
        d3 = Math.abs(d3);
        if (d > d2 && d > d3) {
            double d5 = d * d4;
            return d2 <= d5 && d3 <= d5;
        }
        if (d2 > d && d2 > d3) {
            double d6 = d2 * d4;
            return d <= d6 && d3 <= d6;
        }
        if (d3 > d && d3 > d2) {
            double d7 = d3 * d4;
            return d <= d7 && d2 <= d7;
        }
        return false;
    }

    public static boolean isAxisAligned(AxisAngle4d axisAngle4d, double d) {
        if (!GeomUtil.isAxisAlignedAxis(axisAngle4d, d)) {
            return false;
        }
        double d2 = Math.abs(axisAngle4d.angle / 1.5707963267948966);
        return theUtil.eq0(d2 - Math.floor(d2), d);
    }

    public static boolean isAxisAligned(Matrix4d matrix4d, double d) {
        if (matrix4d.m00 == 0.0 || matrix4d.m11 == 0.0 || matrix4d.m22 == 0.0) {
            return true;
        }
        AxisAngle4d axisAngle4d = GeomUtil.getRotation(matrix4d);
        if (axisAngle4d == null) {
            return false;
        }
        if (axisAngle4d.angle == 0.0) {
            return true;
        }
        return GeomUtil.isAxisAligned(axisAngle4d, d);
    }

    public static List<Pair<ICurve, Integer>> getFaceOutlines(IGeom iGeom) {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        ArrayList<Pair<ICurve, Integer>> arrayList2 = new ArrayList<Pair<ICurve, Integer>>(iGeom.getNumPrims(1));
        List<IPrimitive> list = GeomUtil.explodeToTypes(iGeom, 1);
        for (int i = 0; i < list.size(); ++i) {
            IFace iFace = (IFace)list.get(i);
            if (iFace == null) continue;
            arrayList.clear();
            iFace.getBoundary(arrayList);
            for (ICurve iCurve : arrayList) {
                arrayList2.add(new Pair<ICurve, Integer>(iCurve, i));
            }
        }
        return arrayList2;
    }

    public static void getBoundary(List<ICurve> list, IPolygon iPolygon) {
        PolyUtil.getBoundary(list, iPolygon);
    }

    public static Point3d[] getAllVerts(IPolygon iPolygon) {
        return PolyUtil.getAllVerts(iPolygon, false);
    }

    public static Point3d[][] getLoops(IPolygon iPolygon) {
        return PolyUtil.getLoops(iPolygon, false);
    }

    public static int[] getLoopOffsets(IPolygon iPolygon) {
        return PolyUtil.getLoopOffsets(iPolygon, false);
    }

    public static void flatten(IGeom iGeom, List<IGeom> list) {
        if (iGeom instanceof GeomGroup) {
            for (IGeom iGeom2 : ((GeomGroup)iGeom).children) {
                GeomUtil.flatten(iGeom2, list);
            }
        } else {
            list.add(iGeom);
        }
    }

    public static List<IGeom> flatten(IGeom iGeom) {
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
        GeomUtil.flatten(iGeom, arrayList);
        return arrayList;
    }

    public static boolean isZRotation(RotateXform rotateXform, double d) {
        return GeomUtil.isZRotation(rotateXform.getAxisAngle(), d);
    }

    public static boolean isZRotation(AxisAngle4d axisAngle4d, double d) {
        return theUtil.eq0(axisAngle4d.angle, d) || theUtil.eq0(axisAngle4d.x, d) && theUtil.eq0(axisAngle4d.y, d) && !theUtil.eq0(axisAngle4d.z, d);
    }

    public static boolean testTransforms(ITransform iTransform, Predicate<TranslateXform> predicate, Predicate<MirrorXform> predicate2, Predicate<RotateXform> predicate3, Predicate<ScaleXform> predicate4, Predicate<MatrixXform> predicate5, Predicate<ITransform> predicate6) {
        if (iTransform instanceof TranslateXform) {
            return predicate.test((TranslateXform)iTransform);
        }
        if (iTransform instanceof MatrixXform) {
            return predicate5.test((MatrixXform)iTransform);
        }
        if (iTransform instanceof MirrorXform) {
            return predicate2.test((MirrorXform)iTransform);
        }
        if (iTransform instanceof RotateXform) {
            return predicate3.test((RotateXform)iTransform);
        }
        if (iTransform instanceof ScaleXform) {
            return predicate4.test((ScaleXform)iTransform);
        }
        if (iTransform instanceof ConcatTransform) {
            ConcatTransform concatTransform = (ConcatTransform)iTransform;
            return GeomUtil.testTransforms(concatTransform.left, predicate, predicate2, predicate3, predicate4, predicate5, predicate6) && GeomUtil.testTransforms(concatTransform.right, predicate, predicate2, predicate3, predicate4, predicate5, predicate6);
        }
        return predicate6.test(iTransform);
    }

    public static boolean testTransforms(ITransform iTransform, Predicate<TranslateXform> predicate, Predicate<MirrorXform> predicate2, Predicate<RotateXform> predicate3, Predicate<ScaleXform> predicate4, Predicate<ITransform> predicate5) {
        return GeomUtil.testTransforms(iTransform, predicate, predicate2, predicate3, predicate4, matrixXform -> GeomUtil.testTransforms(matrixXform.xform, predicate, predicate3, predicate4), predicate5);
    }

    public static boolean testTransforms(Matrix4d matrix4d, Predicate<TranslateXform> predicate, Predicate<RotateXform> predicate2, Predicate<ScaleXform> predicate3) {
        int[] nArray = new int[]{0};
        try {
            GeomUtil.decompose(matrix4d, 0.0, vector3d -> {
                nArray[0] = nArray[0] + 1;
                if (!predicate.test(new TranslateXform(vector3d.x, vector3d.y, vector3d.z))) {
                    throw new CancellationException();
                }
            }, axisAngle4d -> {
                nArray[0] = nArray[0] + 1;
                if (!predicate2.test(new RotateXform((AxisAngle4d)axisAngle4d))) {
                    throw new CancellationException();
                }
            }, vector3d -> {
                nArray[0] = nArray[0] + 1;
                if (!predicate3.test(new ScaleXform(vector3d.x, vector3d.y, vector3d.z))) {
                    throw new CancellationException();
                }
            });
        }
        catch (CancellationException cancellationException) {
            return false;
        }
        return nArray[0] == 3;
    }

    public static void decompose(Matrix4d matrix4d, double d, Consumer<Vector3d> consumer, Consumer<AxisAngle4d> consumer2, Consumer<Vector3d> consumer3) {
        if (consumer != null) {
            consumer.accept(new Vector3d(matrix4d.m03, matrix4d.m13, matrix4d.m23));
        }
        if (consumer3 == null && consumer2 == null) {
            return;
        }
        AxisAngle4d axisAngle4d = GeomUtil.getRotation(matrix4d);
        if (axisAngle4d == null) {
            return;
        }
        if (consumer2 != null) {
            consumer2.accept(axisAngle4d);
        }
        if (consumer3 != null) {
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.setIdentity();
            matrix4d2.setRotation(axisAngle4d);
            double d2 = matrix4d2.m00 == 0.0 ? 0.0 : matrix4d.m00 / matrix4d2.m00;
            double d3 = matrix4d2.m10 == 0.0 ? 0.0 : matrix4d.m10 / matrix4d2.m10;
            double d4 = matrix4d2.m20 == 0.0 ? 0.0 : matrix4d.m20 / matrix4d2.m20;
            double d5 = matrix4d2.m01 == 0.0 ? 0.0 : matrix4d.m01 / matrix4d2.m01;
            double d6 = matrix4d2.m11 == 0.0 ? 0.0 : matrix4d.m11 / matrix4d2.m11;
            double d7 = matrix4d2.m21 == 0.0 ? 0.0 : matrix4d.m21 / matrix4d2.m21;
            double d8 = matrix4d2.m02 == 0.0 ? 0.0 : matrix4d.m02 / matrix4d2.m02;
            double d9 = matrix4d2.m12 == 0.0 ? 0.0 : matrix4d.m12 / matrix4d2.m12;
            double d10 = matrix4d2.m22 == 0.0 ? 0.0 : matrix4d.m22 / matrix4d2.m22;
            double d11 = GeomUtil.getScale(d2, d3, d4, d);
            double d12 = GeomUtil.getScale(d5, d6, d7, d);
            double d13 = GeomUtil.getScale(d8, d9, d10, d);
            if (!(Double.isNaN(d11) || Double.isNaN(d12) || Double.isNaN(d13))) {
                consumer3.accept(new Vector3d(d11, d12, d13));
            }
        }
    }

    private static double getScale(double d, double d2, double d3, double d4) {
        boolean bl = theUtil.eq0(d, d4);
        boolean bl2 = theUtil.eq0(d2, d4);
        boolean bl3 = theUtil.eq0(d3, d4);
        if (bl && bl2 && bl3) {
            return 0.0;
        }
        if (bl && bl2) {
            return d3;
        }
        if (bl && bl3) {
            return d2;
        }
        if (bl2 && bl3) {
            return d;
        }
        if (bl) {
            return theUtil.eq(d2, d3, 1.0E-5) ? d2 : Double.NaN;
        }
        if (bl2) {
            return theUtil.eq(d, d3, 1.0E-5) ? d : Double.NaN;
        }
        if (bl3) {
            return theUtil.eq(d, d2, 1.0E-5) ? d : Double.NaN;
        }
        return theUtil.eq(d, d2, 1.0E-5) && theUtil.eq(d, d3, 1.0E-5) ? d : Double.NaN;
    }

    public static AxisAngle4d getRotation(Matrix4d matrix4d) {
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        axisAngle4d.set(matrix4d);
        if (axisAngle4d.x == 0.0 && axisAngle4d.y == 1.0 && axisAngle4d.z == 0.0 && axisAngle4d.angle == 0.0) {
            double d = Math.signum(matrix4d.m00);
            double d2 = Math.signum(matrix4d.m11);
            double d3 = Math.signum(matrix4d.m22);
            if (d != 0.0 && d2 != 0.0 && d3 != 0.0 && theUtil.eq0(matrix4d.m01, 1.0E-12) && theUtil.eq0(matrix4d.m10, 1.0E-12) && theUtil.eq0(matrix4d.m20, 1.0E-12) && theUtil.eq0(matrix4d.m02, 1.0E-12) && theUtil.eq0(matrix4d.m21, 1.0E-12) && theUtil.eq0(matrix4d.m12, 1.0E-12)) {
                if (d != d2 && d2 == d3) {
                    axisAngle4d.set(1.0, 0.0, 0.0, Math.PI);
                } else if (d != d2 && d == d3) {
                    axisAngle4d.set(0.0, 1.0, 0.0, Math.PI);
                } else if (d == d2 && d2 != d3) {
                    axisAngle4d.set(0.0, 0.0, 1.0, Math.PI);
                } else {
                    axisAngle4d.set(0.0, 0.0, 1.0, 0.0);
                }
            } else {
                return null;
            }
        }
        return axisAngle4d;
    }

    public static Point3d[] xformVerts(Point3d[] point3dArray, Matrix4d matrix4d) {
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray2[i] = Util3D.xform(matrix4d, point3dArray[i]);
        }
        return point3dArray2;
    }

    public static Vector3d getClosestAxis(Vector3d vector3d) {
        double d = 0.0;
        int n = -1;
        Vector3d[] vector3dArray = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
        for (int i = 0; i < vector3dArray.length; ++i) {
            double d2 = vector3d.dot(vector3dArray[i]);
            if (!(Math.abs(d2) > Math.abs(d))) continue;
            d = d2;
            n = i;
        }
        if (n == -1) {
            return GeomConstants.VEC3D_XNEG;
        }
        if (d < 0.0) {
            switch (n) {
                case 0: {
                    return GeomConstants.VEC3D_XNEG;
                }
                case 1: {
                    return GeomConstants.VEC3D_YNEG;
                }
                case 2: {
                    return GeomConstants.VEC3D_ZNEG;
                }
            }
        }
        return vector3dArray[n];
    }

    public static List<LineSeg> getLineSegs(double d, ICurve ... iCurveArray) {
        return GeomUtil.getLineSegs(d, Arrays.asList(iCurveArray));
    }

    public static List<LineSeg> getLineSegs(double d, Collection<? extends ICurve> collection) {
        ArrayList<LineSeg> arrayList = new ArrayList<LineSeg>();
        for (ICurve iCurve : collection) {
            Mesh mesh = iCurve.getSegments(d);
            int n = 0;
            while (n < mesh.indices.length) {
                Point3d point3d = mesh.vertices[mesh.indices[n++]];
                Point3d point3d2 = mesh.vertices[mesh.indices[n++]];
                arrayList.add(new LineSeg(point3d, point3d2));
            }
        }
        return arrayList;
    }

    public static List<LineSeg> convertToLineSegs(double d, IGeom iGeom) {
        return GeomUtil.convertToLineSegs(d, Arrays.asList(iGeom));
    }

    public static List<LineSeg> convertToLineSegs(double d, Collection<? extends IGeom> collection) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(collection, 2);
        return GeomUtil.getLineSegs(d, theUtil.filter(list, ICurve.class));
    }

    public static List<Triangle> convertToTriangles(double d, IGeom iGeom) {
        return GeomUtil.convertToTriangles(d, Arrays.asList(iGeom));
    }

    public static List<Triangle> convertToTriangles(double d, Collection<? extends IGeom> collection) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(collection, 1);
        return GeomUtil.getTriangles(d, theUtil.filter(list, IFace.class));
    }

    public static List<Triangle> getTriangles(double d, IFace ... iFaceArray) {
        return GeomUtil.getTriangles(d, Arrays.asList(iFaceArray));
    }

    public static List<Triangle> getTriangles(double d, Collection<? extends IFace> collection) {
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        for (IFace iFace : collection) {
            Mesh mesh = iFace.triangulate(d);
            int n = 0;
            while (n < mesh.indices.length) {
                Point3d point3d = mesh.vertices[mesh.indices[n++]];
                Point3d point3d2 = mesh.vertices[mesh.indices[n++]];
                Point3d point3d3 = mesh.vertices[mesh.indices[n++]];
                arrayList.add(new Triangle(point3d, point3d2, point3d3));
            }
        }
        return arrayList;
    }

    public static IGeom group(IGeom ... iGeomArray) {
        if (iGeomArray.length == 0) {
            return EmptyGeom.INSTANCE;
        }
        if (iGeomArray.length == 1) {
            return iGeomArray[0];
        }
        return new GeomGroup(Arrays.asList(iGeomArray));
    }

    public static IGeom group(Collection<? extends IGeom> collection) {
        if (collection.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return new GeomGroup(collection);
    }

    public static IGeom filter(IGeom iGeom, int n) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(iGeom, n);
        return GeomUtil.group(list);
    }

    public static ICurve generatePathCatmullRom(List<Point3d> list, boolean bl, CatmullRomSpline.Type type) {
        Point3d point3d;
        Point3d point3d2;
        Point3d point3d3;
        Point3d point3d4;
        assert (list.size() >= 2);
        if (list.size() == 2) {
            return new LineSeg(list.get(0), list.get(1));
        }
        if (bl) {
            point3d4 = list.get(list.size() - 1);
            point3d3 = list.get(0);
        } else {
            point3d4 = list.get(0);
            point3d3 = list.get(list.size() - 1);
        }
        int n = bl ? list.size() : list.size() - 1;
        ICurve[] iCurveArray = new ICurve[n];
        Point3d point3d5 = point3d4;
        for (int i = 0; i < list.size() - 1; ++i) {
            point3d2 = list.get(i);
            point3d = list.get(i + 1);
            Point3d point3d6 = i == list.size() - 2 ? point3d3 : list.get(i + 2);
            iCurveArray[i] = new CatmullRomSpline(type, point3d5, point3d2, point3d, point3d6);
            point3d5 = point3d2;
        }
        if (bl) {
            Point3d point3d7 = point3d4;
            point3d2 = point3d3;
            point3d = list.get(1);
            iCurveArray[n - 1] = new CatmullRomSpline(type, point3d5, point3d7, point3d2, point3d);
        }
        return new PolyCurve(iCurveArray);
    }

    public static AABox getTransformedBounds(TransformInfo transformInfo, IGeom iGeom, AABox aABox) {
        iGeom.getBoundingBox(GeomUtil.getBoundsTransformer(transformInfo, aABox));
        return aABox;
    }

    public static AABox getBoundsTransformer(TransformInfo transformInfo, final AABox aABox) {
        if (transformInfo.isIdentity()) {
            return aABox;
        }
        final Matrix4d matrix4d = transformInfo.getMatrix();
        return new AABox(){

            @Override
            public void add(AABox aABox2) {
                aABox.add(aABox2.transform(matrix4d));
            }

            @Override
            public void add(ISearchVol iSearchVol) {
                assert (false);
                aABox.add(iSearchVol);
            }

            @Override
            public void addPoint(double d, double d2, double d3) {
                Point3d point3d = new Point3d(d, d2, d3);
                matrix4d.transform(point3d);
                aABox.addPoint(point3d.x, point3d.y, point3d.z);
            }
        };
    }
}

