/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public class GeomGroup
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final List<IGeom> children;

    public GeomGroup(Collection<? extends IGeom> collection) {
        this.children = new ArrayList<IGeom>(collection);
    }

    @Override
    public GeomGroup optimize(IPointOptimizer iPointOptimizer) {
        boolean bl = false;
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            IGeom iGeom = this.children.get(i);
            IGeom iGeom2 = iGeom.optimize(iPointOptimizer);
            arrayList.add(iGeom2);
            bl |= iGeom != iGeom2;
        }
        return bl ? new GeomGroup(arrayList) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).getBoundingBox(aABox);
        }
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        LinkedHashSet<IDOF> linkedHashSet = new LinkedHashSet<IDOF>();
        for (IGeom iGeom : this.children) {
            linkedHashSet.add(iGeom.getDOF());
        }
        return IDOF.group(linkedHashSet);
    }

    @Override
    public IDOF getRetainingDOF() {
        LinkedHashSet<IDOF> linkedHashSet = new LinkedHashSet<IDOF>();
        for (IGeom iGeom : this.children) {
            linkedHashSet.add(iGeom.getRetainingDOF());
        }
        return IDOF.group(linkedHashSet);
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>(this.children.size());
        for (IGeom iGeom : this.children) {
            arrayList.add(iGeom.transform(transformInfo, n));
        }
        return new GeomGroup(arrayList);
    }

    @Override
    public boolean canExplode() {
        return !this.children.isEmpty();
    }

    @Override
    public int getNumPrims(int n) {
        int n2 = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            n2 += this.children.get(i).getNumPrims(n);
        }
        return n2;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.addAll(this.children);
        return collection;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).isShell()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, final IBoxCollector iBoxCollector) throws CancelledException {
        int n = 0;
        for (IGeom iGeom : this.children) {
            final int n2 = n;
            IBoxCollector iBoxCollector2 = new IBoxCollector(){

                @Override
                public void addNonFace(Object object) throws CancelledException {
                    iBoxCollector.addNonFace(object);
                }

                @Override
                public void addFace(Object object, int n, Supplier<Pair<Point3d, Vector3d>> supplier) throws CancelledException {
                    iBoxCollector.addFace(object, n2 + n, supplier);
                }
            };
            iGeom.pickBox(object, iIsectFilter, convexHull, iBoxCollector2);
            n += iGeom.getNumPrims(7);
        }
    }

    @Override
    public void pickPoints(final IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        int n = 0;
        AABox aABox = new AABox();
        for (IGeom iGeom : this.children) {
            iIsectCollector.getProgress().check();
            final int n2 = n;
            IIsectCollector iIsectCollector2 = new IIsectCollector(){

                @Override
                public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                    iIsectCollector.addNonFace(object, point3d, geomType);
                }

                @Override
                public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                    iIsectCollector.addFace(object, point3d, n2 + n, supplier, supplier2);
                }

                @Override
                public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                    iIsectCollector.addInfinite(object, point3d, geomType, iPrimitive);
                }

                @Override
                public TaskProgress getProgress() {
                    return iIsectCollector.getProgress();
                }
            };
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            if (iTest.test((AABox)aABox).positive) {
                iGeom.pickPoints(iIsectCollector2, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
            }
            n += iGeom.getNumPrims(7);
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        AABox aABox = new AABox();
        for (IGeom iGeom : this.children) {
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            if (!iTest.test((AABox)aABox).positive) continue;
            iGeom.find(iTest, iResult);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.children) {
            iGeom.getAll(iResult);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (this.children.size() > 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        for (int i = 0; i < this.children.size(); ++i) {
            IGeom iGeom = this.children.get(i);
            if (!(iGeom instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)iGeom)).generateManipHandles()) {
                arrayList.add(new Handle(this, i, iHandle));
            }
        }
        return arrayList;
    }

    private static class Handle
    implements IHandle {
        private GeomGroup d_geom;
        private final int d_ix;
        private final IHandle d_handle;
        private List<IGeom> t_children;

        public Handle(GeomGroup geomGroup, int n, IHandle iHandle) {
            this.d_geom = geomGroup;
            this.d_ix = n;
            this.d_handle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_ix == this.d_ix && ((Handle)object).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_handle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.d_handle.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_children = new ArrayList<IGeom>(this.d_geom.children);
            this.d_handle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            Object object = this.d_handle.modify(point3d);
            this.d_geom = this.modify(object);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_children = null;
            return this.d_geom;
        }

        private GeomGroup modify(Object object) {
            if (object instanceof IGeom) {
                this.t_children.set(this.d_ix, (IGeom)object);
                return new GeomGroup(this.t_children);
            }
            return this.d_geom;
        }
    }
}

