/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class GeneralPoly
extends AFace
implements IPolygon {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;
    public final int[] loopOffsets;

    public GeneralPoly(Collection<Point3d> collection, int ... nArray) {
        this(collection.toArray(new Point3d[collection.size()]), nArray);
    }

    public GeneralPoly(Point3d[] point3dArray, int ... nArray) {
        assert (point3dArray.length >= 3);
        assert (GeneralPoly.checkLoopOffsets(point3dArray, nArray));
        this.points = point3dArray;
        this.loopOffsets = nArray;
    }

    public GeneralPoly(Point3d[][] point3dArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < point3dArray.length; ++n) {
            n2 += point3dArray[n].length;
        }
        this.points = new Point3d[n2];
        n = 0;
        this.loopOffsets = new int[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            this.loopOffsets[i] = n;
            Point3d[] point3dArray2 = point3dArray[i];
            for (int j = 0; j < point3dArray2.length; ++j) {
                this.points[n + j] = point3dArray2[j];
            }
            n += point3dArray[i].length;
        }
    }

    @Override
    public GeneralPoly flipOrient() {
        Point3d[] point3dArray = new Point3d[this.points.length];
        int n = this.loopOffsets.length - 1;
        for (int i = 0; i < this.loopOffsets.length; ++i) {
            int n2 = this.loopOffsets[i];
            int n3 = i == n ? this.points.length : this.loopOffsets[i + 1];
            int n4 = n3 - n2;
            GeomUtil.reverse(this.points, n2, point3dArray, n2, n4);
        }
        return new GeneralPoly(point3dArray, this.loopOffsets);
    }

    @Override
    public Plane3d getPlane(boolean bl) {
        if (this.points.length == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        Vector3d vector3d = this.getNormal(bl);
        return new Plane3d(vector3d, this.points[0]);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean bl) {
        if (this.points.length == 0) {
            return null;
        }
        Vector3d vector3d = this.getNormalIfValid(bl);
        return vector3d != null ? new Plane3d(vector3d, this.points[0]) : null;
    }

    public static boolean checkLoopOffsets(Point3d[] point3dArray, int ... nArray) {
        for (int n : nArray) {
            if (n >= 0 && n < point3dArray.length) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeneralPoly optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.points[i]);
            bl |= point3dArray[i] != this.points[i];
        }
        return bl ? new GeneralPoly(point3dArray, this.loopOffsets) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.points);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public GeneralPoly transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Point3d[] point3dArray = GeomUtil.xformVerts(this.points, transformInfo.getMatrix());
        return new GeneralPoly(point3dArray, this.loopOffsets);
    }

    @Override
    public int getNumLoops() {
        return this.loopOffsets.length;
    }

    @Override
    public int getNumPoints(int n) {
        assert (n >= 0 && n < this.loopOffsets.length);
        if (n == this.loopOffsets.length - 1) {
            return this.points.length - this.loopOffsets[n];
        }
        return this.loopOffsets[n + 1] - this.loopOffsets[n];
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        assert (n >= 0 && n < this.loopOffsets.length);
        return this.points[this.loopOffsets[n] + n2];
    }

    @Override
    public Vector3d getNormal(boolean bl) {
        Vector3d vector3d;
        List<Point3d> list = Arrays.asList(this.points);
        if (this.loopOffsets.length > 1) {
            list = list.subList(0, this.loopOffsets[1]);
        }
        return (vector3d = Util3D.simplePolygonNormal(list, bl, 0.0)) == null ? GeomConstants.VEC3D_ZERO : vector3d;
    }

    @Override
    public Vector3d getNormalIfValid(boolean bl) {
        List<Point3d> list = Arrays.asList(this.points);
        if (this.loopOffsets.length > 1) {
            list = list.subList(0, this.loopOffsets[1]);
        }
        return Util3D.simplePolygonNormal(list, bl, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double d, boolean bl) {
        int n;
        Object object;
        int n2;
        HashMap<Point2d, Point3d> hashMap = new HashMap<Point2d, Point3d>();
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.points), true, 0.0);
        if (plane3d == null) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point2d[] point2dArray = new Point2d[this.points.length];
        MeshBuilder meshBuilder = new MeshBuilder(1.0E-6);
        for (n2 = 0; n2 < this.points.length; ++n2) {
            Point2d point2d = Util3D.xform2d(matrix4d, this.points[n2]);
            hashMap.put(point2d, this.points[n2]);
            point2dArray[n2] = point2d;
        }
        for (n2 = 0; n2 < this.loopOffsets.length; ++n2) {
            int n3 = this.getNumPoints(n2);
            int n4 = this.loopOffsets[n2];
            for (int i = 0; i < n3; ++i) {
                object = point2dArray[n4 + i];
                Point2d point2d = point2dArray[n4 + (i + 1) % n3];
                meshBuilder.addEdge((Point2d)object, point2d);
            }
        }
        thunderheadeng.delaunay.Mesh mesh = meshBuilder.build();
        boolean bl2 = mesh.triangulateEvenOdd(0, 0.0);
        if (!bl2) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        TriangulatorInfo triangulatorInfo = mesh.getOutput();
        object = new int[triangulatorInfo.points.length];
        for (n = 0; n < triangulatorInfo.points.length; ++n) {
            Integer n5;
            Point2d point2d = triangulatorInfo.points[n];
            Point3d point3d = (Point3d)hashMap.get(point2d);
            if (point3d == null) {
                point3d = Util3D.xform(matrix4d2, new Point3d(point2d.x, point2d.y, 0.0));
            }
            if ((n5 = (Integer)linkedHashMap.get(point3d)) == null) {
                n5 = linkedHashMap.size();
                linkedHashMap.put(point3d, n5);
            }
            object[n] = n5;
        }
        for (n = 0; n < triangulatorInfo.triangles.length; ++n) {
            triangulatorInfo.triangles[n] = (int)object[triangulatorInfo.triangles[n]];
        }
        Mesh mesh2 = new Mesh(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), triangulatorInfo.triangles, 2);
        return new Pair<Mesh, Boolean>(mesh2, true);
    }
}

