/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.AExtrudeHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ExtrudedPoly
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final IPolygon poly;
    public final Vector3d extrusion;

    public ExtrudedPoly(IPolygon iPolygon, Vector3d vector3d) {
        this.poly = iPolygon;
        this.extrusion = vector3d;
    }

    @Override
    public ExtrudedPoly optimize(IPointOptimizer iPointOptimizer) {
        IPolygon iPolygon = this.poly.optimize(iPointOptimizer);
        return iPolygon == this.poly ? this : new ExtrudedPoly(iPolygon, this.extrusion);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        this.poly.getBoundingBox(aABox);
        GeomUtil.getTransformedBounds(TransformUtil.translate(this.extrusion.x, this.extrusion.y, this.extrusion.z).getInfo(), this.poly, aABox);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        IPolygon iPolygon = this.poly.transform(transformInfo, n);
        Vector3d vector3d = Util3D.xform(transformInfo.getMatrix(), this.extrusion);
        return new ExtrudedPoly(iPolygon, vector3d);
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        int n2 = this.poly.getNumPrims(n) * 2;
        if ((n & 1) != 0) {
            for (int i = 0; i < this.poly.getNumLoops(); ++i) {
                n2 += this.poly.getNumPoints(i);
            }
        }
        return n2;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        int n;
        IPolygon iPolygon = this.poly;
        collection.add(iPolygon);
        int[] nArray = PolyUtil.getLoopOffsets(iPolygon, false);
        int n2 = 0;
        for (n = 0; n < iPolygon.getNumLoops(); ++n) {
            n2 += iPolygon.getNumPoints(n);
        }
        n = 0;
        Point3d[] point3dArray = new Point3d[n2 * 2];
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            for (int j = 0; j < iPolygon.getNumPoints(i); ++j) {
                point3dArray[n++] = iPolygon.getPoint(i, j);
            }
        }
        Vector3d vector3d = this.extrusion;
        Point3d[] point3dArray2 = new Point3d[n2];
        for (int i = n2; i < point3dArray.length; ++i) {
            Point3d point3d = new Point3d();
            point3d.add(point3dArray[i - n2], vector3d);
            point3dArray[i] = point3d;
            point3dArray2[i - n2] = point3d;
        }
        collection.add(PolyUtil.newPoly(point3dArray2, nArray));
        int[] nArray2 = new int[n2 * 4];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n5; ++j) {
                int n6 = n4 + j;
                int n7 = n4 + (j + 1) % n5;
                nArray2[n3++] = n6;
                nArray2[n3++] = n7;
                nArray2[n3++] = n7 + n2;
                nArray2[n3++] = n6 + n2;
            }
        }
        collection.add(new Mesh(point3dArray, nArray2, 3));
        return collection;
    }

    private List<IGeom> explode() {
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>(3);
        this.explode(arrayList);
        return arrayList;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        return Boolean.FALSE;
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        new GeomGroup(this.explode()).pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        new GeomGroup(this.explode()).pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.explode()) {
            iGeom.find(iTest, iResult);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.explode()) {
            iGeom.getAll(iResult);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<IHandle> arrayList = new ArrayList<IHandle>();
        for (int i = 0; i < 2; ++i) {
            boolean bl = i == 0;
            int n = this.poly.getNumLoops();
            for (int j = 0; j < n; ++j) {
                int n2 = this.poly.getNumPoints(j);
                for (int k = 0; k < n2; ++k) {
                    arrayList.add(new VertHandle(this, j, k, bl));
                }
            }
        }
        arrayList.add(new ExtrusionHandle(this, true));
        arrayList.add(new ExtrusionHandle(this, false));
        return arrayList;
    }

    private static class VertHandle
    implements IHandle {
        private ExtrudedPoly geom;
        private final int loop;
        private final int vert;
        private final boolean bottom;

        public VertHandle(ExtrudedPoly extrudedPoly, int n, int n2, boolean bl) {
            this.geom = extrudedPoly;
            this.loop = n;
            this.vert = n2;
            this.bottom = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof VertHandle)) {
                return false;
            }
            VertHandle vertHandle = (VertHandle)object;
            return vertHandle.loop == this.loop && vertHandle.vert == this.vert && vertHandle.bottom == this.bottom;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.getLocation()));
        }

        protected Point3d getLocation() {
            Point3d point3d = this.geom.poly.getPoint(this.loop, this.vert);
            if (!this.bottom) {
                point3d = Util3D.add(point3d, (Tuple3d)this.geom.extrusion);
            }
            return point3d;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            Plane3d plane3d;
            if (this.bottom) {
                plane3d = this.geom.poly.getPlane(true);
            } else {
                Vector3d vector3d = this.geom.poly.getNormal(true);
                Point3d point3d2 = Util3D.add(this.geom.poly.getPoint(this.loop, this.vert), (Tuple3d)this.geom.extrusion);
                plane3d = new Plane3d(vector3d, point3d2);
            }
            return new PlanarConstraint(plane3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public ExtrudedPoly modify(Point3d point3d) throws ManipException {
            if (!this.bottom) {
                point3d = Util3D.sub(point3d, (Tuple3d)this.geom.extrusion);
            }
            Point3d[][] point3dArray = PolyUtil.getLoops(this.geom.poly, true);
            point3dArray[this.loop][this.vert] = point3d;
            this.geom = new ExtrudedPoly(PolyUtil.newPoly(point3dArray), this.geom.extrusion);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    private static class ExtrusionHandle
    extends AExtrudeHandle<ExtrudedPoly> {
        private final boolean d_top;

        public ExtrusionHandle(ExtrudedPoly extrudedPoly, boolean bl) {
            super(extrudedPoly);
            this.d_top = bl;
        }

        @Override
        public IGeomNode getGeom() {
            ExtrudedPoly extrudedPoly = (ExtrudedPoly)this.getManipGeom();
            IPolygon iPolygon = this.d_top ? extrudedPoly.poly.transform(TransformUtil.translate(extrudedPoly.extrusion.x, extrudedPoly.extrusion.y, extrudedPoly.extrusion.z).getInfo(), 1) : extrudedPoly.poly;
            return GeomNodeUtil.newNode(iPolygon);
        }

        @Override
        protected Vector3d getExtrudeDir(ExtrudedPoly extrudedPoly) {
            return theUtil.eq0(extrudedPoly.extrusion.length(), 1.0E-6) ? extrudedPoly.poly.getNormal(true) : Util3D.normalize(extrudedPoly.extrusion);
        }

        @Override
        protected ExtrudedPoly extrude(ExtrudedPoly extrudedPoly, Vector3d vector3d, double d) throws ManipException {
            vector3d = Util3D.scale(vector3d, d);
            if (this.d_top) {
                vector3d = Util3D.add(extrudedPoly.extrusion, (Tuple3d)vector3d);
                return new ExtrudedPoly(extrudedPoly.poly, vector3d);
            }
            ITransform iTransform = TransformUtil.translate(vector3d.x, vector3d.y, vector3d.z);
            IPolygon iPolygon = extrudedPoly.poly.transform(iTransform.getInfo(), 1);
            vector3d = Util3D.sub(extrudedPoly.extrusion, (Tuple3d)vector3d);
            return new ExtrudedPoly(iPolygon, vector3d);
        }
    }
}

