/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACubicSpline;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class CubicBezierSpline
extends ACubicSpline {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d c1;
    public final Point3d c2;
    public final Point3d p2;

    public CubicBezierSpline(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        super(point3d4.x - 3.0 * point3d3.x + 3.0 * point3d2.x - point3d.x, 3.0 * point3d3.x - 6.0 * point3d2.x + 3.0 * point3d.x, 3.0 * point3d2.x - 3.0 * point3d.x, point3d.x, point3d4.y - 3.0 * point3d3.y + 3.0 * point3d2.y - point3d.y, 3.0 * point3d3.y - 6.0 * point3d2.y + 3.0 * point3d.y, 3.0 * point3d2.y - 3.0 * point3d.y, point3d.y, point3d4.z - 3.0 * point3d3.z + 3.0 * point3d2.z - point3d.z, 3.0 * point3d3.z - 6.0 * point3d2.z + 3.0 * point3d.z, 3.0 * point3d2.z - 3.0 * point3d.z, point3d.z);
        this.p1 = point3d;
        this.c1 = point3d2;
        this.c2 = point3d3;
        this.p2 = point3d4;
    }

    @Override
    public CubicBezierSpline reverse() {
        return new CubicBezierSpline(this.p2, this.c2, this.c1, this.p1);
    }

    @Override
    public Point3d get(double d) {
        if (d == 0.0) {
            return this.p1;
        }
        if (d == 1.0) {
            return this.p2;
        }
        return super.get(d);
    }

    public ACubicSpline projectToPlane(Plane3d plane3d, Matrix4d matrix4d) {
        return new CubicBezierSpline(CubicBezierSpline.project(this.p1, plane3d, matrix4d), CubicBezierSpline.project(this.c1, plane3d, matrix4d), CubicBezierSpline.project(this.c2, plane3d, matrix4d), CubicBezierSpline.project(this.p2, plane3d, matrix4d));
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public CubicBezierSpline transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        return new CubicBezierSpline(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.c1), Util3D.xform(matrix4d, this.c2), Util3D.xform(matrix4d, this.p2));
    }

    @Override
    public CubicBezierSpline optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p1);
        Point3d point3d2 = iPointOptimizer.getExisting(this.c1);
        Point3d point3d3 = iPointOptimizer.getExisting(this.c2);
        Point3d point3d4 = iPointOptimizer.getExisting(this.p2);
        if (point3d == this.p1 && point3d2 == this.c1 && point3d3 == this.c2 && point3d4 == this.p2) {
            return this;
        }
        return new CubicBezierSpline(point3d, point3d2, point3d3, point3d4);
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        return point3d;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.p1, this.c1, this.c2, this.p2);
        return aABox;
    }
}

