/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class ClosedLinearCurve
extends ACurve
implements ILinearCurve,
IManipulatable {
    public static final long serialVersionUID = 4032153402700153011L;
    public static final long serialVersionUID_old = 8783959934722819851L;
    public final ILinearCurve base;

    public ClosedLinearCurve(ILinearCurve iLinearCurve) {
        assert (iLinearCurve.getNumVerts() >= 3);
        assert (iLinearCurve.getVert(0).epsilonEquals(iLinearCurve.getVert(iLinearCurve.getNumVerts() - 1), 1.0E-9));
        this.base = iLinearCurve;
    }

    @Override
    public ILinearCurve transform(TransformInfo transformInfo, int n) {
        ILinearCurve iLinearCurve = this.base.transform(transformInfo, n);
        if (iLinearCurve == this.base) {
            return this;
        }
        return new ClosedLinearCurve(iLinearCurve);
    }

    @Override
    public ClosedLinearCurve reverse() {
        return new ClosedLinearCurve(this.base.reverse());
    }

    @Override
    public ILinearCurve optimize(IPointOptimizer iPointOptimizer) {
        ILinearCurve iLinearCurve = this.base.optimize(iPointOptimizer);
        if (iLinearCurve == this.base) {
            return this;
        }
        return new ClosedLinearCurve(iLinearCurve);
    }

    @Override
    public Mesh getSegments(double d) {
        return this.base.getSegments(d);
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        return this.base.project(point3d, d);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        return this.base.getBoundingBox(aABox);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return this.base.getDOF();
    }

    @Override
    public IDOF getRetainingDOF() {
        return this.base.getRetainingDOF();
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        this.base.pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        this.base.pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    public int getNumVerts() {
        return this.base.getNumVerts();
    }

    @Override
    public Point3d getVert(int n) {
        return this.base.getVert(n);
    }

    @Override
    protected int getPrimType() {
        return super.getPrimType();
    }

    @Override
    public ILinearCurve newCurve(Point3d ... point3dArray) {
        return new ClosedLinearCurve(this.base.newCurve(point3dArray));
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (!(this.base instanceof IManipulatable)) {
            return Collections.emptyList();
        }
        ArrayList<? extends IHandle> arrayList = new ArrayList<IHandle>(this.base.generateManipHandles());
        ArrayList<Handle> arrayList2 = new ArrayList<Handle>(arrayList.size() - 1);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            arrayList2.add(new Handle(this.base, (IHandle)arrayList.get(i), i == 0));
        }
        return arrayList2;
    }

    private static class Handle
    implements IHandle {
        private final ILinearCurve d_baseCurve;
        private final IHandle d_base;
        private final boolean d_first;

        public Handle(ILinearCurve iLinearCurve, IHandle iHandle, boolean bl) {
            this.d_baseCurve = iLinearCurve;
            this.d_base = iHandle;
            this.d_first = bl;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_base.equals(this.d_base) && ((Handle)object).d_first == this.d_first;
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_base.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_base.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.d_base.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.d_base.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            return this.modify(this.d_base.modify(point3d));
        }

        @Override
        public Object end() {
            return this.modify(this.d_base.end());
        }

        private Object modify(Object object) {
            if (object instanceof ILinearCurve) {
                ILinearCurve iLinearCurve = (ILinearCurve)object;
                if (!this.d_first) {
                    return new ClosedLinearCurve(iLinearCurve);
                }
                Point3d[] point3dArray = new Point3d[iLinearCurve.getNumVerts()];
                for (int i = 0; i < iLinearCurve.getNumVerts() - 1; ++i) {
                    point3dArray[i] = iLinearCurve.getVert(i);
                }
                point3dArray[point3dArray.length - 1] = point3dArray[0];
                return new ClosedLinearCurve(this.d_baseCurve.newCurve(point3dArray));
            }
            return null;
        }
    }
}

