/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACubicSpline;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class CatmullRomSpline
extends ACubicSpline {
    static final long serialVersionUID = 1L;
    public final Type type;
    public final Point3d p0;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public CatmullRomSpline(Type type, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        super(CatmullRomSpline.getCoefficients(type, point3d, point3d2, point3d3, point3d4));
        this.type = type;
        this.p0 = point3d;
        this.p1 = point3d2;
        this.p2 = point3d3;
        this.p3 = point3d4;
    }

    private static final double[] getCoefficients(Type type, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        double d = type.alpha * 0.5;
        double d2 = Math.pow(point3d.distanceSquared(point3d2), d);
        double d3 = Math.pow(point3d2.distanceSquared(point3d3), d);
        double d4 = Math.pow(point3d3.distanceSquared(point3d4), d);
        if (d3 < 1.0E-4) {
            d3 = 1.0;
        }
        if (d2 < 1.0E-4) {
            d2 = d3;
        }
        if (d4 < 1.0E-4) {
            d4 = d3;
        }
        double[] dArray = new double[12];
        CatmullRomSpline.initNonuniformCatmullRom(dArray, 0, d2, d3, d4, point3d.x, point3d2.x, point3d3.x, point3d4.x);
        CatmullRomSpline.initNonuniformCatmullRom(dArray, 4, d2, d3, d4, point3d.y, point3d2.y, point3d3.y, point3d4.y);
        CatmullRomSpline.initNonuniformCatmullRom(dArray, 8, d2, d3, d4, point3d.z, point3d2.z, point3d3.z, point3d4.z);
        return dArray;
    }

    private static final void initNonuniformCatmullRom(double[] dArray, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d5 - d4) / d - (d6 - d4) / (d + d2) + (d6 - d5) / d2;
        double d9 = (d6 - d5) / d2 - (d7 - d5) / (d2 + d3) + (d7 - d6) / d3;
        CatmullRomSpline.initCubicPoly(dArray, n, d5, d6, d8 *= d2, d9 *= d2);
    }

    private static final void initCatmullRom(double[] dArray, int n, double d, double d2, double d3, double d4) {
        CatmullRomSpline.initCubicPoly(dArray, n, d2, d3, 0.5 * (d3 - d), 0.5 * (d4 - d2));
    }

    private static final void initCubicPoly(double[] dArray, int n, double d, double d2, double d3, double d4) {
        dArray[n + 3] = d;
        dArray[n + 2] = d3;
        dArray[n + 1] = -3.0 * d + 3.0 * d2 - 2.0 * d3 - d4;
        dArray[n + 0] = 2.0 * d - 2.0 * d2 + d3 + d4;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public CatmullRomSpline transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        Matrix4d matrix4d = transformInfo.getMatrix();
        return new CatmullRomSpline(this.type, Util3D.xform(matrix4d, this.p0), Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2), Util3D.xform(matrix4d, this.p3));
    }

    @Override
    public CatmullRomSpline optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p0);
        Point3d point3d2 = iPointOptimizer.getExisting(this.p1);
        Point3d point3d3 = iPointOptimizer.getExisting(this.p2);
        Point3d point3d4 = iPointOptimizer.getExisting(this.p3);
        if (point3d == this.p0 && point3d2 == this.p1 && point3d3 == this.p2 && point3d4 == this.p3) {
            return this;
        }
        return new CatmullRomSpline(this.type, point3d, point3d2, point3d3, point3d4);
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        return point3d;
    }

    @Override
    public Point3d get(double d) {
        if (d == 0.0) {
            return this.p1;
        }
        if (d == 1.0) {
            return this.p2;
        }
        return super.get(d);
    }

    @Override
    public CatmullRomSpline reverse() {
        return new CatmullRomSpline(this.type, this.p3, this.p2, this.p1, this.p0);
    }

    public static enum Type {
        UNIFORM(0.0),
        CHORDAL(1.0),
        CENTRIPETAL(0.5);

        public final double alpha;

        private Type(double d) {
            this.alpha = d;
        }
    }
}

