/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MatrixXform;

public class BGImageXform
implements ITransform {
    private static final long serialVersionUID = 1L;
    public final Point2d anchorImage;
    public final Point3d anchorModel;
    public final Point2d aImage;
    public final Point2d bImage;
    public final double distABModel;
    public final double abAngle;

    public BGImageXform(Point2d point2d, Point3d point3d, Point2d point2d2, Point2d point2d3, double d, double d2) {
        this.anchorImage = point2d;
        this.anchorModel = point3d;
        this.aImage = point2d2;
        this.bImage = point2d3;
        this.distABModel = d;
        this.abAngle = Double.isNaN(d2) ? Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(point2d2, point2d3)) : d2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BGImageXform)) {
            return false;
        }
        BGImageXform bGImageXform = (BGImageXform)object;
        return this.anchorImage.equals(bGImageXform.anchorImage) && this.anchorModel.equals(bGImageXform.anchorModel) && this.aImage.equals(bGImageXform.aImage) && this.bImage.equals(bGImageXform.bImage) && this.distABModel == bGImageXform.distABModel && this.abAngle == bGImageXform.abAngle;
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        if (this.isIdentity()) {
            return matrix4d;
        }
        matrix4d.setTranslation(new Vector3d(this.anchorModel.x, this.anchorModel.y, this.anchorModel.z));
        double d = BGImageXform.getBackgroundImageScale(this.aImage, this.bImage, this.distABModel);
        matrix4d.mul(Util.scaleMat(d, d, 1.0));
        double d2 = BGImageXform.getBGImageRotation(this.aImage, this.bImage, this.abAngle);
        matrix4d.mul(Util.rotMat(0.0, 0.0, 1.0, d2));
        matrix4d.mul(Util.translateMat(-this.anchorImage.x, -this.anchorImage.y, 0.0));
        return matrix4d;
    }

    private static double getBackgroundImageScale(Point2d point2d, Point2d point2d2, double d) {
        double d2 = point2d.distance(point2d2);
        return d / d2;
    }

    private static double getBGImageRotation(Point2d point2d, Point2d point2d2, double d) {
        Vector2d vector2d = Util2D.vector(point2d, point2d2);
        double d2 = Util2D.angle(new Vector2d(1.0, 0.0), vector2d);
        return d - d2;
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new MatrixXform(this.toMatrix(false)).invert();
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return this;
    }

    @Override
    public boolean isIdentity() {
        return this.aImage.equals(this.bImage) || this.distABModel == 0.0;
    }
}

