/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IParametricCurve;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public abstract class ACubicSpline
extends ACurve
implements IParametricCurve {
    static final long serialVersionUID = 1L;
    public final double ax;
    public final double bx;
    public final double cx;
    public final double dx;
    public final double ay;
    public final double by;
    public final double cy;
    public final double dy;
    public final double az;
    public final double bz;
    public final double cz;
    public final double dz;

    public ACubicSpline(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.ax = d;
        this.ay = d5;
        this.az = d9;
        this.bx = d2;
        this.by = d6;
        this.bz = d10;
        this.cx = d3;
        this.cy = d7;
        this.cz = d11;
        this.dx = d4;
        this.dy = d8;
        this.dz = d12;
    }

    public ACubicSpline(double[] dArray) {
        this(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], dArray[10], dArray[11]);
    }

    @Override
    public abstract ACubicSpline reverse();

    @Override
    public Point3d get(double d) {
        double d2 = d * d;
        double d3 = d2 * d;
        return new Point3d(this.ax * d3 + this.bx * d2 + this.cx * d + this.dx, this.ay * d3 + this.by * d2 + this.cy * d + this.dy, this.az * d3 + this.bz * d2 + this.cz * d + this.dz);
    }

    @Override
    public Vector3d getTangent(double d, ICurve.Orient orient, boolean bl) {
        double d2 = d * d;
        Vector3d vector3d = new Vector3d(3.0 * this.ax * d2 + 2.0 * this.bx * d + this.cx, 3.0 * this.ay * d2 + 2.0 * this.by * d + this.cy, 3.0 * this.az * d2 + 2.0 * this.bz * d + this.cz);
        if (orient == ICurve.Orient.NEGATIVE) {
            vector3d.negate();
        }
        if (bl) {
            Util3D.safeNormalize(vector3d, 1.0E-12);
        }
        return vector3d;
    }

    public double[] getIsects(Plane3d plane3d, double d) {
        double d2 = plane3d.x * this.ax + plane3d.y * this.ay + plane3d.z * this.az;
        double d3 = plane3d.x * this.bx + plane3d.y * this.by + plane3d.z * this.bz;
        double d4 = plane3d.x * this.cx + plane3d.y * this.cy + plane3d.z * this.cz;
        double d5 = plane3d.w;
        double[] dArray = theMath.solveCubic(d2, d3, d4, d5);
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = Util.clampTIfValid(dArray[i], 0.0, 1.0, d);
            if (Double.isNaN(d6)) continue;
            arrayList.add(d6);
        }
        return theUtil.toDoubleArray(arrayList);
    }

    protected static Point3d project(Point3d point3d, Plane3d plane3d, Matrix4d matrix4d) {
        Point3d point3d2 = plane3d.projectOntoPlane(point3d);
        matrix4d.transform(point3d2);
        return point3d2;
    }

    @Override
    public Mesh getSegments(double d) {
        Point3d[] point3dArray = new Point3d[25];
        double d2 = 0.041666666666666664;
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = this.get((double)i * d2);
        }
        int[] nArray = new int[48];
        for (int i = 0; i < point3dArray.length - 1; ++i) {
            nArray[i * 2] = i;
            nArray[i * 2 + 1] = i + 1;
        }
        return new Mesh(point3dArray, nArray, 1);
    }

    public double length(double d) {
        double d2 = 0.0;
        Mesh mesh = this.getSegments(d);
        for (int i = 0; i < mesh.indices.length; i += 2) {
            Point3d point3d = mesh.vertices[mesh.indices[i]];
            Point3d point3d2 = mesh.vertices[mesh.indices[i + 1]];
            d2 += point3d.distance(point3d2);
        }
        return d2;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        return this.getSegments(0.001).getBoundingBox(aABox);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Mesh mesh = this.getSegments(0.001);
        mesh.pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        this.getSegments(0.001).pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }
}

