/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;

public class Vertex
extends AModelObj {
    static final long serialVersionUID = 1L;
    public Point3d loc;
    public transient List<Edge> edges = new ArrayList<Edge>(2);
    public transient Face face = null;

    public Vertex(Point3d point3d) {
        this.loc = point3d;
    }

    @Override
    public AABox getBounds() {
        return new AABox(this.loc);
    }

    public String toString() {
        return String.format("[Vertex] %s", this.loc.toString());
    }

    @Override
    public Object clone() {
        Vertex vertex = (Vertex)super.clone();
        vertex.edges = new ArrayList<Edge>(this.edges.size());
        vertex.face = null;
        return vertex;
    }

    public boolean isConnected() {
        return this.face != null || !this.edges.isEmpty();
    }

    public void addEdge(Edge edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.edges);
        objectOutputStream.writeObject(this.face);
    }

    @Override
    public void readTopology(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.edges = (List)objectInputStream.readObject();
        this.face = (Face)objectInputStream.readObject();
    }
}

