/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.ISearchVol;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class Model
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int SEARCHACTION_ADD = 0;
    public static final int SEARCHACTION_UPDATE = 1;
    public static final int SEARCHACTION_REMOVE = 2;
    public static final double DIST_TOL = 1.0E-6;
    public static final double DIST_TOL_SQ = 1.0E-12;
    static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());
    private transient GeomSearcher<Face> d_faceSearch = Model.newSearcher();
    private transient GeomSearcher<Edge> d_edgeSearch = Model.newSearcher();
    private transient GeomSearcher<Vertex> d_vertSearch = Model.newSearcher();
    private Group d_mainGroup = new Group(-1, LinkedIdentityHashSet.class);

    private static <T extends AModelObj> GeomSearcher<T> newSearcher() {
        return new TreeSearcher();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (Face aModelObj : this.d_mainGroup.faces) {
            aModelObj.writeTopology(objectOutputStream);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.writeTopology(objectOutputStream);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            vertex.writeTopology(objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ArrayList<Face> arrayList = new ArrayList<Face>();
        for (Face aModelObj : this.d_mainGroup.faces) {
            aModelObj.readTopology(objectInputStream);
            if (!aModelObj.edgeLoops.isEmpty()) continue;
            arrayList.add(aModelObj);
        }
        this.d_mainGroup.faces.removeAll(arrayList);
        for (Edge edge : this.d_mainGroup.edges) {
            edge.readTopology(objectInputStream);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            vertex.readTopology(objectInputStream);
        }
        this.d_faceSearch = Model.newSearcher();
        this.d_edgeSearch = Model.newSearcher();
        this.d_vertSearch = Model.newSearcher();
        for (Face face : this.d_mainGroup.faces) {
            this.updateFaceSearch(face, 0);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            this.updateEdgeSearch(edge, 0);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            this.updateVertexSearch(vertex, 0);
        }
    }

    public void addGroupId(int n) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.addGroup(n);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.addGroup(n);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.addGroup(n);
        }
    }

    public void removeGroupIds(int ... nArray) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.removeGroups(nArray);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.removeGroups(nArray);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.removeGroups(nArray);
        }
    }

    public Object clone() {
        return this.clone(Predicates.alwaysTrue(), Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public Model clone(Predicate<Vertex> predicate, Predicate<Edge> predicate2, Predicate<Face> predicate3) {
        AModelObj aModelObj;
        Model model;
        try {
            model = (Model)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        model.d_mainGroup = new Group(this.d_mainGroup.id, LinkedIdentityHashSet.class);
        CloneMap cloneMap = new CloneMap();
        Predicate<Face> predicate4 = predicate3;
        Predicate<Edge> predicate5 = Predicates.alwaysTrue(predicate4) ? predicate2 : edge -> {
            if (predicate2.test((Edge)edge)) {
                return true;
            }
            for (Face face : edge.faces) {
                if (!predicate4.test(face)) continue;
                return true;
            }
            return false;
        };
        Predicate<Vertex> predicate6 = Predicates.alwaysTrue(predicate4) && Predicates.alwaysTrue(predicate5) ? predicate : vertex -> {
            if (predicate.test((Vertex)vertex)) {
                return true;
            }
            if (vertex.face != null && predicate4.test(vertex.face)) {
                return true;
            }
            for (Edge edge : vertex.edges) {
                if (!predicate5.test(edge)) continue;
                return true;
            }
            return false;
        };
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Vertex aModelObj2 : this.d_mainGroup.verts) {
            if (!predicate6.test(aModelObj2)) {
                ++n;
                continue;
            }
            aModelObj = (Vertex)aModelObj2.clone();
            cloneMap.put(aModelObj2, (Vertex)aModelObj);
            model.d_mainGroup.verts.add((Vertex)aModelObj);
        }
        for (Edge edge2 : this.d_mainGroup.edges) {
            if (!predicate5.test(edge2)) {
                ++n2;
                continue;
            }
            aModelObj = edge2.clone(cloneMap);
            cloneMap.put(edge2, (Edge)aModelObj);
            ((Edge)aModelObj).buildConnections();
            model.d_mainGroup.edges.add((Edge)aModelObj);
        }
        for (Face face : this.d_mainGroup.faces) {
            if (!predicate4.test(face)) {
                ++n3;
                continue;
            }
            aModelObj = face.clone(cloneMap);
            if (!((Face)aModelObj).isValid(this)) {
                LOGGER.log(Level.WARNING, "0x73849e Invalid face orient");
            }
            cloneMap.put(face, (Face)aModelObj);
            ((Face)aModelObj).buildConnections();
            model.d_mainGroup.faces.add((Face)aModelObj);
        }
        model.d_vertSearch = n == 0 ? this.d_vertSearch.clone(cloneMap.getVertMap()) : this.initSearches(cloneMap.getVertMap().values());
        model.d_edgeSearch = n2 == 0 ? this.d_edgeSearch.clone(cloneMap.getEdgeMap()) : this.initSearches(cloneMap.getEdgeMap().values());
        model.d_faceSearch = n3 == 0 ? this.d_faceSearch.clone(cloneMap.getFaceMap()) : this.initSearches(cloneMap.getFaceMap().values());
        return model;
    }

    private <T extends AModelObj> GeomSearcher<T> initSearches(Collection<T> collection) {
        GeomSearcher<T> geomSearcher = Model.newSearcher();
        collection.forEach(geomSearcher::add);
        return geomSearcher;
    }

    public void clear() {
        this.d_faceSearch.clear();
        this.d_edgeSearch.clear();
        this.d_vertSearch.clear();
        this.d_mainGroup.clear();
    }

    public Collection<Face> getFaces() {
        return this.d_mainGroup.faces;
    }

    public Collection<Edge> getEdges() {
        return this.d_mainGroup.edges;
    }

    public Collection<Vertex> getVerts() {
        return this.d_mainGroup.verts;
    }

    public AABox getBoundingBox() {
        AABox aABox = new AABox();
        aABox.add(this.d_vertSearch.getBounds());
        aABox.add(this.d_edgeSearch.getBounds());
        aABox.add(this.d_faceSearch.getBounds());
        return aABox;
    }

    public void divideEdges(double d) {
        Edge[] edgeArray;
        if (d == Double.MAX_VALUE || Double.isInfinite(d) || d <= 0.0) {
            return;
        }
        for (Edge edge : edgeArray = this.d_mainGroup.edges.toArray(new Edge[this.d_mainGroup.edges.size()])) {
            this.divideEdge(edge, d);
        }
    }

    private void divideEdge(Edge edge, double d) {
        double d2 = edge.curve.length();
        if (d2 > d) {
            double d3 = d2 / d;
            double d4 = Math.floor(d3);
            double d5 = d3 - d4;
            d3 = theUtil.gt0(d5, 1.0E-6) ? d4 + 1.0 : d4;
            IParametric3D iParametric3D = edge.curve;
            int[] nArray = edge.groups;
            double[] dArray = new double[(int)d3 - 1];
            Vertex[] vertexArray = new Vertex[dArray.length];
            int n = 1;
            while ((double)n < d3) {
                double d6;
                dArray[n - 1] = d6 = (double)n / d3;
                vertexArray[n - 1] = this.addVertexToRegion(iParametric3D.get(d6), nArray);
                ++n;
            }
            this.addVerticesToEdge(edge, dArray, vertexArray);
        }
    }

    public Triangulation triangulate(double d) {
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Face face : this.d_mainGroup.faces) {
            face.triangulate(d, linkedHashMap, arrayList);
        }
        return new Triangulation(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), theUtil.toIntArray(arrayList));
    }

    public void addEdges(int n, Collection<? extends IParametric3D> collection) {
        this.addEdges(collection, n);
    }

    public void addEdges(Collection<? extends IParametric3D> collection, int ... nArray) {
        this.addEdges(collection, Collections.nCopies(collection.size(), nArray));
    }

    public void addEdges(Collection<? extends IParametric3D> collection, Collection<int[]> collection2) {
        assert (collection.size() == collection2.size());
        Model model = new Model();
        Iterator<int[]> iterator = collection2.iterator();
        assert (collection2.size() == collection.size());
        for (IParametric3D iParametric3D : collection) {
            this.addEdge(iParametric3D, model, iterator.next());
        }
    }

    public void addEdge(int n, IParametric3D iParametric3D) {
        this.addEdge(iParametric3D, n);
    }

    public void addEdge(IParametric3D iParametric3D, int ... nArray) {
        Model model = new Model();
        this.addEdge(iParametric3D, model, nArray);
    }

    private boolean addEdge(int n, IParametric3D iParametric3D, Model model) {
        return this.addEdge(iParametric3D, model, n);
    }

    private boolean addEdge(IParametric3D iParametric3D, Model model, int ... nArray) {
        if (iParametric3D.length() <= 1.0E-6) {
            return false;
        }
        Point3d point3d = iParametric3D.get(0.0);
        Point3d point3d2 = iParametric3D.get(1.0);
        model.clear();
        Vertex vertex = model.addVertexToRegion(point3d, nArray);
        Vertex vertex2 = model.addVertexToRegion(point3d2, nArray);
        model.addEdgeToRegion(iParametric3D, vertex, vertex2, nArray);
        this.merge(model);
        return true;
    }

    public void addFace(Face face, int ... nArray) {
        Serializable serializable;
        Object object;
        Model model = new Model();
        IdentityHashMap<Vertex, Vertex> identityHashMap = new IdentityHashMap<Vertex, Vertex>();
        IdentityHashMap<Edge, Vertex> identityHashMap2 = new IdentityHashMap<Edge, Vertex>();
        for (FaceLoop object22 : face.edgeLoops) {
            for (Vertex vertex : object22.getVerts()) {
                if (identityHashMap.containsKey(vertex)) continue;
                object = nArray.length == 0 ? vertex.groups : nArray;
                serializable = model.addVertexToRegion(vertex.loc, (int[])object);
                identityHashMap.put(vertex, (Vertex)serializable);
            }
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            for (EdgeUse edgeUse : faceLoop.edges) {
                if (identityHashMap2.containsKey(edgeUse.edge)) continue;
                object = nArray.length == 0 ? edgeUse.edge.groups : nArray;
                serializable = model.addEdgeToRegion(edgeUse.edge.curve, (Vertex)identityHashMap.get(edgeUse.edge.v1), (Vertex)identityHashMap.get(edgeUse.edge.v2), (int[])object);
                identityHashMap2.put(edgeUse.edge, (Vertex)serializable);
            }
        }
        ArrayList arrayList = new ArrayList(face.edgeLoops.size());
        for (FaceLoop faceLoop : face.edgeLoops) {
            FaceLoop faceLoop2 = new FaceLoop(face.edgeLoops.size());
            if (faceLoop.vert != null) {
                assert (identityHashMap.get(faceLoop.vert) != null);
                faceLoop2.vert = (Vertex)identityHashMap.get(faceLoop.vert);
            }
            object = faceLoop.edges.iterator();
            while (object.hasNext()) {
                serializable = (EdgeUse)object.next();
                Edge edge = (Edge)identityHashMap2.get(((EdgeUse)serializable).edge);
                assert (edge != null);
                faceLoop2.edges.add(new EdgeUse(edge, ((EdgeUse)serializable).orient));
            }
            if (faceLoop2.vert == null && faceLoop2.edges.isEmpty()) continue;
            arrayList.add(faceLoop2);
        }
        int[] nArray2 = nArray.length == 0 ? face.groups : nArray;
        model.addFaceToRegion(face.plane, (List<FaceLoop>)arrayList, nArray2);
        this.merge(model);
    }

    public void add(Collection<Face> collection, Collection<Edge> collection2, Collection<Vertex> collection3) {
        Model model = new Model();
        IdentityHashMap<Vertex, Vertex> identityHashMap = new IdentityHashMap<Vertex, Vertex>();
        Function<Vertex, Vertex> function = vertex -> model.addVertexToRegion(vertex.loc, vertex.groups);
        IdentityHashMap<Edge, Edge> identityHashMap2 = new IdentityHashMap<Edge, Edge>();
        Function<Edge, Edge> function2 = edge -> {
            Vertex vertex = (Vertex)identityHashMap.computeIfAbsent(edge.v1, function);
            Vertex vertex2 = (Vertex)identityHashMap.computeIfAbsent(edge.v2, function);
            return model.addEdgeToRegion(edge.curve, vertex, vertex2, edge.groups);
        };
        for (Vertex aModelObj : collection3) {
            identityHashMap.computeIfAbsent(aModelObj, function);
        }
        for (Edge edge2 : collection2) {
            identityHashMap2.computeIfAbsent(edge2, function2);
        }
        for (Face face : collection) {
            ArrayList<FaceLoop> arrayList = new ArrayList<FaceLoop>(face.edgeLoops.size());
            for (FaceLoop faceLoop : face.edgeLoops) {
                FaceLoop faceLoop2 = new FaceLoop(face.edgeLoops.size());
                if (faceLoop.vert != null) {
                    faceLoop2.vert = identityHashMap.computeIfAbsent(faceLoop.vert, function);
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    Edge edge3 = identityHashMap2.computeIfAbsent(edgeUse.edge, function2);
                    faceLoop2.edges.add(new EdgeUse(edge3, edgeUse.orient));
                }
                if (faceLoop2.vert == null && faceLoop2.edges.isEmpty()) continue;
                arrayList.add(faceLoop2);
            }
            Object object = face.groups;
            model.addFaceToRegion(face.plane, arrayList, (int[])object);
        }
        this.merge(model);
    }

    public void deleteFace(Face face, boolean bl, boolean bl2) {
        this.updateFaceSearch(face, 2);
        face.clearConnections();
        this.d_mainGroup.faces.remove(face);
        if (bl || bl2) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (faceLoop.vert != null && bl2 && !faceLoop.vert.isConnected()) {
                    this.deleteVertex(faceLoop.vert);
                    continue;
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    if (edgeUse.edge.isConnected()) continue;
                    this.deleteEdge(edgeUse.edge, bl2);
                }
            }
        }
    }

    public void deleteEdge(Edge edge, boolean bl) {
        assert (edge.faces.isEmpty());
        this.updateEdgeSearch(edge, 2);
        edge.clearConnections();
        this.d_mainGroup.edges.remove(edge);
        if (bl) {
            if (!edge.v1.isConnected()) {
                this.deleteVertex(edge.v1);
            }
            if (!edge.v2.isConnected()) {
                this.deleteVertex(edge.v2);
            }
        }
    }

    public void deleteVertex(Vertex vertex) {
        assert (vertex.edges.isEmpty() && vertex.face == null);
        this.updateVertexSearch(vertex, 2);
        this.d_mainGroup.verts.remove(vertex);
    }

    public boolean addPolygonFace(int n, Plane3d plane3d, Point3d ... point3dArray) {
        int[] nArray = new int[]{n};
        return this.addPolygonFace(plane3d, new Point3d[][]{point3dArray}, nArray, Collections.nCopies(point3dArray.length, nArray));
    }

    public boolean addPolygonFace(Plane3d plane3d, Point3d[][] point3dArray, int[] nArray, Collection<int[]> collection) {
        Point3d[] point3dArray2;
        if (point3dArray.length == 1) {
            point3dArray2 = point3dArray[0];
            Point3d[][] point3dArray3 = Util3D.deleteDupPoints(1.0E-6, true, point3dArray2);
            if (point3dArray3.length < 3) {
                return false;
            }
            if (point3dArray2 == point3dArray3) {
                if (point3dArray3.length == 3) {
                    Vector3d vector3d = Util3D.vector((Point3d)point3dArray3[0], (Point3d)point3dArray3[1]);
                    double d = Inter3D.distSqToNearestPtOnLine((Point3d)point3dArray3[0], vector3d, (Point3d)point3dArray3[2]);
                    if (d <= 1.0E-12) {
                        return false;
                    }
                    Model model = new Model();
                    Vertex vertex = model.addVertexToRegion((Point3d)point3dArray3[0], nArray);
                    Vertex vertex2 = model.addVertexToRegion((Point3d)point3dArray3[1], nArray);
                    Vertex vertex3 = model.addVertexToRegion((Point3d)point3dArray3[2], nArray);
                    Iterator<int[]> iterator = collection.iterator();
                    Edge edge = model.addEdgeToRegion(new LineSeg3D((Point3d)point3dArray3[0], (Point3d)point3dArray3[1]), vertex, vertex2, iterator.next());
                    Edge edge2 = model.addEdgeToRegion(new LineSeg3D((Point3d)point3dArray3[1], (Point3d)point3dArray3[2]), vertex2, vertex3, iterator.next());
                    Edge edge3 = model.addEdgeToRegion(new LineSeg3D((Point3d)point3dArray3[2], (Point3d)point3dArray3[0]), vertex3, vertex, iterator.next());
                    EdgeUse edgeUse = new EdgeUse(edge, true);
                    EdgeUse edgeUse2 = new EdgeUse(edge2, true);
                    EdgeUse edgeUse3 = new EdgeUse(edge3, true);
                    model.addFaceToRegion(plane3d, Model.toLoops(edgeUse, edgeUse2, edgeUse3), false, nArray);
                    this.merge(model);
                    return true;
                }
                if (Util3D.isConvex(1.0E-6, (Point3d[])point3dArray3)) {
                    Model model = new Model();
                    Vertex[] vertexArray = new Vertex[point3dArray3.length];
                    for (int i = 0; i < point3dArray3.length; ++i) {
                        vertexArray[i] = model.addVertexToRegion((Point3d)point3dArray3[i], nArray);
                    }
                    ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(point3dArray3.length);
                    Iterator<int[]> iterator = collection.iterator();
                    for (int i = 0; i < point3dArray3.length; ++i) {
                        int n = (i + 1) % point3dArray3.length;
                        Point3d[] point3dArray4 = point3dArray3[i];
                        Point3d[] point3dArray5 = point3dArray3[n];
                        Vertex vertex = vertexArray[i];
                        Vertex vertex4 = vertexArray[n];
                        Edge edge = model.addEdgeToRegion(new LineSeg3D((Point3d)point3dArray4, (Point3d)point3dArray5), vertex, vertex4, iterator.next());
                        arrayList.add(new EdgeUse(edge, true));
                    }
                    model.addFaceToRegion(plane3d, Model.toLoops(arrayList), false, nArray);
                    this.merge(model);
                    return true;
                }
            }
        }
        point3dArray2 = new ArrayList();
        for (Point3d[] point3dArray6 : point3dArray) {
            point3dArray2.addAll(NmtUtil.toCurves(point3dArray6));
        }
        return this.addFace(plane3d, (Collection<? extends IParametric3D>)point3dArray2, nArray, collection);
    }

    public boolean addFace(int n, Plane3d plane3d, Collection<? extends IParametric3D> collection) {
        return this.addFace(plane3d, collection, n);
    }

    public boolean addFace(Plane3d plane3d, Collection<? extends IParametric3D> collection, int ... nArray) {
        return this.addFace(plane3d, collection, nArray, Collections.nCopies(collection.size(), nArray));
    }

    public boolean addFace(Plane3d plane3d, Collection<? extends IParametric3D> collection, int[] nArray, Collection<int[]> collection2) {
        Object object;
        Object object2;
        Object[] objectArray22;
        assert (collection2.size() == 0 || collection2.size() == collection.size());
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        AABox aABox = new AABox();
        for (IParametric3D iParametric3D : collection) {
            aABox.add(Util3D.xform(matrix4d, iParametric3D.get(0.0)));
            aABox.add(Util3D.xform(matrix4d, iParametric3D.get(1.0)));
        }
        if (aABox.getMinX() >= aABox.getMaxX() || aABox.getMinY() >= aABox.getMaxY()) {
            return false;
        }
        double d = aABox.getMaxX() - aABox.getMinX();
        double d2 = aABox.getMaxY() - aABox.getMinY();
        double d3 = Math.max(d2 * 0.5, 9.999999999999999E-6);
        double d4 = Math.max(d * 0.5, 9.999999999999999E-6);
        aABox.set(new Point3d(aABox.getMinX() - d4, aABox.getMinY() - d3, 0.0), new Point3d(aABox.getMaxX() + d4, aABox.getMaxY() + d3, 0.0));
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point3d[] point3dArray = new Point3d[]{Util3D.xformEq(matrix4d2, new Point3d(aABox.getMinX(), aABox.getMinY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMaxX(), aABox.getMinY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMaxX(), aABox.getMaxY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMinX(), aABox.getMaxY(), 0.0))};
        int n = 0;
        while (NmtUtil.findGroup(nArray, n)) {
            ++n;
        }
        for (Object[] objectArray22 : collection2) {
            while (NmtUtil.findGroup(objectArray22, n)) {
                ++n;
            }
        }
        Model model = new Model();
        objectArray22 = new Vertex[4];
        for (int i = 0; i < 4; ++i) {
            objectArray22[i] = (int)super.addVertexToRegion(point3dArray[i], n);
        }
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(4);
        for (int i = 0; i < 4; ++i) {
            object2 = objectArray22[i];
            object = objectArray22[(i + 1) % 4];
            LineSeg3D lineSeg3D = new LineSeg3D(((Vertex)object2).loc, object.loc);
            Edge object3 = super.addEdgeToRegion(lineSeg3D, (Vertex)object2, (Vertex)object, n);
            arrayList.add(new EdgeUse(object3, true));
        }
        super.addFaceToRegion(plane3d, Model.toLoops(arrayList), n);
        model.addEdges(collection, collection2);
        Face face = null;
        object2 = model.getEdges().iterator();
        while (object2.hasNext()) {
            object = (Edge)object2.next();
            if (object.groups.length != 1 || object.groups[0] != n || object.faces.isEmpty()) continue;
            assert (object.faces.size() == 1);
            face = object.faces.get(0);
            break;
        }
        if (face == null) {
            return false;
        }
        object2 = Model.classifyFaces(model, face);
        boolean bl = false;
        for (Map.Entry entry : object2.entrySet()) {
            if ((Integer)entry.getValue() % 2 == 0) continue;
            this.addFace((Face)entry.getKey(), nArray);
            bl = true;
        }
        return bl;
    }

    private static Map<Face, Integer> classifyFaces(Model model, Face face) {
        LinkedIdentityHashMap<Face, Integer> linkedIdentityHashMap = new LinkedIdentityHashMap<Face, Integer>();
        Stack<Face> stack = new Stack<Face>();
        Stack<Face> stack2 = new Stack<Face>();
        stack2.push(face);
        int n = 0;
        while (!stack2.isEmpty()) {
            Face face2 = (Face)stack2.pop();
            if (!linkedIdentityHashMap.containsKey(face2)) {
                linkedIdentityHashMap.put(face2, n);
                for (FaceLoop faceLoop : face2.edgeLoops) {
                    for (EdgeUse edgeUse : faceLoop.edges) {
                        for (Face face3 : edgeUse.edge.faces) {
                            if (face3 == face2 || linkedIdentityHashMap.containsKey(face3)) continue;
                            stack.push(face3);
                        }
                    }
                }
            }
            if (!stack2.isEmpty()) continue;
            ++n;
            Stack<Face> stack3 = stack2;
            stack2 = stack;
            stack = stack3;
        }
        return linkedIdentityHashMap;
    }

    private static Point3d findPointInLoop(Plane3d plane3d, List<IParametric3D> list) {
        for (IParametric3D iParametric3D : list) {
            Point3d point3d = iParametric3D.get(0.0);
            for (IParametric3D iParametric3D2 : list) {
                Point3d point3d2 = iParametric3D2.get(0.5);
                Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
                FaceClassify faceClassify = Model.testPointInLoop(list, plane3d, point3d3);
                if (faceClassify != FaceClassify.INSIDE) continue;
                return point3d3;
            }
        }
        return null;
    }

    public Point3d findRandomPointInFace(Face face, Random random) {
        List<EdgeUse> list = face.getEdges(true);
        Collections.shuffle(list, random);
        return this.findPointInFace(face, list);
    }

    private Point3d findPointInFace(Face face, List<EdgeUse> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point3d point3d = list.get((int)i).edge.curve.get(0.0);
            for (int j = 0; j < list.size(); ++j) {
                FaceClassify faceClassify;
                Point3d point3d2;
                Point3d point3d3;
                Point3d point3d4;
                if (i == j || Model.compare(point3d4 = Util3D.getMidPoint(point3d, point3d3 = list.get((int)j).edge.curve.get(0.5)), point3d) || Model.compare(point3d4, point3d3) || !Model.compare(point3d2 = face.plane.projectOntoPlane(point3d4), point3d4) || (faceClassify = this.testPointOnFace(face, point3d2)) != FaceClassify.INSIDE) continue;
                return point3d2;
            }
        }
        return null;
    }

    public Point3d findPointInFace(Face face) {
        List<EdgeUse> list = face.getEdges();
        return this.findPointInFace(face, list);
    }

    private static List<IParametric3D> getSegs(Map<Point3d, List<IParametric3D>> map, Point3d point3d) {
        List<IParametric3D> list = map.get(point3d);
        if (list == null) {
            list = new ArrayList<IParametric3D>();
            map.put(point3d, list);
        }
        return list;
    }

    private void addToGroups(AModelObj aModelObj, int ... nArray) {
        aModelObj.addGroups(nArray);
        this.d_mainGroup.add(aModelObj);
    }

    public Group getGroup(int n) {
        return this.getGroup(n, true, true, true);
    }

    public Group getGroup(int n, boolean bl, boolean bl2, boolean bl3) {
        Group group = new Group(n, ArrayList.class);
        if (bl) {
            for (Face aModelObj : this.d_mainGroup.faces) {
                if (!aModelObj.partOfGroup(n)) continue;
                group.faces.add(aModelObj);
            }
        }
        if (bl2) {
            for (Edge edge : this.d_mainGroup.edges) {
                if (!edge.partOfGroup(n)) continue;
                group.edges.add(edge);
            }
        }
        if (bl3) {
            for (Vertex vertex : this.d_mainGroup.verts) {
                if (!vertex.partOfGroup(n)) continue;
                group.verts.add(vertex);
            }
        }
        return group;
    }

    public Collection<Face> getFaces(int n) {
        return Model.getComponents(this.d_mainGroup.faces, n);
    }

    public Collection<Face> getFaces(Predicate<Face> predicate) {
        return Model.getComponents(this.d_mainGroup.faces, predicate);
    }

    public Collection<Edge> getEdges(int n) {
        return Model.getComponents(this.d_mainGroup.edges, n);
    }

    public Collection<Edge> getEdges(Predicate<Edge> predicate) {
        return Model.getComponents(this.d_mainGroup.edges, predicate);
    }

    public Collection<Vertex> getVerts(int n) {
        return Model.getComponents(this.d_mainGroup.verts, n);
    }

    public Collection<Vertex> getVerts(Predicate<Vertex> predicate) {
        return Model.getComponents(this.d_mainGroup.verts, predicate);
    }

    private static <T extends AModelObj> Collection<T> getComponents(Collection<T> collection, int n) {
        return Model.getComponents(collection, aModelObj -> aModelObj.partOfGroup(n));
    }

    private static <T> Collection<T> getComponents(Collection<T> collection, Predicate<T> predicate) {
        return theUtil.filter(collection, predicate);
    }

    private Edge[] addVerticesToEdge(Edge edge, double[] dArray, Vertex[] vertexArray) {
        assert (dArray.length == vertexArray.length);
        Edge[] edgeArray = new Edge[vertexArray.length];
        double d = 0.0;
        Edge edge2 = edge;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            Vertex vertex = vertexArray[i];
            double d3 = (d2 - d) / (1.0 - d);
            edgeArray[i] = this.addVertexToEdge(edge2, d3, vertex);
            edge2 = edgeArray[i];
            d = d2;
        }
        return edgeArray;
    }

    private Edge addVertexToEdge(Edge edge, double d, Vertex vertex) {
        Vertex vertex2 = edge.v2;
        IParametric3D iParametric3D = edge.curve.trim(0.0, d);
        IParametric3D iParametric3D2 = edge.curve.trim(d, 1.0);
        edge.curve = iParametric3D;
        edge.v2 = vertex;
        vertex2.edges.remove(edge);
        vertex.addEdge(edge);
        this.updateEdgeSearch(edge, 1);
        Edge edge2 = this.addEdgeToRegion(iParametric3D2, vertex, vertex2, edge.groups);
        edge2.faces.addAll(edge.faces);
        vertex.addEdge(edge2);
        for (Face face : edge.faces) {
            boolean bl = face.isInternalEdge(edge);
            for (FaceLoop faceLoop : face.edgeLoops) {
                ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator();
                while (listIterator.hasNext()) {
                    EdgeUse edgeUse = listIterator.next();
                    if (edgeUse.edge != edge) continue;
                    EdgeUse edgeUse2 = new EdgeUse(edge2, edgeUse.orient);
                    if (!edgeUse.orient) {
                        listIterator.set(edgeUse2);
                        listIterator.add(edgeUse);
                        continue;
                    }
                    listIterator.add(edgeUse2);
                }
            }
            if (bl) {
                face.addInternalEdge(edge2);
            }
            if (face.isValid(this)) continue;
            LOGGER.log(Level.WARNING, "0a Invalid face orient");
        }
        this.validateVertLoops();
        return edge2;
    }

    public boolean removeVertexFromEdges(Vertex vertex) {
        return this.removeVerticesFromEdges(Collections.singleton(vertex));
    }

    public boolean removeVerticesFromEdges(Collection<Vertex> collection) {
        Object object;
        Iterator<Face> iterator;
        Object object2;
        Cloneable cloneable22;
        if (collection.isEmpty()) {
            return false;
        }
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        IdentityHashSet identityHashSet = new IdentityHashSet();
        LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
        LinkedIdentityHashSet linkedIdentityHashSet3 = new LinkedIdentityHashSet();
        for (Cloneable cloneable22 : collection) {
            if (cloneable22.edges.size() != 2 || (object2 = cloneable22.edges.get(0)) == (iterator = cloneable22.edges.get(1)) || !theUtil.setsEqual(((Edge)object2).faces, ((Edge)((Object)iterator)).faces)) continue;
            if (((Edge)object2).faces.isEmpty()) {
                linkedIdentityHashSet3.add(cloneable22);
            }
            identityHashSet.add(cloneable22);
            linkedIdentityHashSet.addAll(((Edge)object2).faces);
            linkedIdentityHashSet2.add(object2);
            linkedIdentityHashSet2.add(iterator);
        }
        BiFunction<Edge, Vertex, Edge> biFunction = (edge, vertex) -> edge == vertex.edges.get(0) ? vertex.edges.get(1) : vertex.edges.get(0);
        cloneable22 = new HashMap();
        object2 = (arg_0, arg_1, arg_2) -> this.lambda$removeVerticesFromEdges$226((Map)((Object)cloneable22), biFunction, arg_0, arg_1, arg_2);
        if (!linkedIdentityHashSet3.isEmpty()) {
            iterator = new IdentityHashSet();
            for (Vertex vertex2 : linkedIdentityHashSet3) {
                if (!iterator.add((Face)((Object)vertex2))) continue;
                Vertex vertex3 = vertex2;
                object = vertex3.edges.get(0);
                while (linkedIdentityHashSet3.contains(vertex3) && (vertex3 = ((Edge)(object = (Edge)biFunction.apply((Edge)object, vertex3))).otherVert(vertex3)) != vertex2) {
                }
                Vertex vertex4 = ((Edge)object).otherVert(vertex3);
                Serializable serializable = object;
                while (vertex4 != vertex3 && linkedIdentityHashSet3.contains(vertex4)) {
                    iterator.add((Face)((Object)vertex4));
                    serializable = (Edge)biFunction.apply((Edge)serializable, vertex4);
                    vertex4 = ((Edge)serializable).otherVert(vertex4);
                }
                if (vertex3 == vertex4) continue;
                object2.apply(object, vertex3, vertex4);
            }
        }
        for (Face face : linkedIdentityHashSet) {
            boolean bl = false;
            for (int i = 0; i < face.edgeLoops.size(); ++i) {
                Object object3;
                object = face.edgeLoops.get(i);
                if (((FaceLoop)object).vert != null) continue;
                boolean bl2 = false;
                int n = -1;
                for (int j = 0; !(j >= ((FaceLoop)object).edges.size() || n != -1 && bl2); ++j) {
                    object3 = ((FaceLoop)object).edges.get(j);
                    Vertex vertex5 = ((EdgeUse)object3).v1();
                    if (!identityHashSet.contains(vertex5)) {
                        if (n != -1) continue;
                        n = j;
                        continue;
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                assert (n != -1);
                if (n == -1) continue;
                ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>();
                object3 = (arg_0, arg_1) -> Model.lambda$removeVerticesFromEdges$227((FaceLoop)object, arrayList, (TriFunction)object2, arg_0, arg_1);
                int n2 = n;
                for (int j = 0; j < ((FaceLoop)object).edges.size(); ++j) {
                    int n3 = (j + n) % ((FaceLoop)object).edges.size();
                    EdgeUse edgeUse = ((FaceLoop)object).edges.get(n3);
                    Vertex vertex6 = edgeUse.v2();
                    if (identityHashSet.contains(vertex6)) continue;
                    object3.accept(n2, n3);
                    n2 = (n3 + 1) % ((FaceLoop)object).edges.size();
                }
                FaceLoop faceLoop = new FaceLoop(arrayList);
                face.edgeLoops.set(i, faceLoop);
                faceLoop.addFace(face);
                bl = true;
            }
            if (!bl) continue;
            face.buildConnections();
            face.recalcInternalEdges();
            if (face.isValid(this)) continue;
            LOGGER.log(Level.WARNING, "0x29384f Invalid face");
        }
        for (Face face : this.getFaces()) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (faceLoop.vert != null) {
                    identityHashSet.remove(faceLoop.vert);
                    continue;
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    linkedIdentityHashSet2.remove(edgeUse.edge);
                    identityHashSet.remove(edgeUse.v1());
                    identityHashSet.remove(edgeUse.v2());
                }
            }
        }
        for (Edge edge2 : linkedIdentityHashSet2) {
            edge2.faces.clear();
            this.deleteEdge(edge2, false);
        }
        for (Vertex vertex7 : identityHashSet) {
            this.deleteVertex(vertex7);
        }
        this.validateVertLoops();
        return true;
    }

    private void addVertexToFace(Face face, Vertex vertex) {
        assert (vertex != null);
        FaceLoop faceLoop = new FaceLoop();
        faceLoop.vert = vertex;
        vertex.face = face;
        face.edgeLoops.add(faceLoop);
        if (!face.isValid(this)) {
            LOGGER.log(Level.WARNING, "0x3ff3a invalid face");
        }
        this.validateVertLoops();
    }

    public void removeVertexFromFace(Vertex vertex) {
        assert (vertex.edges.isEmpty() && vertex.face != null);
        for (int i = 0; i < vertex.face.edgeLoops.size(); ++i) {
            if (vertex.face.edgeLoops.get((int)i).vert != vertex) continue;
            vertex.face.edgeLoops.remove(i);
            break;
        }
        if (!vertex.face.isValid(this)) {
            LOGGER.log(Level.WARNING, "0x3ff3a invalid face");
        }
        vertex.face = null;
        this.deleteVertex(vertex);
        this.validateVertLoops();
    }

    private Vertex addVertexToRegion(Point3d point3d, int ... nArray) {
        Vertex vertex = new Vertex(point3d);
        this.addToGroups(vertex, nArray);
        this.updateVertexSearch(vertex, 0);
        return vertex;
    }

    private boolean validateVertLoops() {
        return true;
    }

    private Face addEdgeToFace(Face face, Edge edge, FaceEdgeInsert faceEdgeInsert, FaceEdgeInsert faceEdgeInsert2) {
        edge.addFace(face);
        FaceLoop faceLoop = faceEdgeInsert.loop;
        int n = faceEdgeInsert.edgeIx;
        FaceLoop faceLoop2 = faceEdgeInsert2.loop;
        int n2 = faceEdgeInsert2.edgeIx;
        Face face2 = null;
        if (faceLoop.vert != null && faceLoop2.vert != null) {
            faceLoop.removeFace(face);
            faceLoop2.removeFace(face);
            face.edgeLoops.remove(faceLoop);
            face.edgeLoops.remove(faceLoop2);
            FaceLoop faceLoop3 = new FaceLoop();
            faceLoop3.edges.add(new EdgeUse(edge, true));
            faceLoop3.edges.add(new EdgeUse(edge, false));
            face.edgeLoops.add(faceLoop3);
            face.addInternalEdge(edge);
            this.validateVertLoops();
            if (!face.isValid(this)) {
                LOGGER.log(Level.WARNING, "0 Invalid face orient");
            }
        } else if (faceLoop.vert != null) {
            faceLoop.removeFace(face);
            face.edgeLoops.remove(faceLoop);
            ListIterator<EdgeUse> listIterator = faceLoop2.edges.listIterator(n2);
            listIterator.add(new EdgeUse(edge, false));
            listIterator.add(new EdgeUse(edge, true));
            face.addInternalEdge(edge);
            this.validateVertLoops();
            if (!face.isValid(this)) {
                LOGGER.log(Level.WARNING, "4 Invalid face orient");
            }
        } else if (faceLoop2.vert != null) {
            faceLoop2.removeFace(face);
            face.edgeLoops.remove(faceLoop2);
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator(n);
            listIterator.add(new EdgeUse(edge, true));
            listIterator.add(new EdgeUse(edge, false));
            face.addInternalEdge(edge);
            this.validateVertLoops();
            if (!face.isValid(this)) {
                LOGGER.log(Level.WARNING, "5 Invalid face orient");
            }
        } else if (faceLoop != faceLoop2) {
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator(n);
            ListIterator<EdgeUse> listIterator2 = n2 == faceLoop2.edges.size() ? faceLoop2.edges.listIterator() : faceLoop2.edges.listIterator(n2);
            listIterator.add(new EdgeUse(edge, true));
            for (int i = 0; i < faceLoop2.edges.size(); ++i) {
                EdgeUse edgeUse = listIterator2.next();
                listIterator.add(edgeUse);
                if (listIterator2.hasNext()) continue;
                listIterator2 = faceLoop2.edges.listIterator();
            }
            listIterator.add(new EdgeUse(edge, false));
            if (faceLoop2 == face.outerLoop()) {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.set(0, faceLoop);
            } else {
                face.edgeLoops.remove(faceLoop2);
            }
            face.addInternalEdge(edge);
            this.validateVertLoops();
            if (!face.isValid(this)) {
                LOGGER.log(Level.WARNING, "1 Invalid face orient");
            }
        } else {
            Serializable serializable;
            boolean bl;
            face.clearConnections();
            FaceLoop faceLoop4 = faceLoop;
            boolean bl2 = bl = faceLoop4 == face.outerLoop();
            if (n2 == faceLoop4.edges.size()) {
                n2 = 0;
            }
            if (n == faceLoop4.edges.size()) {
                n = 0;
            }
            ListIterator<EdgeUse> listIterator = faceLoop4.edges.listIterator(n2);
            Serializable serializable2 = new ArrayList<EdgeUse>();
            serializable2.add(new EdgeUse(edge, true));
            while (listIterator.nextIndex() != n) {
                serializable2.add(listIterator.next());
                if (listIterator.hasNext()) continue;
                listIterator = faceLoop4.edges.listIterator();
            }
            ListIterator<EdgeUse> listIterator3 = faceLoop4.edges.listIterator(n);
            ArrayList<Object> arrayList = new ArrayList<EdgeUse>();
            arrayList.add(new EdgeUse(edge, false));
            while (listIterator3.nextIndex() != n2) {
                arrayList.add(listIterator3.next());
                if (listIterator3.hasNext()) continue;
                listIterator3 = faceLoop4.edges.listIterator();
            }
            if (!bl && NmtUtil.getFaceOrient(serializable2, face.plane) != 2) {
                serializable = arrayList;
                arrayList = serializable2;
                serializable2 = serializable;
            }
            serializable = new FaceLoop(serializable2.size());
            serializable.edges.addAll((Collection<EdgeUse>)((Object)serializable2));
            face.edgeLoops.remove(faceLoop4);
            if (bl) {
                face.edgeLoops.add(0, (FaceLoop)serializable);
            } else {
                face.edgeLoops.add((FaceLoop)serializable);
            }
            FaceLoop faceLoop5 = new FaceLoop(arrayList.size());
            faceLoop5.edges.addAll(arrayList);
            ArrayList<FaceLoop> arrayList2 = new ArrayList<FaceLoop>(1);
            arrayList2.add(faceLoop5);
            face2 = this.addFaceToRegion(face.plane, arrayList2, true, face.groups);
            FaceLoop[] faceLoopArray = face.edgeLoops.toArray(new FaceLoop[face.edgeLoops.size()]);
            ArrayList<FaceLoop> arrayList3 = new ArrayList<FaceLoop>(faceLoopArray.length);
            for (FaceLoop faceLoop6 : faceLoopArray) {
                Vertex vertex;
                if (faceLoop6 == serializable || (vertex = Model.findVertex(faceLoop6)) == null || !this.testPointOnFace((Face)face2, (Point3d)vertex.loc).inside) continue;
                arrayList3.add(faceLoop6);
            }
            if (!arrayList3.isEmpty()) {
                for (FaceLoop faceLoop7 : arrayList3) {
                    face.edgeLoops.remove(faceLoop7);
                    face2.edgeLoops.add(faceLoop7);
                    faceLoop7.addFace(face2);
                }
            }
            face.buildConnections();
            for (Edge edge2 : new ArrayList<Edge>(face.getInternalEdges())) {
                int n3 = edge2.faces.contains(face) ? 1 : 0;
                boolean bl3 = edge2.faces.contains(face2);
                if (n3 != 0 && bl3) {
                    face.removeInternalEdge(edge2);
                    continue;
                }
                if (!bl3) continue;
                face.removeInternalEdge(edge2);
                face2.addInternalEdge(edge2);
            }
            if (bl) {
                face.invalidateBounds();
                this.updateFaceSearch(face, 1);
            }
            this.validateVertLoops();
            if (!face.isValid(this)) {
                LOGGER.log(Level.WARNING, "2 Invalid face orient");
            }
            if (!face2.isValid(this)) {
                LOGGER.log(Level.WARNING, "3 Invalid face orient");
            }
        }
        return face2;
    }

    private static Vertex findVertex(FaceLoop faceLoop) {
        if (faceLoop.vert != null) {
            return faceLoop.vert;
        }
        assert (!faceLoop.edges.isEmpty());
        if (faceLoop.edges.isEmpty()) {
            LOGGER.log(Level.WARNING, "[Model.findVertex] Found empty loop.");
            return null;
        }
        return faceLoop.edges.get(0).v1();
    }

    public boolean removeEdgeFromFaces(Edge edge) {
        boolean bl;
        if (edge.faces.size() != 2) {
            return false;
        }
        Face face = edge.faces.get(0);
        Face face2 = edge.faces.get(1);
        if (face.isInternalEdge(edge) || face2.isInternalEdge(edge)) {
            LOGGER.log(Level.WARNING, "Found edge shared between two faces and marked as internal");
            return false;
        }
        FaceEdgeInsert faceEdgeInsert = Model.findFaceEdgeDeletion(face, edge);
        if (faceEdgeInsert == null) {
            return false;
        }
        FaceEdgeInsert faceEdgeInsert2 = Model.findFaceEdgeDeletion(face2, edge);
        if (faceEdgeInsert2 == null) {
            return false;
        }
        assert (!face.isInternalEdge(edge) && !face2.isInternalEdge(edge));
        face.clearConnections();
        face2.clearConnections();
        if (face2.outerLoop() != faceEdgeInsert2.loop) {
            assert (face.outerLoop() == faceEdgeInsert.loop);
            FaceEdgeInsert faceEdgeInsert3 = faceEdgeInsert2;
            faceEdgeInsert2 = faceEdgeInsert;
            faceEdgeInsert = faceEdgeInsert3;
            Face face3 = face;
            face = face2;
            face2 = face3;
        }
        boolean bl2 = face.outerLoop() == faceEdgeInsert.loop;
        boolean bl3 = bl = face2.outerLoop() == faceEdgeInsert2.loop;
        assert (bl);
        ListIterator<EdgeUse> listIterator = faceEdgeInsert.loop.edges.listIterator(faceEdgeInsert.edgeIx);
        EdgeUse edgeUse = listIterator.next();
        if (!listIterator.hasNext()) {
            listIterator = faceEdgeInsert.loop.edges.listIterator();
        }
        ListIterator<EdgeUse> listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.edgeIx);
        EdgeUse edgeUse2 = listIterator2.next();
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(faceEdgeInsert.loop.edges.size() + faceEdgeInsert2.loop.edges.size() - 2);
        if (edgeUse.orient != edgeUse2.orient) {
            if (!listIterator2.hasNext()) {
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator();
            }
            while (listIterator2.nextIndex() != faceEdgeInsert2.edgeIx) {
                arrayList.add(listIterator2.next());
                if (listIterator2.hasNext()) continue;
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator();
            }
        } else {
            listIterator2.previous();
            if (!listIterator2.hasPrevious()) {
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.loop.edges.size());
            }
            while (listIterator2.previousIndex() != faceEdgeInsert2.edgeIx) {
                arrayList.add(listIterator2.previous().reverse());
                if (listIterator2.hasPrevious()) continue;
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.loop.edges.size());
            }
        }
        while (listIterator.nextIndex() != faceEdgeInsert.edgeIx) {
            arrayList.add(listIterator.next());
            if (listIterator.hasNext()) continue;
            listIterator = faceEdgeInsert.loop.edges.listIterator();
        }
        FaceLoop faceLoop = new FaceLoop();
        faceLoop.edges.addAll(arrayList);
        if (bl2) {
            face.edgeLoops.set(0, faceLoop);
        } else {
            face.edgeLoops.remove(faceEdgeInsert.loop);
            face.edgeLoops.add(faceLoop);
        }
        for (int i = 1; i < face2.edgeLoops.size(); ++i) {
            face.edgeLoops.add(face2.edgeLoops.get(i));
        }
        face.addGroups(face2.groups);
        this.deleteFace(face2, false, false);
        edge.faces.clear();
        this.deleteEdge(edge, false);
        face.recalcInternalEdges();
        face.buildConnections();
        face.invalidateBounds();
        this.updateFaceSearch(face, 1);
        if (!face.isValid(this)) {
            LOGGER.log(Level.WARNING, "0x1193f invalid face");
        }
        this.validateVertLoops();
        return true;
    }

    public boolean removeEdgeFromFace(Edge edge) {
        int n;
        assert (edge.faces.size() == 1);
        Face face = edge.faces.get(0);
        FaceLoop faceLoop = null;
        int n2 = -1;
        int n3 = -1;
        for (FaceLoop faceLoop2 : face.edgeLoops) {
            for (n = 0; n < faceLoop2.edges.size(); ++n) {
                if (faceLoop2.edges.get((int)n).edge != edge) continue;
                faceLoop = faceLoop2;
                if (n2 == -1) {
                    n2 = n;
                    continue;
                }
                n3 = n;
                break;
            }
            if (faceLoop == null) continue;
            break;
        }
        if (faceLoop == null || n2 == -1 || n3 == -1) {
            return false;
        }
        assert (face.isInternalEdge(edge));
        face.clearConnections();
        EdgeUse edgeUse = faceLoop.edges.get(n2);
        boolean bl = (n3 + 1) % faceLoop.edges.size() == n2;
        n = (n2 + 1) % faceLoop.edges.size() == n3 ? 1 : 0;
        FaceLoop faceLoop3 = new FaceLoop();
        FaceLoop faceLoop4 = new FaceLoop();
        if (bl && n != 0) {
            faceLoop3.vert = edgeUse.v1();
            faceLoop4.vert = edgeUse.v2();
            assert (faceLoop != face.outerLoop());
            face.edgeLoops.remove(faceLoop);
            face.edgeLoops.add(faceLoop3);
            face.edgeLoops.add(faceLoop4);
        } else if (bl || n != 0) {
            int n4;
            int n5;
            if (bl) {
                faceLoop3.vert = edgeUse.v1();
                n5 = n2;
                n4 = n3;
            } else {
                faceLoop3.vert = edgeUse.v2();
                n5 = n3;
                n4 = n2;
            }
            int n6 = (n5 + 1) % faceLoop.edges.size();
            while (n6 != n4) {
                faceLoop4.edges.add(faceLoop.edges.get(n6));
                n6 = (n6 + 1) % faceLoop.edges.size();
            }
            if (faceLoop == face.outerLoop()) {
                face.edgeLoops.set(0, faceLoop4);
            } else {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.add(faceLoop4);
            }
            face.edgeLoops.add(faceLoop3);
        } else {
            int n7 = (n2 + 1) % faceLoop.edges.size();
            while (n7 != n3) {
                faceLoop3.edges.add(faceLoop.edges.get(n7));
                n7 = (n7 + 1) % faceLoop.edges.size();
            }
            n7 = (n3 + 1) % faceLoop.edges.size();
            while (n7 != n2) {
                faceLoop4.edges.add(faceLoop.edges.get(n7));
                n7 = (n7 + 1) % faceLoop.edges.size();
            }
            if (faceLoop == face.outerLoop()) {
                n7 = 0;
                int n8 = n7 = faceLoop3.isOpen() && NmtUtil.getFaceOrient(faceLoop3.edges, face.plane) == 1 ? 1 : 0;
                if (n7 != 0) {
                    face.edgeLoops.set(0, faceLoop3);
                    face.edgeLoops.add(faceLoop4);
                } else {
                    face.edgeLoops.set(0, faceLoop4);
                    face.edgeLoops.add(faceLoop3);
                }
            } else {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.add(faceLoop3);
                face.edgeLoops.add(faceLoop4);
            }
        }
        edge.faces.clear();
        face.buildConnections();
        if (edge.faces.isEmpty()) {
            this.deleteEdge(edge, false);
            face.removeInternalEdge(edge);
        }
        if (!face.isValid(this)) {
            LOGGER.log(Level.WARNING, "0x923984 invalid face");
        }
        this.validateVertLoops();
        return true;
    }

    private static FaceEdgeInsert findFaceEdgeDeletion(Face face, Edge edge) {
        for (FaceLoop faceLoop : face.edgeLoops) {
            for (int i = 0; i < faceLoop.edges.size(); ++i) {
                EdgeUse edgeUse = faceLoop.edges.get(i);
                if (edgeUse.edge != edge) continue;
                return new FaceEdgeInsert(faceLoop, i);
            }
        }
        return null;
    }

    private static FaceEdgeInsert[] findInsertPos(Face face, Vertex vertex, Vertex vertex2, IParametric3D iParametric3D) {
        FaceEdgeInsert faceEdgeInsert = Model.findInsertPos(face, vertex, iParametric3D, true);
        if (faceEdgeInsert == null) {
            return null;
        }
        FaceEdgeInsert faceEdgeInsert2 = Model.findInsertPos(face, vertex2, iParametric3D, false);
        if (faceEdgeInsert2 == null) {
            return null;
        }
        return new FaceEdgeInsert[]{faceEdgeInsert, faceEdgeInsert2};
    }

    private static FaceEdgeInsert findInsertPos(Face face, Vertex vertex, IParametric3D iParametric3D, boolean bl) {
        Vector3d vector3d;
        FaceEdgeInsert faceEdgeInsert = new FaceEdgeInsert();
        for (FaceLoop faceLoop : face.edgeLoops) {
            if (faceLoop.vert != vertex) continue;
            faceEdgeInsert.loop = faceLoop;
            faceEdgeInsert.edgeIx = 0;
            return faceEdgeInsert;
        }
        Vector3d vector3d2 = face.plane.getNormal();
        double d = Double.MAX_VALUE;
        if (bl) {
            vector3d = iParametric3D.getTangent(0.0);
        } else {
            vector3d = iParametric3D.getTangent(1.0);
            vector3d.negate();
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            if (faceLoop.vert != null) continue;
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator();
            while (listIterator.hasNext()) {
                EdgeUse edgeUse = listIterator.next();
                if (edgeUse.v2() != vertex) continue;
                Vector3d vector3d3 = edgeUse.curve().getTangent(1.0);
                vector3d3.negate();
                double d2 = Util3D.angle0To2PI(vector3d, vector3d3, vector3d2);
                if (!(d2 < d)) continue;
                d = d2;
                faceEdgeInsert.loop = faceLoop;
                faceEdgeInsert.edgeIx = listIterator.nextIndex();
            }
        }
        if (faceEdgeInsert.loop == null) {
            return null;
        }
        EdgeUse edgeUse = faceEdgeInsert.edgeIx == faceEdgeInsert.loop.edges.size() ? faceEdgeInsert.loop.edges.get(0) : faceEdgeInsert.loop.edges.get(faceEdgeInsert.edgeIx);
        double d3 = Util3D.angle0To2PI(vector3d, edgeUse.getTangent(0.0), vector3d2);
        if (d3 < d) {
            return null;
        }
        return faceEdgeInsert;
    }

    private Edge addEdgeToRegion(IParametric3D iParametric3D, Vertex vertex, Vertex vertex2, int ... nArray) {
        Edge edge = new Edge(vertex, vertex2, iParametric3D);
        this.addToGroups(edge, nArray);
        edge.buildConnections();
        this.updateEdgeSearch(edge, 0);
        return edge;
    }

    private static List<FaceLoop> toLoops(EdgeUse ... edgeUseArray) {
        return Model.toLoops(Arrays.asList(edgeUseArray));
    }

    private static List<FaceLoop> toLoops(List<EdgeUse> list) {
        return Model.toLoops(list, Collections.EMPTY_LIST);
    }

    private static List<FaceLoop> toLoops(List<EdgeUse> list, List<Vertex> list2) {
        ArrayList<FaceLoop> arrayList = new ArrayList<FaceLoop>();
        assert (!list.isEmpty());
        FaceLoop faceLoop = new FaceLoop();
        EdgeUse edgeUse = list.get(0);
        faceLoop.edges.add(edgeUse);
        for (int i = 1; i < list.size(); ++i) {
            EdgeUse serializable = list.get(i);
            if (serializable.v1() != edgeUse.v2()) {
                arrayList.add(faceLoop);
                faceLoop = new FaceLoop();
            }
            faceLoop.edges.add(serializable);
            edgeUse = serializable;
        }
        arrayList.add(faceLoop);
        for (Vertex vertex : list2) {
            FaceLoop faceLoop2 = new FaceLoop();
            assert (vertex != null);
            faceLoop2.vert = vertex;
            arrayList.add(faceLoop2);
        }
        return arrayList;
    }

    private Face addFaceToRegion(Plane3d plane3d, List<FaceLoop> list, int ... nArray) {
        return this.addFaceToRegion(plane3d, list, true, nArray);
    }

    private Face addFaceToRegion(Plane3d plane3d, List<FaceLoop> list, boolean bl, int ... nArray) {
        assert (!list.isEmpty());
        Face face = new Face(plane3d, list, bl);
        if (!face.isValid(this)) {
            LOGGER.log(Level.WARNING, "0x234f invalid face");
        }
        this.addToGroups(face, nArray);
        face.buildConnections();
        this.updateFaceSearch(face, 0);
        return face;
    }

    public void updateVertexSearch(Vertex vertex, int n) {
        this.updateSearch(this.d_vertSearch, vertex, n);
    }

    public void updateEdgeSearch(Edge edge, int n) {
        this.updateSearch(this.d_edgeSearch, edge, n);
    }

    public void updateFaceSearch(Face face, int n) {
        this.updateSearch(this.d_faceSearch, face, n);
    }

    private <T extends AModelObj> void updateSearch(GeomSearcher<T> geomSearcher, T t, int n) {
        switch (n) {
            case 0: {
                geomSearcher.add(t);
                break;
            }
            case 1: {
                geomSearcher.update(t);
                break;
            }
            case 2: {
                geomSearcher.remove(t);
            }
        }
    }

    public List<Vertex> findVerts(AABox aABox) {
        return Model.find(this.d_vertSearch, aABox);
    }

    public List<Vertex> findVerts(ITest<AABox> iTest) {
        return Model.find(this.d_vertSearch, iTest);
    }

    public List<Edge> findEdges(AABox aABox) {
        return Model.find(this.d_edgeSearch, aABox);
    }

    public List<Edge> findEdge(ITest<AABox> iTest) {
        return Model.find(this.d_edgeSearch, iTest);
    }

    public List<Face> findFaces(AABox aABox) {
        return Model.find(this.d_faceSearch, aABox);
    }

    public List<Face> findFaces(ITest<AABox> iTest) {
        return Model.find(this.d_faceSearch, iTest);
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> geomSearcher, AABox aABox) {
        return geomSearcher.find(new AABoxTest(aABox, 1.0E-6));
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> geomSearcher, ITest<AABox> iTest) {
        return geomSearcher.find(iTest);
    }

    public Face findFace(Point3d point3d) {
        Pair<Face, FaceClassify> pair = this.findFace(point3d, NmtUtil.acceptPointsOnFace());
        return pair == null ? null : (Face)pair.v1;
    }

    public Pair<Face, FaceClassify> findFace(Point3d point3d, Predicate<FaceClassify> predicate) {
        Face face = null;
        FaceClassify faceClassify = null;
        double d = Double.MAX_VALUE;
        for (Face face2 : this.findFaces(new AABox(point3d, point3d))) {
            FaceClassify faceClassify2;
            double d2;
            Point3d point3d2 = face2.plane.projectOntoPlane(point3d);
            if (!Model.compare(point3d2, point3d) || (d2 = point3d2.distanceSquared(point3d)) >= d || !predicate.test(faceClassify2 = this.testPointOnFace(face2, point3d2))) continue;
            face = face2;
            d = d2;
            faceClassify = faceClassify2;
        }
        return face == null ? null : new Pair<Object, Object>(face, faceClassify);
    }

    public void merge(Model model) {
        int n = this.d_mainGroup.verts.size() + this.d_mainGroup.edges.size() + this.d_mainGroup.faces.size();
        int n2 = model.d_mainGroup.verts.size() + model.d_mainGroup.edges.size() + model.d_mainGroup.faces.size();
        if (n2 > n) {
            model.forceMerge(this);
            Cloneable cloneable = this.d_edgeSearch;
            this.d_edgeSearch = model.d_edgeSearch;
            model.d_edgeSearch = cloneable;
            cloneable = this.d_faceSearch;
            this.d_faceSearch = model.d_faceSearch;
            model.d_faceSearch = cloneable;
            cloneable = this.d_vertSearch;
            this.d_vertSearch = model.d_vertSearch;
            model.d_vertSearch = cloneable;
            cloneable = this.d_mainGroup;
            this.d_mainGroup = model.d_mainGroup;
            model.d_mainGroup = (Group)cloneable;
        } else {
            this.forceMerge(model);
        }
    }

    public void forceMerge(Model model) {
        LinkedIdentityHashMap<Vertex, Vertex> linkedIdentityHashMap = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Vertex, Vertex> linkedIdentityHashMap2 = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Edge, Edge> linkedIdentityHashMap3 = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Edge, Edge> linkedIdentityHashMap4 = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Face, Face> linkedIdentityHashMap5 = new LinkedIdentityHashMap<Face, Face>();
        for (Vertex cloneable2 : model.d_mainGroup.verts) {
            Model.setMate(linkedIdentityHashMap2, cloneable2, null);
        }
        for (Edge edge : model.d_mainGroup.edges) {
            Model.setMate(linkedIdentityHashMap4, edge, null);
        }
        for (Face face : model.d_mainGroup.faces) {
            Model.setMate(linkedIdentityHashMap5, face, null);
        }
        Stack stack = new Stack();
        Stack<Face> stack2 = new Stack<Face>();
        Model.vv(this, model, linkedIdentityHashMap, linkedIdentityHashMap2);
        Model.ve(this, model, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4);
        Model.vf(this, model, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap5);
        Model.vr(this, model, linkedIdentityHashMap, linkedIdentityHashMap2);
        Model.ee(this, model, stack, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4);
        Model.ef(this, model, stack, stack2, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4, linkedIdentityHashMap5);
        Model.er(this, model, linkedIdentityHashMap2, linkedIdentityHashMap4);
        Model.ff(this, model, stack2, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4, linkedIdentityHashMap5);
        Model.fr(this, model, linkedIdentityHashMap2, linkedIdentityHashMap4, linkedIdentityHashMap5);
        this.validateVertLoops();
    }

    private static <T> void setMate(Map<T, T> map, T t, T t2) {
        map.put(t, t2);
    }

    private static <T> void setMates(Map<T, T> map, Map<T, T> map2, T t, T t2) {
        map.put(t, t2);
        map2.put(t2, t);
    }

    private static <T> T getMate(Map<T, T> map, T t) {
        return map.get(t);
    }

    private void debugFindVert(Point3d point3d, int n) {
    }

    private static void vv(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2) {
        for (Vertex vertex : map2.keySet()) {
            Vertex vertex2 = model.findVertex(vertex.loc);
            if (vertex2 == null) continue;
            Model.setMates(map, map2, vertex2, vertex);
            vertex2.addGroups(vertex.groups);
            vertex.addGroups(vertex2.groups);
        }
    }

    private static void ve(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4) {
        Cloneable cloneable;
        model.validateVertLoops();
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (Edge object3 : map4.keySet()) {
            for (Vertex vertex : model.findVerts(object3.getBounds())) {
                if (map.get(vertex) != null) continue;
                linkedIdentityHashSet.add(vertex);
            }
        }
        for (Vertex vertex : linkedIdentityHashSet) {
            double d = 0.0;
            Point3d point3d = null;
            cloneable = null;
            double d2 = 1.0E-6;
            for (Edge edge : model2.findEdges(vertex.getBounds())) {
                double d3 = edge.curve.getClosestT(vertex.loc);
                Point3d point3d2 = edge.curve.get(d3);
                double d4 = point3d2.distance(vertex.loc);
                if (!(d4 <= d2)) continue;
                d2 = d4;
                cloneable = edge;
                point3d = point3d2;
                d = d3;
            }
            if (cloneable != null) {
                model2.debugFindVert(point3d, 600116);
                Object object = NmtUtil.mergeGroupIds(vertex.groups, cloneable.groups);
                vertex.groups = (int[])object;
                Vertex vertex2 = model2.addVertexToRegion(point3d, (int[])object);
                Edge edge = model2.addVertexToEdge((Edge)cloneable, d, vertex2);
                Model.setMates(map, map2, vertex, vertex2);
                Model.setMate(map4, edge, null);
            }
            model.validateVertLoops();
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vertex = (Vertex)entry.getKey();
            double d = 0.0;
            cloneable = null;
            AModelObj aModelObj = null;
            double d5 = 1.0E-6;
            for (AModelObj aModelObj2 : model.findEdges(vertex.getBounds())) {
                double d6 = aModelObj2.curve.getClosestT(vertex.loc);
                Point3d point3d = aModelObj2.curve.get(d6);
                double d7 = point3d.distance(vertex.loc);
                if (!(d7 <= d5)) continue;
                d5 = d7;
                aModelObj = aModelObj2;
                cloneable = point3d;
                d = d6;
            }
            if (aModelObj != null) {
                AModelObj aModelObj2;
                model.debugFindVert((Point3d)cloneable, 593789949);
                int[] nArray = NmtUtil.mergeGroupIds(vertex.groups, aModelObj.groups);
                vertex.groups = nArray;
                aModelObj2 = model.addVertexToRegion((Point3d)cloneable, nArray);
                Edge edge = model.addVertexToEdge((Edge)aModelObj, d, (Vertex)aModelObj2);
                Model.setMates(map, map2, aModelObj2, vertex);
                Model.setMate(map3, edge, null);
            }
            model.validateVertLoops();
        }
    }

    private static void vf(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Face, Face> map3) {
        Cloneable cloneable3;
        Object object;
        Cloneable cloneable2;
        Object object2;
        LinkedIdentityHashMap<Vertex, ArrayList<Face>> linkedIdentityHashMap = new LinkedIdentityHashMap<Vertex, ArrayList<Face>>();
        for (Face object5 : map3.keySet()) {
            for (Vertex vertex : model.findVerts(object5.getBounds())) {
                if (map.get(vertex) != null) continue;
                ArrayList<Face> arrayList = (ArrayList<Face>)linkedIdentityHashMap.get(vertex);
                if (arrayList == null) {
                    arrayList = new ArrayList<Face>(2);
                    linkedIdentityHashMap.put(vertex, arrayList);
                }
                arrayList.add(object5);
            }
        }
        model.validateVertLoops();
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            object2 = (Vertex)entry.getKey();
            List list = (List)entry.getValue();
            double d = Double.MAX_VALUE;
            cloneable2 = null;
            object = null;
            for (Cloneable cloneable3 : list) {
                FaceClassify faceClassify;
                double d2;
                Point3d point3d = ((Face)cloneable3).plane.projectOntoPlane(((Vertex)object2).loc);
                if (!Model.compare(point3d, ((Vertex)object2).loc) || (d2 = point3d.distanceSquared(((Vertex)object2).loc)) >= d || (faceClassify = model2.testPointOnFace((Face)cloneable3, point3d)) != FaceClassify.INSIDE) continue;
                d = d2;
                cloneable2 = point3d;
                object = cloneable3;
            }
            if (object != null) {
                model2.debugFindVert((Point3d)cloneable2, 153352767);
                int[] nArray = NmtUtil.mergeGroupIds(((Vertex)object2).groups, ((Face)object).groups);
                ((Vertex)object2).groups = nArray;
                cloneable3 = model2.addVertexToRegion((Point3d)cloneable2, nArray);
                model2.addVertexToFace((Face)object, (Vertex)cloneable3);
                Model.setMates(map, map2, object2, cloneable3);
            }
            model.validateVertLoops();
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            object2 = (Vertex)entry.getKey();
            double d = Double.MAX_VALUE;
            Cloneable cloneable4 = null;
            cloneable2 = null;
            for (Face face : model.findFaces(((Vertex)object2).getBounds())) {
                FaceClassify faceClassify;
                double d3;
                cloneable3 = face.plane.projectOntoPlane(((Vertex)object2).loc);
                if (!Model.compare((Point3d)cloneable3, ((Vertex)object2).loc) || (d3 = ((Point3d)cloneable3).distanceSquared(((Vertex)object2).loc)) >= d || (faceClassify = model.testPointOnFace(face, (Point3d)cloneable3)) != FaceClassify.INSIDE) continue;
                d = d3;
                cloneable4 = cloneable3;
                cloneable2 = face;
            }
            if (cloneable2 != null) {
                model.debugFindVert((Point3d)cloneable4, 35882234);
                object = NmtUtil.mergeGroupIds(((Vertex)object2).groups, ((Face)cloneable2).groups);
                Vertex vertex = model.addVertexToRegion((Point3d)cloneable4, (int[])object);
                ((Vertex)object2).groups = (int[])object;
                model.addVertexToFace((Face)cloneable2, vertex);
                Model.setMates(map, map2, vertex, object2);
            }
            model.validateVertLoops();
        }
    }

    private static void vr(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2) {
        for (Map.Entry<Vertex, Vertex> entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vertex = entry.getKey();
            model.debugFindVert(vertex.loc, 215290);
            Vertex vertex2 = model.addVertexToRegion(vertex.loc, vertex.groups);
            Model.setMates(map, map2, vertex2, vertex);
        }
        model.validateVertLoops();
    }

    private static void ee(Model model, Model model2, Stack<Edge> stack, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4) {
        for (Map.Entry<Edge, Edge> entry : map4.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block1: while (!stack.isEmpty()) {
            Edge edge;
            Map.Entry<Edge, Edge> entry;
            Edge edge2 = stack.pop();
            entry = model.findEdges(edge2.getBounds());
            boolean bl = false;
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                edge = (Edge)iterator.next();
                if (!Model.compare(edge, edge2, map)) continue;
                edge.addGroups(edge2.groups);
                edge2.addGroups(edge.groups);
                Model.setMates(map3, map4, edge, edge2);
                bl = true;
                break;
            }
            if (bl) continue;
            iterator = entry.iterator();
            while (iterator.hasNext()) {
                double[] dArray;
                edge = (Edge)iterator.next();
                Vertex vertex = Model.getMate(map2, edge2.v1);
                Vertex vertex2 = Model.getMate(map2, edge2.v2);
                assert (vertex != null);
                assert (vertex2 != null);
                if (vertex == edge.v1 || vertex == edge.v2 || vertex2 == edge.v1 || vertex2 == edge.v2 || (dArray = Model.isect(edge.curve, edge2.curve)) == null || dArray.length <= 0) continue;
                Point3d point3d = edge.curve.get(dArray[0]);
                Point3d point3d2 = edge2.curve.get(dArray[1]);
                if (Model.compare(point3d, edge.curve.get(0.0)) || Model.compare(point3d, edge.curve.get(1.0)) || Model.compare(point3d2, edge2.curve.get(0.0)) || Model.compare(point3d2, edge2.curve.get(1.0))) continue;
                model.validateVertLoops();
                int[] nArray = NmtUtil.mergeGroupIds(edge.groups, edge2.groups);
                model.debugFindVert(point3d, 65167);
                Vertex vertex3 = model.addVertexToRegion(point3d, nArray);
                Edge edge3 = model.addVertexToEdge(edge, dArray[0], vertex3);
                model2.debugFindVert(point3d2, 63485);
                Vertex vertex4 = model2.addVertexToRegion(point3d2, nArray);
                Edge edge4 = model2.addVertexToEdge(edge2, dArray[1], vertex4);
                Model.setMates(map, map2, vertex3, vertex4);
                Model.setMate(map3, edge3, null);
                Model.setMate(map4, edge4, null);
                model.validateVertLoops();
                stack.push(edge2);
                stack.push(edge4);
                continue block1;
            }
        }
    }

    private static boolean isConnected(Vertex vertex, Vertex vertex2, Face face) {
        return vertex != null && vertex.face == face || vertex2 != null && vertex2.face == face;
    }

    private static void ef(Model model, Model model2, Stack<Edge> stack, Stack<Face> stack2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4, Map<Face, Face> map5) {
        Vertex vertex;
        Edge edge;
        Vertex vertex2;
        int[] nArray;
        Point3d point3d;
        Cloneable cloneable;
        Object object;
        Object[] objectArray;
        Vertex vertex3;
        Vertex vertex4;
        Object object2;
        for (Face entry : map5.keySet()) {
            stack2.push(entry);
        }
        while (!stack2.isEmpty()) {
            object2 = stack2.pop();
            for (Edge edge2 : model.findEdges(((Face)object2).getBounds())) {
                if (map3.get(edge2) != null) continue;
                vertex4 = Model.getMate(map, edge2.v1);
                vertex3 = Model.getMate(map, edge2.v2);
                if (Model.curveOnSurface(edge2.curve, (Face)object2)) {
                    if (vertex4 == null || vertex3 == null || (objectArray = Model.findInsertPos((Face)object2, vertex4, vertex3, edge2.curve)) == null) continue;
                    object = NmtUtil.mergeGroupIds(edge2.groups, ((Face)object2).groups);
                    edge2.groups = object;
                    cloneable = model2.addEdgeToRegion(edge2.curve, vertex4, vertex3, (int)object);
                    Face face = model2.addEdgeToFace((Face)object2, (Edge)cloneable, (FaceEdgeInsert)objectArray[0], (FaceEdgeInsert)objectArray[1]);
                    Model.setMates(map3, map4, edge2, cloneable);
                    if (face == null) continue;
                    Model.setMate(map5, face, null);
                    stack2.push(face);
                    continue;
                }
                if (Model.isConnected(vertex4, vertex3, (Face)object2) || (objectArray = model2.isect(edge2.curve, (Face)object2, Filters.accept(FaceClassify.INSIDE), 0.0)).length <= 0) continue;
                object = edge2.curve.get(0.0);
                cloneable = edge2.curve.get(1.0);
                assert (objectArray.length == 1);
                for (Object object3 : objectArray) {
                    point3d = edge2.curve.get((Double)((Pair)object3).v1);
                    if (Model.compare(point3d, (Point3d)object) || Model.compare(point3d, cloneable)) continue;
                    nArray = NmtUtil.mergeGroupIds(edge2.groups, ((Face)object2).groups);
                    model.debugFindVert(point3d, 2751);
                    vertex2 = model.addVertexToRegion(point3d, nArray);
                    edge = model.addVertexToEdge(edge2, (Double)((Pair)object3).v1, vertex2);
                    model2.debugFindVert(point3d, 403279);
                    vertex = model2.addVertexToRegion(point3d, nArray);
                    model2.addVertexToFace((Face)object2, vertex);
                    Model.setMates(map, map2, vertex2, vertex);
                    Model.setMate(map3, edge, null);
                }
            }
        }
        for (Map.Entry<Edge, Edge> entry : map4.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block5: while (!stack.isEmpty()) {
            object2 = stack.pop();
            for (Face face : model.findFaces(((Edge)object2).getBounds())) {
                vertex4 = Model.getMate(map2, ((Edge)object2).v1);
                vertex3 = Model.getMate(map2, ((Edge)object2).v2);
                if (Model.curveOnSurface(((Edge)object2).curve, face)) {
                    if (vertex4 == null || vertex3 == null) {
                        LOGGER.log(Level.WARNING, "2 Missing a vertex mate for " + object2);
                        continue;
                    }
                    objectArray = Model.findInsertPos(face, vertex4, vertex3, ((Edge)object2).curve);
                    if (objectArray == null) continue;
                    object = NmtUtil.mergeGroupIds(((Edge)object2).groups, face.groups);
                    ((Edge)object2).groups = object;
                    cloneable = model.addEdgeToRegion(((Edge)object2).curve, vertex4, vertex3, (int)object);
                    model.addEdgeToFace(face, (Edge)cloneable, (FaceEdgeInsert)objectArray[0], (FaceEdgeInsert)objectArray[1]);
                    Model.setMates(map3, map4, cloneable, object2);
                    continue block5;
                }
                if (Model.isConnected(vertex4, vertex3, face) || (objectArray = model.isect(((Edge)object2).curve, face, Filters.accept(FaceClassify.INSIDE), 0.0)).length <= 0) continue;
                object = ((Edge)object2).curve.get(0.0);
                cloneable = ((Edge)object2).curve.get(1.0);
                assert (objectArray.length == 1);
                for (Object object3 : objectArray) {
                    point3d = ((Edge)object2).curve.get((Double)((Pair)object3).v1);
                    if (Model.compare(point3d, (Point3d)object) || Model.compare(point3d, cloneable)) continue;
                    nArray = NmtUtil.mergeGroupIds(face.groups, ((Edge)object2).groups);
                    model2.debugFindVert(point3d, 74655);
                    vertex2 = model2.addVertexToRegion(point3d, nArray);
                    edge = model2.addVertexToEdge((Edge)object2, (Double)((Pair)object3).v1, vertex2);
                    model.debugFindVert(point3d, 156815);
                    vertex = model.addVertexToRegion(point3d, nArray);
                    model.addVertexToFace(face, vertex);
                    Model.setMates(map, map2, vertex, vertex2);
                    Model.setMate(map4, edge, null);
                    stack.push(edge);
                }
            }
        }
    }

    private static void er(Model model, Model model2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        for (Map.Entry<Edge, Edge> entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            Edge edge = entry.getKey();
            Vertex vertex = Model.getMate(map, edge.v1);
            Vertex vertex2 = Model.getMate(map, edge.v2);
            if (vertex == null || vertex2 == null) {
                LOGGER.log(Level.WARNING, "3 Missing a vertex mate for " + edge);
                continue;
            }
            Edge edge2 = model.addEdgeToRegion(edge.curve, vertex, vertex2, edge.groups);
            Model.setMate(map2, edge, edge2);
        }
    }

    private static void ff(Model model, Model model2, Stack<Face> stack, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4, Map<Face, Face> map5) {
        for (Map.Entry<Face, Face> entry : map5.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block1: while (!stack.isEmpty()) {
            Face face = stack.pop();
            boolean bl = false;
            List<Face> list = model.findFaces(face.getBounds());
            if (list.isEmpty()) continue;
            for (Face face2 : list) {
                if (!Model.compare(face2, face, map, map3)) continue;
                face2.addGroups(face.groups);
                face.addGroups(face2.groups);
                Model.setMate(map5, face, face2);
                bl = true;
                break;
            }
            if (bl) continue;
            IdentityHashSet identityHashSet = new IdentityHashSet();
            for (Serializable serializable : face.edgeLoops) {
                for (Vertex vertex : Vertices.get(serializable)) {
                    identityHashSet.add(vertex);
                }
            }
            for (Serializable serializable : list) {
                Object object;
                Object object2;
                LineSeg3D lineSeg3D = Model.isect(((Face)serializable).plane, face.plane);
                if (lineSeg3D == null) continue;
                TreeMap<Double, Pair<Vertex, Object>> treeMap = new TreeMap<Double, Pair<Vertex, Object>>();
                for (int i = 0; i < ((Face)serializable).edgeLoops.size(); ++i) {
                    object2 = ((Face)serializable).edgeLoops.get(i);
                    for (Vertex vertex : Vertices.get((FaceLoop)object2)) {
                        object = map.get(vertex);
                        if (object == null || !identityHashSet.contains(object)) continue;
                        double d = Util3D.tOnLineSeg(lineSeg3D.p1, lineSeg3D.p2, vertex.loc);
                        treeMap.put(d, new Pair<Vertex, Object>(vertex, object));
                    }
                }
                if (treeMap.size() <= 1) continue;
                int[] nArray = NmtUtil.mergeGroupIds(((Face)serializable).groups, face.groups);
                object2 = treeMap.entrySet().iterator();
                Object object3 = (Map.Entry)object2.next();
                boolean bl2 = false;
                while (object2.hasNext()) {
                    FaceEdgeInsert[] faceEdgeInsertArray;
                    FaceEdgeInsert[] faceEdgeInsertArray2;
                    object = (Map.Entry)object2.next();
                    Point3d point3d = lineSeg3D.get((Double)object3.getKey());
                    Point3d point3d2 = lineSeg3D.get((Double)object.getKey());
                    Vertex vertex = (Vertex)((Pair)object.getValue()).v1;
                    Vertex vertex2 = (Vertex)((Pair)object3.getValue()).v1;
                    Vertex vertex3 = (Vertex)((Pair)object.getValue()).v2;
                    Vertex vertex4 = (Vertex)((Pair)object3.getValue()).v2;
                    object3 = object;
                    if (point3d.distance(point3d2) <= 1.0E-6) continue;
                    LineSeg3D lineSeg3D2 = new LineSeg3D(vertex.loc, vertex2.loc);
                    LineSeg3D lineSeg3D3 = new LineSeg3D(vertex3.loc, vertex4.loc);
                    if (model.findEdge(lineSeg3D2, vertex, vertex2) || model2.findEdge(lineSeg3D3, vertex3, vertex4) || (faceEdgeInsertArray2 = Model.findInsertPos((Face)serializable, vertex, vertex2, lineSeg3D2)) == null || (faceEdgeInsertArray = Model.findInsertPos(face, vertex3, vertex4, lineSeg3D3)) == null) continue;
                    Edge edge = model.addEdgeToRegion(lineSeg3D2, vertex, vertex2, nArray);
                    Edge edge2 = model2.addEdgeToRegion(lineSeg3D3, vertex3, vertex4, nArray);
                    Model.setMates(map3, map4, edge, edge2);
                    Face face3 = model.addEdgeToFace((Face)serializable, edge, faceEdgeInsertArray2[0], faceEdgeInsertArray2[1]);
                    Face face4 = model2.addEdgeToFace(face, edge2, faceEdgeInsertArray[0], faceEdgeInsertArray[1]);
                    if (face4 != null) {
                        Model.setMate(map5, face4, null);
                        stack.push(face4);
                    }
                    if (face3 == null && face4 == null) continue;
                    bl2 = true;
                    stack.push(face);
                    break;
                }
                if (!bl2) continue;
                continue block1;
            }
        }
    }

    private static void fr(Model model, Model model2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2, Map<Face, Face> map3) {
        for (Map.Entry<Face, Face> entry : map3.entrySet()) {
            if (entry.getValue() != null) continue;
            Face face = entry.getKey();
            ArrayList<FaceLoop> arrayList = new ArrayList<FaceLoop>(face.edgeLoops.size());
            for (FaceLoop faceLoop : face.edgeLoops) {
                FaceLoop faceLoop2 = new FaceLoop(faceLoop.edges.size());
                if (faceLoop.vert != null) {
                    Vertex vertex = Model.getMate(map, faceLoop.vert);
                    if (vertex == null) {
                        LOGGER.log(Level.WARNING, "5 Missing a vertex mate for " + faceLoop.vert);
                        continue;
                    }
                    if (vertex.face != null) {
                        LOGGER.log(Level.WARNING, "5a Vertex loop already assigned to another face");
                        continue;
                    }
                    faceLoop2.vert = vertex;
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    Edge edge = Model.getMate(map2, edgeUse.edge);
                    Vertex vertex = Model.getMate(map, edgeUse.v1());
                    if (edge == null || vertex == null) {
                        LOGGER.log(Level.WARNING, "6 Missing a vertex or edge mate for " + edgeUse.edge + " " + edgeUse.v1());
                        continue;
                    }
                    assert (edge != null && vertex != null);
                    boolean bl = edge.v1 == vertex;
                    faceLoop2.edges.add(new EdgeUse(edge, bl));
                }
                if (faceLoop2.vert == null && faceLoop2.edges.isEmpty()) continue;
                arrayList.add(faceLoop2);
            }
            if (arrayList.isEmpty()) {
                LOGGER.log(Level.WARNING, "7 Face has no loops");
                continue;
            }
            Face face2 = model.addFaceToRegion(face.plane, arrayList, face.groups);
            Model.setMate(map3, face, face2);
            model.validateVertLoops();
        }
    }

    private Vertex findVertex(Point3d point3d) {
        double d = 1.0E-12;
        Vertex vertex = null;
        AABox aABox = new AABox(point3d);
        for (Vertex vertex2 : this.findVerts(aABox)) {
            double d2 = point3d.distanceSquared(vertex2.loc);
            if (!(d2 <= d)) continue;
            d = d2;
            vertex = vertex2;
        }
        return vertex;
    }

    private boolean findEdge(IParametric3D iParametric3D, Vertex vertex, Vertex vertex2) {
        if (vertex.edges.size() > vertex2.edges.size()) {
            Vertex vertex3 = vertex;
            vertex = vertex2;
            vertex2 = vertex3;
        }
        for (int i = 0; i < vertex.edges.size(); ++i) {
            Vertex vertex4;
            Edge edge = vertex.edges.get(i);
            Vertex vertex5 = vertex4 = edge.v1 == vertex ? edge.v2 : edge.v1;
            if (vertex4 != vertex2) continue;
            return true;
        }
        return false;
    }

    private static FaceClassify testPointInLoop(List<IParametric3D> list, Point3d point3d, Vector3d vector3d) {
        int n = 0;
        boolean bl = false;
        double[] dArray = new double[2];
        for (IParametric3D iParametric3D : list) {
            double d;
            Point3d point3d2;
            double d2;
            Point3d point3d3 = iParametric3D.get(d2 = iParametric3D.getClosestT(point3d));
            if (Model.compare(point3d3, point3d)) {
                return FaceClassify.ON_EDGE;
            }
            Point3d point3d4 = iParametric3D.get(0.0);
            if (!Inter3D.copLineLineSeg(point3d, vector3d, point3d4, point3d2 = iParametric3D.get(1.0), dArray, 1.0E-6, d = 1.0E-6 / point3d4.distance(point3d2)) || !(dArray[0] > 0.0)) continue;
            if (theUtil.eq0(dArray[1], d) || theUtil.eq(dArray[1], 1.0, d)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        Object object = n % 2 != 0 ? FaceClassify.INSIDE : FaceClassify.OUTSIDE;
        return object;
    }

    private static double randomVecComp(Random random) {
        return random.nextDouble() * 2.0 - 1.0;
    }

    private static Vector3d newRandomVec2D(Random random) {
        return new Vector3d(Model.randomVecComp(random), Model.randomVecComp(random), 0.0);
    }

    private static Vector3d newRandomVec3D(Random random) {
        return new Vector3d(Model.randomVecComp(random), Model.randomVecComp(random), Model.randomVecComp(random));
    }

    private static FaceClassify testPointInLoop(List<IParametric3D> list, Plane3d plane3d, Point3d point3d) {
        Object object;
        Random random = new Random(1L);
        Matrix4d matrix4d = Util.getLocalToWorldXform(plane3d);
        int n = 3;
        for (int i = 0; i < n; ++i) {
            Vector3d object2 = Model.newRandomVec2D(random);
            matrix4d.transform(object2);
            object = Model.testPointInLoop(list, point3d, object2);
            if (object == null) continue;
            return object;
        }
        for (IParametric3D iParametric3D : list) {
            FaceClassify faceClassify;
            object = iParametric3D.get(0.5);
            Vector3d vector3d = Util3D.vector(point3d, (Point3d)object);
            if (vector3d.length() <= 1.0E-6 || (faceClassify = Model.testPointInLoop(list, point3d, vector3d)) == null) continue;
            return faceClassify;
        }
        LOGGER.log(Level.WARNING, String.format("No result found for pointInLoop %s%n", point3d.toString()));
        return FaceClassify.OUTSIDE;
    }

    private FaceClassify testPointInEdgeLoop(Face face, Point3d point3d, Vector3d vector3d, AABox aABox) {
        double[] dArray = Inter3D.rayAABoxIsect(point3d, vector3d, aABox.getMin(), aABox.getMax(), 1.0E-6);
        if (dArray != null) {
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, dArray[1]);
            List<Edge> list = Model.find(this.d_edgeSearch, new LineSegRTreeTest(point3d, point3d2));
            ArrayList<IParametric3D> arrayList = new ArrayList<IParametric3D>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Edge edge = list.get(i);
                if (!edge.faces.contains(face) || face.isInternalEdge(edge)) continue;
                arrayList.add(edge.curve);
            }
            return Model.testPointInLoop(arrayList, point3d, vector3d);
        }
        return FaceClassify.OUTSIDE;
    }

    private FaceClassify testPointInEdgeLoop(Face face, Plane3d plane3d, Point3d point3d, AABox aABox) {
        Serializable serializable;
        int n;
        Random random = new Random(1L);
        Matrix4d matrix4d = Util.getLocalToWorldXform(plane3d);
        int n2 = 3;
        for (n = 0; n < n2; ++n) {
            serializable = Model.newRandomVec2D(random);
            matrix4d.transform((Vector3d)serializable);
            FaceClassify faceClassify = this.testPointInEdgeLoop(face, point3d, (Vector3d)serializable, aABox);
            if (faceClassify == null) continue;
            return faceClassify;
        }
        for (n = 0; n < face.edgeLoops.size(); ++n) {
            serializable = face.edgeLoops.get(n);
            for (int i = 0; i < ((FaceLoop)serializable).edges.size(); ++i) {
                FaceClassify faceClassify;
                EdgeUse edgeUse = ((FaceLoop)serializable).edges.get(i);
                Point3d point3d2 = edgeUse.edge.curve.get(0.5);
                Vector3d vector3d = Util3D.vector(point3d, point3d2);
                if (vector3d.length() <= 1.0E-6 || (faceClassify = this.testPointInEdgeLoop(face, point3d, vector3d, aABox)) == null) continue;
                return faceClassify;
            }
        }
        LOGGER.log(Level.WARNING, String.format("No result found for pointInLoop %s%n", point3d.toString()));
        return FaceClassify.OUTSIDE;
    }

    public FaceClassify testPointOnFace(Face face, Point3d point3d) {
        Object object;
        if (!face.getBounds().contains(point3d, 1.0E-6)) {
            return FaceClassify.OUTSIDE;
        }
        int n = 0;
        for (FaceLoop serializable : face.edgeLoops) {
            n += serializable.edges.size();
        }
        if (n > 30) {
            object = this.testPointInEdgeLoop(face, face.plane, point3d, face.getBounds());
        } else {
            ArrayList<IParametric3D> arrayList = new ArrayList<IParametric3D>(n);
            for (int i = 0; i < face.edgeLoops.size(); ++i) {
                FaceLoop faceLoop = face.edgeLoops.get(i);
                for (int j = 0; j < faceLoop.edges.size(); ++j) {
                    arrayList.add(faceLoop.edges.get((int)j).edge.curve);
                }
            }
            object = Model.testPointInLoop(arrayList, face.plane, point3d);
        }
        return object;
    }

    private boolean pointInSolid(Collection<Face> collection, LineSeg3D lineSeg3D) {
        int n = 0;
        for (Face face : collection) {
            Pair<Double, FaceClassify>[] pairArray = this.isect(lineSeg3D, face, Filters.acceptAll(FaceClassify.class), 1.0E-6);
            if (pairArray.length <= 0) continue;
            if (Model.compare(lineSeg3D.get((Double)pairArray[0].v1), lineSeg3D.get(0.0))) {
                return true;
            }
            n += pairArray.length;
        }
        return n % 2 != 0;
    }

    private boolean contains(Point3d point3d, Vector3d vector3d) {
        AABox aABox = this.getBoundingBox();
        if (!aABox.contains(point3d, 1.0E-6)) {
            return false;
        }
        double[] dArray = Inter3D.rayAABoxIsect(point3d, vector3d, aABox.getMin(), aABox.getMax(), 1.0E-6);
        if (dArray != null) {
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, dArray[1]);
            List<Face> list = Model.compare(point3d, point3d2) ? Model.find(this.d_faceSearch, new AABox(point3d)) : Model.find(this.d_faceSearch, new LineSegRTreeTest(point3d, point3d2));
            double d = Math.max(1.0, dArray[1] * 2.0);
            return this.pointInSolid(list, new LineSeg3D(point3d, Util3D.linePoint(point3d, vector3d, d)));
        }
        return false;
    }

    public boolean contains(Point3d point3d) {
        Random random = new Random(1L);
        Vector3d vector3d = Model.newRandomVec3D(random);
        return this.contains(point3d, vector3d);
    }

    private static boolean pointOnLoop(Point3d point3d, List<IParametric3D> list) {
        for (IParametric3D iParametric3D : list) {
            double d;
            Point3d point3d2 = iParametric3D.get(d = iParametric3D.getClosestT(point3d));
            if (!Model.compare(point3d2, point3d)) continue;
            return true;
        }
        return false;
    }

    public boolean pointOnBoundary(Point3d point3d, Face face) {
        int n = 0;
        for (FaceLoop serializable : face.edgeLoops) {
            n += serializable.edges.size();
        }
        if (n < 10) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (!Model.pointOnLoop(point3d, faceLoop.getCurves())) continue;
                return true;
            }
        } else {
            for (Edge edge : this.findEdges(new AABox(point3d))) {
                double d;
                if (!edge.faces.contains(face) || !Model.compare(edge.curve.get(d = edge.curve.getClosestT(point3d)), point3d)) continue;
                return true;
            }
        }
        return false;
    }

    public static double[] isect(IParametric3D iParametric3D, IParametric3D iParametric3D2) {
        Point3d point3d = iParametric3D.get(0.0);
        Point3d point3d2 = iParametric3D.get(1.0);
        Point3d point3d3 = iParametric3D2.get(0.0);
        Point3d point3d4 = iParametric3D2.get(1.0);
        return Inter3D.getLineSegLineSegIntersection(point3d, point3d2, point3d3, point3d4, 0.0, 1.0E-12);
    }

    private static boolean compare(Edge edge, Edge edge2, Map<Vertex, Vertex> map) {
        Vertex vertex = map.get(edge.v1);
        Vertex vertex2 = map.get(edge.v2);
        return vertex == edge2.v1 && vertex2 == edge2.v2 || vertex == edge2.v2 && vertex2 == edge2.v1;
    }

    public Pair<Double, FaceClassify>[] isect(IParametric3D iParametric3D, Face face, Predicate<FaceClassify> predicate, double d) {
        double[] dArray = iParametric3D.getIsects(face.plane, d);
        if (dArray != null && dArray.length > 0) {
            ArrayList<Pair<Double, FaceClassify>> arrayList = new ArrayList<Pair<Double, FaceClassify>>(dArray.length);
            for (double d2 : dArray) {
                Point3d point3d = iParametric3D.get(d2);
                FaceClassify faceClassify = this.testPointOnFace(face, point3d);
                if (!faceClassify.on || !predicate.test(faceClassify)) continue;
                arrayList.add(new Pair<Double, FaceClassify>(d2, faceClassify));
            }
            return theUtil.toArray(arrayList, Pair.class);
        }
        return new Pair[0];
    }

    private static boolean compare(Face face, Face face2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        if (face.edgeLoops.size() != face2.edgeLoops.size()) {
            return false;
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            boolean bl = false;
            for (FaceLoop faceLoop2 : face2.edgeLoops) {
                if (!Model.compare(faceLoop, faceLoop2, map, map2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean compare(FaceLoop faceLoop, FaceLoop faceLoop2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        if (faceLoop.vert != null) {
            Vertex vertex = map.get(faceLoop.vert);
            return vertex != null && vertex == faceLoop2.vert;
        }
        if (faceLoop.edges.size() != faceLoop2.edges.size()) {
            return false;
        }
        for (EdgeUse edgeUse : faceLoop.edges) {
            Edge edge = map2.get(edgeUse.edge);
            if (edge == null) {
                return false;
            }
            boolean bl = false;
            for (EdgeUse edgeUse2 : faceLoop2.edges) {
                if (edgeUse2.edge != edge) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Point3d point3d, Point3d point3d2) {
        double d = point3d.distance(point3d2);
        return d <= 1.0E-6;
    }

    private static boolean curveOnSurface(IParametric3D iParametric3D, Face face) {
        double d = 1.0E-6;
        return face.plane.distance(iParametric3D.get(0.5)) <= d && face.plane.distance(iParametric3D.get(0.0)) <= d && face.plane.distance(iParametric3D.get(1.0)) <= d;
    }

    private static LineSeg3D isect(Plane3d plane3d, Plane3d plane3d2) {
        Tuple3d[] tuple3dArray = Inter3D.planePlaneIsect(plane3d, plane3d2, 0.0);
        if (tuple3dArray == null) {
            return null;
        }
        return new LineSeg3D((Point3d)tuple3dArray[0], Util3D.add((Point3d)tuple3dArray[0], tuple3dArray[1]));
    }

    public void transform(Matrix4d matrix4d) {
        this.transformUnsafe(matrix4d);
    }

    public void transform(ITransform iTransform, Matrix4d matrix4d) {
        if (Model.getCanUseUnsafeXform(iTransform)) {
            this.transformUnsafe(matrix4d);
        } else {
            this.transformSafe(matrix4d);
        }
    }

    private static boolean getCanUseUnsafeXform(ITransform iTransform) {
        ITransform iTransform2 = TransformUtil.findTransformLastToFirst(iTransform, TransformUtil.SCALING_FILTER);
        return iTransform2 == null;
    }

    private void transformUnsafe(Matrix4d matrix4d) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.loc = Util3D.xform(matrix4d, aModelObj.loc);
            this.updateVertexSearch(aModelObj, 1);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.curve = edge.curve.transform(matrix4d);
            this.updateEdgeSearch(edge, 1);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.calcPlane();
            face.invalidateBounds();
            this.updateFaceSearch(face, 1);
        }
    }

    private void transformSafe(Matrix4d matrix4d) {
        Iterator<Face> iterator;
        Model model = new Model();
        for (Vertex serializable2 : this.d_mainGroup.verts) {
            iterator = Util3D.xform(matrix4d, serializable2.loc);
            model.addVertexToRegion((Point3d)((Object)iterator), serializable2.groups);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            iterator = edge.curve.transform(matrix4d);
            model.addEdge((IParametric3D)((Object)iterator), edge.groups);
        }
        ArrayList arrayList = new ArrayList();
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (Face face : this.d_mainGroup.faces) {
            arrayList.clear();
            identityHashSet.clear();
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (faceLoop.vert != null) continue;
                for (EdgeUse edgeUse : faceLoop.edges) {
                    if (!identityHashSet.add(edgeUse.edge)) continue;
                    arrayList.add(edgeUse.edge.curve.transform(matrix4d));
                }
            }
            model.addFace(face.plane.transformBy(matrix4d), (Collection<? extends IParametric3D>)arrayList, face.groups);
        }
        this.steal(model);
    }

    private void steal(Model model) {
        this.d_edgeSearch = model.d_edgeSearch;
        this.d_faceSearch = model.d_faceSearch;
        this.d_mainGroup = model.d_mainGroup;
        this.d_vertSearch = model.d_vertSearch;
    }

    public void optimize() {
        HashMap<IntArrHash, int[]> hashMap = new HashMap<IntArrHash, int[]>();
        Model.optimize(this.d_mainGroup.verts, hashMap);
        Model.optimize(this.d_mainGroup.edges, hashMap);
        Model.optimize(this.d_mainGroup.faces, hashMap);
    }

    private static void optimize(Collection<? extends AModelObj> collection, Map<IntArrHash, int[]> map) {
        for (AModelObj aModelObj : collection) {
            IntArrHash intArrHash = new IntArrHash(aModelObj.groups);
            int[] nArray = map.get(intArrHash);
            if (nArray == null) {
                map.put(intArrHash, aModelObj.groups);
                continue;
            }
            aModelObj.groups = nArray;
        }
    }

    private static /* synthetic */ void lambda$removeVerticesFromEdges$227(FaceLoop faceLoop, ArrayList arrayList, TriFunction triFunction, Integer n, Integer n2) {
        Vertex vertex;
        EdgeUse edgeUse = faceLoop.edges.get(n);
        if (n.equals(n2)) {
            arrayList.add(edgeUse);
            return;
        }
        EdgeUse edgeUse2 = faceLoop.edges.get(n2);
        Vertex vertex2 = edgeUse.v1();
        if (vertex2 == (vertex = edgeUse2.v2())) {
            return;
        }
        Edge edge = (Edge)triFunction.apply(edgeUse.edge, vertex2, vertex);
        boolean bl = vertex2 == edge.v1;
        EdgeUse edgeUse3 = new EdgeUse(edge, bl);
        arrayList.add(edgeUse3);
    }

    private /* synthetic */ Edge lambda$removeVerticesFromEdges$226(Map map, BiFunction biFunction, Edge edge, Vertex vertex, Vertex vertex2) {
        if (edge.otherVert(vertex) == vertex2) {
            return edge;
        }
        return map.computeIfAbsent(new UnorderedPair<Vertex, Vertex>(vertex, vertex2), unorderedPair -> {
            LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
            Edge edge2 = edge;
            Vertex vertex = edge2.otherVert((Vertex)unorderedPair.v1);
            while (vertex != unorderedPair.v2) {
                for (int n : edge2.groups) {
                    linkedHashSet.add(n);
                }
                edge2 = (Edge)biFunction.apply(edge2, vertex);
                vertex = edge2.otherVert(vertex);
            }
            for (int n : edge2.groups) {
                linkedHashSet.add(n);
            }
            int[] nArray = theUtil.toIntArray(linkedHashSet);
            LineSeg3D lineSeg3D = new LineSeg3D(((Vertex)unorderedPair.v1).loc, ((Vertex)unorderedPair.v2).loc);
            return this.addEdgeToRegion(lineSeg3D, (Vertex)unorderedPair.v1, (Vertex)unorderedPair.v2, nArray);
        });
    }

    public static class Vertices {
        public static Iterable<Vertex> get(final FaceLoop faceLoop) {
            return new Iterable<Vertex>(){

                @Override
                public Iterator<Vertex> iterator() {
                    return new LoopVertexIterator(faceLoop);
                }
            };
        }
    }

    public static class LoopVertexIterator
    implements Iterator<Vertex> {
        private final FaceLoop d_loop;
        private int d_index;

        public LoopVertexIterator(FaceLoop faceLoop) {
            this.d_loop = faceLoop;
            this.d_index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.d_loop.vert != null ? this.d_index == 0 : this.d_index < this.d_loop.edges.size();
        }

        @Override
        public Vertex next() {
            Vertex vertex = this.d_loop.vert != null ? this.d_loop.vert : this.d_loop.edges.get(this.d_index).v1();
            ++this.d_index;
            return vertex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntArrHash {
        public final int[] vals;

        public IntArrHash(int[] nArray) {
            this.vals = nArray;
        }

        public int hashCode() {
            int n = 0;
            for (int n2 : this.vals) {
                n += n2;
            }
            return n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof IntArrHash && NmtUtil.equal(((IntArrHash)object).vals, this.vals);
        }
    }

    public static enum FaceClassify {
        OUTSIDE(false, false),
        INSIDE(true, false),
        ON_EDGE(false, true);

        public final boolean on;
        public final boolean outside;
        public final boolean inside;
        public final boolean onEdge;

        private FaceClassify(boolean bl, boolean bl2) {
            this.on = bl || bl2;
            this.outside = !this.on;
            this.inside = bl;
            this.onEdge = bl2;
        }
    }

    private static class FaceEdgeInsert {
        public FaceLoop loop;
        public int edgeIx;

        public FaceEdgeInsert() {
        }

        public FaceEdgeInsert(FaceLoop faceLoop, int n) {
            this.loop = faceLoop;
            this.edgeIx = n;
        }
    }

    private static class CrossoverSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private static final int CROSSOVER = 30;
        private RTree<T> d_searchTree;
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private CrossoverSearcher() {
        }

        @Override
        public void add(T t) {
            if (this.d_boxCache != null) {
                this.d_boxCache.put(t, ((AModelObj)t).getBounds());
                if (this.d_boxCache.size() == 30) {
                    this.d_searchTree = new RTree();
                    for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                        this.d_searchTree.insert((ISearchVol)entry.getValue(), entry.getKey());
                    }
                    this.d_boxCache = null;
                }
            } else {
                this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T t) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(t);
                if (this.d_searchTree.count() == 29) {
                    this.d_boxCache = this.d_searchTree.getCachedBounds();
                    this.d_boxCache.remove(t);
                    this.d_searchTree = null;
                }
            } else {
                this.d_boxCache.remove(t);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T t) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(t);
                this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
            } else {
                this.d_boxCache.remove(t);
                this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_searchTree = null;
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList<T> arrayList = new ArrayList<T>();
            if (this.d_searchTree != null) {
                this.d_searchTree.find(iTest, (IResult<T>)new CollResult(arrayList));
            } else {
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    if (!iTest.test((AABox)entry.getValue()).positive) continue;
                    arrayList.add(entry.getKey());
                }
            }
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            CrossoverSearcher crossoverSearcher;
            try {
                crossoverSearcher = (CrossoverSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            if (this.d_boxCache != null) {
                crossoverSearcher.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    crossoverSearcher.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
                }
            } else {
                crossoverSearcher.d_searchTree = this.d_searchTree.clone(map);
            }
            if (this.d_cachedBounds != null) {
                crossoverSearcher.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return crossoverSearcher;
        }

        @Override
        public AABox getBounds() {
            if (this.d_searchTree != null) {
                return this.d_searchTree.getBoundingBox();
            }
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox aABox : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(aABox);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class ListSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private ListSearcher() {
        }

        @Override
        public void add(T t) {
            this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T t) {
            this.d_boxCache.remove(t);
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T t) {
            this.d_boxCache.remove(t);
            this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                Containment containment = iTest.test(entry.getValue());
                if (!containment.positive) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            ListSearcher listSearcher;
            try {
                listSearcher = (ListSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            listSearcher.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                listSearcher.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
            }
            if (this.d_cachedBounds != null) {
                listSearcher.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return listSearcher;
        }

        @Override
        public AABox getBounds() {
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox aABox : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(aABox);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class TreeSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private RTree<T> d_searchTree = new RTree();

        private TreeSearcher() {
        }

        @Override
        public void add(T t) {
            this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
        }

        @Override
        public void remove(T t) {
            this.d_searchTree.remove(t);
        }

        @Override
        public void update(T t) {
            this.d_searchTree.remove(t);
            this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
        }

        @Override
        public void clear() {
            this.d_searchTree.clear();
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList arrayList = new ArrayList();
            this.d_searchTree.find(iTest, (IResult<T>)new CollResult(arrayList));
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            TreeSearcher treeSearcher;
            try {
                treeSearcher = (TreeSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            treeSearcher.d_searchTree = this.d_searchTree.clone(map);
            return treeSearcher;
        }

        @Override
        public AABox getBounds() {
            return this.d_searchTree.getBoundingBox();
        }
    }

    private static interface GeomSearcher<T extends AModelObj>
    extends Cloneable {
        public void add(T var1);

        public void remove(T var1);

        public void update(T var1);

        public void clear();

        public List<T> find(ITest<AABox> var1);

        public GeomSearcher<T> clone(Map<T, T> var1);

        public AABox getBounds();
    }

    public static class Group
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final Collection<Face> faces;
        public final Collection<Edge> edges;
        public final Collection<Vertex> verts;

        public Group(int n, Class<? extends Collection> clazz) {
            this.id = n;
            this.faces = Group.newCollection(clazz);
            this.edges = Group.newCollection(clazz);
            this.verts = Group.newCollection(clazz);
        }

        private static <T> Collection<T> newCollection(Class<? extends Collection> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                return new ArrayList();
            }
        }

        public void add(AModelObj aModelObj) {
            if (aModelObj instanceof Vertex) {
                this.verts.add((Vertex)aModelObj);
            } else if (aModelObj instanceof Edge) {
                this.edges.add((Edge)aModelObj);
            } else if (aModelObj instanceof Face) {
                this.faces.add((Face)aModelObj);
            }
        }

        public void clear() {
            this.faces.clear();
            this.edges.clear();
            this.verts.clear();
        }
    }
}

