/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class Face
extends AModelObj {
    private static final Logger LOGGER = Logger.getLogger(Face.class.getName());
    static final long serialVersionUID = 1L;
    public static final int ORIENT_NONE = 0;
    public static final int ORIENT_CCW = 1;
    public static final int ORIENT_CW = 2;
    public Plane3d plane;
    public List<FaceLoop> edgeLoops;
    private transient AABox d_cachedBounds = null;
    private transient Set<Edge> d_internalEdges = null;

    public Face(Plane3d plane3d, List<FaceLoop> list, boolean bl) {
        this.plane = plane3d;
        this.edgeLoops = new ArrayList<FaceLoop>(list);
        if (bl) {
            this.recalcInternalEdges();
        } else {
            this.d_internalEdges = new LinkedIdentityHashSet<Edge>();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.recalcInternalEdges();
    }

    public boolean checkInternalVerts(Model model) {
        for (FaceLoop faceLoop : this.edgeLoops) {
            if (faceLoop.vert == null) continue;
            Point3d point3d = this.plane.projectOntoPlane(faceLoop.vert.loc);
            if (!Model.compare(point3d, faceLoop.vert.loc)) {
                return false;
            }
            if (model.testPointOnFace(this, point3d) == Model.FaceClassify.INSIDE) continue;
            return false;
        }
        return true;
    }

    public boolean isInternalEdge(Edge edge) {
        return this.getInternalEdges().contains(edge);
    }

    private Set<Edge> calcInternalEdges() {
        LinkedIdentityHashSet<Edge> linkedIdentityHashSet = new LinkedIdentityHashSet<Edge>();
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (FaceLoop faceLoop : this.edgeLoops) {
            for (EdgeUse edgeUse : faceLoop.edges) {
                if (identityHashSet.add(edgeUse.edge)) continue;
                linkedIdentityHashSet.add(edgeUse.edge);
            }
        }
        return linkedIdentityHashSet;
    }

    public boolean checkInternalEdgesCorrect() {
        return this.calcInternalEdges().equals(this.d_internalEdges);
    }

    public Set<Edge> getInternalEdges() {
        return this.d_internalEdges;
    }

    public void calcPlane() {
        Plane3d plane3d = NmtUtil.calcLoopPlane(this.edgeLoops.get((int)0).edges);
        if (plane3d == null) {
            LOGGER.log(Level.WARNING, "0x83229f Could not calculate plane");
        } else {
            this.plane = plane3d;
        }
    }

    public void flipOrient() {
        this.plane = this.plane.negate();
        for (FaceLoop faceLoop : this.edgeLoops) {
            faceLoop.flipOrient();
        }
    }

    public double getArea() {
        double d = 0.0;
        for (FaceLoop faceLoop : this.edgeLoops) {
            d += NmtUtil.loopArea(faceLoop.edges, this.plane);
        }
        return Math.abs(d);
    }

    public boolean isValid(Model model) {
        return true;
    }

    private boolean validate(Model model) {
        if (!this.checkInternalEdgesCorrect()) {
            return false;
        }
        assert (!this.edgeLoops.isEmpty());
        FaceLoop faceLoop = this.edgeLoops.get(0);
        if (faceLoop.vert != null || faceLoop.edges.isEmpty() || !faceLoop.isValid() || !faceLoop.isOpen() || NmtUtil.getFaceOrient(faceLoop.edges, this.plane) != 1) {
            return false;
        }
        for (int i = 1; i < this.edgeLoops.size(); ++i) {
            FaceLoop faceLoop2 = this.edgeLoops.get(i);
            if (!faceLoop2.isValid()) {
                return false;
            }
            if (faceLoop2.vert != null || !faceLoop2.isOpen() || NmtUtil.getFaceOrient(faceLoop2.edges, this.plane) == 2) continue;
            return false;
        }
        return model == null || this.checkInternalVerts(model);
    }

    public Face clone(CloneMap cloneMap) {
        Face face = (Face)this.clone();
        face.edgeLoops = new ArrayList<FaceLoop>(this.edgeLoops.size());
        for (FaceLoop serializable : this.edgeLoops) {
            face.edgeLoops.add(serializable.clone(cloneMap));
        }
        face.d_internalEdges = new LinkedIdentityHashSet<Edge>();
        for (Edge edge : this.d_internalEdges) {
            face.d_internalEdges.add(cloneMap.get(edge));
        }
        return face;
    }

    @Override
    public AABox getBounds() {
        if (this.d_cachedBounds == null) {
            AABox aABox = new AABox();
            FaceLoop faceLoop = this.outerLoop();
            for (EdgeUse edgeUse : faceLoop.edges) {
                aABox.add(edgeUse.edge.getBounds());
            }
            this.d_cachedBounds = aABox;
        }
        return this.d_cachedBounds;
    }

    public AABox getLocalBounds() {
        Matrix4d matrix4d = Util.getWorldToLocalXform(this.plane);
        AABox aABox = this.getBounds();
        AABox aABox2 = new AABox();
        aABox2.add(Util3D.xform(matrix4d, aABox.mmm()));
        aABox2.add(Util3D.xform(matrix4d, aABox.mmM()));
        aABox2.add(Util3D.xform(matrix4d, aABox.mMm()));
        aABox2.add(Util3D.xform(matrix4d, aABox.mMM()));
        aABox2.add(Util3D.xform(matrix4d, aABox.Mmm()));
        aABox2.add(Util3D.xform(matrix4d, aABox.MmM()));
        aABox2.add(Util3D.xform(matrix4d, aABox.MMm()));
        aABox2.add(Util3D.xform(matrix4d, aABox.MMM()));
        return aABox2;
    }

    public void invalidateBounds() {
        this.d_cachedBounds = null;
    }

    public void recalcInternalEdges() {
        this.d_internalEdges = this.calcInternalEdges();
    }

    public void addInternalEdge(Edge edge) {
        this.getInternalEdges().add(edge);
    }

    public void removeInternalEdge(Edge edge) {
        this.getInternalEdges().remove(edge);
    }

    public void clearConnections() {
        for (FaceLoop faceLoop : this.edgeLoops) {
            faceLoop.removeFace(this);
        }
    }

    public void buildConnections() {
        for (FaceLoop faceLoop : this.edgeLoops) {
            faceLoop.addFace(this);
        }
    }

    public FaceLoop outerLoop() {
        assert (!this.edgeLoops.isEmpty());
        return this.edgeLoops.get(0);
    }

    public List<EdgeUse> getEdges() {
        return this.getEdges(false);
    }

    public List<EdgeUse> getEdges(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.edgeLoops.size(); ++i) {
            n += this.edgeLoops.get((int)i).edges.size();
        }
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(n);
        for (int i = 0; i < this.edgeLoops.size(); ++i) {
            arrayList.addAll(this.edgeLoops.get((int)i).edges);
        }
        return arrayList;
    }

    public Triangulation triangulate(double d) {
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.triangulate(d, linkedHashMap, arrayList);
        return new Triangulation(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), theUtil.toIntArray(arrayList));
    }

    public boolean triangulate(double d, Map<Point3d, Integer> map, List<Integer> list) {
        int n;
        int n2;
        Object object;
        HashMap<Object, Vertex> hashMap = new HashMap<Object, Vertex>();
        Matrix4d matrix4d = Util.getWorldToLocalXform(this.plane);
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(this.plane);
        MeshBuilder meshBuilder = new MeshBuilder(1.0E-6);
        for (FaceLoop faceLoop : this.edgeLoops) {
            for (EdgeUse object22 : faceLoop.edges) {
                object = Util3D.xform2d(matrix4d, object22.v1().loc);
                Point2d n3 = Util3D.xform2d(matrix4d, object22.v2().loc);
                hashMap.put(object, object22.v1());
                hashMap.put(n3, object22.v2());
                meshBuilder.addEdge((Point2d)object, n3);
            }
        }
        Mesh mesh = meshBuilder.build();
        boolean bl = mesh.triangulateEvenOdd(n2 = d > 0.0 ? 1 : 0, d);
        if (!bl) {
            return false;
        }
        TriangulatorInfo triangulatorInfo = mesh.getOutput();
        object = new int[triangulatorInfo.points.length];
        for (n = 0; n < triangulatorInfo.points.length; ++n) {
            Point3d point3d;
            Point2d point2d = triangulatorInfo.points[n];
            Vertex vertex = (Vertex)hashMap.get(point2d);
            if (vertex != null) {
                point3d = vertex.loc;
            } else {
                point3d = new Point3d(point2d.x, point2d.y, 0.0);
                matrix4d2.transform(point3d);
            }
            Integer n4 = map.get(point3d);
            if (n4 == null) {
                n4 = map.size();
                map.put(point3d, n4);
            }
            object[n] = n4;
        }
        for (n = 0; n < triangulatorInfo.triangles.length; ++n) {
            triangulatorInfo.triangles[n] = (int)object[triangulatorInfo.triangles[n]];
        }
        list.addAll(Arrays.asList(theUtil.toIntArray(triangulatorInfo.triangles)));
        return true;
    }

    public IFace toGeomFace() {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.edgeLoops.size());
        for (int i = 0; i < this.edgeLoops.size(); ++i) {
            FaceLoop faceLoop = this.edgeLoops.get(i);
            if (faceLoop.vert != null || faceLoop.edges.size() < 3) continue;
            arrayList2.add(arrayList.size());
            for (EdgeUse edgeUse : faceLoop.edges) {
                arrayList.add(edgeUse.v1().loc);
            }
        }
        return PolyUtil.newPoly(arrayList.toArray(new Point3d[arrayList.size()]), theUtil.toIntArray(arrayList2));
    }

    public List<EdgeUse> getUses(Edge edge) {
        ArrayList<EdgeUse> arrayList = null;
        for (FaceLoop faceLoop : this.edgeLoops) {
            for (EdgeUse edgeUse : faceLoop.edges) {
                if (edgeUse.edge != edge || arrayList != null && arrayList.contains(edgeUse)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<EdgeUse>(2);
                }
                arrayList.add(edgeUse);
                if (arrayList.size() != 2) continue;
                return arrayList;
            }
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }
}

