/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Vertex;

public class EdgeUse
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Edge edge;
    public final boolean orient;
    private transient IParametric3D d_cachedCurve = null;

    public EdgeUse(Edge edge, boolean bl) {
        this.edge = edge;
        this.orient = bl;
    }

    public Vertex v1() {
        return this.orient ? this.edge.v1 : this.edge.v2;
    }

    public Vertex v2() {
        return this.orient ? this.edge.v2 : this.edge.v1;
    }

    public synchronized IParametric3D curve() {
        if (this.d_cachedCurve == null) {
            this.d_cachedCurve = this.orient ? this.edge.curve : this.edge.curve.reverse();
        }
        return this.d_cachedCurve;
    }

    public String toString() {
        return "[EdgeUse] " + this.orient + ": " + this.edge.v1 + " -> " + this.edge.v2;
    }

    public Vector3d getTangent(double d) {
        if (this.orient) {
            return this.edge.curve.getTangent(d);
        }
        Vector3d vector3d = this.edge.curve.getTangent(1.0 - d);
        vector3d.negate();
        return vector3d;
    }

    public EdgeUse reverse() {
        return new EdgeUse(this.edge, !this.orient);
    }

    public EdgeUse clone(CloneMap cloneMap) {
        return new EdgeUse(cloneMap.get(this.edge), this.orient);
    }
}

