/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.CloneMap;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Vertex;

public class Edge
extends AModelObj {
    static final long serialVersionUID = 1L;
    public Vertex v1;
    public Vertex v2;
    public IParametric3D curve;
    public transient List<Face> faces = new ArrayList<Face>(3);

    public Edge(Vertex vertex, Vertex vertex2, IParametric3D iParametric3D) {
        this.v1 = vertex;
        this.v2 = vertex2;
        this.curve = iParametric3D;
    }

    @Override
    public AABox getBounds() {
        AABox aABox = new AABox();
        aABox.add(this.v1.loc, this.v2.loc);
        return aABox;
    }

    public String toString() {
        return String.format("[Edge] %s -> %s", this.v1.loc.toString(), this.v2.loc.toString());
    }

    public Edge clone(CloneMap cloneMap) {
        Edge edge = (Edge)this.clone();
        edge.v1 = cloneMap.get(this.v1);
        edge.v2 = cloneMap.get(this.v2);
        edge.faces = new ArrayList<Face>(this.faces.size());
        return edge;
    }

    public boolean isConnected() {
        return !this.faces.isEmpty();
    }

    public void clearConnections() {
        this.v1.edges.remove(this);
        this.v2.edges.remove(this);
    }

    public void buildConnections() {
        this.v1.addEdge(this);
        this.v2.addEdge(this);
    }

    public Vertex otherVert(Vertex vertex) {
        return vertex == this.v1 ? this.v2 : this.v1;
    }

    public void addFace(Face face) {
        if (!this.faces.contains(face)) {
            this.faces.add(face);
        }
    }

    public void addAllFaces(Collection<Face> collection) {
        for (Face face : collection) {
            if (this.faces.contains(face)) continue;
            this.faces.add(face);
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.faces);
    }

    @Override
    public void readTopology(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.faces = (List)objectInputStream.readObject();
    }
}

