/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.util.IdentityHashMap;
import java.util.Map;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Vertex;

public class CloneMap {
    private final Map<Vertex, Vertex> d_vertMap = new IdentityHashMap<Vertex, Vertex>();
    private final Map<Edge, Edge> d_edgeMap = new IdentityHashMap<Edge, Edge>();
    private final Map<Face, Face> d_faceMap = new IdentityHashMap<Face, Face>();

    private static <T> T get(Map<T, T> map, T t) {
        T t2 = map.get(t);
        assert (t2 != null);
        return t2;
    }

    public Map<Vertex, Vertex> getVertMap() {
        return this.d_vertMap;
    }

    public Map<Edge, Edge> getEdgeMap() {
        return this.d_edgeMap;
    }

    public Map<Face, Face> getFaceMap() {
        return this.d_faceMap;
    }

    public Vertex get(Vertex vertex) {
        return CloneMap.get(this.d_vertMap, vertex);
    }

    public Edge get(Edge edge) {
        return CloneMap.get(this.d_edgeMap, edge);
    }

    public Face get(Face face) {
        return CloneMap.get(this.d_faceMap, face);
    }

    public void put(Vertex vertex, Vertex vertex2) {
        this.d_vertMap.put(vertex, vertex2);
    }

    public void put(Edge edge, Edge edge2) {
        this.d_edgeMap.put(edge, edge2);
    }

    public void put(Face face, Face face2) {
        this.d_faceMap.put(face, face2);
    }
}

