/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.IntPredicate;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.NmtUtil;

public abstract class AModelObj
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public int[] groups = new int[0];

    public abstract AABox getBounds();

    public void addGroup(int n) {
        this.groups = NmtUtil.mergeGroupIds(this.groups, n);
    }

    public void addGroups(int[] nArray) {
        this.groups = NmtUtil.mergeGroupIds(this.groups, nArray);
    }

    public boolean partOfGroup(int n) {
        return NmtUtil.findGroup(this.groups, n);
    }

    public void removeGroupsIf(IntPredicate intPredicate) {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.groups.length];
        for (n = 0; n < this.groups.length; ++n) {
            int n3 = this.groups[n];
            if (intPredicate.test(n3)) continue;
            nArray[n2++] = this.groups[n];
        }
        this.groups = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.groups[n] = nArray[n];
        }
    }

    public void removeGroups(int[] nArray) {
        this.removeGroupsIf(n -> NmtUtil.findGroup(nArray, n));
    }

    public void removeGroup(int n) {
        this.removeGroupsIf(n2 -> n2 == n);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public void writeTopology(ObjectOutputStream objectOutputStream) throws IOException {
    }

    public void readTopology(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

