/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.manip;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.util.Pair;

public abstract class AExtrudeHandle<T>
implements IHandle {
    private T d_origGeom;
    private T d_geom;
    private Vector3d d_extrudeDir;
    private Point3d d_snapLoc;

    public AExtrudeHandle(T t) {
        this.d_geom = t;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof AExtrudeHandle && ((AExtrudeHandle)object).d_geom.getClass().isInstance(this.d_geom);
    }

    protected T getManipGeom() {
        return this.d_geom;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getPickFilter() {
        return null;
    }

    protected abstract Vector3d getExtrudeDir(T var1);

    protected abstract T extrude(T var1, Vector3d var2, double var3) throws ManipException;

    @Override
    public ISnapConstraint getConstraint(Point3d point3d) {
        Vector3d vector3d = this.getExtrudeDir(this.d_geom);
        return new LineConstraint(point3d, vector3d);
    }

    @Override
    public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        LineConstraint lineConstraint = (LineConstraint)iSnapConstraint;
        this.d_origGeom = this.d_geom;
        this.d_snapLoc = point3d;
        this.d_extrudeDir = lineConstraint.dir;
    }

    @Override
    public Object modify(Point3d point3d) throws ManipException {
        double d = Util3D.tOnLine(this.d_snapLoc, this.d_extrudeDir, point3d);
        this.d_geom = this.extrude(this.d_origGeom, this.d_extrudeDir, d);
        return this.d_geom;
    }

    @Override
    public Object end() {
        return this.d_geom;
    }
}

