/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.TriInterpolator3d;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public class Util3D {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final Tuple3d TUP3D_ZERO = new Point3d(0.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XPOS = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XNEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_YPOS = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d VEC3D_YNEG = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d VEC3D_ZPOS = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d VEC3D_ZNEG = new Vector3d(0.0, 0.0, -1.0);
    public static final Point3d PNT3D_XPOS = new Point3d(1.0, 0.0, 0.0);
    public static final Point3d PNT3D_XNEG = new Point3d(-1.0, 0.0, 0.0);
    public static final Point3d PNT3D_YPOS = new Point3d(0.0, 1.0, 0.0);
    public static final Point3d PNT3D_YNEG = new Point3d(0.0, -1.0, 0.0);
    public static final Point3d PNT3D_ZPOS = new Point3d(0.0, 0.0, 1.0);
    public static final Point3d PNT3D_ZNEG = new Point3d(0.0, 0.0, -1.0);
    public static final Vector3d VEC_ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Point3d PNT_ZERO = new Point3d(0.0, 0.0, 0.0);

    public static double interpolateTriValues(Point3d point3d, Point3d point3d2, Point3d point3d3, double d, double d2, double d3, Point3d point3d4) {
        TriInterpolator3d triInterpolator3d = new TriInterpolator3d(point3d, point3d2, point3d3);
        return triInterpolator3d.interpolate(point3d4, d, d2, d3);
    }

    public static Plane3d getPlane(Vector3d vector3d, Point3d point3d) {
        double d = -(vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z);
        return new Plane3d(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public static Plane3d getPlane(Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        vector3d.normalize();
        return Util3D.getPlane(vector3d, point3d);
    }

    public static double distance(Point3d point3d, Plane3d plane3d) {
        return point3d.x * plane3d.x + point3d.y * plane3d.y + point3d.z * plane3d.z + plane3d.w;
    }

    public static boolean pointOnPlane(Point3d point3d, Plane3d plane3d, double d) {
        double d2 = point3d.x * plane3d.x + point3d.y * plane3d.y + point3d.z * plane3d.z + plane3d.w;
        return Math.abs(d2) <= d;
    }

    public static boolean isPointBehindPlane(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        double d = -(vector3d.x * point3d2.x + vector3d.y * point3d2.y + vector3d.z * point3d2.z);
        double d2 = vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d;
        return d2 < 0.0;
    }

    public static int getClosestAxis(Vector3d vector3d) {
        double d;
        int n;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.normalize(vector3d);
        double d2 = vector3d2.dot(VEC3D_XPOS);
        double d3 = vector3d2.dot(VEC3D_YPOS);
        double d4 = vector3d2.dot(VEC3D_ZPOS);
        double d5 = Math.abs(Math.abs(d2) - 1.0);
        double d6 = Math.abs(Math.abs(d3) - 1.0);
        double d7 = Math.abs(Math.abs(d4) - 1.0);
        if (d5 < d6) {
            n = 0;
            d = d5;
        } else {
            n = 1;
            d = d6;
        }
        if (d7 < d) {
            n = 2;
        }
        return n;
    }

    public static Point3d getClosestPoint(View view, Point3d point3d, double d, Point3d ... point3dArray) {
        return Util3D.getClosestPoint(view, point3d, d, Arrays.asList(point3dArray));
    }

    public static Point3d getClosestPoint(View view, Point3d point3d, double d, Collection<Point3d> collection) {
        Point3d point3d2 = view.worldToScreen(point3d);
        double d2 = d * d;
        Point3d point3d3 = null;
        double d3 = d2;
        for (Point3d point3d4 : collection) {
            if (point3d4 == null) continue;
            Point3d point3d5 = view.worldToScreen(point3d4);
            double d4 = point3d5.x - point3d2.x;
            double d5 = point3d5.y - point3d2.y;
            double d6 = d4 * d4 + d5 * d5;
            if (!(d6 <= d3)) continue;
            d3 = d6;
            point3d3 = point3d4;
        }
        return point3d3;
    }

    private static boolean lEqual(double d, double d2, double d3) {
        return d - d2 <= d3;
    }

    private static boolean gEqual(double d, double d2, double d3) {
        return d - d2 >= -d3;
    }

    public static Quat4d shortestArc(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        Quat4d quat4d = new Quat4d();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.normalize(vector3d);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.normalize(vector3d2);
        double d2 = vector3d4.dot(vector3d5);
        if (Util3D.lEqual(d2, -1.0, d)) {
            Vector3d vector3d6 = new Vector3d();
            vector3d6.normalize(vector3d3);
            quat4d.set(vector3d6.x, vector3d6.y, vector3d6.z, 0.0);
            return quat4d;
        }
        if (Util3D.gEqual(d2, 1.0, d)) {
            quat4d.set(0.0, 0.0, 0.0, 1.0);
            return quat4d;
        }
        Vector3d vector3d7 = new Vector3d();
        vector3d7.cross(vector3d4, vector3d5);
        double d3 = Math.sqrt((1.0 + d2) * 2.0);
        double d4 = 1.0 / d3;
        quat4d.set(vector3d7.x * d4, vector3d7.y * d4, vector3d7.z * d4, d3 * 0.5);
        return quat4d;
    }

    public static Quat4d shortestArcN(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        double d2 = vector3d.dot(vector3d2);
        if (theUtil.le(d2, -1.0, d)) {
            return new Quat4d(vector3d3.x, vector3d3.y, vector3d3.z, 0.0);
        }
        if (theUtil.ge(d2, 1.0, d)) {
            return new Quat4d(0.0, 0.0, 0.0, 1.0);
        }
        Vector3d vector3d4 = Util3D.cross(vector3d, vector3d2);
        double d3 = Math.sqrt((1.0 + d2) * 2.0);
        double d4 = 1.0 / d3;
        return new Quat4d(vector3d4.x * d4, vector3d4.y * d4, vector3d4.z * d4, d3 * 0.5);
    }

    public static double getRotation(Quat4d quat4d) {
        return Util3D.getRotation(quat4d, null);
    }

    public static double getRotation(Quat4d quat4d, Vector3d vector3d) {
        double d = Math.acos(quat4d.w);
        if (vector3d != null) {
            double d2 = 1.0 / Math.sin(d);
            vector3d.set(quat4d.x * d2, quat4d.y * d2, quat4d.z * d2);
        }
        return d * 2.0;
    }

    public static Vector3d vector(Point3d point3d, Point3d point3d2) {
        return new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
    }

    public static Vector3d vectorN(Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        vector3d.normalize();
        return vector3d;
    }

    public static Vector3d normalize(Vector3d vector3d) {
        double d = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        return new Vector3d(vector3d.x * d, vector3d.y * d, vector3d.z * d);
    }

    public static Vector3d cross(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        return vector3d3;
    }

    public static double safeNormalize(Vector3d vector3d, double d) {
        double d2 = vector3d.lengthSquared();
        if (theUtil.eq0(d2, d)) {
            return 0.0;
        }
        double d3 = Math.sqrt(d2);
        vector3d.scale(1.0 / d3);
        return d3;
    }

    public static double dot(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return tuple3d.x * tuple3d2.x + tuple3d.y * tuple3d2.y + tuple3d.z * tuple3d2.z;
    }

    public static Vector3d add(Vector3d vector3d, Tuple3d tuple3d) {
        return new Vector3d(vector3d.x + tuple3d.x, vector3d.y + tuple3d.y, vector3d.z + tuple3d.z);
    }

    public static Point3d add(Point3d point3d, Tuple3d tuple3d) {
        return new Point3d(point3d.x + tuple3d.x, point3d.y + tuple3d.y, point3d.z + tuple3d.z);
    }

    public static Vector3d sub(Vector3d vector3d, Tuple3d tuple3d) {
        return new Vector3d(vector3d.x - tuple3d.x, vector3d.y - tuple3d.y, vector3d.z - tuple3d.z);
    }

    public static Point3d sub(Point3d point3d, Tuple3d tuple3d) {
        return new Point3d(point3d.x - tuple3d.x, point3d.y - tuple3d.y, point3d.z - tuple3d.z);
    }

    public static Vector3d scale(Vector3d vector3d, double d) {
        return new Vector3d(vector3d.x * d, vector3d.y * d, vector3d.z * d);
    }

    public static Matrix4d invert(Matrix4d matrix4d) throws NoninvertibleTransformException {
        try {
            Matrix4d matrix4d2 = new Matrix4d(matrix4d);
            matrix4d2.invert();
            return matrix4d2;
        }
        catch (Throwable throwable) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible transform matrix."));
        }
    }

    public static Point3d getMidPoint(Point3d point3d, Point3d point3d2) {
        return new Point3d((point3d.x + point3d2.x) * 0.5, (point3d.y + point3d2.y) * 0.5, (point3d.z + point3d2.z) * 0.5);
    }

    public static Vector3d negate(Vector3d vector3d) {
        return new Vector3d(-vector3d.x, -vector3d.y, -vector3d.z);
    }

    public static Vector3d negateEq(Vector3d vector3d) {
        vector3d.negate();
        return vector3d;
    }

    public static double angleWithPlane(Plane3d plane3d, Vector3d vector3d, double d) {
        Vector3d vector3d2 = plane3d.getNormal();
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        if (theUtil.eq0(vector3d3.dot(vector3d3), d * d)) {
            return 1.5707963267948966;
        }
        vector3d3.cross(vector3d2, vector3d3);
        return vector3d3.angle(vector3d);
    }

    public static boolean areParallel(Plane3d plane3d, Vector3d vector3d, double d) {
        return Util3D.arePerpendicular(plane3d.getNormal(), vector3d, d);
    }

    public static boolean areParallel(Plane3d plane3d, Plane3d plane3d2, double d) {
        return Util3D.areParallel(plane3d.getNormal(), plane3d2.getNormal(), d);
    }

    public static boolean lineInPlane(Plane3d plane3d, Point3d point3d, Vector3d vector3d, double d) {
        double d2 = plane3d.dot(point3d);
        if (Math.abs(d2) > d) {
            return false;
        }
        return Util3D.areParallel(plane3d, vector3d, d);
    }

    public static boolean linesegInPlane(Plane3d plane3d, Point3d point3d, Point3d point3d2, double d) {
        return Math.abs(plane3d.dot(point3d)) <= d && Math.abs(plane3d.dot(point3d2)) <= d;
    }

    public static Point3d linesegPoint(Point3d point3d, Point3d point3d2, double d) {
        if (d == 1.0) {
            return new Point3d(point3d2);
        }
        return new Point3d(point3d.x + (point3d2.x - point3d.x) * d, point3d.y + (point3d2.y - point3d.y) * d, point3d.z + (point3d2.z - point3d.z) * d);
    }

    public static Point3d linePoint(Point3d point3d, Vector3d vector3d, double d) {
        return new Point3d(point3d.x + vector3d.x * d, point3d.y + vector3d.y * d, point3d.z + vector3d.z * d);
    }

    public static Point3d linePoint(Point3d point3d, Vector3d vector3d, double d, Point3d point3d2) {
        point3d2.set(point3d.x + vector3d.x * d, point3d.y + vector3d.y * d, point3d.z + vector3d.z * d);
        return point3d2;
    }

    private static double dirDotTest(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = vector3d.lengthSquared();
        if (d2 <= d) {
            return Double.NaN;
        }
        double d3 = vector3d2.lengthSquared();
        if (d3 <= d) {
            return Double.NaN;
        }
        Vector3d vector3d3 = Util3D.scale(vector3d, 1.0 / Math.sqrt(d2));
        Vector3d vector3d4 = Util3D.scale(vector3d2, 1.0 / Math.sqrt(d3));
        return vector3d3.dot(vector3d4);
    }

    private static double dirDotTest(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.lengthSquared();
        if (d == 0.0) {
            return Double.NaN;
        }
        double d2 = vector3d2.lengthSquared();
        if (d2 == 0.0) {
            return Double.NaN;
        }
        double d3 = 1.0 / Math.sqrt(d);
        double d4 = 1.0 / Math.sqrt(d2);
        return vector3d.x * d3 * vector3d2.x * d4 + vector3d.y * d3 * vector3d2.y * d4 + vector3d.z * d3 * vector3d2.z * d4;
    }

    public static boolean areParallel(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2, d);
        return Double.isNaN(d2) || Math.abs(Math.abs(d2) - 1.0) <= d;
    }

    public static boolean testParallel(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2);
        return !Double.isNaN(d2) && Math.abs(Math.abs(d2) - 1.0) <= d;
    }

    public static boolean arePerpendicular(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2, d);
        return Double.isNaN(d2) || Math.abs(d2) <= d;
    }

    public static boolean testPerpendicular(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2);
        return !Double.isNaN(d2) && Math.abs(d2) <= d;
    }

    public static boolean areAligned(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double d) {
        return Util3D.areParallel(vector3d, vector3d2, d) && Util3D.areParallel(vector3d, Util3D.vector(point3d, point3d2), d);
    }

    public static boolean testAligned(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double d, double d2) {
        if (!Util3D.testParallel(vector3d, vector3d2, d)) {
            return false;
        }
        return Inter3D.distSqToNearestPtOnLine(point3d, vector3d, point3d2) <= d2;
    }

    public static boolean pointSameDir(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2, d);
        return Double.isNaN(d2) || Math.abs(d2 - 1.0) <= d;
    }

    public static boolean testSameDir(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = Util3D.dirDotTest(vector3d, vector3d2);
        return !Double.isNaN(d2) && Math.abs(d2 - 1.0) <= d;
    }

    public static Vector3d rotate(Vector3d vector3d, Vector3d vector3d2, double d) {
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d2, d);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setRotation(axisAngle4d);
        Vector3d vector3d3 = new Vector3d(vector3d);
        matrix4d.transform(vector3d3);
        return vector3d3;
    }

    public static boolean isVecZero(Vector3d vector3d) {
        return vector3d.epsilonEquals(VEC_ZERO, 1.0E-9);
    }

    public static double tOnLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = point3d3.x - point3d.x;
        double d5 = point3d3.y - point3d.y;
        double d6 = point3d3.z - point3d.z;
        double d7 = d * d4 + d2 * d5 + d3 * d6;
        double d8 = d * d + d2 * d2 + d3 * d3;
        return d7 / d8;
    }

    public static double tOnLine(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = vector3d.x * d + vector3d.y * d2 + vector3d.z * d3;
        return d4 / vector3d.lengthSquared();
    }

    public static Point3d round(Point3d point3d, int n) {
        return new Point3d(theMath.round(point3d.x, n), theMath.round(point3d.y, n), theMath.round(point3d.z, n));
    }

    public static Point3d round(Point3d point3d, double d) {
        return new Point3d(theMath.round(point3d.x, d), theMath.round(point3d.y, d), theMath.round(point3d.z, d));
    }

    public static double lineAngle(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.angle(vector3d2);
        assert (d >= 0.0);
        return d > 1.5707963267948966 ? Math.PI - d : d;
    }

    public static double angle(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = vector3d.angle(vector3d2);
        Vector3d vector3d4 = Util3D.cross(vector3d, vector3d2);
        double d2 = vector3d4.dot(vector3d3);
        return d2 >= 0.0 ? d : -d;
    }

    public static double angle0To2PI(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        if (vector3d.equals(vector3d2)) {
            return 0.0;
        }
        double d = vector3d.angle(vector3d2);
        Vector3d vector3d4 = Util3D.cross(vector3d, vector3d2);
        double d2 = vector3d4.dot(vector3d3);
        return d2 >= 0.0 ? d : Math.PI * 2 - d;
    }

    public static Point2d to2d(Point3d point3d) {
        return new Point2d(point3d.x, point3d.y);
    }

    public static Vector2d to2d(Vector2d vector2d) {
        return new Vector2d(vector2d.x, vector2d.y);
    }

    public static Point2d xform2d(Matrix4d matrix4d, Point3d point3d) {
        return Util3D.xform2d(matrix4d, point3d, false);
    }

    public static Point2d xform2d(Matrix4d matrix4d, Point3d point3d, boolean bl) {
        point3d = Util3D.xform(matrix4d, point3d, bl);
        return new Point2d(point3d.x, point3d.y);
    }

    public static Point3d xform(Matrix4d matrix4d, Point3d point3d) {
        return Util3D.xform(matrix4d, point3d, false);
    }

    public static Point3d xform(Matrix4d matrix4d, Point3d point3d, boolean bl) {
        point3d = new Point3d(point3d);
        if (bl) {
            Util3D.normalizedXform(matrix4d, point3d);
        } else {
            matrix4d.transform(point3d);
        }
        return point3d;
    }

    public static Point3d xformEq(Matrix4d matrix4d, Point3d point3d) {
        return Util3D.xformEq(matrix4d, point3d, false);
    }

    public static Point3d xformEq(Matrix4d matrix4d, Point3d point3d, boolean bl) {
        if (bl) {
            Util3D.normalizedXform(matrix4d, point3d);
        } else {
            matrix4d.transform(point3d);
        }
        return point3d;
    }

    public static Vector3d xform(Matrix4d matrix4d, Vector3d vector3d) {
        vector3d = new Vector3d(vector3d);
        matrix4d.transform(vector3d);
        return vector3d;
    }

    public static void normalizedXform(Matrix4d matrix4d, Point3d point3d) {
        double d = matrix4d.m00 * point3d.x + matrix4d.m01 * point3d.y + matrix4d.m02 * point3d.z + matrix4d.m03;
        double d2 = matrix4d.m10 * point3d.x + matrix4d.m11 * point3d.y + matrix4d.m12 * point3d.z + matrix4d.m13;
        double d3 = matrix4d.m20 * point3d.x + matrix4d.m21 * point3d.y + matrix4d.m22 * point3d.z + matrix4d.m23;
        double d4 = 1.0 / (matrix4d.m30 * point3d.x + matrix4d.m31 * point3d.y + matrix4d.m32 * point3d.z + matrix4d.m33);
        point3d.x = d * d4;
        point3d.y = d2 * d4;
        point3d.z = d3 * d4;
    }

    private static double randomVecComp(Random random) {
        return random.nextDouble() * 2.0 - 1.0;
    }

    public static Vector3d newRandomVector(Random random) {
        Vector3d vector3d = new Vector3d(Util3D.randomVecComp(random), Util3D.randomVecComp(random), Util3D.randomVecComp(random));
        vector3d.normalize();
        return vector3d;
    }

    public static double simplePolygonArea(List<Point3d> list, boolean bl, Vector3d vector3d) {
        Vector3d vector3d2 = Util3D.simplePolygonCross(list);
        if (vector3d2 == null) {
            return 0.0;
        }
        double d = 0.5 * vector3d2.length();
        if (vector3d != null) {
            if (bl && vector3d2.dot(vector3d) < 0.0) {
                d = -d;
            } else if (!bl && vector3d2.dot(vector3d) >= 0.0) {
                d = -d;
            }
        }
        return d;
    }

    public static double simplePolygonArea(List<Point3d> list) {
        return Util3D.simplePolygonArea(list, true, null);
    }

    public static Vector3d simplePolygonNormal(List<Point3d> list, boolean bl) {
        return Util3D.simplePolygonNormal(list, bl, 0.0);
    }

    public static Vector3d simplePolygonNormal(List<Point3d> list, boolean bl, double d) {
        Vector3d vector3d = Util3D.simplePolygonCross(list);
        if (vector3d == null || theUtil.eq0(vector3d.lengthSquared(), d * d)) {
            return null;
        }
        vector3d.normalize();
        if (!bl) {
            vector3d.negate();
        }
        return vector3d;
    }

    public static Plane3d simplePolygonPlane(List<Point3d> list, boolean bl) {
        return Util3D.simplePolygonPlane(list, bl, 0.0);
    }

    public static Plane3d simplePolygonPlane(List<Point3d> list, boolean bl, double d) {
        Vector3d vector3d = Util3D.simplePolygonNormal(list, bl, d);
        if (vector3d == null) {
            return null;
        }
        return new Plane3d(vector3d, list.get(0));
    }

    private static Vector3d simplePolygonCross(List<Point3d> list) {
        if (list.size() < 3) {
            return null;
        }
        Point3d point3d = list.get(0);
        int n = point3d.equals(list.get(list.size() - 1)) ? list.size() - 1 : list.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Point3d point3d2 = list.get(1);
        double d4 = point3d2.x - point3d.x;
        double d5 = point3d2.y - point3d.y;
        double d6 = point3d2.z - point3d.z;
        for (int i = 2; i < n; ++i) {
            Point3d point3d3 = list.get(i);
            double d7 = point3d3.x - point3d.x;
            double d8 = point3d3.y - point3d.y;
            double d9 = point3d3.z - point3d.z;
            d += d5 * d9 - d8 * d6;
            d2 += d6 * d7 - d9 * d4;
            d3 += d4 * d8 - d7 * d5;
            d4 = d7;
            d5 = d8;
            d6 = d9;
        }
        return new Vector3d(d, d2, d3);
    }

    public static Point3d simplePolygonCentroid(Point3d ... point3dArray) {
        double d = Util3D.simplePolygonArea(Arrays.asList(point3dArray));
        if (d == 0.0) {
            return null;
        }
        assert (point3dArray.length >= 3);
        Point3d point3d = point3dArray[0];
        int n = point3d.equals(point3dArray[point3dArray.length - 1]) ? point3dArray.length - 1 : point3dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Vector3d vector3d = Util3D.vector(point3d, point3dArray[1]);
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        for (int i = 2; i < n; ++i) {
            Point3d point3d2 = point3dArray[i];
            vector3d2.sub(point3d2, point3d);
            vector3d3.cross(vector3d, vector3d2);
            double d5 = vector3d3.length();
            d2 += (vector3d.x + vector3d2.x) * d5;
            d3 += (vector3d.y + vector3d2.y) * d5;
            d4 += (vector3d.z + vector3d2.z) * d5;
            vector3d.set(vector3d2);
        }
        double d6 = 1.0 / (6.0 * d);
        return new Point3d(point3d.x + d6 * d2, point3d.y + d6 * d3, point3d.z + d6 * d4);
    }

    private static Plane3d getCoplanarBasisPlane(double d, Point3d ... point3dArray) {
        Point3d[] point3dArray2;
        int n;
        Point3d point3d = point3dArray[0];
        Point3d[] point3dArray3 = null;
        for (n = 1; n < point3dArray.length; ++n) {
            point3dArray2 = point3dArray[n];
            if (point3dArray2.epsilonEquals(point3d, d)) continue;
            point3dArray3 = point3dArray2;
            break;
        }
        if (point3dArray3 == null) {
            return null;
        }
        point3dArray2 = new Point3d[]{point3d, point3dArray3, null};
        List<Point3d> list = Arrays.asList(point3dArray2);
        Vector3d vector3d = Util3D.vector(point3d, (Point3d)point3dArray3);
        double d2 = d * d;
        ++n;
        while (n < point3dArray.length) {
            Point3d point3d2 = point3dArray[n];
            double d3 = Inter3D.distSqToNearestPtOnLine(point3d, vector3d, point3d2);
            if (d3 > d2) {
                point3dArray2[2] = point3d2;
                Plane3d plane3d = Util3D.simplePolygonPlane(list, true);
                if (plane3d != null) {
                    return plane3d;
                }
            }
            ++n;
        }
        return null;
    }

    public static boolean areCoplanar(double d, Point3d ... point3dArray) {
        if (point3dArray.length < 3) {
            return true;
        }
        Plane3d plane3d = Util3D.getCoplanarBasisPlane(d, point3dArray);
        if (plane3d == null) {
            return false;
        }
        for (Point3d point3d : point3dArray) {
            double d2 = Math.abs(plane3d.distance(point3d));
            if (theUtil.eq0(d2, d)) continue;
            return false;
        }
        return true;
    }

    public static int[] getNonCoplanar(double d, Point3d ... point3dArray) {
        if (point3dArray.length < 3) {
            return new int[0];
        }
        Plane3d plane3d = Util3D.getCoplanarBasisPlane(d, point3dArray);
        if (plane3d == null) {
            int[] nArray = new int[point3dArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            double d2 = Math.abs(plane3d.distance(point3d));
            if (theUtil.eq0(d2, d)) continue;
            arrayList.add(i);
        }
        return theUtil.toIntArray(arrayList);
    }

    public static boolean isConvex(double d, Point3d ... point3dArray) {
        int n;
        if (point3dArray.length < 3) {
            return false;
        }
        double d2 = d * d;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d.sub(point3dArray[1], point3dArray[0]);
        for (n = 1; n < point3dArray.length; ++n) {
            Point3d point3d = point3dArray[n];
            Point3d point3d2 = point3dArray[(n + 1) % point3dArray.length];
            vector3d3.sub(point3d2, point3d);
            vector3d2.cross(vector3d, vector3d3);
            if (vector3d2.lengthSquared() > d2) {
                vector3d.set(vector3d3);
                break;
            }
            if (!(vector3d.dot(vector3d3) < 0.0)) continue;
            return false;
        }
        if (n == point3dArray.length) {
            return false;
        }
        double d3 = 0.0;
        ++n;
        while (n <= point3dArray.length) {
            Point3d point3d = point3dArray[n % point3dArray.length];
            Point3d point3d3 = point3dArray[(n + 1) % point3dArray.length];
            vector3d3.sub(point3d3, point3d);
            vector3d4.cross(vector3d, vector3d3);
            if (vector3d4.dot(vector3d4) > d2) {
                double d4 = vector3d2.dot(vector3d4);
                if (d3 == 0.0) {
                    d3 = d4;
                } else if (d3 < 0.0 && d4 > 0.0 || d3 > 0.0 && d4 < 0.0) {
                    return false;
                }
                vector3d.set(vector3d3);
                vector3d2.set(vector3d4);
            } else if (vector3d.dot(vector3d3) < 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean rectify(Point3d point3d, Point3d point3d2) {
        double d;
        boolean bl = false;
        if (point3d2.x < point3d.x) {
            d = point3d2.x;
            point3d2.x = point3d.x;
            point3d.x = d;
            bl = true;
        }
        if (point3d2.y < point3d.y) {
            d = point3d2.y;
            point3d2.y = point3d.y;
            point3d.y = d;
            bl = true;
        }
        if (point3d2.z < point3d.z) {
            d = point3d2.z;
            point3d2.z = point3d.z;
            point3d.z = d;
            bl = true;
        }
        return bl;
    }

    public static Point3d lerp(Point3d point3d, Point3d point3d2, double d) {
        return new Point3d(theUtil.lerp(point3d.x, point3d2.x, d), theUtil.lerp(point3d.y, point3d2.y, d), theUtil.lerp(point3d.z, point3d2.z, d));
    }

    public static Vector3d slerp(Vector3d vector3d, Vector3d vector3d2, double d) {
        if (vector3d.epsilonEquals(vector3d2, 1.0E-9)) {
            return new Vector3d(vector3d2);
        }
        double d2 = vector3d.angle(vector3d2);
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d3, 0.0);
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4d);
        axisAngle4d = new AxisAngle4d(vector3d3, d2);
        Quat4d quat4d2 = new Quat4d();
        quat4d2.set(axisAngle4d);
        quat4d.interpolate(quat4d2, d);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(quat4d);
        return Util3D.xform(matrix4d, vector3d);
    }

    public static Point3d[] deleteDupPoints(double d, boolean bl, Point3d ... point3dArray) {
        int n;
        int n2;
        if (point3dArray.length == 0) {
            return point3dArray;
        }
        double d2 = d * d;
        BitSet bitSet = null;
        if (bl) {
            n2 = point3dArray.length - 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        Point3d point3d = point3dArray[n2];
        for (int i = n; i < point3dArray.length; ++i) {
            Point3d point3d2 = point3dArray[i];
            if (point3d.distanceSquared(point3d2) <= d2) {
                if (bitSet == null) {
                    bitSet = new BitSet(point3dArray.length);
                    bitSet.set(0, point3dArray.length);
                }
                bitSet.clear(i);
                continue;
            }
            point3d = point3d2;
        }
        if (bitSet == null) {
            return point3dArray;
        }
        Point3d[] point3dArray2 = new Point3d[bitSet.cardinality()];
        int n3 = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            if (!bitSet.get(i)) continue;
            point3dArray2[n3++] = point3dArray[i];
        }
        return point3dArray2;
    }

    public static <T extends Tuple3d> T rotate(Quat4d quat4d, T t) {
        Tuple3d tuple3d = (Tuple3d)t.clone();
        Util3D.rotateEq(quat4d, tuple3d);
        return (T)tuple3d;
    }

    public static Quat4d rotateEq(Quat4d quat4d, Tuple3d tuple3d) {
        double d = -quat4d.x * tuple3d.x - quat4d.y * tuple3d.y - quat4d.z * tuple3d.z;
        double d2 = quat4d.w * tuple3d.x + quat4d.y * tuple3d.z - quat4d.z * tuple3d.y;
        double d3 = quat4d.w * tuple3d.y - quat4d.x * tuple3d.z + quat4d.z * tuple3d.x;
        double d4 = quat4d.w * tuple3d.z + quat4d.x * tuple3d.y - quat4d.y * tuple3d.x;
        tuple3d.x = -d * quat4d.x + d2 * quat4d.w - d3 * quat4d.z + d4 * quat4d.y;
        tuple3d.y = -d * quat4d.y + d2 * quat4d.z + d3 * quat4d.w - d4 * quat4d.x;
        tuple3d.z = -d * quat4d.z - d2 * quat4d.y + d3 * quat4d.x + d4 * quat4d.w;
        return quat4d;
    }

    public static AxisAngle4d shortestArcAA(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        Vector3d vector3d4;
        double d2;
        Vector3d vector3d5 = Util3D.cross(vector3d, vector3d2);
        double d3 = Util3D.safeNormalize(vector3d5, d);
        if (d3 == 0.0) {
            if (vector3d.epsilonEquals(vector3d2, d)) {
                return new AxisAngle4d(vector3d3, 0.0);
            }
            d2 = Math.PI;
            vector3d4 = vector3d3;
        } else {
            vector3d4 = vector3d5;
            d2 = Math.asin(d3);
        }
        return new AxisAngle4d(vector3d4, d2);
    }

    public static Matrix3d toMatrix3(double d, double d2, double d3, double d4) {
        return Util3D.toMatrix3(new AxisAngle4d(d, d2, d3, d4));
    }

    public static Matrix3d toMatrix3(AxisAngle4d axisAngle4d) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        return matrix3d;
    }

    public static Quat4d toQuat(AxisAngle4d axisAngle4d) {
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4d);
        return quat4d;
    }

    public static Quat4d toQuat(double d, double d2, double d3, double d4) {
        return Util3D.toQuat(new AxisAngle4d(d, d2, d3, d4));
    }

    public static Quat4d concatenate(Quat4d quat4d, Quat4d quat4d2) {
        return new Quat4d(quat4d.w * quat4d2.x + quat4d.x * quat4d2.w + quat4d.y * quat4d2.z - quat4d.z * quat4d2.y, quat4d.w * quat4d2.y - quat4d.x * quat4d2.z + quat4d.y * quat4d2.w + quat4d.z * quat4d2.x, quat4d.w * quat4d2.z + quat4d.x * quat4d2.y - quat4d.y * quat4d2.x + quat4d.z * quat4d2.w, quat4d.w * quat4d2.w - quat4d.x * quat4d2.x - quat4d.y * quat4d2.y - quat4d.z * quat4d2.z);
    }

    public static Point3d getRandomPointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Random random) {
        double d = random.nextDouble();
        double d2 = random.nextDouble();
        double d3 = Math.sqrt(d);
        double d4 = 1.0 - d3;
        double d5 = d3 * (1.0 - d2);
        double d6 = d3 * d2;
        double d7 = d4 * point3d.x + d5 * point3d2.x + d6 * point3d3.x;
        double d8 = d4 * point3d.y + d5 * point3d2.y + d6 * point3d3.y;
        double d9 = d4 * point3d.z + d5 * point3d2.z + d6 * point3d3.z;
        return new Point3d(d7, d8, d9);
    }
}

