/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;

public class TrimmedCurve3D
implements IParametric3D,
Serializable {
    static final long serialVersionUID = 1L;
    private final IParametric3D d_baseCurve;
    private final double d_t1;
    private final double d_t2;

    public TrimmedCurve3D(IParametric3D iParametric3D, double d, double d2) {
        this.d_baseCurve = iParametric3D;
        this.d_t1 = d;
        this.d_t2 = d2;
    }

    @Override
    public boolean isLinear() {
        return this.d_baseCurve.isLinear();
    }

    public IParametric3D getBaseCurve() {
        return this.d_baseCurve;
    }

    private double baseT(double d) {
        return d * (this.d_t2 - this.d_t1) + this.d_t1;
    }

    private double localT(double d) {
        return (d - this.d_t1) / (this.d_t2 - this.d_t1);
    }

    @Override
    public Point3d get(double d) {
        return this.d_baseCurve.get(this.baseT(d));
    }

    @Override
    public double getClosestT(Point3d point3d) {
        double d = this.d_baseCurve.getClosestT(point3d);
        double d2 = this.localT(d);
        return Util.clampT(d2, 0.0, 1.0);
    }

    @Override
    public double[] getIsects(Plane3d plane3d, double d) {
        double[] dArray = this.d_baseCurve.getIsects(plane3d, d);
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        for (double d2 : dArray) {
            double d3 = this.localT(d2);
            if (Double.isNaN(d3 = Util.clampTIfValid(d3, 0.0, 1.0, d))) continue;
            dArray2[n++] = d3;
        }
        if (dArray2.length != n) {
            double[] dArray3 = new double[n];
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray2[i];
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    @Override
    public double length() {
        double d = this.d_baseCurve.length();
        return d * Math.abs(this.d_t2 - this.d_t1);
    }

    @Override
    public Vector3d getTangent(double d) {
        Vector3d vector3d = this.d_baseCurve.getTangent(this.baseT(d));
        if (this.d_t2 < this.d_t1) {
            vector3d.negate();
        }
        return vector3d;
    }

    @Override
    public IParametric2D projectToPlane(Plane3d plane3d, Matrix4d matrix4d) {
        return this.d_baseCurve.projectToPlane(plane3d, matrix4d).subsegment(this.d_t1, this.d_t2);
    }

    @Override
    public IParametric3D transform(Matrix4d matrix4d) {
        return new TrimmedCurve3D(this.d_baseCurve.transform(matrix4d), this.d_t1, this.d_t2);
    }

    @Override
    public IParametric2D transform2D(Matrix4d matrix4d) {
        return this.d_baseCurve.transform2D(matrix4d).subsegment(this.d_t1, this.d_t2);
    }

    @Override
    public IParametric3D reverse() {
        return new TrimmedCurve3D(this.d_baseCurve, this.d_t2, this.d_t1);
    }

    @Override
    public IParametric3D trim(double d, double d2) {
        if (d == 0.0 && d2 == 1.0) {
            return this;
        }
        if (d2 == 0.0 && d == 0.0) {
            return this.reverse();
        }
        double d3 = this.d_t2 - this.d_t1;
        double d4 = d * d3 + this.d_t1;
        double d5 = d2 * d3 + this.d_t1;
        return new TrimmedCurve3D(this.d_baseCurve, d4, d5);
    }

    public String toString() {
        return "TrimmedCurve: " + this.get(0.0) + " -> " + this.get(1.0);
    }
}

