/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;

public class TriSurface {
    public List<Tri> tris = new ArrayList<Tri>();
    public double totalWeight = 0.0;

    public boolean addTri(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        return this.addTri(new Tri(point3d, point3d2, point3d3));
    }

    public boolean addTri(Tri tri) {
        if (tri.weight == 0.0) {
            return false;
        }
        this.tris.add(tri);
        this.totalWeight += tri.weight;
        return true;
    }

    public boolean addTris(Collection<Tri> collection) {
        boolean bl = false;
        for (Tri tri : collection) {
            bl |= this.addTri(tri);
        }
        return bl;
    }

    public boolean addTris(Point3d[] point3dArray, int[] nArray) {
        boolean bl = false;
        int n = 0;
        while (n < nArray.length) {
            Point3d point3d = point3dArray[nArray[n++]];
            Point3d point3d2 = point3dArray[nArray[n++]];
            Point3d point3d3 = point3dArray[nArray[n++]];
            bl |= this.addTri(point3d, point3d2, point3d3);
        }
        return bl;
    }

    public void addTris(TriSurface triSurface) {
        this.tris.addAll(triSurface.tris);
        this.totalWeight += triSurface.totalWeight;
    }

    public boolean isEmpty() {
        return this.tris.isEmpty();
    }

    public Supplier<Point3d> getPointGenerator(Random random) {
        if (this.tris.isEmpty()) {
            return () -> null;
        }
        if (this.tris.size() == 1) {
            Tri tri = this.tris.get(0);
            return () -> Util3D.getRandomPointInTri(tri.p1, tri.p2, tri.p3, random);
        }
        double[] dArray = new double[this.tris.size()];
        double d = 0.0;
        for (int i = 0; i < this.tris.size(); ++i) {
            Tri tri = this.tris.get(i);
            dArray[i] = d;
            d += tri.weight / this.totalWeight;
        }
        return () -> {
            double d = random.nextDouble();
            int n = Arrays.binarySearch(dArray, d);
            if (n < 0) {
                n = -2 - n;
            }
            Tri tri = this.tris.get(n);
            return Util3D.getRandomPointInTri(tri.p1, tri.p2, tri.p3, random);
        };
    }

    public static class Tri {
        private final Point3d p1;
        private final Point3d p2;
        private final Point3d p3;
        private final double weight;

        public Tri(Point3d point3d, Point3d point3d2, Point3d point3d3) {
            this(point3d, point3d2, point3d3, Util3D.simplePolygonArea(Arrays.asList(point3d, point3d2, point3d3)));
        }

        public Tri(Point3d point3d, Point3d point3d2, Point3d point3d3, double d) {
            this.p1 = point3d;
            this.p2 = point3d2;
            this.p3 = point3d3;
            this.weight = d;
        }

        public boolean isEmpty() {
            return this.weight != 0.0;
        }
    }
}

