/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;

public class TriInterpolator3d
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Point3d A;
    public final Point2d A2d;
    public final Point2d B2d;
    public final Point2d C2d;
    public final Matrix3d rot;

    public TriInterpolator3d(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        this.A = point3d;
        Vector3d vector3d = new Vector3d(1.0, 0.0, 0.0);
        Vector3d vector3d2 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 1.0);
        Point3d point3d4 = new Point3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        Point3d point3d5 = new Point3d(point3d3.x - point3d.x, point3d3.y - point3d.y, point3d3.z - point3d.z);
        Vector3d vector3d4 = new Vector3d(point3d4);
        Vector3d vector3d5 = Util3D.cross(vector3d4, new Vector3d(point3d5));
        Vector3d vector3d6 = Util3D.cross(vector3d5, vector3d4);
        vector3d4.normalize();
        vector3d6.normalize();
        vector3d5.normalize();
        this.rot = new Matrix3d(vector3d.dot(vector3d4), vector3d2.dot(vector3d4), vector3d3.dot(vector3d4), vector3d.dot(vector3d6), vector3d2.dot(vector3d6), vector3d3.dot(vector3d6), vector3d.dot(vector3d5), vector3d2.dot(vector3d5), vector3d3.dot(vector3d5));
        this.rot.transform(point3d4);
        this.rot.transform(point3d5);
        this.A2d = new Point2d(0.0, 0.0);
        this.B2d = new Point2d(point3d4.x, point3d4.y);
        this.C2d = new Point2d(point3d5.x, point3d5.y);
    }

    public double[] getParams(Point3d point3d) {
        Vector3d vector3d = Util3D.vector(this.A, point3d);
        this.rot.transform(vector3d);
        Point2d point2d = new Point2d(vector3d.x, vector3d.y);
        return Util2D.getInterpolateParams(this.A2d, this.B2d, this.C2d, point2d);
    }

    public double interpolate(double[] dArray, double d, double d2, double d3) {
        return Util2D.interpolate(d, d2, d3, dArray);
    }

    public double interpolate(Point3d point3d, double d, double d2, double d3) {
        if (d == d2 && d == d3) {
            return d;
        }
        double[] dArray = this.getParams(point3d);
        return this.interpolate(dArray, d, d2, d3);
    }
}

