/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public interface Spline3D
extends IParametric3D {

    public static class Quadratic
    extends Cubic
    implements Spline3D {
        static final long serialVersionUID = 1L;

        public Quadratic(Point3d point3d, Point3d point3d2, Point3d point3d3) {
            super(point3d, point3d2, point3d2, point3d3, 0.0, 0.0, 0.0, point3d3.x - 2.0 * point3d2.x + point3d.x, point3d3.y - 2.0 * point3d2.y + point3d.y, point3d3.z - 2.0 * point3d2.z + point3d.z, 2.0 * point3d2.x - 2.0 * point3d.x, 2.0 * point3d2.y - 2.0 * point3d.y, 2.0 * point3d2.z - 2.0 * point3d.z, point3d.x, point3d.y, point3d.z);
        }

        @Override
        public IParametric2D projectToPlane(Plane3d plane3d, Matrix4d matrix4d) {
            return new Spline2D.Quadratic(Quadratic.project(this.getP1(), plane3d, matrix4d), Quadratic.project(this.getC1(), plane3d, matrix4d), Quadratic.project(this.getP2(), plane3d, matrix4d));
        }

        @Override
        public IParametric3D transform(Matrix4d matrix4d) {
            return new Quadratic(Util3D.xform(matrix4d, this.getP1()), Util3D.xform(matrix4d, this.getC1()), Util3D.xform(matrix4d, this.getP2()));
        }

        @Override
        public IParametric2D transform2D(Matrix4d matrix4d) {
            return new Spline2D.Quadratic(Quadratic.xform2d(matrix4d, this.getP1()), Quadratic.xform2d(matrix4d, this.getC1()), Quadratic.xform2d(matrix4d, this.getP2()));
        }

        @Override
        public IParametric3D reverse() {
            return new Quadratic(this.getP2(), this.getC1(), this.getP1());
        }
    }

    public static class Cubic
    implements Spline3D,
    Serializable {
        static final long serialVersionUID = 1L;
        private final Point3d p1;
        private final Point3d c1;
        private final Point3d c2;
        private final Point3d p2;
        private final double ax;
        private final double bx;
        private final double cx;
        private final double dx;
        private final double ay;
        private final double by;
        private final double cy;
        private final double dy;
        private final double az;
        private final double bz;
        private final double cz;
        private final double dz;

        public Cubic(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
            this(point3d, point3d2, point3d3, point3d4, point3d4.x - 3.0 * point3d3.x + 3.0 * point3d2.x - point3d.x, point3d4.y - 3.0 * point3d3.y + 3.0 * point3d2.y - point3d.y, point3d4.z - 3.0 * point3d3.z + 3.0 * point3d2.z - point3d.z, 3.0 * point3d3.x - 6.0 * point3d2.x + 3.0 * point3d.x, 3.0 * point3d3.y - 6.0 * point3d2.y + 3.0 * point3d.y, 3.0 * point3d3.z - 6.0 * point3d2.z + 3.0 * point3d.z, 3.0 * point3d2.x - 3.0 * point3d.x, 3.0 * point3d2.y - 3.0 * point3d.y, 3.0 * point3d2.z - 3.0 * point3d.z, point3d.x, point3d.y, point3d.z);
        }

        protected Cubic(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
            this.p1 = point3d;
            this.c1 = point3d2;
            this.c2 = point3d3;
            this.p2 = point3d4;
            this.ax = d;
            this.ay = d2;
            this.az = d3;
            this.bx = d4;
            this.by = d5;
            this.bz = d6;
            this.cx = d7;
            this.cy = d8;
            this.cz = d9;
            this.dx = d10;
            this.dy = d11;
            this.dz = d12;
        }

        @Override
        public boolean isLinear() {
            return false;
        }

        @Override
        public IParametric3D reverse() {
            return new Cubic(this.p2, this.c2, this.c1, this.p1);
        }

        @Override
        public Point3d get(double d) {
            if (d == 1.0) {
                return new Point3d(this.p2);
            }
            double d2 = d * d;
            double d3 = d2 * d;
            return new Point3d(this.ax * d3 + this.bx * d2 + this.cx * d + this.dx, this.ay * d3 + this.by * d2 + this.cy * d + this.dy, this.az * d3 + this.bz * d2 + this.cz * d + this.dz);
        }

        @Override
        public Vector3d getTangent(double d) {
            double d2 = d * d;
            return new Vector3d(3.0 * this.ax * d2 + 2.0 * this.bx * d + this.cx, 3.0 * this.ay * d2 + 2.0 * this.by * d + this.cy, 3.0 * this.az * d2 + 2.0 * this.bz * d + this.cz);
        }

        public Point3d getP1() {
            return this.p1;
        }

        public Point3d getP2() {
            return this.p2;
        }

        public Point3d getC1() {
            return this.c1;
        }

        public Point3d getC2() {
            return this.c2;
        }

        @Override
        public double length() {
            return this.p1.distance(this.c1) + this.c1.distance(this.c2) + this.c2.distance(this.p2);
        }

        @Override
        public double getClosestT(Point3d point3d) {
            return Double.NaN;
        }

        @Override
        public double[] getIsects(Plane3d plane3d, double d) {
            double d2 = plane3d.x * this.ax + plane3d.y * this.ay + plane3d.z * this.az;
            double d3 = plane3d.x * this.bx + plane3d.y * this.by + plane3d.z * this.bz;
            double d4 = plane3d.x * this.cx + plane3d.y * this.cy + plane3d.z * this.cz;
            double d5 = plane3d.w;
            double[] dArray = theMath.solveCubic(d2, d3, d4, d5);
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                double d6 = Util.clampTIfValid(dArray[i], 0.0, 1.0, d);
                if (Double.isNaN(d6)) continue;
                arrayList.add(d6);
            }
            return theUtil.toDoubleArray(arrayList);
        }

        protected static Point2d project(Point3d point3d, Plane3d plane3d, Matrix4d matrix4d) {
            Point3d point3d2 = plane3d.projectOntoPlane(point3d);
            matrix4d.transform(point3d2);
            return new Point2d(point3d2.x, point3d2.y);
        }

        @Override
        public IParametric2D projectToPlane(Plane3d plane3d, Matrix4d matrix4d) {
            return new Spline2D.Cubic(Cubic.project(this.p1, plane3d, matrix4d), Cubic.project(this.c1, plane3d, matrix4d), Cubic.project(this.c2, plane3d, matrix4d), Cubic.project(this.p2, plane3d, matrix4d));
        }

        @Override
        public IParametric3D transform(Matrix4d matrix4d) {
            return new Cubic(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.c1), Util3D.xform(matrix4d, this.c2), Util3D.xform(matrix4d, this.p2));
        }

        @Override
        public IParametric2D transform2D(Matrix4d matrix4d) {
            return new Spline2D.Cubic(Cubic.xform2d(matrix4d, this.p1), Cubic.xform2d(matrix4d, this.c1), Cubic.xform2d(matrix4d, this.c2), Cubic.xform2d(matrix4d, this.p2));
        }

        protected static Point2d xform2d(Matrix4d matrix4d, Point3d point3d) {
            Point3d point3d2 = Util3D.xform(matrix4d, point3d);
            return new Point2d(point3d2.x, point3d2.y);
        }
    }
}

