/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.SerShape;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Spline3D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.util.theUtil;

public class ShapeUtil {
    public static final AffineTransform IDENTITY = new AffineTransform();

    public static AABox getBounds(Shape shape, Matrix4d matrix4d) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        AABox aABox = new AABox();
        aABox.add(ShapeUtil.xform(matrix4d, rectangle2D.getMinX(), rectangle2D.getMinY()), ShapeUtil.xform(matrix4d, rectangle2D.getMinX(), rectangle2D.getMaxY()), ShapeUtil.xform(matrix4d, rectangle2D.getMaxX(), rectangle2D.getMinY()), ShapeUtil.xform(matrix4d, rectangle2D.getMaxX(), rectangle2D.getMaxY()));
        return aABox;
    }

    public static boolean isZAligned(Matrix4d matrix4d) {
        return matrix4d.m20 == 0.0 && matrix4d.m21 == 0.0 && matrix4d.m22 == 1.0;
    }

    public static double getZLoc(Matrix4d matrix4d) {
        assert (ShapeUtil.isZAligned(matrix4d));
        return matrix4d.m23;
    }

    public static void setZLoc(Matrix4d matrix4d, double d) {
        matrix4d.setRow(2, 0.0, 0.0, 1.0, d);
    }

    public static Point3d xform(Matrix4d matrix4d, double d, double d2) {
        Point3d point3d = new Point3d(d, d2, 0.0);
        matrix4d.transform(point3d);
        return point3d;
    }

    public static Point3d xform(Matrix4d matrix4d, Point2d point2d) {
        Point3d point3d = new Point3d(point2d.x, point2d.y, 0.0);
        matrix4d.transform(point3d);
        return point3d;
    }

    public static Vector3d xform(Matrix4d matrix4d, Vector2d vector2d) {
        Vector3d vector3d = new Vector3d(vector2d.x, vector2d.y, 0.0);
        matrix4d.transform(vector3d);
        return vector3d;
    }

    public static Vector3d invXform(Matrix4d matrix4d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        matrix4d.transform(vector3d2);
        return vector3d2;
    }

    public static Point3d invXform(Matrix4d matrix4d, Point3d point3d) {
        Point3d point3d2 = new Point3d(point3d);
        matrix4d.transform(point3d2);
        return point3d2;
    }

    public static Point2d invXform2d(Matrix4d matrix4d, Point3d point3d) {
        Point3d point3d2 = new Point3d(point3d);
        matrix4d.transform(point3d2);
        return new Point2d(point3d2.x, point3d2.y);
    }

    public static Point3d extract3d(Matrix4d matrix4d, double[] dArray, int n) {
        return ShapeUtil.xform(matrix4d, dArray[n], dArray[n + 1]);
    }

    public static Point2d extract2d(double[] dArray, int n) {
        return new Point2d(dArray[n], dArray[n + 1]);
    }

    public static CubicCurve2D subcurve(CubicCurve2D cubicCurve2D, double d, double d2) {
        double[] dArray = Util.clampTRange(d, d2);
        d = dArray[0];
        d2 = dArray[1];
        if (d == 0.0 && d2 == 1.0) {
            return (CubicCurve2D)cubicCurve2D.clone();
        }
        if (d == 0.0) {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            ShapeUtil.split(cubicCurve2D, double_, null, d2);
            return double_;
        }
        if (d2 == 1.0) {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            ShapeUtil.split(cubicCurve2D, null, double_, d);
            return double_;
        }
        CubicCurve2D.Double double_ = new CubicCurve2D.Double();
        ShapeUtil.split(cubicCurve2D, double_, null, d2);
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        ShapeUtil.split(double_, null, double_2, d / d2);
        return double_2;
    }

    public static void split(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, CubicCurve2D cubicCurve2D3, double d) {
        if (d <= 0.0) {
            if (cubicCurve2D2 != null) {
                Point2D point2D = cubicCurve2D.getP1();
                cubicCurve2D2.setCurve(point2D, point2D, point2D, point2D);
            }
            if (cubicCurve2D3 != null) {
                cubicCurve2D3.setCurve(cubicCurve2D);
            }
            return;
        }
        if (d >= 1.0) {
            Point2D point2D = cubicCurve2D.getP2();
            if (cubicCurve2D2 != null) {
                cubicCurve2D2.setCurve(point2D, point2D, point2D, point2D);
            }
            if (cubicCurve2D3 != null) {
                cubicCurve2D3.setCurve(point2D, point2D, point2D, point2D);
            }
            return;
        }
        double d2 = cubicCurve2D.getX1();
        double d3 = cubicCurve2D.getY1();
        double d4 = cubicCurve2D.getCtrlX1();
        double d5 = cubicCurve2D.getCtrlY1();
        double d6 = cubicCurve2D.getCtrlX2();
        double d7 = cubicCurve2D.getCtrlY2();
        double d8 = cubicCurve2D.getX2();
        double d9 = cubicCurve2D.getY2();
        double d10 = d4 + (d6 - d4) * d;
        double d11 = d5 + (d7 - d5) * d;
        d4 = d2 + (d4 - d2) * d;
        d5 = d3 + (d5 - d3) * d;
        d6 += (d8 - d6) * d;
        d7 += (d9 - d7) * d;
        double d12 = d4 + (d10 - d4) * d;
        double d13 = d5 + (d11 - d5) * d;
        double d14 = d10 + (d6 - d10) * d;
        double d15 = d11 + (d7 - d11) * d;
        d10 = d12 + (d14 - d12) * d;
        d11 = d13 + (d15 - d13) * d;
        if (cubicCurve2D2 != null) {
            cubicCurve2D2.setCurve(d2, d3, d4, d5, d12, d13, d10, d11);
        }
        if (cubicCurve2D3 != null) {
            cubicCurve2D3.setCurve(d10, d11, d14, d15, d6, d7, d8, d9);
        }
    }

    public static QuadCurve2D subcurve(QuadCurve2D quadCurve2D, double d, double d2) {
        double[] dArray = Util.clampTRange(d, d2);
        d = dArray[0];
        d2 = dArray[1];
        if (d == 0.0 && d2 == 1.0) {
            return (QuadCurve2D)quadCurve2D.clone();
        }
        if (d == 0.0) {
            QuadCurve2D.Double double_ = new QuadCurve2D.Double();
            ShapeUtil.split(quadCurve2D, double_, null, d2);
            return double_;
        }
        if (d2 == 1.0) {
            QuadCurve2D.Double double_ = new QuadCurve2D.Double();
            ShapeUtil.split(quadCurve2D, null, double_, d);
            return double_;
        }
        QuadCurve2D.Double double_ = new QuadCurve2D.Double();
        ShapeUtil.split(quadCurve2D, double_, null, d2);
        QuadCurve2D.Double double_2 = new QuadCurve2D.Double();
        ShapeUtil.split(double_, null, double_2, d / d2);
        return double_2;
    }

    public static void split(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3, double d) {
        if (d <= 0.0) {
            if (quadCurve2D2 != null) {
                Point2D point2D = quadCurve2D.getP1();
                quadCurve2D2.setCurve(point2D, point2D, point2D);
            }
            if (quadCurve2D3 != null) {
                quadCurve2D3.setCurve(quadCurve2D);
            }
            return;
        }
        if (d >= 1.0) {
            Point2D point2D = quadCurve2D.getP2();
            if (quadCurve2D2 != null) {
                quadCurve2D2.setCurve(point2D, point2D, point2D);
            }
            if (quadCurve2D3 != null) {
                quadCurve2D3.setCurve(point2D, point2D, point2D);
            }
            return;
        }
        double d2 = quadCurve2D.getX1();
        double d3 = quadCurve2D.getY1();
        double d4 = quadCurve2D.getCtrlX();
        double d5 = quadCurve2D.getCtrlY();
        double d6 = quadCurve2D.getX2();
        double d7 = quadCurve2D.getY2();
        double d8 = d2 + (d4 - d2) * d;
        double d9 = d3 + (d5 - d3) * d;
        double d10 = d4 + (d6 - d4) * d;
        double d11 = d5 + (d7 - d5) * d;
        d4 = d8 + (d10 - d8) * d;
        d5 = d9 + (d11 - d9) * d;
        if (quadCurve2D2 != null) {
            quadCurve2D2.setCurve(d2, d3, d8, d9, d4, d5);
        }
        if (quadCurve2D3 != null) {
            quadCurve2D3.setCurve(d4, d5, d10, d11, d6, d7);
        }
    }

    public static double getFlatness(Shape shape, double d) {
        return ShapeUtil.getFlatness(shape.getBounds2D(), d);
    }

    public static double getFlatness(Rectangle2D rectangle2D, double d) {
        double d2 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
        double d3 = d2 * d;
        return d3;
    }

    public static PathIterator getPathIterator(Shape shape, AffineTransform affineTransform, double d) {
        if (d > 0.0) {
            double d2 = ShapeUtil.getFlatness(shape, d);
            return shape.getPathIterator(affineTransform, d2);
        }
        return shape.getPathIterator(affineTransform);
    }

    public static <T extends IParametric2D> Collection<T> getBoundary2D(Shape shape, AffineTransform affineTransform, double d, Class<T> clazz) {
        return theUtil.filter(ShapeUtil.getBoundary2D(shape, affineTransform, d), clazz);
    }

    public static List<List<IParametric2D>> getBoundaries2D(Shape shape, AffineTransform affineTransform, double d) {
        ArrayList<List<IParametric2D>> arrayList = new ArrayList<List<IParametric2D>>();
        ArrayList<IParametric2D> arrayList2 = new ArrayList<IParametric2D>();
        double[] dArray = new double[6];
        Point2d point2d = null;
        Tuple2d tuple2d = null;
        boolean bl = shape instanceof Area;
        PathIterator pathIterator = ShapeUtil.getPathIterator(shape, affineTransform, d);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            IParametric2D iParametric2D = null;
            switch (n) {
                case 0: {
                    point2d = ShapeUtil.extract2d(dArray, 0);
                    tuple2d = point2d;
                    if (arrayList2.isEmpty()) break;
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                    break;
                }
                case 4: {
                    if (tuple2d.equals(point2d)) break;
                    iParametric2D = new LineSeg2D((Point2d)tuple2d, point2d);
                    break;
                }
                case 1: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    iParametric2D = new LineSeg2D((Point2d)tuple2d, point2d2);
                    tuple2d = point2d2;
                    break;
                }
                case 2: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 2);
                    iParametric2D = new Spline2D.Quadratic((Point2d)tuple2d, point2d2, point2d3);
                    tuple2d = point2d3;
                    break;
                }
                case 3: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 2);
                    Point2d point2d4 = ShapeUtil.extract2d(dArray, 4);
                    iParametric2D = new Spline2D.Cubic((Point2d)tuple2d, point2d2, point2d3, point2d4);
                    tuple2d = point2d4;
                    break;
                }
            }
            if (iParametric2D != null) {
                if (bl) {
                    iParametric2D = iParametric2D.reverse();
                }
                arrayList2.add(iParametric2D);
            }
            pathIterator.next();
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static List<IParametric2D> getBoundary2D(Shape shape, AffineTransform affineTransform, double d) {
        ArrayList<IParametric2D> arrayList = new ArrayList<IParametric2D>();
        double[] dArray = new double[6];
        Point2d point2d = null;
        Tuple2d tuple2d = null;
        boolean bl = shape instanceof Area;
        PathIterator pathIterator = ShapeUtil.getPathIterator(shape, affineTransform, d);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            IParametric2D iParametric2D = null;
            switch (n) {
                case 0: {
                    point2d = ShapeUtil.extract2d(dArray, 0);
                    tuple2d = point2d;
                    break;
                }
                case 4: {
                    if (tuple2d.equals(point2d)) break;
                    iParametric2D = new LineSeg2D((Point2d)tuple2d, point2d);
                    break;
                }
                case 1: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    iParametric2D = new LineSeg2D((Point2d)tuple2d, point2d2);
                    tuple2d = point2d2;
                    break;
                }
                case 2: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 2);
                    iParametric2D = new Spline2D.Quadratic((Point2d)tuple2d, point2d2, point2d3);
                    tuple2d = point2d3;
                    break;
                }
                case 3: {
                    Point2d point2d2 = ShapeUtil.extract2d(dArray, 0);
                    Point2d point2d3 = ShapeUtil.extract2d(dArray, 2);
                    Point2d point2d4 = ShapeUtil.extract2d(dArray, 4);
                    iParametric2D = new Spline2D.Cubic((Point2d)tuple2d, point2d2, point2d3, point2d4);
                    tuple2d = point2d4;
                    break;
                }
            }
            if (iParametric2D != null) {
                if (bl) {
                    iParametric2D = iParametric2D.reverse();
                }
                arrayList.add(iParametric2D);
            }
            pathIterator.next();
        }
        return arrayList;
    }

    public static <T extends IParametric3D> Collection<T> getBoundary3D(Shape shape, Matrix4d matrix4d, double d, Class<T> clazz) {
        return theUtil.filter(ShapeUtil.getBoundary3D(shape, matrix4d, d), clazz);
    }

    public static List<IParametric3D> getBoundary3D(Shape shape, Matrix4d matrix4d, double d) {
        ArrayList<IParametric3D> arrayList = new ArrayList<IParametric3D>();
        double[] dArray = new double[6];
        Point3d point3d = null;
        Tuple3d tuple3d = null;
        boolean bl = shape instanceof Area;
        PathIterator pathIterator = ShapeUtil.getPathIterator(shape, null, d);
        while (!pathIterator.isDone()) {
            IParametric3D iParametric3D = null;
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    point3d = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    tuple3d = point3d;
                    break;
                }
                case 4: {
                    if (tuple3d.equals(point3d)) break;
                    iParametric3D = new LineSeg3D((Point3d)tuple3d, point3d);
                    break;
                }
                case 1: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    iParametric3D = new LineSeg3D((Point3d)tuple3d, point3d2);
                    tuple3d = point3d2;
                    break;
                }
                case 2: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    Point3d point3d3 = ShapeUtil.extract3d(matrix4d, dArray, 2);
                    iParametric3D = new Spline3D.Quadratic((Point3d)tuple3d, point3d2, point3d3);
                    tuple3d = point3d3;
                    break;
                }
                case 3: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    Point3d point3d3 = ShapeUtil.extract3d(matrix4d, dArray, 2);
                    Point3d point3d4 = ShapeUtil.extract3d(matrix4d, dArray, 4);
                    iParametric3D = new Spline3D.Cubic((Point3d)tuple3d, point3d2, point3d3, point3d4);
                    tuple3d = point3d4;
                    break;
                }
            }
            if (iParametric3D != null) {
                if (bl) {
                    iParametric3D = iParametric3D.reverse();
                }
                arrayList.add(iParametric3D);
            }
            pathIterator.next();
        }
        return arrayList;
    }

    public static Point3d[] getBoundaryVerts(Shape shape, Matrix4d matrix4d, double d) {
        int n;
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        double[] dArray = new double[6];
        Point3d point3d = null;
        boolean bl = shape instanceof Area;
        Point3d[] point3dArray = ShapeUtil.getPathIterator(shape, null, d);
        while (!point3dArray.isDone()) {
            n = point3dArray.currentSegment(dArray);
            switch (n) {
                case 0: {
                    point3d = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    arrayList.add(point3d);
                    break;
                }
                case 1: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 0);
                    arrayList.add(point3d2);
                    break;
                }
                case 2: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 2);
                    arrayList.add(point3d2);
                    break;
                }
                case 3: {
                    Point3d point3d2 = ShapeUtil.extract3d(matrix4d, dArray, 4);
                    arrayList.add(point3d2);
                    break;
                }
            }
            point3dArray.next();
        }
        point3dArray = new Point3d[arrayList.size()];
        if (bl) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                point3dArray[arrayList.size() - 1 - n] = (Point3d)arrayList.get(n);
            }
        } else {
            arrayList.toArray(point3dArray);
        }
        return point3dArray;
    }

    public static Path2D.Double toPolygon(boolean bl, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        Plane3d plane3d = new Plane3d(bl, point3dArray);
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        return ShapeUtil.toPolygon(matrix4d, point3dArray);
    }

    public static Path2D.Double toPolygon(Matrix4d matrix4d, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        Path2D.Double double_ = ShapeUtil.toPath(matrix4d, point3dArray);
        double_.closePath();
        return double_;
    }

    public static Path2D.Double toPolygon(Point2d ... point2dArray) {
        assert (point2dArray.length >= 3);
        Path2D.Double double_ = ShapeUtil.toPath(point2dArray);
        double_.closePath();
        return double_;
    }

    public static void appendAsSubPath(Path2D.Double double_, List<? extends IParametric2D> list) {
        if (!list.isEmpty()) {
            Point2d point2d = list.get(0).get(0.0);
            double_.moveTo(point2d.x, point2d.y);
            for (IParametric2D iParametric2D : list) {
                iParametric2D.append(double_);
            }
        }
    }

    public static Path2D.Double toPath(List<? extends IParametric2D> list) {
        Path2D.Double double_ = new Path2D.Double();
        ShapeUtil.appendAsSubPath(double_, list);
        return double_;
    }

    public static Path2D.Double toPaths(List<List<? extends IParametric2D>> list) {
        Path2D.Double double_ = new Path2D.Double();
        for (List<? extends IParametric2D> list2 : list) {
            ShapeUtil.appendAsSubPath(double_, list2);
        }
        return double_;
    }

    public static Area reverseBoundary(Area area) {
        return (Area)ShapeUtil.reverseBoundary((Shape)area);
    }

    public static Shape reverseBoundary(Shape shape) {
        List<List<IParametric2D>> list = ShapeUtil.getBoundaries2D(shape, IDENTITY, 0.0);
        ArrayList<List<? extends IParametric2D>> arrayList = new ArrayList<List<? extends IParametric2D>>(list.size());
        for (List<IParametric2D> list2 : list) {
            ArrayList<IParametric2D> arrayList2 = new ArrayList<IParametric2D>(list2.size());
            for (int i = list2.size() - 1; i >= 0; --i) {
                arrayList2.add(list2.get(i).reverse());
            }
            arrayList.add(arrayList2);
        }
        Path2D.Double double_ = ShapeUtil.toPaths(arrayList);
        return shape instanceof Area ? new Area(double_) : double_;
    }

    public static Path2D.Double toPath(Matrix4d matrix4d, Point3d ... point3dArray) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            point2dArray[i] = ShapeUtil.invXform2d(matrix4d, point3dArray[i]);
        }
        return ShapeUtil.toPath(point2dArray);
    }

    public static Path2D.Double toPath(Point2d ... point2dArray) {
        Path2D.Double double_ = new Path2D.Double();
        double_.moveTo(point2dArray[0].x, point2dArray[0].y);
        for (int i = 1; i < point2dArray.length; ++i) {
            Point2d point2d = point2dArray[i];
            double_.lineTo(point2d.x, point2d.y);
        }
        return double_;
    }

    public static void writeShape(ObjectOutputStream objectOutputStream, Shape shape) throws IOException {
        SerShape serShape = new SerShape(shape);
        objectOutputStream.writeObject(serShape);
    }

    public static Shape readShape(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SerShape serShape = (SerShape)objectInputStream.readObject();
        return serShape.getShape();
    }

    public static Arc2D.Double newCircularArc(Point2d point2d, Point2d point2d2, double d) {
        double d2;
        double d3;
        double d4 = Math.abs(d);
        double d5 = (point2d2.x - point2d.x) * 0.5;
        double d6 = (point2d2.y - point2d.y) * 0.5;
        if (d > 0.0) {
            d3 = d6;
            d2 = -d5;
        } else {
            d3 = -d6;
            d2 = d5;
        }
        double d7 = point2d.x + d5;
        double d8 = point2d.y + d6;
        double d9 = Math.sqrt(d5 * d5 + d6 * d6);
        double d10 = d9 * d4;
        double d11 = d4 == 0.0 ? 0.0 : Math.abs(0.5 * (d10 + d9 / d4));
        double d12 = d10 - d11;
        Vector2d vector2d = new Vector2d(d3, d2);
        vector2d.normalize();
        vector2d.scale(d12);
        double d13 = d7 + vector2d.x;
        double d14 = d8 + vector2d.y;
        double d15 = Util2D.sAngle(1.0, 0.0, point2d.x - d13, point2d.y - d14);
        double d16 = Util2D.sAngle(1.0, 0.0, point2d2.x - d13, point2d2.y - d14);
        return ShapeUtil.newCircularArc(d13, d14, d11, d15, d16, d >= 0.0);
    }

    public static Arc2D.Double newCircularArc(double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = d3 + d3;
        return ShapeUtil.newArc(d, d2, d6, d6, d4, d5, bl);
    }

    public static Arc2D.Double newArc(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        d6 = ShapeUtil.adjustAngle2(d5, d6, bl);
        d5 = -Math.toDegrees(d5);
        d6 = -Math.toDegrees(d6);
        return new Arc2D.Double(d - d3 * 0.5, d2 - d4 * 0.5, d3, d4, d5, d6 - d5, 0);
    }

    private static double adjustAngle2(double d, double d2, boolean bl) {
        double d3 = d2 - d;
        if (d < d2 && !bl) {
            d3 -= Math.PI * 2;
        } else if (d > d2 && bl) {
            d3 += Math.PI * 2;
        }
        return d + d3;
    }

    public static Ellipse2D.Double newCircle(double d) {
        double d2 = d + d;
        return ShapeUtil.newEllipse(d2, d2);
    }

    public static Ellipse2D.Double newEllipse(double d, double d2) {
        return new Ellipse2D.Double(-d * 0.5, -d2 * 0.5, d, d2);
    }

    public static class PolyLineBuilder {
        private final Path2D.Double d_path = new Path2D.Double();

        public Path2D.Double getPath() {
            return this.d_path;
        }

        public void moveTo(Point2d point2d) {
            this.getPath().moveTo(point2d.x, point2d.y);
        }

        public void lineTo(Point2d point2d) {
            this.getPath().lineTo(point2d.x, point2d.y);
        }

        public void bulgeTo(Point2d point2d, double d) {
            Path2D.Double double_ = this.getPath();
            Point2D point2D = double_.getCurrentPoint();
            Arc2D.Double double_2 = ShapeUtil.newCircularArc(new Point2d(point2D.getX(), point2D.getY()), point2d, d);
            double_.append(double_2, true);
        }

        public void close() {
            this.getPath().closePath();
        }

        public void clear() {
            this.getPath().reset();
        }
    }
}

