/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SerPathIterator
implements Serializable {
    static final long serialVersionUID = 1L;
    private List<PathSegment> segs;
    private int windRule;

    public SerPathIterator(PathIterator pathIterator) {
        if (pathIterator == null) {
            this.segs = null;
            this.windRule = -1;
            return;
        }
        this.segs = new ArrayList<PathSegment>();
        this.windRule = pathIterator.getWindingRule();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            double[] dArray2 = new double[this.opArgs(n)];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            this.segs.add(new PathSegment(n, dArray2));
            pathIterator.next();
        }
    }

    public List<PathSegment> getSegs() {
        return this.segs;
    }

    public int getWindRule() {
        return this.windRule;
    }

    public void dump(PrintStream printStream) {
        for (PathSegment pathSegment : this.segs) {
            printStream.println(this.op2str(pathSegment.segType) + "  " + Arrays.toString(pathSegment.dcoords));
        }
    }

    private int opArgs(int n) {
        switch (n) {
            case 4: {
                return 0;
            }
            case 3: {
                return 6;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return -1;
    }

    private String op2str(int n) {
        switch (n) {
            case 4: {
                return "SEG_CLOSE";
            }
            case 3: {
                return "SEG_CUBICTO";
            }
            case 1: {
                return "SEG_LINETO";
            }
            case 0: {
                return "SEG_MOVETO";
            }
            case 2: {
                return "SEG_QUADTO";
            }
        }
        return "Invalid function input: op2str(" + n + ")";
    }

    public Path2D.Double toPath() {
        if (this.segs == null) {
            return null;
        }
        Path2D.Double double_ = new Path2D.Double(this.windRule, this.segs.size());
        for (PathSegment pathSegment : this.segs) {
            switch (pathSegment.segType) {
                case 4: {
                    double_.closePath();
                    break;
                }
                case 3: {
                    double_.curveTo(pathSegment.dcoords[0], pathSegment.dcoords[1], pathSegment.dcoords[2], pathSegment.dcoords[3], pathSegment.dcoords[4], pathSegment.dcoords[5]);
                    break;
                }
                case 1: {
                    double_.lineTo(pathSegment.dcoords[0], pathSegment.dcoords[1]);
                    break;
                }
                case 0: {
                    double_.moveTo(pathSegment.dcoords[0], pathSegment.dcoords[1]);
                    break;
                }
                case 2: {
                    double_.quadTo(pathSegment.dcoords[0], pathSegment.dcoords[1], pathSegment.dcoords[2], pathSegment.dcoords[3]);
                }
            }
        }
        return double_;
    }

    public static class PathSegment
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int segType;
        public final float[] coords;
        public double[] dcoords;

        public PathSegment(int n, double[] dArray) {
            this.segType = n;
            this.dcoords = dArray;
            this.coords = null;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.dcoords == null) {
                assert (this.coords != null);
                this.dcoords = new double[this.coords.length];
                for (int i = 0; i < this.coords.length; ++i) {
                    this.dcoords[i] = this.coords[i];
                }
            }
        }

        public int getNumPoints() {
            switch (this.segType) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 0;
                }
            }
            return 0;
        }

        public void getPoint(int n, double[] dArray) {
            assert (n < this.getNumPoints() && dArray.length >= 2);
            int n2 = n * 2;
            dArray[0] = this.dcoords[n2];
            dArray[1] = this.dcoords[n2 + 1];
        }

        public void setPoint(int n, double[] dArray) {
            assert (n < this.getNumPoints() && dArray.length >= 2);
            int n2 = n * 2;
            this.dcoords[n2] = dArray[0];
            this.dcoords[n2 + 1] = dArray[1];
        }
    }
}

