/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point2d;
import thunderheadeng.geometry.Util2D;

public final class RotatingCalipers {
    static final double A90 = 1.5707963267948966;
    static final double A180 = Math.PI;
    static final double A270 = Math.toRadians(270.0);
    static final double A360 = Math.PI * 2;

    public static double getArea(Point2d[] point2dArray) {
        double d = point2dArray[0].x - point2dArray[1].x;
        double d2 = point2dArray[0].y - point2dArray[1].y;
        double d3 = point2dArray[1].x - point2dArray[2].x;
        double d4 = point2dArray[1].y - point2dArray[2].y;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        return d5 * d6;
    }

    public static List<Point2d[]> getAllBoundingRectangles(int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Point2d(nArray[i], nArray2[i]));
        }
        return RotatingCalipers.getAllBoundingRectangles(arrayList);
    }

    public static List<Point2d[]> getAllBoundingRectangles(Collection<Point2d> collection) {
        ArrayList<Point2d[]> arrayList = new ArrayList<Point2d[]>();
        Collection<Point2d> collection2 = Util2D.getConvexHull(collection);
        List<Object> list = collection2 instanceof List ? (List<Object>)collection2 : new ArrayList<Point2d>(collection2);
        Caliper caliper = new Caliper((List<Point2d>)list, RotatingCalipers.getIndex((List<Point2d>)list, Corner.UPPER_RIGHT), 1.5707963267948966);
        Caliper caliper2 = new Caliper((List<Point2d>)list, RotatingCalipers.getIndex((List<Point2d>)list, Corner.UPPER_LEFT), Math.PI);
        Caliper caliper3 = new Caliper((List<Point2d>)list, RotatingCalipers.getIndex((List<Point2d>)list, Corner.LOWER_LEFT), A270);
        Caliper caliper4 = new Caliper((List<Point2d>)list, RotatingCalipers.getIndex((List<Point2d>)list, Corner.LOWER_RIGHT), 0.0);
        while (caliper4.currentAngle < 1.5707963267948966) {
            arrayList.add(new Point2d[]{caliper4.getIntersection(caliper), caliper.getIntersection(caliper2), caliper2.getIntersection(caliper3), caliper3.getIntersection(caliper4)});
            double d = RotatingCalipers.getSmallestTheta(caliper, caliper2, caliper3, caliper4);
            caliper.rotateBy(d);
            caliper2.rotateBy(d);
            caliper3.rotateBy(d);
            caliper4.rotateBy(d);
        }
        return arrayList;
    }

    public static Point2d[] getMinimumBoundingRectangle(int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Point2d(nArray[i], nArray2[i]));
        }
        return RotatingCalipers.getMinimumBoundingRectangle(arrayList);
    }

    public static Point2d[] getMinimumBoundingRectangle(Collection<Point2d> collection) {
        List<Point2d[]> list = RotatingCalipers.getAllBoundingRectangles(collection);
        Point2d[] point2dArray = null;
        double d = 9.223372036854776E18;
        for (Point2d[] point2dArray2 : list) {
            double d2 = RotatingCalipers.getArea(point2dArray2);
            if (point2dArray != null && !(d2 < d)) continue;
            point2dArray = point2dArray2;
            d = d2;
        }
        return point2dArray;
    }

    private static double getSmallestTheta(Caliper caliper, Caliper caliper2, Caliper caliper3, Caliper caliper4) {
        double d = caliper.getDeltaAngleNextPoint();
        double d2 = caliper2.getDeltaAngleNextPoint();
        double d3 = caliper3.getDeltaAngleNextPoint();
        double d4 = caliper4.getDeltaAngleNextPoint();
        if (d <= d2 && d <= d3 && d <= d4) {
            return d;
        }
        if (d2 <= d3 && d2 <= d4) {
            return d2;
        }
        if (d3 <= d4) {
            return d3;
        }
        return d4;
    }

    protected static int getIndex(List<Point2d> list, Corner corner) {
        int n = 0;
        Point2d point2d = list.get(n);
        for (int i = 1; i < list.size(); ++i) {
            Point2d point2d2 = list.get(i);
            boolean bl = false;
            switch (corner) {
                case UPPER_RIGHT: {
                    bl = point2d2.x > point2d.x || point2d2.x == point2d.x && point2d2.y > point2d.y;
                    break;
                }
                case UPPER_LEFT: {
                    bl = point2d2.y > point2d.y || point2d2.y == point2d.y && point2d2.x < point2d.x;
                    break;
                }
                case LOWER_LEFT: {
                    bl = point2d2.x < point2d.x || point2d2.x == point2d.x && point2d2.y < point2d.y;
                    break;
                }
                case LOWER_RIGHT: {
                    boolean bl2 = bl = point2d2.y < point2d.y || point2d2.y == point2d.y && point2d2.x > point2d.x;
                }
            }
            if (!bl) continue;
            n = i;
            point2d = point2d2;
        }
        return n;
    }

    protected static class Caliper {
        static final double SIGMA = 1.0E-11;
        final List<Point2d> convexHull;
        int pointIndex;
        double currentAngle;

        Caliper(List<Point2d> list, int n, double d) {
            this.convexHull = list;
            this.pointIndex = n;
            this.currentAngle = d;
        }

        double getAngleNextPoint() {
            Point2d point2d = this.convexHull.get(this.pointIndex);
            Point2d point2d2 = this.convexHull.get((this.pointIndex + 1) % this.convexHull.size());
            double d = point2d2.y - point2d.y;
            double d2 = point2d2.x - point2d.x;
            double d3 = Math.atan2(d, d2);
            return d3 < 0.0 ? Math.PI * 2 + d3 : d3;
        }

        double getConstant() {
            Point2d point2d = this.convexHull.get(this.pointIndex);
            return point2d.y - this.getSlope() * point2d.x;
        }

        double getDeltaAngleNextPoint() {
            double d = this.getAngleNextPoint();
            d = d < 0.0 ? Math.PI * 2 + d - this.currentAngle : d - this.currentAngle;
            return d < 0.0 ? Math.PI * 2 : d;
        }

        Point2d getIntersection(Caliper caliper) {
            double d = this.isVertical() ? this.convexHull.get((int)this.pointIndex).x : (this.isHorizontal() ? caliper.convexHull.get((int)caliper.pointIndex).x : (caliper.getConstant() - this.getConstant()) / (this.getSlope() - caliper.getSlope()));
            double d2 = this.isVertical() ? caliper.getConstant() : (this.isHorizontal() ? this.getConstant() : this.getSlope() * d + this.getConstant());
            return new Point2d(d, d2);
        }

        double getSlope() {
            return Math.tan(this.currentAngle);
        }

        boolean isHorizontal() {
            return Math.abs(this.currentAngle) < 1.0E-11 || Math.abs(this.currentAngle - Math.PI) < 1.0E-11;
        }

        boolean isVertical() {
            return Math.abs(this.currentAngle - 1.5707963267948966) < 1.0E-11 || Math.abs(this.currentAngle - A270) < 1.0E-11;
        }

        void rotateBy(double d) {
            if (this.getDeltaAngleNextPoint() == d) {
                this.pointIndex = (this.pointIndex + 1) % this.convexHull.size();
            }
            this.currentAngle += d;
        }
    }

    protected static enum Corner {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

