/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;

public class Ray3d {
    public final Point3d origin;
    public final Vector3d dir;
    public final double length;

    public Ray3d(Point3d point3d, Vector3d vector3d, double d) {
        this.origin = point3d;
        this.dir = vector3d;
        this.length = d;
    }

    public Ray3d(Point3d point3d, Point3d point3d2) {
        this.origin = point3d;
        this.dir = Util3D.vector(point3d, point3d2);
        this.length = Util3D.safeNormalize(this.dir, 0.0);
    }

    public Point3d p1() {
        return this.origin;
    }

    public Point3d p2() {
        return this.get(this.length);
    }

    public Point3d evaluate(double d) {
        return this.get(d);
    }

    public Point3d get(double d) {
        return new Point3d(this.origin.x + this.dir.x * d, this.origin.y + this.dir.y * d, this.origin.z + this.dir.z * d);
    }

    public double distance(Point3d point3d) {
        double d = point3d.x - this.origin.x;
        double d2 = point3d.y - this.origin.y;
        double d3 = point3d.z - this.origin.z;
        return d * this.dir.x + d2 * this.dir.y + d3 * this.dir.z;
    }
}

