/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;

public class LineSeg3D
implements IParametric3D,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg3D(Point3d point3d, Point3d point3d2) {
        this.p1 = point3d;
        this.p2 = point3d2;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    public Object clone() {
        return new LineSeg3D(new Point3d(this.p1), new Point3d(this.p2));
    }

    public Vector3d getDir() {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.p2, this.p1);
        return vector3d;
    }

    public Vector3d getDirN() {
        Vector3d vector3d = this.getDir();
        vector3d.normalize();
        return vector3d;
    }

    @Override
    public Vector3d getTangent(double d) {
        return Util3D.vector(this.p1, this.p2);
    }

    public int hashCode() {
        return 153629939 + this.p1.hashCode() + this.p2.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineSeg3D)) {
            return false;
        }
        LineSeg3D lineSeg3D = (LineSeg3D)object;
        return this.p1.equals(lineSeg3D.p1) && this.p2.equals(lineSeg3D.p2) || this.p1.equals(lineSeg3D.p2) && this.p2.equals(lineSeg3D.p1);
    }

    public Point3d getMidpoint() {
        return Util3D.getMidPoint(this.p1, this.p2);
    }

    @Override
    public Point3d get(double d) {
        return Util3D.linesegPoint(this.p1, this.p2, d);
    }

    public double getT(Point3d point3d) {
        return Util3D.tOnLineSeg(this.p1, this.p2, point3d);
    }

    public Point3d getP1() {
        return this.p1;
    }

    public Point3d getP2() {
        return this.p2;
    }

    public String toString() {
        return "LineSeg: " + this.p1 + " -> " + this.p2;
    }

    @Override
    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    public boolean lengthZero() {
        return this.p1.equals(this.p2);
    }

    public AABox getBoundingBox() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.p1.x <= this.p2.x) {
            d6 = this.p1.x;
            d5 = this.p2.x;
        } else {
            d6 = this.p2.x;
            d5 = this.p1.x;
        }
        if (this.p1.y <= this.p2.y) {
            d4 = this.p1.y;
            d3 = this.p2.y;
        } else {
            d4 = this.p2.y;
            d3 = this.p1.y;
        }
        if (this.p1.z <= this.p2.z) {
            d2 = this.p1.z;
            d = this.p2.z;
        } else {
            d2 = this.p2.z;
            d = this.p1.z;
        }
        return new AABox(new Point3d(d6, d4, d2), new Point3d(d5, d3, d));
    }

    @Override
    public LineSeg3D transform(Matrix4d matrix4d) {
        return new LineSeg3D(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2));
    }

    @Override
    public double getClosestT(Point3d point3d) {
        return Inter3D.nearestTOnLineSeg(this.p1, this.p2, point3d);
    }

    @Override
    public double[] getIsects(Plane3d plane3d, double d) {
        double d2 = Inter3D.linePlaneIntersectionT(this.p1, this.getDir(), plane3d, d);
        if (Double.isNaN(d2 = Util.clampTIfValid(d2, 0.0, 1.0, d))) {
            return new double[0];
        }
        return new double[]{d2};
    }

    @Override
    public IParametric2D projectToPlane(Plane3d plane3d, Matrix4d matrix4d) {
        Point3d point3d = plane3d.projectOntoPlane(this.p1);
        Point3d point3d2 = plane3d.projectOntoPlane(this.p2);
        matrix4d.transform(point3d);
        matrix4d.transform(point3d2);
        return new LineSeg2D(new Point2d(point3d.x, point3d.y), new Point2d(point3d2.x, point3d2.y));
    }

    @Override
    public IParametric2D transform2D(Matrix4d matrix4d) {
        Point3d point3d = Util3D.xform(matrix4d, this.p1);
        Point3d point3d2 = Util3D.xform(matrix4d, this.p2);
        return new LineSeg2D(new Point2d(point3d.x, point3d.y), new Point2d(point3d2.x, point3d2.y));
    }

    @Override
    public IParametric3D reverse() {
        return new LineSeg3D(this.p2, this.p1);
    }

    @Override
    public IParametric3D trim(double d, double d2) {
        if (d == 0.0 && d2 == 1.0) {
            return this;
        }
        if (d2 == 0.0 && d == 1.0) {
            return this.reverse();
        }
        return new LineSeg3D(this.get(d), this.get(d2));
    }
}

