/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class AreaUtil {
    private static final int ROUND_DECIMALS = 6;

    public static double area(Area area, AffineTransform affineTransform, double d, double d2) {
        if (area.isEmpty()) {
            return 0.0;
        }
        double d3 = 0.0;
        TriangulatorInfo triangulatorInfo = AreaUtil.triangulate(area, affineTransform, d, d2);
        for (int i = 0; i < triangulatorInfo.triangles.length; i += 3) {
            Point2d point2d = triangulatorInfo.points[triangulatorInfo.triangles[i + 0]];
            Point2d point2d2 = triangulatorInfo.points[triangulatorInfo.triangles[i + 1]];
            Point2d point2d3 = triangulatorInfo.points[triangulatorInfo.triangles[i + 2]];
            d3 += Util2D.triArea(point2d, point2d2, point2d3);
        }
        return d3;
    }

    private static Point2d findPointInPoly(List<? extends IParametric2D> list, double d) {
        if (list.isEmpty()) {
            return null;
        }
        Point2d point2d = list.get(0).get(0.5);
        Random random = new Random(0L);
        for (int i = 0; i < 10; ++i) {
            Vector2d vector2d = AreaUtil.randomVec(random);
            List<double[]> list2 = AreaUtil.trimLineToPoly(list, point2d, vector2d, d);
            for (double[] dArray : list2) {
                if (theUtil.eq(dArray[0], dArray[1], d)) continue;
                double d2 = (dArray[0] + dArray[1]) * 0.5;
                return Util2D.linePoint(point2d, vector2d, d2);
            }
        }
        return point2d;
    }

    private static Vector2d randomVec(Random random) {
        double d = 0.0;
        double d2 = 0.0;
        while (d == 0.0 && d2 == 0.0) {
            d = random.nextDouble() - 0.5;
            d2 = random.nextDouble() - 0.5;
        }
        return new Vector2d(d, d2);
    }

    public static List<double[]> trimLineToPoly(List<? extends IParametric2D> list, Point2d point2d, Vector2d vector2d, double d) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (IParametric2D object2 : list) {
            List<double[]> i = object2.getLineIsects(point2d, vector2d, d);
            for (double[] dArray : i) {
                boolean bl = theUtil.eq0(dArray[0], d);
                boolean bl2 = theUtil.eq(dArray[0], 1.0, d);
                if (bl || bl2) {
                    double d4;
                    Vector2d vector2d2 = object2.getTangent(dArray[0]);
                    if (bl2) {
                        vector2d2.negate();
                    }
                    if (!theUtil.gt0(d4 = Util2D.cross(vector2d, vector2d2), d)) continue;
                    arrayList.add(dArray[1]);
                    continue;
                }
                arrayList.add(dArray[1]);
            }
        }
        if (arrayList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (arrayList.size() == 1) {
            System.err.println("Encountered 1 intersection during line to poly trim.");
            return Collections.EMPTY_LIST;
        }
        Collections.sort(arrayList, (d2, d3) -> theUtil.compare(d2, d3, d));
        if (arrayList.size() % 2 != 0) {
            System.err.println("Encounterd odd number of intersections during line to poly trim");
            return Arrays.asList(new double[][]{{(Double)arrayList.get(0), (Double)arrayList.get(arrayList.size() - 1)}});
        }
        ArrayList arrayList2 = new ArrayList();
        double[] dArray = theUtil.toDoubleArray(arrayList);
        for (int i = 0; i < dArray.length - 1; i += 2) {
            arrayList2.add(new double[]{dArray[i], dArray[i + 1]});
        }
        arrayList2.trimToSize();
        return arrayList2;
    }

    public static IPolygon toPoly(Area area, Matrix4d matrix4d, double d) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(0);
        PathIterator pathIterator = ShapeUtil.getPathIterator(area, null, d);
        double[] dArray = new double[2];
        int n = 0;
        Point3d point3d = null;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    if (arrayList.size() > n) {
                        arrayList2.add(arrayList.size());
                    }
                    n = arrayList.size();
                    point3d = new Point3d(dArray[0], dArray[1], 0.0);
                    if (matrix4d != null) {
                        matrix4d.transform(point3d);
                    }
                    arrayList.add(point3d);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Point3d point3d2 = new Point3d(dArray[0], dArray[1], 0.0);
                    if (matrix4d != null) {
                        matrix4d.transform(point3d2);
                    }
                    if (point3d2.equals(point3d)) break;
                    arrayList.add(point3d2);
                }
            }
            pathIterator.next();
        }
        return PolyUtil.newPoly(arrayList.toArray(new Point3d[arrayList.size()]), theUtil.toIntArray(arrayList2));
    }

    public static TriangulatorInfo triangulate(Area area, AffineTransform affineTransform, double d, double d2) {
        MeshBuilder meshBuilder = new MeshBuilder(d2);
        PathIterator pathIterator = ShapeUtil.getPathIterator(area, affineTransform, d);
        double[] dArray = new double[2];
        Point2d point2d = null;
        Point2d point2d2 = null;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    point2d2 = point2d = new Point2d(dArray[0], dArray[1]);
                    break;
                }
                case 4: {
                    meshBuilder.addEdge(point2d2, point2d);
                    break;
                }
                default: {
                    Point2d point2d3 = new Point2d(dArray[0], dArray[1]);
                    meshBuilder.addEdge(point2d2, point2d3);
                    point2d2 = point2d3;
                }
            }
            pathIterator.next();
        }
        Mesh mesh = meshBuilder.build();
        mesh.triangulateEvenOdd(0);
        return mesh.getOutput();
    }

    public static void cleanupArea(Area area) {
        Path2D.Double double_ = new Path2D.Double(area);
        area.reset();
        area.add(new Area(double_));
    }

    public static List<List<IParametric2D>> toParametrics(Area area, AffineTransform affineTransform, double d) {
        return AreaUtil.toParametrics(AreaUtil.getBoundaryLoops(area), affineTransform, d);
    }

    public static List<List<IParametric2D>> toParametrics(List<Loop> list, AffineTransform affineTransform, double d) {
        ArrayList<List<IParametric2D>> arrayList = new ArrayList<List<IParametric2D>>();
        Stack<Loop> stack = new Stack<Loop>();
        stack.addAll(list);
        while (!stack.isEmpty()) {
            Loop loop = (Loop)stack.pop();
            Path2D.Double double_ = new Path2D.Double();
            loop.addToPath(double_);
            arrayList.add(ShapeUtil.getBoundary2D(double_, affineTransform, d));
            stack.addAll(loop.children);
        }
        return arrayList;
    }

    public static List<ComponentArea> toSimpleAreas(Area area) {
        ArrayList<ComponentArea> arrayList = new ArrayList<ComponentArea>();
        AreaUtil.toSimpleAreas(arrayList, AreaUtil.getBoundaryLoops(area));
        return arrayList;
    }

    private static void toSimpleAreas(List<ComponentArea> list, Collection<Loop> collection) {
        for (Loop loop : collection) {
            Path2D.Double double_ = loop.toPath();
            ArrayList<Path2D.Double> arrayList = new ArrayList<Path2D.Double>();
            for (Loop loop2 : loop.children) {
                arrayList.add(loop2.toPath());
            }
            list.add(new ComponentArea(double_, arrayList));
            for (Loop loop2 : loop.children) {
                AreaUtil.toSimpleAreas(list, loop2.children);
            }
        }
    }

    private static Point2d getCoords(double[] dArray, int n) {
        return new Point2d(dArray[n], dArray[n + 1]);
    }

    private static Set<Point2d> getPathPoints(Collection<PathCommand> collection) {
        LinkedHashSet<Point2d> linkedHashSet = new LinkedHashSet<Point2d>();
        for (PathCommand pathCommand : collection) {
            switch (pathCommand.type) {
                case 0: {
                    linkedHashSet.add(AreaUtil.getCoords(pathCommand.coords, 0));
                    break;
                }
                case 1: {
                    linkedHashSet.add(AreaUtil.getCoords(pathCommand.coords, 0));
                    break;
                }
                case 2: {
                    linkedHashSet.add(AreaUtil.getCoords(pathCommand.coords, 2));
                    break;
                }
                case 3: {
                    linkedHashSet.add(AreaUtil.getCoords(pathCommand.coords, 4));
                }
            }
        }
        return linkedHashSet;
    }

    public static List<Loop> getBoundaryLoops(Area area) {
        Object object;
        PathIterator pathIterator = area.getPathIterator(null);
        if (pathIterator.getWindingRule() == 0) {
            return null;
        }
        LinkedList<Loop> linkedList = new LinkedList<Loop>();
        Loop loop = null;
        while (!pathIterator.isDone()) {
            object = new PathCommand();
            ((PathCommand)object).type = pathIterator.currentSegment(((PathCommand)object).coords);
            switch (((PathCommand)object).type) {
                case 0: {
                    loop = new Loop(pathIterator.getWindingRule());
                    linkedList.add(loop);
                    loop.path.moveTo(((PathCommand)object).coords[0], ((PathCommand)object).coords[1]);
                    loop.commands.add((PathCommand)object);
                    break;
                }
                case 1: {
                    loop.path.lineTo(((PathCommand)object).coords[0], ((PathCommand)object).coords[1]);
                    loop.commands.add((PathCommand)object);
                    break;
                }
                case 2: {
                    loop.path.quadTo(((PathCommand)object).coords[0], ((PathCommand)object).coords[1], ((PathCommand)object).coords[2], ((PathCommand)object).coords[3]);
                    loop.commands.add((PathCommand)object);
                    break;
                }
                case 3: {
                    loop.path.curveTo(((PathCommand)object).coords[0], ((PathCommand)object).coords[1], ((PathCommand)object).coords[2], ((PathCommand)object).coords[3], ((PathCommand)object).coords[4], ((PathCommand)object).coords[5]);
                    loop.commands.add((PathCommand)object);
                    break;
                }
                case 4: {
                    loop.path.closePath();
                    loop.commands.add((PathCommand)object);
                    loop.points = AreaUtil.getPathPoints(loop.commands);
                }
            }
            pathIterator.next();
        }
        object = linkedList.iterator();
        block8: while (object.hasNext()) {
            Loop loop2 = (Loop)object.next();
            for (Loop loop3 : linkedList) {
                if (loop2 == loop3 || !loop3.contains(loop2)) continue;
                loop3.children.add(loop2);
                object.remove();
                continue block8;
            }
        }
        return linkedList;
    }

    public static Collection<Area> separateUnconnectedAreas(Area area) {
        List<Loop> list = AreaUtil.getBoundaryLoops(area);
        ArrayList<Area> arrayList = new ArrayList<Area>(list.size());
        for (Loop loop : list) {
            loop.createAreas(arrayList, null, 0);
        }
        return arrayList;
    }

    public static boolean overlap(Area area, Area area2) {
        area = (Area)area.clone();
        area.intersect(area2);
        return !area.isEmpty();
    }

    public static boolean overlap(Area area, Area area2, double d, double d2) {
        if (d2 == 0.0) {
            return AreaUtil.overlap(area, area2);
        }
        area = (Area)area.clone();
        area.intersect(area2);
        double d3 = AreaUtil.area(area, null, d, d2);
        return d3 > d2;
    }

    public static Area union(Area area, Area area2) {
        if (area.equals(area2)) {
            return (Area)area.clone();
        }
        List<Loop> list = AreaUtil.getBoundaryLoops(area);
        List<Loop> list2 = AreaUtil.getBoundaryLoops(area2);
        List<List<IParametric2D>> list3 = AreaUtil.toParametrics(list, null, 0.0);
        List<List<IParametric2D>> list4 = AreaUtil.toParametrics(list2, null, 0.0);
        ArrayList<List<IParametric2D>> arrayList = new ArrayList<List<IParametric2D>>();
        ArrayList<List<IParametric2D>> arrayList2 = new ArrayList<List<IParametric2D>>();
        Collection<LoopVert> collection = AreaUtil.getIsects(list3, list4, arrayList, arrayList2);
        Collection<LoopEdge> collection2 = AreaUtil.getExitingEdges(collection);
        Path2D.Double double_ = new Path2D.Double();
        while (!collection2.isEmpty()) {
            Iterator iterator = collection2.iterator().next();
            LoopVert object = ((LoopEdge)((Object)iterator)).v1;
            double_.moveTo(object.p.x, object.p.y);
            Object object2 = iterator;
            while (true) {
                ((LoopEdge)object2).parm.append(double_);
                collection2.remove(object2);
                if (((LoopEdge)object2).v2 == object) break;
                LoopEdge loopEdge = ((LoopEdge)object2).v2.nextEdge((LoopEdge)object2);
                ((LoopEdge)object2).disconnect();
                assert (loopEdge != null);
                assert (loopEdge != object2);
                object2 = loopEdge;
            }
            ((LoopEdge)object2).disconnect();
            double_.closePath();
        }
        for (List list5 : arrayList) {
            int n = AreaUtil.findImmediateParentLevel(list2, list5);
            if (n != -1 && n % 2 == 0) continue;
            ShapeUtil.appendAsSubPath(double_, list5);
        }
        for (List list6 : arrayList2) {
            int n = AreaUtil.findImmediateParentLevel(list, list6);
            if (n != -1 && n % 2 == 0) continue;
            ShapeUtil.appendAsSubPath(double_, list6);
        }
        return new Area(double_);
    }

    private static int findImmediateParentLevel(List<Loop> list, List<IParametric2D> list2) {
        Point2d point2d = AreaUtil.findPointInPoly(list2, 1.0E-6);
        if (point2d == null) {
            return -1;
        }
        int n = -1;
        List<Loop> list3 = list;
        block0: while (list3 != null) {
            List<Loop> list4 = list3;
            list3 = null;
            for (Loop loop : list4) {
                if (!loop.path.contains(point2d.x, point2d.y)) continue;
                ++n;
                list3 = loop.children;
                continue block0;
            }
        }
        return n;
    }

    private static Collection<LoopVert> getIsects(List<List<IParametric2D>> list, List<List<IParametric2D>> list2, List<List<IParametric2D>> list3, List<List<IParametric2D>> list4) {
        list = AreaUtil.removeInvalidSegs(list);
        list2 = AreaUtil.removeInvalidSegs(list2);
        LinkedHashMap<Point2d, LoopVert> linkedHashMap = new LinkedHashMap<Point2d, LoopVert>();
        List<List<ParmDiv>> list5 = AreaUtil.initVerts(linkedHashMap, list);
        List<List<ParmDiv>> list6 = AreaUtil.initVerts(linkedHashMap, list2);
        AreaUtil.getIsects(list5, list6, linkedHashMap);
        AreaUtil.constructEdges(0, list5);
        AreaUtil.constructEdges(1, list6);
        Collection<LoopVert> collection = AreaUtil.getIsectVerts(linkedHashMap.values());
        AreaUtil.getNonIsectLoops(list5, collection, list3);
        AreaUtil.getNonIsectLoops(list6, collection, list4);
        return collection;
    }

    private static Point2d get(IParametric2D iParametric2D, double d) {
        return Util2D.round(iParametric2D.get(d), 6);
    }

    private static List<List<ParmDiv>> initVerts(Map<Point2d, LoopVert> map, List<List<IParametric2D>> list) {
        ArrayList<List<ParmDiv>> arrayList = new ArrayList<List<ParmDiv>>(list.size());
        for (List<IParametric2D> list2 : list) {
            LoopVert loopVert;
            Object object;
            Object object2;
            ArrayList<LoopVert> arrayList2 = new ArrayList<LoopVert>(list2.size());
            for (IParametric2D iParametric2D : list2) {
                object2 = iParametric2D.get(0.0);
                object = Util2D.round((Point2d)object2, 6);
                loopVert = map.get(object);
                if (loopVert == null) {
                    loopVert = new LoopVert((Point2d)object2);
                    map.put((Point2d)object, loopVert);
                }
                arrayList2.add(loopVert);
            }
            ArrayList arrayList3 = new ArrayList(list2.size());
            arrayList.add(arrayList3);
            for (int i = 0; i < list2.size(); ++i) {
                object2 = list2.get(i);
                object = (LoopVert)arrayList2.get(i);
                loopVert = (LoopVert)arrayList2.get((i + 1) % arrayList2.size());
                arrayList3.add(new ParmDiv((IParametric2D)object2, (LoopVert)object, loopVert));
            }
        }
        return arrayList;
    }

    private static List<List<IParametric2D>> removeInvalidSegs(List<List<IParametric2D>> list) {
        ArrayList<List<IParametric2D>> arrayList = new ArrayList<List<IParametric2D>>(list.size());
        for (List<IParametric2D> list2 : list) {
            ArrayList<IParametric2D> arrayList2 = new ArrayList<IParametric2D>(list2.size());
            for (IParametric2D iParametric2D : list2) {
                if (!iParametric2D.isValid(1.0E-6)) continue;
                arrayList2.add(iParametric2D);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private static void getIsects(List<List<ParmDiv>> list, List<List<ParmDiv>> list2, Map<Point2d, LoopVert> map) {
        for (List<ParmDiv> list3 : list) {
            for (ParmDiv parmDiv : list3) {
                IParametric2D iParametric2D = parmDiv.parm;
                TreeMap<Double, LoopVert> treeMap = parmDiv.divs;
                for (List<ParmDiv> list4 : list2) {
                    for (ParmDiv parmDiv2 : list4) {
                        IParametric2D iParametric2D2 = parmDiv2.parm;
                        TreeMap<Double, LoopVert> treeMap2 = parmDiv2.divs;
                        List<double[]> list5 = AreaUtil.isect(iParametric2D, iParametric2D2);
                        for (double[] dArray : list5) {
                            Point2d point2d;
                            Point2d point2d2 = AreaUtil.get(iParametric2D, dArray[0]);
                            if (!point2d2.equals(point2d = AreaUtil.get(iParametric2D2, dArray[1]))) continue;
                            LoopVert loopVert = map.get(point2d2);
                            if (loopVert == null) {
                                loopVert = new LoopVert(point2d2);
                                map.put(point2d2, loopVert);
                            }
                            if (!treeMap.containsValue(loopVert)) {
                                dArray[0] = iParametric2D.getClosestT(loopVert.p);
                                treeMap.put(dArray[0], loopVert);
                            }
                            if (treeMap2.containsValue(loopVert)) continue;
                            dArray[1] = iParametric2D2.getClosestT(loopVert.p);
                            treeMap2.put(dArray[1], loopVert);
                        }
                    }
                }
            }
        }
    }

    private static void constructEdges(int n, List<List<ParmDiv>> list) {
        for (List<ParmDiv> list2 : list) {
            for (ParmDiv parmDiv : list2) {
                TreeMap<Double, LoopVert> treeMap = parmDiv.divs;
                double d = -1.0;
                LoopVert loopVert = null;
                for (Map.Entry<Double, LoopVert> entry : treeMap.entrySet()) {
                    double d2 = entry.getKey();
                    LoopVert loopVert2 = entry.getValue();
                    if (d2 > 0.0) {
                        IParametric2D iParametric2D = parmDiv.parm.subsegment(d, d2);
                        iParametric2D.setBegin(loopVert.p);
                        iParametric2D.setEnd(loopVert2.p);
                        LoopEdge loopEdge = new LoopEdge(n, loopVert, loopVert2, iParametric2D);
                        loopEdge.connect();
                    }
                    d = d2;
                    loopVert = loopVert2;
                }
            }
        }
    }

    private static Collection<LoopVert> getIsectVerts(Collection<LoopVert> collection) {
        LinkedIdentityHashSet<LoopVert> linkedIdentityHashSet = new LinkedIdentityHashSet<LoopVert>();
        LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
        for (LoopVert object : collection) {
            if (!object.isIntersectVert()) continue;
            linkedIdentityHashSet2.add(object);
        }
        linkedIdentityHashSet.addAll(linkedIdentityHashSet2);
        while (!linkedIdentityHashSet2.isEmpty()) {
            LoopVert loopVert = (LoopVert)linkedIdentityHashSet2.iterator().next();
            linkedIdentityHashSet2.remove(loopVert);
            for (List list : loopVert.edges.values()) {
                for (LoopEdge loopEdge : list) {
                    LoopVert loopVert2 = loopEdge.v1 == loopVert ? loopEdge.v2 : loopEdge.v1;
                    if (!linkedIdentityHashSet.add(loopVert2)) continue;
                    linkedIdentityHashSet2.add(loopVert2);
                }
            }
        }
        return linkedIdentityHashSet;
    }

    private static void getNonIsectLoops(List<List<ParmDiv>> list, Collection<LoopVert> collection, List<List<IParametric2D>> list2) {
        for (List<ParmDiv> list3 : list) {
            boolean bl = false;
            for (ParmDiv parmDiv : list3) {
                TreeMap<Double, LoopVert> treeMap = parmDiv.divs;
                for (LoopVert loopVert : treeMap.values()) {
                    if (!collection.contains(loopVert)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) continue;
            ArrayList arrayList = new ArrayList(list3.size());
            for (ParmDiv parmDiv : list3) {
                arrayList.add(parmDiv.parm);
            }
            list2.add(arrayList);
        }
    }

    private static Collection<LoopEdge> getExitingEdges(Collection<LoopVert> collection) {
        LinkedIdentityHashSet<LoopEdge> linkedIdentityHashSet = new LinkedIdentityHashSet<LoopEdge>();
        for (LoopVert loopVert : collection) {
            for (List list : loopVert.edges.values()) {
                for (LoopEdge loopEdge : list) {
                    if (!AreaUtil.isEdgeExiting(loopEdge, loopVert)) continue;
                    linkedIdentityHashSet.add(loopEdge);
                }
            }
        }
        return linkedIdentityHashSet;
    }

    private static boolean isEdgeExiting(LoopEdge loopEdge, LoopVert loopVert) {
        if (loopEdge.v2 == loopVert) {
            return false;
        }
        LoopEdge loopEdge2 = loopVert.prevEdge(loopEdge);
        return loopEdge2 != null;
    }

    private static List<double[]> isect(IParametric2D iParametric2D, IParametric2D iParametric2D2) {
        if (!(iParametric2D instanceof LineSeg2D) || !(iParametric2D2 instanceof LineSeg2D)) {
            return null;
        }
        List<double[]> list = iParametric2D.getIsects(iParametric2D2, 1.0E-6);
        if (list.isEmpty()) {
            List<double[][]> list2 = iParametric2D.getAlignedSegs(iParametric2D2, 1.0E-6);
            list = new ArrayList<double[]>(list2.size() * 2);
            for (double[][] dArray : list2) {
                list.add(new double[]{dArray[0][0], dArray[1][0]});
                list.add(new double[]{dArray[0][1], dArray[1][1]});
            }
        }
        return list;
    }

    private static class TolComp
    implements Comparator<Double> {
        private final double tol;

        public TolComp(double d) {
            this.tol = d;
        }

        @Override
        public int compare(Double d, Double d2) {
            return theUtil.compare(d, d2, this.tol);
        }
    }

    private static class ParmDiv {
        public final IParametric2D parm;
        public final TreeMap<Double, LoopVert> divs;

        public ParmDiv(IParametric2D iParametric2D, LoopVert loopVert, LoopVert loopVert2) {
            this.parm = iParametric2D;
            this.divs = new TreeMap();
            this.divs.put(0.0, loopVert);
            this.divs.put(1.0, loopVert2);
        }
    }

    private static class LoopEdgeUse {
        public final LoopEdge edge;
        public final boolean positive;

        public LoopEdgeUse(LoopEdge loopEdge, boolean bl) {
            this.edge = loopEdge;
            this.positive = bl;
        }

        public LoopVert v1() {
            return this.positive ? this.edge.v1 : this.edge.v2;
        }

        public LoopVert v2() {
            return this.positive ? this.edge.v2 : this.edge.v1;
        }
    }

    private static class LoopEdge {
        public final int whichArea;
        public final LoopVert v1;
        public final LoopVert v2;
        public final IParametric2D parm;

        public LoopEdge(int n, LoopVert loopVert, LoopVert loopVert2, IParametric2D iParametric2D) {
            this.whichArea = n;
            this.v1 = loopVert;
            this.v2 = loopVert2;
            this.parm = iParametric2D;
        }

        public void connect() {
            this.v1.add(this);
            this.v2.add(this);
        }

        public void disconnect() {
            this.v1.remove(this);
            this.v2.remove(this);
        }

        public String toString() {
            return "[LoopEdge: " + this.v1.p + " -> " + this.v2.p + "]";
        }
    }

    private static class LoopVert {
        private static final Vector2d s_baseDir = new Vector2d(1.0, 0.0);
        private final TreeMap<Double, List<LoopEdge>> edges = new TreeMap();
        public final Point2d p;

        public LoopVert(Point2d point2d) {
            this.p = point2d;
        }

        public void add(LoopEdge loopEdge) {
            Vector2d vector2d = this.getRelativeDir(loopEdge);
            double d = Util2D.angle(s_baseDir, vector2d);
            List<LoopEdge> list = this.edges.get(d);
            if (list == null) {
                list = new ArrayList<LoopEdge>(2);
                this.edges.put(d, list);
            }
            list.add(loopEdge);
        }

        public void remove(LoopEdge loopEdge) {
            Vector2d vector2d = this.getRelativeDir(loopEdge);
            double d = Util2D.angle(s_baseDir, vector2d);
            List<LoopEdge> list = this.edges.get(d);
            assert (list != null);
            list.remove(loopEdge);
            if (list.isEmpty()) {
                this.edges.remove(d);
            }
        }

        public boolean isIntersectVert() {
            int n = -1;
            for (List<LoopEdge> list : this.edges.values()) {
                for (LoopEdge loopEdge : list) {
                    if (n == -1) {
                        n = loopEdge.whichArea;
                        continue;
                    }
                    if (loopEdge.whichArea == n) continue;
                    return true;
                }
            }
            return false;
        }

        private Vector2d getRelativeDir(LoopEdge loopEdge) {
            if (loopEdge.v1 == this) {
                return loopEdge.parm.getTangent(0.0);
            }
            Vector2d vector2d = loopEdge.parm.getTangent(1.0);
            vector2d.negate();
            return vector2d;
        }

        private List<LoopEdge> nextEdges(double d) {
            Map.Entry<Double, List<LoopEdge>> entry = this.edges.lowerEntry(d);
            return entry == null ? this.edges.lastEntry().getValue() : entry.getValue();
        }

        private List<LoopEdge> prevEdges(double d) {
            Map.Entry<Double, List<LoopEdge>> entry = this.edges.higherEntry(d);
            return entry == null ? this.edges.firstEntry().getValue() : entry.getValue();
        }

        public LoopEdge nextEdge(LoopEdge loopEdge) {
            if (loopEdge.v1 == this) {
                return null;
            }
            Vector2d vector2d = this.getRelativeDir(loopEdge);
            double d = Util2D.angle(s_baseDir, vector2d);
            List<LoopEdge> list = this.edges.get(d);
            assert (list != null);
            for (LoopEdge object2 : list) {
                if (object2.v1 != this) continue;
                return null;
            }
            List<LoopEdge> list2 = this.nextEdges(d);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                LoopEdge loopEdge2 = (LoopEdge)iterator.next();
                if (loopEdge2.v2 != this) continue;
                return null;
            }
            return (LoopEdge)list2.get(0);
        }

        public LoopEdge prevEdge(LoopEdge loopEdge) {
            if (loopEdge.v2 == this) {
                return null;
            }
            Vector2d vector2d = this.getRelativeDir(loopEdge);
            double d = Util2D.angle(s_baseDir, vector2d);
            List<LoopEdge> list = this.edges.get(d);
            assert (list != null);
            for (LoopEdge object2 : list) {
                if (object2.v1 == this) continue;
                return null;
            }
            List<LoopEdge> list2 = this.prevEdges(d);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                LoopEdge loopEdge2 = (LoopEdge)iterator.next();
                if (loopEdge2.v1 != this) continue;
                return null;
            }
            return (LoopEdge)list2.get(0);
        }

        public String toString() {
            return this.p.toString();
        }
    }

    private static class Loop {
        public final Path2D.Double path;
        public final List<PathCommand> commands = new ArrayList<PathCommand>();
        public final List<Loop> children = new ArrayList<Loop>();
        public Set<Point2d> points;

        public Loop(int n) {
            this.path = new Path2D.Double(n);
        }

        public boolean contains(Loop loop) {
            List<IParametric2D> list = ShapeUtil.getBoundary2D(loop.path, null, 0.0);
            Point2d point2d = AreaUtil.findPointInPoly(list, 1.0E-6);
            return this.path.contains(point2d.x, point2d.y);
        }

        public Path2D.Double toPath() {
            Path2D.Double double_ = new Path2D.Double();
            this.addToPath(double_);
            return double_;
        }

        public void addToPath(Path2D.Double double_) {
            for (PathCommand pathCommand : this.commands) {
                switch (pathCommand.type) {
                    case 0: {
                        double_.moveTo(pathCommand.coords[0], pathCommand.coords[1]);
                        break;
                    }
                    case 1: {
                        double_.lineTo(pathCommand.coords[0], pathCommand.coords[1]);
                        break;
                    }
                    case 2: {
                        double_.quadTo(pathCommand.coords[0], pathCommand.coords[1], pathCommand.coords[2], pathCommand.coords[3]);
                        break;
                    }
                    case 3: {
                        double_.curveTo(pathCommand.coords[0], pathCommand.coords[1], pathCommand.coords[2], pathCommand.coords[3], pathCommand.coords[4], pathCommand.coords[5]);
                        break;
                    }
                    case 4: {
                        double_.closePath();
                    }
                }
            }
        }

        public void createAreas(Collection<Area> collection, Path2D.Double double_, int n) {
            boolean bl;
            boolean bl2 = bl = n % 2 == 0;
            if (bl) {
                double_ = new Path2D.Double();
            }
            this.addToPath(double_);
            int n2 = n + 1;
            for (Loop loop : this.children) {
                loop.createAreas(collection, double_, n2);
            }
            if (bl) {
                collection.add(new Area(double_));
            }
        }
    }

    private static class PathCommand {
        public int type;
        public double[] coords = new double[6];

        private PathCommand() {
        }
    }

    public static class ComponentArea {
        public final Path2D.Double posComp;
        public final Collection<Path2D.Double> negComps;

        public ComponentArea(Path2D.Double double_, Collection<Path2D.Double> collection) {
            this.posComp = double_;
            this.negComps = collection;
        }
    }
}

