/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABoxf;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.ISearchVol;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.theUtil;

public class AABox
implements Serializable,
Cloneable,
ISearchVol,
ITest<AABox> {
    static final long serialVersionUID = 1L;
    public static final double VOL_EPS = 2.220446049250313E-16;
    private double d_minx;
    private double d_miny;
    private double d_minz;
    private double d_maxx;
    private double d_maxy;
    private double d_maxz;

    public AABox() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public AABox(AABox aABox) {
        this(aABox.d_minx, aABox.d_miny, aABox.d_minz, aABox.d_maxx, aABox.d_maxy, aABox.d_maxz);
    }

    public AABox(Point3d point3d, Point3d point3d2) {
        this.set(point3d, point3d2);
    }

    public AABox(double d, double d2, double d3, double d4, double d5, double d6) {
        this.d_minx = d;
        this.d_miny = d2;
        this.d_minz = d3;
        this.d_maxx = d4;
        this.d_maxy = d5;
        this.d_maxz = d6;
    }

    public AABox(Point3d point3d) {
        this.d_minx = this.d_maxx = point3d.x;
        this.d_miny = this.d_maxy = point3d.y;
        this.d_minz = this.d_maxz = point3d.z;
    }

    public AABox(Point3d ... point3dArray) {
        this();
        this.add(point3dArray);
    }

    public double getWidth() {
        return this.d_maxx - this.d_minx;
    }

    public double getDepth() {
        return this.d_maxy - this.d_miny;
    }

    public double getHeight() {
        return this.d_maxz - this.d_minz;
    }

    public static AABox infinite() {
        return new AABox(new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY), new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.d_minx) || Double.isInfinite(this.d_miny) || Double.isInfinite(this.d_minz) || Double.isInfinite(this.d_maxx) || Double.isInfinite(this.d_maxy) || Double.isInfinite(this.d_maxz);
    }

    public void reset() {
        this.d_minz = Double.MAX_VALUE;
        this.d_miny = Double.MAX_VALUE;
        this.d_minx = Double.MAX_VALUE;
        this.d_maxz = -1.7976931348623157E308;
        this.d_maxy = -1.7976931348623157E308;
        this.d_maxx = -1.7976931348623157E308;
    }

    @Override
    public boolean isValid() {
        return this.d_minx <= this.d_maxx && this.d_miny <= this.d_maxy && this.d_minz <= this.d_maxz;
    }

    public void set(Point3d point3d, Point3d point3d2) {
        this.d_minx = point3d.x;
        this.d_miny = point3d.y;
        this.d_minz = point3d.z;
        this.d_maxx = point3d2.x;
        this.d_maxy = point3d2.y;
        this.d_maxz = point3d2.z;
    }

    public void set(double d, double d2, double d3, double d4, double d5, double d6) {
        this.d_minx = d;
        this.d_miny = d2;
        this.d_minz = d3;
        this.d_maxx = d4;
        this.d_maxy = d5;
        this.d_maxz = d6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AABox{");
        stringBuffer.append(this.getMin().toString() + " --> ");
        stringBuffer.append(this.getMax().toString() + "}");
        return stringBuffer.toString();
    }

    public Point3d getCenter() {
        return new Point3d((this.d_minx + this.d_maxx) * 0.5, (this.d_miny + this.d_maxy) * 0.5, (this.d_minz + this.d_maxz) * 0.5);
    }

    public Point3d getMin() {
        return new Point3d(this.d_minx, this.d_miny, this.d_minz);
    }

    public Point3d getMax() {
        return new Point3d(this.d_maxx, this.d_maxy, this.d_maxz);
    }

    public Point3d[] getVerts() {
        return this.getVerts(true);
    }

    public Point3d[] getVerts(boolean bl) {
        Point3d[] point3dArray = new Point3d[]{this.mmm(), this.mmM(), this.mMm(), this.mMM(), this.Mmm(), this.MmM(), this.MMm(), this.MMM()};
        if (!bl) {
            point3dArray[0] = new Point3d(point3dArray[0]);
            point3dArray[7] = new Point3d(point3dArray[7]);
        }
        return point3dArray;
    }

    public double getMinX() {
        return this.d_minx;
    }

    public double getMinY() {
        return this.d_miny;
    }

    public double getMinZ() {
        return this.d_minz;
    }

    public double getMaxX() {
        return this.d_maxx;
    }

    public double getMaxY() {
        return this.d_maxy;
    }

    public double getMaxZ() {
        return this.d_maxz;
    }

    @Override
    public void add(ISearchVol iSearchVol) {
        if (iSearchVol instanceof AABox) {
            this.add((AABox)iSearchVol);
        }
    }

    public void add(AABox aABox) {
        if (aABox.d_minx < this.d_minx) {
            this.d_minx = aABox.d_minx;
        }
        if (aABox.d_maxx > this.d_maxx) {
            this.d_maxx = aABox.d_maxx;
        }
        if (aABox.d_miny < this.d_miny) {
            this.d_miny = aABox.d_miny;
        }
        if (aABox.d_maxy > this.d_maxy) {
            this.d_maxy = aABox.d_maxy;
        }
        if (aABox.d_minz < this.d_minz) {
            this.d_minz = aABox.d_minz;
        }
        if (aABox.d_maxz > this.d_maxz) {
            this.d_maxz = aABox.d_maxz;
        }
    }

    public void add(Point3d ... point3dArray) {
        for (Point3d point3d : point3dArray) {
            this.add(point3d);
        }
    }

    public void add(Point3d point3d) {
        this.addPoint(point3d.x, point3d.y, point3d.z);
    }

    public void addPoint(double d, double d2, double d3) {
        if (d < this.d_minx) {
            this.d_minx = d;
        }
        if (d > this.d_maxx) {
            this.d_maxx = d;
        }
        if (d2 < this.d_miny) {
            this.d_miny = d2;
        }
        if (d2 > this.d_maxy) {
            this.d_maxy = d2;
        }
        if (d3 < this.d_minz) {
            this.d_minz = d3;
        }
        if (d3 > this.d_maxz) {
            this.d_maxz = d3;
        }
    }

    public double volume() {
        return (this.d_maxx - this.d_minx) * (this.d_maxy - this.d_miny) * (this.d_maxz - this.d_minz);
    }

    public double volume(double d) {
        double d2 = this.d_maxx - this.d_minx + d;
        double d3 = this.d_maxy - this.d_miny + d;
        double d4 = this.d_maxz - this.d_minz + d;
        return d2 * d3 * d4;
    }

    @Override
    public double volumeEps() {
        return this.volume(2.220446049250313E-16);
    }

    public AABox ensureValidSize(double d, double d2) {
        Point3d point3d = this.getMin();
        Point3d point3d2 = this.getMax();
        if (!this.isValid()) {
            this.set(new Point3d(-d, -d, -d), new Point3d(d, d, d));
            return this;
        }
        if (point3d.equals(point3d2)) {
            this.set(new Point3d(point3d.x - d, point3d.y - d, point3d.z - d), new Point3d(point3d2.x + d, point3d2.y + d, point3d2.z + d));
            return this;
        }
        if (point3d.x == point3d2.x) {
            point3d.x -= d2;
            point3d2.x += d2;
        }
        if (point3d.y == point3d2.y) {
            point3d.y -= d2;
            point3d2.y += d2;
        }
        if (point3d.z == point3d2.z) {
            point3d.z -= d2;
            point3d2.z += d2;
        }
        this.set(point3d, point3d2);
        return this;
    }

    public boolean cull(Point3d point3d) {
        return !(point3d.x <= this.d_minx || point3d.x >= this.d_maxx || point3d.y <= this.d_miny || point3d.y >= this.d_maxy || point3d.z <= this.d_minz) && !(point3d.z >= this.d_maxz);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AABox)) {
            return false;
        }
        AABox aABox = (AABox)object;
        return this.d_minx == aABox.d_minx && this.d_miny == aABox.d_miny && this.d_minz == aABox.d_minz && this.d_maxx == aABox.d_maxx && this.d_maxy == aABox.d_maxy && this.d_maxz == aABox.d_maxz;
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_minx + this.d_miny + this.d_minz + this.d_maxx + this.d_maxy + this.d_maxz);
    }

    @Override
    public Object clone() {
        return new AABox(this);
    }

    public ConvexHull.PointClassify classify(Point3d point3d, double d) {
        if (this.innerPt(point3d, d)) {
            return ConvexHull.PointClassify.INSIDE;
        }
        if (this.contains(point3d, d)) {
            return ConvexHull.PointClassify.ON;
        }
        return ConvexHull.PointClassify.OUTSIDE;
    }

    public boolean contains(Point3d point3d) {
        return this.d_minx <= point3d.x && point3d.x <= this.d_maxx && this.d_miny <= point3d.y && point3d.y <= this.d_maxy && this.d_minz <= point3d.z && point3d.z <= this.d_maxz;
    }

    public boolean containsOneOf(Point3d ... point3dArray) {
        for (Point3d point3d : point3dArray) {
            if (!this.contains(point3d)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point3d point3d, double d) {
        return this.d_minx - d <= point3d.x && point3d.x <= this.d_maxx + d && this.d_miny - d <= point3d.y && point3d.y <= this.d_maxy + d && this.d_minz - d <= point3d.z && point3d.z <= this.d_maxz + d;
    }

    public boolean innerPt(Point3d point3d) {
        return this.d_minx < point3d.x && point3d.x < this.d_maxx && this.d_miny < point3d.y && point3d.y < this.d_maxy && this.d_minz < point3d.z && point3d.z < this.d_maxz;
    }

    public boolean innerPt(Point3d point3d, double d) {
        return this.d_minx + d < point3d.x && point3d.x < this.d_maxx - d && this.d_miny + d < point3d.y && point3d.y < this.d_maxy - d && this.d_minz + d < point3d.z && point3d.z < this.d_maxz - d;
    }

    @Override
    public Containment test(AABox aABox) {
        return AABox.contains(this.d_minx, this.d_miny, this.d_minz, this.d_maxx, this.d_maxy, this.d_maxz, aABox.d_minx, aABox.d_miny, aABox.d_minz, aABox.d_maxx, aABox.d_maxy, aABox.d_maxz);
    }

    public Containment test(AABox aABox, double d) {
        return AABox.contains(this.d_minx - d, this.d_miny - d, this.d_minz - d, this.d_maxx + d, this.d_maxy + d, this.d_maxz + d, aABox.d_minx - d, aABox.d_miny - d, aABox.d_minz - d, aABox.d_maxx + d, aABox.d_maxy + d, aABox.d_maxz + d);
    }

    private static final Containment contains(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        if (d <= d10 && d7 <= d4 && d2 <= d11 && d8 <= d5 && d3 <= d12 && d9 <= d6) {
            if (d <= d7 && d10 <= d4 && d2 <= d8 && d11 <= d5 && d3 <= d9 && d12 <= d6) {
                return Containment.INSIDE;
            }
            return Containment.INTERSECTS;
        }
        return Containment.OUTSIDE;
    }

    public int contains(AABox aABox) {
        return thunderheadeng.geometry.Containment.convert(this.test(aABox));
    }

    public int contains(AABox aABox, double d) {
        return thunderheadeng.geometry.Containment.convert(this.test(aABox, d));
    }

    public boolean intersects(AABox aABox) {
        Point3d point3d = this.getMin();
        Point3d point3d2 = this.getMax();
        Point3d point3d3 = aABox.getMin();
        Point3d point3d4 = aABox.getMax();
        return point3d.x <= point3d4.x && point3d2.x >= point3d3.x && point3d.y <= point3d4.y && point3d2.y >= point3d3.y && point3d.z <= point3d4.z && point3d2.z >= point3d3.z;
    }

    public boolean intersects(AABox aABox, double d) {
        double d2 = this.d_minx - d;
        double d3 = this.d_miny - d;
        double d4 = this.d_minz - d;
        double d5 = aABox.d_minx - d;
        double d6 = aABox.d_miny - d;
        double d7 = aABox.d_minz - d;
        double d8 = this.d_maxx + d;
        double d9 = this.d_maxy + d;
        double d10 = this.d_maxz + d;
        double d11 = aABox.d_maxx + d;
        double d12 = aABox.d_maxy + d;
        double d13 = aABox.d_maxz + d;
        return d5 <= d8 && d11 >= d2 && d6 <= d9 && d12 >= d3 && d7 <= d10 && d13 >= d4;
    }

    public Point3d mmm() {
        return this.getMin();
    }

    public Point3d mmM() {
        return new Point3d(this.d_minx, this.d_miny, this.d_maxz);
    }

    public Point3d mMm() {
        return new Point3d(this.d_minx, this.d_maxy, this.d_minz);
    }

    public Point3d mMM() {
        return new Point3d(this.d_minx, this.d_maxy, this.d_maxz);
    }

    public Point3d Mmm() {
        return new Point3d(this.d_maxx, this.d_miny, this.d_minz);
    }

    public Point3d MmM() {
        return new Point3d(this.d_maxx, this.d_miny, this.d_maxz);
    }

    public Point3d MMm() {
        return new Point3d(this.d_maxx, this.d_maxy, this.d_minz);
    }

    public Point3d MMM() {
        return this.getMax();
    }

    public Point3d mmm(Point3d point3d) {
        point3d.set(this.d_minx, this.d_miny, this.d_minz);
        return point3d;
    }

    public Point3d mmM(Point3d point3d) {
        point3d.set(this.d_minx, this.d_miny, this.d_maxz);
        return point3d;
    }

    public Point3d mMm(Point3d point3d) {
        point3d.set(this.d_minx, this.d_maxy, this.d_minz);
        return point3d;
    }

    public Point3d mMM(Point3d point3d) {
        point3d.set(this.d_minx, this.d_maxy, this.d_maxz);
        return point3d;
    }

    public Point3d Mmm(Point3d point3d) {
        point3d.set(this.d_maxx, this.d_miny, this.d_minz);
        return point3d;
    }

    public Point3d MmM(Point3d point3d) {
        point3d.set(this.d_maxx, this.d_miny, this.d_maxz);
        return point3d;
    }

    public Point3d MMm(Point3d point3d) {
        point3d.set(this.d_maxx, this.d_maxy, this.d_minz);
        return point3d;
    }

    public Point3d MMM(Point3d point3d) {
        point3d.set(this.d_maxx, this.d_maxy, this.d_maxz);
        return point3d;
    }

    public Point3d getCorner(int n, Point3d point3d) {
        switch (n) {
            case 0: {
                return this.mmm(point3d);
            }
            case 1: {
                return this.mmM(point3d);
            }
            case 2: {
                return this.mMm(point3d);
            }
            case 3: {
                return this.mMM(point3d);
            }
            case 4: {
                return this.Mmm(point3d);
            }
            case 5: {
                return this.MmM(point3d);
            }
            case 6: {
                return this.MMm(point3d);
            }
        }
        return this.MMM(point3d);
    }

    public Point3d[][] getFaces() {
        Point3d point3d = this.mmm();
        Point3d point3d2 = this.mmM();
        Point3d point3d3 = this.mMm();
        Point3d point3d4 = this.mMM();
        Point3d point3d5 = this.Mmm();
        Point3d point3d6 = this.MmM();
        Point3d point3d7 = this.MMm();
        Point3d point3d8 = this.MMM();
        return new Point3d[][]{{point3d3, point3d, point3d2, point3d4}, {point3d5, point3d7, point3d8, point3d6}, {point3d, point3d5, point3d6, point3d2}, {point3d7, point3d3, point3d4, point3d8}, {point3d, point3d3, point3d7, point3d5}, {point3d2, point3d6, point3d8, point3d4}};
    }

    public AABoxf toAABoxf() {
        return new AABoxf((float)this.d_minx, (float)this.d_miny, (float)this.d_minz, (float)this.d_maxx, (float)this.d_maxy, (float)this.d_maxz);
    }

    public void transformEq(Matrix4d matrix4d) {
        Point3d[] point3dArray;
        for (Point3d point3d : point3dArray = this.getVerts()) {
            matrix4d.transform(point3d);
        }
        this.reset();
        this.add(point3dArray);
    }

    public AABox transform(Matrix4d matrix4d) {
        Point3d[] point3dArray;
        AABox aABox = new AABox();
        for (Point3d point3d : point3dArray = this.getVerts()) {
            matrix4d.transform(point3d);
            aABox.add(point3d);
        }
        return aABox;
    }

    public AABox scale(double d) {
        Point3d point3d = this.getCenter();
        double d2 = this.getWidth() * d * 0.5;
        double d3 = this.getHeight() * d * 0.5;
        double d4 = this.getDepth() * d * 0.5;
        return new AABox(point3d.x - d2, point3d.y - d4, point3d.z - d3, point3d.x + d2, point3d.y + d4, point3d.z + d3);
    }
}

