/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.delaunay;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;
import thunderheadeng.delaunay.GeomTests;
import thunderheadeng.delaunay.TriangulateFilter;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.delaunay.VoronoiInfo;
import thunderheadeng.util.Pair;

public class Mesh {
    public static final int EDGEID_UNCONSTRAINED = 0;
    public static final int EDGEID_BOUNDARY = 1;
    public static final int EDGEID_DEFAULT = 2;
    public static final int EDGEID_CUSTOM_OFFSET = 3;
    public static final int OPTION_REFINE = 1;
    public static final int OPTION_COLOR_DISPLAY = 2;
    public static final int OUTOPT_ADJACENCY = 1;
    public static final int OUTOPT_COLORS = 2;
    public static final int OUTOPT_EDGES = 4;
    public static final int REFOPT_CONFORMING = 1;
    public static final int REFOPT_SPLIT_BOUNDARY_EDGES = 2;
    public static final int REFOPT_DEFAULT = 3;
    private static final Logger LOGGER = Logger.getLogger(Mesh.class.getName());
    private static final double UNUSED_AREA = Double.MAX_VALUE;
    private List<Vertex> d_verts = new ArrayList<Vertex>();
    private List<Triangle> d_tris = new ArrayList<Triangle>();
    private List<Edge> d_edges = new ArrayList<Edge>();
    private Handle d_outside;
    private Vertex d_infV1;
    private Vertex d_infV2;
    private Vertex d_infV3;
    private Random d_random;
    private int[] d_resultTris;
    private boolean d_checkArea = false;
    private double d_maxArea = Double.MAX_VALUE;
    private int d_refOpts = 3;
    private int d_defEdgeId = 2;
    public static final double DEF_MIN_ANGLE = 20.0;
    double minAngle = 20.0;
    double cosmin = Math.cos(this.minAngle * Math.PI / 180.0);
    double cos2min = this.cosmin * this.cosmin;
    PriorityQueue<QTri> badTriQ = new PriorityQueue();
    Queue<QEdge> badEdgeQ = new ArrayDeque<QEdge>();
    Deque<Handle> d_undoStack = new ArrayDeque<Handle>();
    int d_undoType = 0;
    Handle d_undoVertexTri1;
    Handle d_undoVertexTri2;
    private static int SUCCESS = 0;
    private static int ENCROACHING = 1;
    private static int ERROR = -1;
    private List<Point2d> d_voronoiVerts;
    private Map<Pair<Integer, Integer>, Integer> d_voronoiMidPts;
    private List<List<Integer>> d_polys;
    private List<List<Integer>> d_adjPolys;
    private int[] d_polymap;
    private int SAMPLES = 0;
    public static final int INTRIANGLE = 1;
    public static final int ONEDGE = 2;
    public static final int ONVERTEX = 3;
    public static final int OUTSIDE = 4;

    public void setDefaultEdgeId(int n) {
        if (n == 0) {
            return;
        }
        this.d_defEdgeId = n;
    }

    public int getDefaultEdgeId() {
        return this.d_defEdgeId;
    }

    private Vertex newVertex(double d, double d2) {
        return this.newVertex(d, d2, Double.MAX_VALUE);
    }

    private Vertex newVertex(double d, double d2, double d3) {
        Vertex vertex = new Vertex(d, d2, d3);
        this.d_verts.add(vertex);
        vertex.id = this.d_verts.size();
        return vertex;
    }

    private Handle newTriangle(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        this.d_tris.add(triangle);
        triangle.id = this.d_tris.size();
        return new Handle(triangle, 0);
    }

    public void addPoint(double d, double d2) {
        this.addPoint(d, d2, Double.MAX_VALUE);
    }

    public void addPoint(double d, double d2, double d3) {
        this.newVertex(d, d2, d3);
    }

    public void addPoints(double ... dArray) {
        assert (dArray.length % 2 == 0);
        for (int i = 0; i < dArray.length - 1; i += 2) {
            this.addPoint(dArray[i], dArray[i + 1]);
        }
    }

    public void addPoints(DoubleBuffer doubleBuffer) {
        doubleBuffer = doubleBuffer.duplicate();
        while (doubleBuffer.hasRemaining()) {
            double d = doubleBuffer.get();
            double d2 = doubleBuffer.get();
            this.addPoint(d, d2);
        }
    }

    public void addPoints(Collection<? extends Point2d> collection) {
        for (Point2d point2d : collection) {
            this.addPoint(point2d.x, point2d.y);
        }
    }

    public void addEdge(int n, int n2) {
        this.addEdge(n, n2, this.d_defEdgeId);
    }

    public void addEdge(int n, int n2, int n3) {
        this.d_edges.add(new Edge(n + 1, n2 + 1, n3));
    }

    public void addEdges(int ... nArray) {
        assert (nArray.length % 2 == 0);
        for (int i = 0; i < nArray.length - 1; i += 2) {
            this.addEdge(nArray[i], nArray[i + 1]);
        }
    }

    public void addIdEdges(int ... nArray) {
        assert (nArray.length % 3 == 0);
        for (int i = 0; i < nArray.length - 1; i += 3) {
            this.addEdge(nArray[i], nArray[i + 1], nArray[i + 2]);
        }
    }

    public void addEdges(IntBuffer intBuffer) {
        intBuffer = intBuffer.duplicate();
        while (intBuffer.hasRemaining()) {
            int n = intBuffer.get();
            int n2 = intBuffer.get();
            this.addEdge(n, n2);
        }
    }

    public void addIdEdges(IntBuffer intBuffer) {
        intBuffer = intBuffer.duplicate();
        while (intBuffer.hasRemaining()) {
            int n = intBuffer.get();
            int n2 = intBuffer.get();
            int n3 = intBuffer.get();
            this.addEdge(n, n2, n3);
        }
    }

    public void addEdges(List<Integer> list) {
        if (list == null) {
            return;
        }
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            if (!iterator.hasNext()) continue;
            int n2 = iterator.next();
            this.addEdge(n, n2);
        }
    }

    public void addEdges(IntStream intStream) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[2];
        intStream.forEachOrdered(n -> {
            int n2 = nArray[0];
            nArray2[0] = n2 + 1;
            nArray[n2] = n;
            if (nArray[0] == nArray2.length) {
                this.addEdge(nArray2[0], nArray2[1]);
                nArray2[0] = 0;
            }
        });
    }

    public void addIdEdges(IntStream intStream) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[3];
        intStream.forEachOrdered(n -> {
            int n2 = nArray[0];
            nArray2[0] = n2 + 1;
            nArray[n2] = n;
            if (nArray[0] == nArray2.length) {
                this.addEdge(nArray2[0], nArray2[1], nArray2[2]);
                nArray2[0] = 0;
            }
        });
    }

    private double checkQuality(PriorityQueue<QTri> priorityQueue, Handle handle) {
        double d;
        double d2;
        Handle handle2;
        double d3;
        if (handle.tri.color == 0) {
            return 0.0;
        }
        Vertex vertex = handle.getA();
        Vertex vertex2 = handle.getB();
        Vertex vertex3 = handle.getC();
        Point2d point2d = vertex.pt;
        Point2d point2d2 = vertex2.pt;
        Point2d point2d3 = vertex3.pt;
        double d4 = point2d.x - point2d2.x;
        double d5 = point2d.y - point2d2.y;
        double d6 = point2d2.x - point2d3.x;
        double d7 = point2d2.y - point2d3.y;
        double d8 = point2d3.x - point2d.x;
        double d9 = point2d3.y - point2d.y;
        double d10 = d4 * d4;
        double d11 = d5 * d5;
        double d12 = d6 * d6;
        double d13 = d7 * d7;
        double d14 = d8 * d8;
        double d15 = d9 * d9;
        double d16 = d10 + d11;
        double d17 = d12 + d13;
        double d18 = d14 + d15;
        if (d16 < d17 && d16 < d18) {
            d3 = d16;
            handle2 = handle.getHandleC();
            d2 = d8 * d6 + d9 * d7;
            d = d2 * d2 / (d18 * d17);
        } else if (d17 < d18) {
            d3 = d17;
            handle2 = handle;
            d2 = d4 * d8 + d5 * d9;
            d = d2 * d2 / (d16 * d18);
        } else {
            d3 = d18;
            handle2 = handle.getHandleB();
            d2 = d6 * d4 + d7 * d5;
            d = d2 * d2 / (d17 * d16);
        }
        if (this.d_checkArea) {
            d2 = 0.5 * (d4 * d7 - d5 * d6);
            double d19 = this.d_maxArea;
            if (vertex.maxArea < d19) {
                d19 = vertex.maxArea;
            }
            if (vertex2.maxArea < d19) {
                d19 = vertex2.maxArea;
            }
            if (vertex3.maxArea < d19) {
                d19 = vertex3.maxArea;
            }
            if (d2 > d19) {
                priorityQueue.offer(new QTri(handle.tri, handle.tri.v[0], handle.tri.v[1], handle.tri.v[2], d3));
            }
        }
        if (d > this.cos2min) {
            boolean bl;
            boolean bl2 = bl = handle2.isConstrained() && handle2.getHandleC().isConstrained();
            if (!bl) {
                priorityQueue.offer(new QTri(handle.tri, handle.tri.v[0], handle.tri.v[1], handle.tri.v[2], d3));
            }
        }
        return d;
    }

    private int encroachSeg(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        double d = point2d.x - point2d3.x;
        double d2 = point2d2.x - point2d3.x;
        double d3 = point2d.y - point2d3.y;
        double d4 = point2d2.y - point2d3.y;
        double d5 = d * d2 + d3 * d4;
        if (d5 > 0.0) {
            return 0;
        }
        return 1;
    }

    private static boolean isBoundary(Handle handle) {
        boolean bl = handle.tri.color != 0;
        boolean bl2 = handle.getNeighborA() != null && handle.getNeighborA().tri.color != 0;
        return bl != bl2;
    }

    private boolean checkEncroach(Queue<QEdge> queue, Handle handle) {
        Point2d point2d = handle.getA().pt;
        Point2d point2d2 = handle.getB().pt;
        Point2d point2d3 = handle.getC().pt;
        if (handle.isConstrained() && this.encroachSeg(point2d, point2d2, point2d3) == 1) {
            if (this.getRefinementOpt(1) && (this.getRefinementOpt(2) || !Mesh.isBoundary(handle))) {
                queue.offer(new QEdge(new Handle(handle.tri, handle.orient), handle.getA(), handle.getB()));
                Handle handle2 = handle.getNeighborA();
                queue.offer(new QEdge(new Handle(handle2.tri, handle2.orient), handle.getB(), handle.getA()));
            }
            return true;
        }
        return false;
    }

    private void checkEncroach(Queue<QEdge> queue, Triangle triangle) {
        this.checkEncroach(queue, new Handle(triangle, 0));
        this.checkEncroach(queue, new Handle(triangle, 1));
        this.checkEncroach(queue, new Handle(triangle, 2));
    }

    private boolean refine() {
        for (Triangle triangle : this.d_tris) {
            this.checkEncroach(this.badEdgeQ, new Handle(triangle, 0));
            this.checkEncroach(this.badEdgeQ, new Handle(triangle, 1));
            this.checkEncroach(this.badEdgeQ, new Handle(triangle, 2));
        }
        for (Triangle triangle : this.d_tris) {
            this.checkQuality(this.badTriQ, new Handle(triangle, 0));
        }
        while (!this.badTriQ.isEmpty() || !this.badEdgeQ.isEmpty()) {
            Object object;
            Object object2;
            if (!this.badEdgeQ.isEmpty()) {
                Handle handle;
                object2 = this.badEdgeQ.remove();
                if (((QEdge)object2).tri.getA() != ((QEdge)object2).a || ((QEdge)object2).tri.getB() != ((QEdge)object2).b) continue;
                boolean bl = false;
                boolean bl2 = false;
                if (((QEdge)object2).tri.tri.color != 0 && ((QEdge)object2).tri.getHandleC().isConstrained()) {
                    bl = true;
                }
                if (((QEdge)object2).tri.tri.color != 0 && ((QEdge)object2).tri.getHandleB().isConstrained()) {
                    bl2 = true;
                }
                object = ((QEdge)object2).tri.getNeighborA();
                if (((Handle)object).tri.color != 0 && ((Handle)object).getHandleC().isConstrained()) {
                    bl2 = true;
                }
                if (((Handle)object).tri.color != 0 && ((Handle)object).getHandleB().isConstrained()) {
                    bl = true;
                }
                double d = ((QEdge)object2).a.pt.x;
                double d2 = ((QEdge)object2).a.pt.y;
                double d3 = ((QEdge)object2).b.pt.x;
                double d4 = ((QEdge)object2).b.pt.y;
                double d5 = 0.5;
                if (bl && bl2) {
                    d5 = 0.5;
                } else if (bl || bl2) {
                    double d6 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
                    double d7 = 1.0;
                    while (d6 > 3.0 * d7) {
                        d7 *= 2.0;
                    }
                    while (d6 < 1.5 * d7) {
                        d7 *= 0.5;
                    }
                    d5 = d7 / d6;
                    if (bl2) {
                        d5 = 1.0 - d5;
                    }
                }
                Point2d point2d = new Point2d(d + (d3 - d) * d5, d2 + (d4 - d2) * d5);
                if (point2d.x == d && point2d.y == d2 || point2d.x == d3 && point2d.y == d4) {
                    LOGGER.log(Level.WARNING, "Split edge too many times!");
                    return false;
                }
                Vertex vertex = this.newVertex(point2d.x, point2d.y);
                Handle[] handleArray = new Handle[2];
                this.splitEdge(((QEdge)object2).tri, vertex, handleArray);
                Handle handle2 = handle = ((QEdge)object2).tri.getHandleC();
                Handle handle3 = handle;
                while (true) {
                    Vertex vertex2 = handle3.getNeighborA().getC();
                    Point2d point2d2 = handle3.getA().pt;
                    Point2d point2d3 = handle3.getB().pt;
                    Point2d point2d4 = handle3.getC().pt;
                    if (!handle3.isConstrained() && GeomTests.inCircle(point2d2, point2d3, point2d4, vertex2.pt) > 0.0) {
                        if (this.swap(handle3)) continue;
                        return false;
                    }
                    this.checkEncroach(this.badEdgeQ, handle3.tri);
                    this.checkQuality(this.badTriQ, handle3);
                    if (this.sameHandle(handle3 = handle3.getNeighborB().getHandleB(), handle2)) break;
                }
                continue;
            }
            object2 = (QTri)this.badTriQ.remove();
            Triangle triangle = ((QTri)object2).tri;
            if (triangle.v[0] != ((QTri)object2).a || triangle.v[1] != ((QTri)object2).b || triangle.v[2] != ((QTri)object2).c) continue;
            Point2d point2d = this.circumcenter(new Handle(triangle, 0));
            object = this.newVertex(point2d.x, point2d.y);
            int n = this.insertVertex((Vertex)object, new Handle(triangle, 0), true);
            if (n != ENCROACHING) continue;
            this.undoVertex();
        }
        return true;
    }

    private void CheckSuperTriColor() {
        for (Triangle triangle : this.d_tris) {
            if (triangle.v[0].id != this.d_infV1.id && triangle.v[0].id != this.d_infV2.id && triangle.v[0].id != this.d_infV3.id && triangle.v[1].id != this.d_infV1.id && triangle.v[1].id != this.d_infV2.id && triangle.v[1].id != this.d_infV3.id && triangle.v[2].id != this.d_infV1.id && triangle.v[2].id != this.d_infV2.id && triangle.v[2].id != this.d_infV3.id || triangle.color == 0) continue;
            LOGGER.log(Level.WARNING, "bad color on outer triangle");
        }
    }

    private Point2d circumcenter(Handle handle) {
        Point2d point2d = handle.getA().pt;
        Point2d point2d2 = handle.getB().pt;
        Point2d point2d3 = handle.getC().pt;
        double d = point2d2.x - point2d.x;
        double d2 = point2d2.y - point2d.y;
        double d3 = point2d3.x - point2d.x;
        double d4 = point2d3.y - point2d.y;
        double d5 = d * d + d2 * d2;
        double d6 = d3 * d3 + d4 * d4;
        double d7 = 0.5 / GeomTests.orient2d(point2d2, point2d3, point2d);
        double d8 = (d4 * d5 - d2 * d6) * d7;
        double d9 = (d * d6 - d3 * d5) * d7;
        return new Point2d(point2d.x + d8, point2d.y + d9);
    }

    public void setMinAngle(double d) {
        this.minAngle = d;
        this.cosmin = Math.cos(d * Math.PI / 180.0);
        this.cos2min = this.cosmin * this.cosmin;
    }

    public void setRefinementOptions(int n) {
        this.d_refOpts = n;
    }

    public int getRefinementOptions() {
        return this.d_refOpts;
    }

    public void setMaxArea(double d) {
        this.d_maxArea = d;
        this.d_checkArea = d < Double.MAX_VALUE;
    }

    private boolean getRefinementOpt(int n) {
        return (this.d_refOpts & n) == n;
    }

    public boolean triangulateEvenOdd(int n) {
        return this.triangulateEvenOdd(n, 20.0);
    }

    public boolean triangulateEvenOdd(int n, double d) {
        if (this.d_edges.size() < 3) {
            return false;
        }
        return this.triangulate(n, d, new TriangulateFilter(){

            @Override
            public boolean filter(int n, Point2d point2d) {
                return n % 2 != 0;
            }
        });
    }

    public boolean triangulateConvexHull(int n) {
        return this.triangulateConvexHull(n, this.minAngle);
    }

    public boolean triangulateConvexHull(int n, double d) {
        return this.triangulate(n, d, new TriangulateFilter(){

            @Override
            public boolean filter(int n, Point2d point2d) {
                return false;
            }
        });
    }

    public boolean triangulate(int n, double d, TriangulateFilter triangulateFilter) {
        if (this.d_verts.size() < 3) {
            return false;
        }
        this.minAngle = d;
        this.cosmin = Math.cos(d * Math.PI / 180.0);
        this.cos2min = this.cosmin * this.cosmin;
        this.d_random = new Random(0L);
        this.init();
        Handle handle = new Handle(this.d_tris.get(0), 0);
        for (Vertex object2 : this.d_verts) {
            if (object2.id == this.d_verts.size() - 2) break;
            int n2 = this.insertVertex(object2, null);
            if (n2 != ERROR) continue;
            return false;
        }
        ArrayDeque arrayDeque = new ArrayDeque();
        ArrayDeque<Edge> arrayDeque2 = new ArrayDeque<Edge>();
        for (Edge edge : this.d_edges) {
            int d2;
            Point2d point2d = this.d_verts.get((int)(edge.v1 - 1)).pt;
            Point2d point2d2 = this.d_verts.get((int)(edge.v2 - 1)).pt;
            int n3 = this.findTriangle(point2d, null, handle);
            n3 = this.findEdgeStart(new Handle(handle), point2d2, handle);
            arrayDeque.clear();
            arrayDeque2.clear();
            if (n3 == 2) {
                if (handle.getB().pt.equals(point2d2)) {
                    this.markEdge(handle, edge.id);
                    continue;
                }
                if (handle.getC().pt.equals(point2d2)) {
                    this.markEdge(handle.getHandleC(), edge.id);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Triangulation error imposing constraints");
                return false;
            }
            arrayDeque.offer(new Edge(handle.getB().id, handle.getC().id, -1));
            Handle handle2 = handle.getNeighborB();
            while (true) {
                double edge2;
                if ((edge2 = GeomTests.orient2d(point2d, point2d2, handle2.getC().pt)) > 0.0) {
                    arrayDeque.offer(new Edge(handle2.getB().id, handle2.getC().id, -1));
                    handle2 = handle2.getNeighborB();
                    continue;
                }
                if (edge2 < 0.0) {
                    arrayDeque.offer(new Edge(handle2.getA().id, handle2.getC().id, -1));
                    handle2 = handle2.getNeighborC();
                    continue;
                }
                if (edge2 == 0.0) break;
            }
            if (!handle2.getC().pt.equals(point2d2)) assert (false);
            while (!arrayDeque.isEmpty()) {
                Edge edge2 = (Edge)arrayDeque.remove();
                Handle handle3 = this.findEdge(edge2.v1, edge2.v2);
                if (handle3 == null) {
                    // empty if block
                }
                if (this.isConvex(handle3)) {
                    if (!this.swap(handle3)) {
                        return false;
                    }
                    int edge3 = handle3.getB().id;
                    int handle32 = handle3.getC().id;
                    if (edge3 != edge.v1 && edge3 != edge.v2 && handle32 != edge.v1 && handle32 != edge.v2) {
                        double point2d6 = GeomTests.orient2d(point2d, point2d2, handle3.getB().pt);
                        double point2d4 = GeomTests.orient2d(point2d, point2d2, handle3.getC().pt);
                        if (point2d6 < 0.0 && point2d4 > 0.0 || point2d6 > 0.0 && point2d4 < 0.0) {
                            point2d6 = GeomTests.orient2d(handle3.getB().pt, handle3.getC().pt, point2d);
                            point2d4 = GeomTests.orient2d(handle3.getB().pt, handle3.getC().pt, point2d2);
                            if (point2d6 < 0.0 && point2d4 > 0.0 || point2d6 > 0.0 && point2d4 < 0.0) {
                                arrayDeque.offer(new Edge(edge3, handle32, -1));
                                continue;
                            }
                        }
                    }
                    if (!(edge3 != edge.v1 && edge3 != edge.v2 || handle32 != edge.v1 && handle32 != edge.v2)) {
                        this.markEdge(handle3.getHandleB(), edge.id);
                        continue;
                    }
                    arrayDeque2.offer(new Edge(edge3, handle32, -1));
                    continue;
                }
                arrayDeque.offer(edge2);
            }
            do {
                d2 = 0;
                for (Edge edge3 : arrayDeque2) {
                    Point2d point2d3;
                    Point2d point2d4;
                    Point2d point2d5;
                    Point2d point2d6;
                    Handle handle4 = this.findEdge(edge3.v1, edge3.v2);
                    if (handle4 == null || !(GeomTests.inCircle(point2d6 = handle4.getA().pt, point2d5 = handle4.getB().pt, point2d4 = handle4.getC().pt, point2d3 = handle4.getNeighborA().getC().pt) > 0.0)) continue;
                    if (!this.isConvex(handle4)) {
                        return false;
                    }
                    if (!this.swap(handle4)) {
                        return false;
                    }
                    edge3.v1 = handle4.getB().id;
                    edge3.v2 = handle4.getC().id;
                    ++d2;
                }
            } while (d2 > 0);
        }
        int n4 = this.classify(triangulateFilter);
        assert (n4 > 0);
        if ((n & 1) == 1) {
            this.refine();
        }
        if ((n & 2) == 2) {
            this.colorTriangles();
        }
        this.markBoundary();
        return true;
    }

    private void markBoundary() {
        for (Triangle triangle : this.d_tris) {
            for (int i = 0; i < 3; ++i) {
                Handle handle = new Handle(triangle, i);
                if (!Mesh.isBoundary(handle) || handle.isConstrained()) continue;
                this.markEdge(handle, 1);
            }
        }
    }

    private int insertVertex(Vertex vertex, Handle handle) {
        return this.insertVertex(vertex, handle, false);
    }

    private int insertVertex(Vertex vertex, Handle handle, boolean bl) {
        Handle handle2 = new Handle();
        int n = this.findTriangle(vertex.pt, handle, handle2);
        Handle[] handleArray = new Handle[2];
        if (n == 1) {
            if (bl && handle2.tri.color == 0) {
                return 4;
            }
            this.split(handle2, vertex, handleArray);
        } else if (n == 2) {
            if (bl && handle2.isConstrained()) {
                return 4;
            }
            this.splitEdge(handle2, vertex, handleArray);
            handle2 = handle2.getHandleC();
        } else {
            if (n == 4) {
                return 4;
            }
            if (n == 3) {
                LOGGER.log(Level.WARNING, "***ERROR - hit vertex during insert");
                return 3;
            }
        }
        this.d_undoType = n;
        this.d_undoVertexTri1 = handleArray[0];
        this.d_undoVertexTri2 = handleArray[1];
        this.d_undoStack.clear();
        boolean bl2 = false;
        Handle handle3 = handle2;
        Vertex vertex2 = handle3.getA();
        while (true) {
            Vertex vertex3 = handle3.getNeighborA().getC();
            Point2d point2d = handle3.getA().pt;
            Point2d point2d2 = handle3.getB().pt;
            Point2d point2d3 = handle3.getC().pt;
            if (!handle3.isConstrained() && GeomTests.inCircle(point2d, point2d2, point2d3, vertex3.pt) > 0.0) {
                if (!this.swap2(handle3)) {
                    return ERROR;
                }
                this.d_undoStack.push(handle3);
                handle3 = handle3.getHandleC();
                continue;
            }
            if (bl) {
                this.checkQuality(this.badTriQ, handle3);
                if (this.checkEncroach(this.badEdgeQ, handle3) || this.checkEncroach(this.badEdgeQ, handle3.getHandleB()) || this.checkEncroach(this.badEdgeQ, handle3.getHandleC())) {
                    bl2 = true;
                }
            }
            if ((handle3 = handle3.getNeighborB().getHandleB()).getA() == vertex2) break;
        }
        if (bl2) {
            return ENCROACHING;
        }
        return SUCCESS;
    }

    private boolean undoVertex() {
        Object object;
        while (!this.d_undoStack.isEmpty()) {
            object = this.d_undoStack.pop();
            this.unswap((Handle)object);
        }
        object = this.d_undoVertexTri1.getC();
        if (this.d_undoType == 1) {
            this.unsplit(this.d_undoVertexTri1, this.d_undoVertexTri2);
            this.deleteVertex((Vertex)object);
        } else if (this.d_undoType == 2) {
            this.unsplitEdge(this.d_undoVertexTri1, this.d_undoVertexTri2);
            this.deleteVertex((Vertex)object);
        }
        return true;
    }

    private void unsplit(Handle handle, Handle handle2) {
        assert (handle.getC().id == handle2.getC().id);
        Handle handle3 = handle.getNeighborA();
        Handle handle4 = handle2.getNeighborA();
        Vertex vertex = handle.getB();
        Handle handle5 = handle.getNeighborC().getHandleC();
        handle5.setC(vertex);
        this.bond(handle5.getHandleB(), handle3);
        this.bond(handle5.getHandleC(), handle4);
        assert (!handle5.getHandleB().isConstrained());
        assert (!handle5.getHandleC().isConstrained());
        handle5.getHandleB().setEdgeId(handle3.getEdgeId());
        handle5.getHandleC().setEdgeId(handle4.getEdgeId());
        this.deleteTriangle(handle2.tri);
        this.deleteTriangle(handle.tri);
    }

    private void unsplitEdge(Handle handle, Handle handle2) {
        assert (handle.getC().id == handle2.getC().id);
        Handle handle3 = handle.getNeighborA();
        Handle handle4 = handle2.getNeighborA();
        Vertex vertex = handle.getA();
        Handle handle5 = handle.getNeighborB().getHandleC();
        Handle handle6 = handle2.getNeighborC().getHandleB();
        handle5.setB(vertex);
        handle6.setA(vertex);
        this.bond(handle5.getHandleB(), handle3);
        this.bond(handle6.getHandleC(), handle4);
        handle5.getHandleB().setEdgeId(handle3.getEdgeId());
        handle6.getHandleC().setEdgeId(handle4.getEdgeId());
        this.deleteTriangle(handle2.tri);
        this.deleteTriangle(handle.tri);
    }

    private static <T> void rremove(List<T> list, T t) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).equals(t)) continue;
            list.remove(i);
            return;
        }
    }

    private void deleteTriangle(Triangle triangle) {
        assert (triangle.id == this.d_tris.size());
        Mesh.rremove(this.d_tris, triangle);
        triangle.id = -1;
        triangle.v[2] = null;
        triangle.v[1] = null;
        triangle.v[0] = null;
        triangle.tri[2] = null;
        triangle.tri[1] = null;
        triangle.tri[0] = null;
    }

    private void deleteVertex(Vertex vertex) {
        assert (vertex.id == this.d_verts.size());
        Mesh.rremove(this.d_verts, vertex);
    }

    private int addVoronoiVertex(Point2d point2d) {
        this.d_voronoiVerts.add(point2d);
        return this.d_voronoiVerts.size();
    }

    private int getVoronoiMidVertex(int n, int n2) {
        assert (n != n2);
        Pair<Integer, Integer> pair = n < n2 ? new Pair<Integer, Integer>(n, n2) : new Pair<Integer, Integer>(n2, n);
        if (this.d_voronoiMidPts.containsKey(pair)) {
            int n3 = this.d_voronoiMidPts.get(pair);
            return n3;
        }
        Point2d point2d = this.d_verts.get((int)(n - 1)).pt;
        Point2d point2d2 = this.d_verts.get((int)(n2 - 1)).pt;
        double d = (point2d.x + point2d2.x) / 2.0;
        double d2 = (point2d.y + point2d2.y) / 2.0;
        Point2d point2d3 = new Point2d(d, d2);
        int n4 = this.addVoronoiVertex(point2d3);
        this.d_voronoiMidPts.put(pair, n4);
        return n4;
    }

    private List<Integer> newPolygon() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.d_polys.add(arrayList);
        return arrayList;
    }

    private List<Integer> newPolygonAdj() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.d_adjPolys.add(arrayList);
        return arrayList;
    }

    private void updateVoronoiData() {
        this.d_polys = new ArrayList<List<Integer>>();
        this.d_adjPolys = new ArrayList<List<Integer>>();
        this.d_voronoiVerts = new ArrayList<Point2d>();
        this.d_voronoiMidPts = new HashMap<Pair<Integer, Integer>, Integer>();
        this.d_polymap = new int[this.d_verts.size()];
        int n = 0;
        for (Triangle triangle : this.d_tris) {
            assert (++n == triangle.id);
            Point2d point2d = this.circumcenter(new Handle(triangle, 0));
            this.addVoronoiVertex(point2d);
        }
        double d = GeomTests.orient2d(this.d_infV1.pt, this.d_infV2.pt, this.d_infV3.pt);
        double d2 = d * 1.0E-20;
        int n2 = 0;
        for (Vertex vertex : this.d_verts) {
            if (vertex.id == this.d_infV1.id || vertex.id == this.d_infV2.id || vertex.id == this.d_infV3.id) {
                this.d_polymap[vertex.id - 1] = -1;
                continue;
            }
            this.d_polymap[vertex.id - 1] = n2++;
        }
        for (Vertex vertex : this.d_verts) {
            if (vertex.id == this.d_infV1.id || vertex.id == this.d_infV2.id || vertex.id == this.d_infV3.id) continue;
            Handle handle = new Handle(this.d_tris.get(0), 0);
            int n3 = this.findTriangle(vertex.pt, null, handle);
            if (n3 != 3) {
                LOGGER.log(Level.WARNING, "not ONVERTEX in updateVoronoiData");
                continue;
            }
            List<Integer> list = this.newPolygon();
            List<Integer> list2 = this.newPolygonAdj();
            int n4 = handle.tri.id;
            Point2d point2d = null;
            Point2d point2d2 = null;
            do {
                int n5;
                double d3;
                Point2d point2d3;
                int n6;
                int n7;
                Handle handle2 = handle.getNeighborA().getHandleB();
                Handle handle3 = handle.getNeighborC();
                if (handle2.tri.color != 0 && handle.tri.color == 0) {
                    Point2d point2d4;
                    double d4;
                    n7 = this.getVoronoiMidVertex(vertex.id, handle.getB().id);
                    point2d = this.d_voronoiVerts.get(n7 - 1);
                    this.addPolyPoint(list, n7 - 1, list2, -1);
                    if (handle.tri.color == 0 && handle3.tri.color != 0) {
                        n6 = this.getVoronoiMidVertex(vertex.id, handle3.getB().id);
                        point2d3 = this.d_voronoiVerts.get(n6 - 1);
                        d3 = GeomTests.orient2d(point2d, point2d3, vertex.pt);
                        if (Math.abs(d3) > d2) {
                            n5 = this.addVoronoiVertex(vertex.pt);
                            this.addPolyPoint(list, n5 - 1, list2, -1);
                        }
                        this.addPolyPoint(list, n6 - 1, list2, handle3.getB().id - 1);
                    } else if (point2d2 != null && Math.abs(d4 = GeomTests.orient2d(point2d, point2d2, point2d4 = this.d_voronoiVerts.get(list.get(0)))) <= d2) {
                        list.remove(0);
                        list2.remove(0);
                    }
                } else if (handle.tri.color == 0 && handle3.tri.color != 0) {
                    if (point2d != null) {
                        Point2d point2d5 = point2d;
                        n6 = this.getVoronoiMidVertex(vertex.id, handle3.getB().id);
                        point2d2 = point2d3 = this.d_voronoiVerts.get(n6 - 1);
                        d3 = GeomTests.orient2d(point2d5, point2d3, vertex.pt);
                        if (Math.abs(d3) > d2) {
                            n5 = this.addVoronoiVertex(vertex.pt);
                            this.addPolyPoint(list, n5 - 1, list2, -1);
                        }
                        this.addPolyPoint(list, n6 - 1, list2, handle3.getB().id - 1);
                    } else {
                        n7 = this.addVoronoiVertex(vertex.pt);
                        this.addPolyPoint(list, n7 - 1, list2, -1);
                        n6 = this.getVoronoiMidVertex(vertex.id, handle3.getB().id);
                        this.addPolyPoint(list, n6 - 1, list2, handle3.getB().id - 1);
                        point2d2 = this.d_voronoiVerts.get(n6 - 1);
                    }
                } else if (!(handle2.tri.color == 0 && handle.tri.color == 0 && handle3.tri.color == 0 || handle2.tri.color != 0 && handle.tri.color == 0 && handle3.tri.color != 0)) {
                    this.addPolyPoint(list, handle.tri.id - 1, list2, handle.getC().id - 1);
                }
                handle = handle3;
            } while (handle.tri.id != n4);
            this.checkPoly(list, list2);
        }
    }

    private boolean addPolyPoint(List<Integer> list, int n, List<Integer> list2, int n2) {
        n2 = n2 == -1 ? -1 : this.d_polymap[n2];
        int n3 = list.size();
        if (n3 > 0 && this.d_voronoiVerts.get(list.get(n3 - 1)).equals(this.d_voronoiVerts.get(n))) {
            list2.set(list2.size() - 1, n2);
            return false;
        }
        list.add(n);
        list2.add(n2);
        return true;
    }

    private void checkPoly(List<Integer> list, List<Integer> list2) {
        if (list.isEmpty()) {
            return;
        }
        if (this.d_voronoiVerts.get(list.get(0)).equals(this.d_voronoiVerts.get(list.get(list.size() - 1)))) {
            list.remove(list.size() - 1);
            list2.remove(list2.size() - 1);
        }
        assert (list.size() == list2.size());
    }

    public VoronoiInfo getVoronoiOutput() {
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        int n4;
        this.updateVoronoiData();
        VoronoiInfo voronoiInfo = new VoronoiInfo();
        Point2d[] point2dArray = new Point2d[this.d_voronoiVerts.size()];
        for (n4 = 0; n4 < this.d_polys.size(); ++n4) {
            object2 = this.d_polys.get(n4);
            for (n3 = 0; n3 < object2.size(); ++n3) {
                n2 = (Integer)object2.get(n3);
                point2dArray[n2] = this.d_voronoiVerts.get(n2);
            }
        }
        n4 = 0;
        object2 = point2dArray;
        n3 = ((Point2d[])object2).length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = object2[n2];
            if (object == null) continue;
            ++n4;
        }
        int n5 = 0;
        voronoiInfo.points = new Point2d[n4];
        int[] nArray = new int[point2dArray.length];
        for (n2 = 0; n2 < point2dArray.length; ++n2) {
            object = point2dArray[n2];
            if (object == null) continue;
            nArray[n2] = n = n5++;
            voronoiInfo.points[n] = object;
        }
        voronoiInfo.polys = new int[this.d_polys.size()][];
        for (n2 = 0; n2 < this.d_polys.size(); ++n2) {
            object = this.d_polys.get(n2);
            voronoiInfo.polys[n2] = new int[object.size()];
            for (n = 0; n < object.size(); ++n) {
                voronoiInfo.polys[n2][n] = nArray[object.get(n)];
            }
        }
        voronoiInfo.adjPolys = new int[this.d_adjPolys.size()][];
        for (n2 = 0; n2 < this.d_adjPolys.size(); ++n2) {
            object = this.d_adjPolys.get(n2);
            voronoiInfo.adjPolys[n2] = new int[object.size()];
            for (n = 0; n < object.size(); ++n) {
                voronoiInfo.adjPolys[n2][n] = object.get(n);
            }
        }
        return voronoiInfo;
    }

    public void writeVoronoi() {
        try {
            Object object;
            int n;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("voronoi.data")));
            VoronoiInfo voronoiInfo = this.getVoronoiOutput();
            printWriter.println(voronoiInfo.points.length);
            for (n = 0; n < voronoiInfo.points.length; ++n) {
                object = voronoiInfo.points[n];
                printWriter.println(((Point2d)object).x + " " + ((Point2d)object).y);
            }
            printWriter.println(voronoiInfo.polys.length);
            for (n = 0; n < voronoiInfo.polys.length; ++n) {
                object = voronoiInfo.polys[n];
                printWriter.print(((Object)object).length);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    printWriter.print(" " + (int)object[i]);
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
        }
    }

    public void writeVoronoiOld() {
        try {
            int n;
            Object object;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("voronoi.data")));
            int n2 = 0;
            for (Triangle list2 : this.d_tris) {
                assert (++n2 == list2.id);
                object = this.circumcenter(new Handle(list2, 0));
                this.addVoronoiVertex((Point2d)object);
            }
            for (Vertex vertex : this.d_verts) {
                if (vertex.id == this.d_infV1.id || vertex.id == this.d_infV2.id || vertex.id == this.d_infV3.id) continue;
                LOGGER.log(Level.FINER, "around v " + vertex.id);
                object = new Handle(this.d_tris.get(0), 0);
                int n3 = this.findTriangle(vertex.pt, null, (Handle)object);
                assert (n3 == 3);
                List<Integer> list = this.newPolygon();
                int n4 = ((Handle)object).tri.id;
                do {
                    int n5;
                    Handle handle = ((Handle)object).getNeighborA().getHandleB();
                    Handle handle2 = ((Handle)object).getNeighborC();
                    LOGGER.log(Level.FINER, handle.tri.color + " " + ((Handle)object).tri.color + " " + handle2.tri.color);
                    if (handle.tri.color != 0 && ((Handle)object).tri.color == 0) {
                        LOGGER.log(Level.FINER, "leaving mesh, use midpoint " + vertex.id);
                        n5 = this.getVoronoiMidVertex(vertex.id, ((Handle)object).getB().id);
                        LOGGER.log(Level.FINER, "  mid: " + n5);
                        list.add(n5 - 1);
                    } else if (((Handle)object).tri.color == 0 && handle2.tri.color != 0) {
                        LOGGER.log(Level.FINER, "entering mesh, use midpoint " + vertex.id);
                        n5 = this.addVoronoiVertex(vertex.pt);
                        list.add(n5 - 1);
                        int n6 = this.getVoronoiMidVertex(vertex.id, handle2.getB().id);
                        list.add(n6 - 1);
                        LOGGER.log(Level.FINER, "  mid: " + n6);
                    } else if (handle.tri.color == 0 && ((Handle)object).tri.color == 0 && handle2.tri.color == 0) {
                        LOGGER.log(Level.FINER, "corner??? " + vertex.id);
                    } else if (handle.tri.color != 0 && ((Handle)object).tri.color == 0 && handle2.tri.color != 0) {
                        LOGGER.log(Level.FINER, "corner 2 ??? " + vertex.id);
                    } else {
                        list.add(((Handle)object).tri.id - 1);
                    }
                    object = handle2;
                } while (((Handle)object).tri.id != n4);
            }
            printWriter.println(this.d_voronoiVerts.size());
            for (n = 0; n < this.d_voronoiVerts.size(); ++n) {
                Point2d point2d = this.d_voronoiVerts.get(n);
                printWriter.println(point2d.x + " " + point2d.y);
            }
            printWriter.println(this.d_verts.size() - 3);
            for (n = 0; n < this.d_polys.size(); ++n) {
                List<Integer> list = this.d_polys.get(n);
                printWriter.print(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    printWriter.print(" " + list.get(i));
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
        }
    }

    boolean isConvex(Handle handle) {
        Point2d point2d = handle.getA().pt;
        Point2d point2d2 = handle.getB().pt;
        Point2d point2d3 = handle.getC().pt;
        Point2d point2d4 = handle.getNeighborA().getC().pt;
        double d = GeomTests.orient2d(point2d3, point2d4, point2d2);
        double d2 = GeomTests.orient2d(point2d4, point2d3, point2d);
        return d > 0.0 && d2 > 0.0;
    }

    void markEdge(Handle handle, int n) {
        handle.setEdgeId(n);
        handle.getNeighborA().setEdgeId(n);
    }

    Handle findEdge(int n, int n2) {
        Handle handle = new Handle(this.d_tris.get(0), 0);
        int n3 = this.findTriangle(this.d_verts.get((int)(n - 1)).pt, null, handle);
        assert (n3 == 3);
        int n4 = handle.getB().id;
        do {
            if (handle.getB().id == n2) {
                return handle;
            }
            handle = handle.getNeighborC();
        } while (handle.getB().id != n4);
        return null;
    }

    int findEdgeStart(Handle handle, Point2d point2d, Handle handle2) {
        boolean bl;
        boolean bl2;
        Point2d point2d2 = handle.getA().pt;
        Point2d point2d3 = handle.getC().pt;
        double d = GeomTests.orient2d(point2d2, point2d, point2d3);
        boolean bl3 = bl2 = d < 0.0;
        while (bl2) {
            handle = handle.getNeighborC();
            d = GeomTests.orient2d(handle.getA().pt, point2d, handle.getC().pt);
            bl2 = d < 0.0;
        }
        double d2 = GeomTests.orient2d(handle.getA().pt, point2d, handle.getB().pt);
        boolean bl4 = bl = d2 > 0.0;
        while (bl) {
            handle = handle.getNeighborA().getHandleB();
            d2 = GeomTests.orient2d(handle.getA().pt, point2d, handle.getB().pt);
            bl = d2 > 0.0;
        }
        handle2.tri = handle.tri;
        handle2.orient = handle.orient;
        d = GeomTests.orient2d(handle.getA().pt, point2d, handle.getC().pt);
        if (d == 0.0 || d2 == 0.0) {
            return 2;
        }
        return 1;
    }

    private boolean swap(Handle handle) {
        if (handle.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex vertex = handle.getC();
        Handle handle2 = handle.getNeighborA();
        Vertex vertex2 = handle2.getC();
        if (handle.tri.color == 0 || handle2.tri.color == 0) {
            handle.tri.color = 0;
            handle2.tri.color = 0;
        }
        handle.setB(vertex2);
        handle2.setB(vertex);
        this.bond(handle2.getNeighborB(), handle);
        this.bond(handle.getNeighborB(), handle2);
        this.bond(handle.getHandleB(), handle2.getHandleB());
        this.markEdge(handle, handle2.getHandleB().getEdgeId());
        handle2.getHandleB().setUnconstrained();
        this.markEdge(handle2, handle.getHandleB().getEdgeId());
        handle.getHandleB().setUnconstrained();
        return true;
    }

    private boolean swap2(Handle handle) {
        if (handle.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex vertex = handle.getA();
        Vertex vertex2 = handle.getB();
        Vertex vertex3 = handle.getC();
        Handle handle2 = handle.getNeighborA();
        Vertex vertex4 = handle2.getC();
        if (handle.tri.color == 0 || handle2.tri.color == 0) {
            handle.tri.color = 0;
            handle2.tri.color = 0;
        }
        handle.setA(vertex4);
        handle.setB(vertex3);
        handle.setC(vertex);
        handle2.setA(vertex3);
        handle2.setB(vertex4);
        handle2.setC(vertex2);
        Handle handle3 = handle.getNeighborB();
        Handle handle4 = handle.getNeighborC();
        Handle handle5 = handle2.getNeighborB();
        Handle handle6 = handle2.getNeighborC();
        this.bond(handle.getHandleB(), handle4);
        this.bond(handle.getHandleC(), handle5);
        this.bond(handle2.getHandleB(), handle6);
        this.bond(handle2.getHandleC(), handle3);
        Arrays.fill(handle.tri.edgeIds, 0);
        Arrays.fill(handle2.tri.edgeIds, 0);
        this.markEdge(handle3, handle3.getEdgeId());
        this.markEdge(handle4, handle4.getEdgeId());
        this.markEdge(handle5, handle5.getEdgeId());
        this.markEdge(handle6, handle6.getEdgeId());
        return true;
    }

    private boolean unswap(Handle handle) {
        if (handle.isConstrained()) {
            LOGGER.log(Level.WARNING, "error -- trying to swap constrained edge");
            return false;
        }
        Vertex vertex = handle.getA();
        Vertex vertex2 = handle.getB();
        Vertex vertex3 = handle.getC();
        Handle handle2 = handle.getNeighborA();
        Vertex vertex4 = handle2.getC();
        if (handle.tri.color == 0 || handle2.tri.color == 0) {
            handle.tri.color = 0;
            handle2.tri.color = 0;
        }
        handle.setA(vertex3);
        handle.setB(vertex4);
        handle.setC(vertex2);
        handle2.setA(vertex4);
        handle2.setB(vertex3);
        handle2.setC(vertex);
        Handle handle3 = handle.getNeighborB();
        Handle handle4 = handle.getNeighborC();
        Handle handle5 = handle2.getNeighborB();
        Handle handle6 = handle2.getNeighborC();
        this.bond(handle2.getHandleB(), handle4);
        this.bond(handle2.getHandleC(), handle5);
        this.bond(handle.getHandleB(), handle6);
        this.bond(handle.getHandleC(), handle3);
        Arrays.fill(handle.tri.edgeIds, 0);
        Arrays.fill(handle2.tri.edgeIds, 0);
        this.markEdge(handle3, handle3.getEdgeId());
        this.markEdge(handle4, handle4.getEdgeId());
        this.markEdge(handle5, handle5.getEdgeId());
        this.markEdge(handle6, handle6.getEdgeId());
        return true;
    }

    private int classify(TriangulateFilter triangulateFilter) {
        this.initAndMarkBoundary();
        ArrayDeque<Triangle> arrayDeque = new ArrayDeque<Triangle>();
        ArrayDeque arrayDeque2 = new ArrayDeque();
        ArrayDeque<Triangle> arrayDeque3 = arrayDeque;
        boolean bl = this.markLevel1Tris(triangulateFilter, arrayDeque3);
        ArrayDeque<Triangle> arrayDeque4 = arrayDeque3;
        arrayDeque3 = arrayDeque2;
        int n = 2;
        while (!arrayDeque4.isEmpty()) {
            Triangle triangle = (Triangle)arrayDeque4.pop();
            if (triangle.color == -1) {
                this.markTriangle(triangle, (short)n, arrayDeque3, triangulateFilter);
            }
            if (!arrayDeque4.isEmpty()) continue;
            ++n;
            ArrayDeque<Triangle> arrayDeque5 = arrayDeque4;
            arrayDeque4 = arrayDeque3;
            arrayDeque3 = arrayDeque5;
        }
        int n2 = n;
        if (!bl) {
            --n2;
        }
        return n2;
    }

    private void initAndMarkBoundary() {
        for (Triangle triangle : this.d_tris) {
            if (triangle.v[0].id == this.d_infV1.id || triangle.v[0].id == this.d_infV2.id || triangle.v[0].id == this.d_infV3.id || triangle.v[1].id == this.d_infV1.id || triangle.v[1].id == this.d_infV2.id || triangle.v[1].id == this.d_infV3.id || triangle.v[2].id == this.d_infV1.id || triangle.v[2].id == this.d_infV2.id || triangle.v[2].id == this.d_infV3.id) {
                triangle.color = 0;
                continue;
            }
            triangle.color = (short)-1;
        }
    }

    private boolean markLevel1Tris(TriangulateFilter triangulateFilter, Deque<Triangle> deque) {
        boolean bl = false;
        for (Triangle triangle : this.d_tris) {
            if (triangle.color != 0) continue;
            for (int i = 0; i < 3; ++i) {
                if (triangle.tri[i].tri.color == -1 && triangle.isConstrained(i)) {
                    deque.add(triangle.tri[i].tri);
                    continue;
                }
                if (triangle.tri[i].tri.color != -1 || triangle.isConstrained(i)) continue;
                bl = true;
                this.markTriangle(triangle.tri[i].tri, (short)1, deque, triangulateFilter);
            }
        }
        return bl;
    }

    private static Point2d centroid(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return new Point2d((point2d.x + point2d2.x + point2d3.x) / 3.0, (point2d.y + point2d2.y + point2d3.y) / 3.0);
    }

    private void markTriangle(Triangle triangle, short s, Deque<Triangle> deque, TriangulateFilter triangulateFilter) {
        assert (triangle.color == -1);
        boolean bl = triangulateFilter.filter(s, triangle.centroid());
        if (bl) {
            s = 0;
        }
        ArrayDeque<Triangle> arrayDeque = new ArrayDeque<Triangle>();
        arrayDeque.push(triangle);
        while (!arrayDeque.isEmpty()) {
            Triangle triangle2 = (Triangle)arrayDeque.pop();
            if (triangle2.color == s) continue;
            triangle2.color = s;
            for (int i = 0; i < 3; ++i) {
                boolean bl2 = triangle2.isConstrained(i);
                if (bl2 && triangle2.tri[i].tri.color == -1) {
                    deque.push(triangle2.tri[i].tri);
                    continue;
                }
                if (bl2 || triangle2.tri[i].tri.color != -1) continue;
                arrayDeque.push(triangle2.tri[i].tri);
            }
        }
    }

    private void colorTriangles() {
        ArrayDeque<Handle> arrayDeque = new ArrayDeque<Handle>();
        arrayDeque.push(this.d_outside);
        while (!arrayDeque.isEmpty()) {
            Handle handle = (Handle)arrayDeque.pop();
            int n = handle.getNeighborA().tri.color2;
            int n2 = handle.getNeighborB().tri.color2;
            int n3 = handle.getNeighborC().tri.color2;
            handle.tri.color2 = this.chooseColor(n, n2, n3);
            if (n == -1) {
                arrayDeque.push(handle.getNeighborA());
            }
            if (n2 == -1) {
                arrayDeque.push(handle.getNeighborB());
            }
            if (n3 != -1) continue;
            arrayDeque.push(handle.getNeighborC());
        }
    }

    private int chooseColor(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n == 0 || n2 == 0 || n3 == 0) {
            bl = true;
        }
        if (n == 1 || n2 == 1 || n3 == 1) {
            bl2 = true;
        }
        if (n == 2 || n2 == 2 || n3 == 2) {
            bl3 = true;
        }
        if (n == 3 || n2 == 3 || n3 == 3) {
            bl4 = true;
        }
        if (!bl) {
            return 0;
        }
        if (!bl2) {
            return 1;
        }
        if (!bl3) {
            return 2;
        }
        if (!bl4) {
            return 3;
        }
        return -1;
    }

    private void init() {
        this.d_resultTris = null;
        this.d_tris.clear();
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (Vertex vertex : this.d_verts) {
            d = Math.min(d, vertex.pt.x);
            d2 = Math.max(d2, vertex.pt.x);
            d3 = Math.min(d3, vertex.pt.y);
            d4 = Math.max(d4, vertex.pt.y);
        }
        double d5 = Math.max(d2 - d, d4 - d3);
        Vertex vertex = this.d_infV1 = this.newVertex(d - 50.0 * d5, d3 - 40.0 * d5);
        Vertex vertex2 = this.d_infV2 = this.newVertex(d2 + 50.0 * d5, d3 - 40.0 * d5);
        Vertex vertex3 = this.d_infV3 = this.newVertex(d + 0.5 * d5, d4 + 60.0 * d5);
        Triangle triangle = new Triangle(vertex, vertex3, vertex2);
        this.d_outside = new Handle(triangle, 0);
        Handle handle = this.newTriangle(vertex, vertex2, vertex3);
        this.bond(handle, this.d_outside.getHandleC());
        this.bond(handle.getHandleB(), this.d_outside.getHandleB());
        this.bond(handle.getHandleC(), this.d_outside);
    }

    private void bond(Handle handle, Handle handle2) {
        assert (handle.getA() == handle2.getB());
        assert (handle2.getA() == handle.getB());
        handle.setNeighborA(handle2);
        handle2.setNeighborA(handle);
    }

    private void split(Handle handle, Vertex vertex, Handle[] handleArray) {
        Vertex vertex2 = handle.getA();
        Vertex vertex3 = handle.getB();
        Vertex vertex4 = handle.getC();
        handle.setC(vertex);
        Handle handle2 = this.newTriangle(vertex3, vertex4, vertex);
        Handle handle3 = this.newTriangle(vertex4, vertex2, vertex);
        handle2.tri.color = handle.tri.color;
        handle3.tri.color = handle.tri.color;
        this.bond(handle2, handle.getNeighborB());
        this.bond(handle3, handle.getNeighborC());
        this.bond(handle2.getHandleB(), handle3.getHandleC());
        this.bond(handle3.getHandleB(), handle.getHandleC());
        this.bond(handle.getHandleB(), handle2.getHandleC());
        handle2.setEdgeId(handle.getHandleB().getEdgeId());
        handle3.setEdgeId(handle.getHandleC().getEdgeId());
        handle.getHandleB().setUnconstrained();
        handle.getHandleC().setUnconstrained();
        handleArray[0] = handle2;
        handleArray[1] = handle3;
    }

    private void splitEdge(Handle handle, Vertex vertex, Handle[] handleArray) {
        Vertex vertex2 = handle.getB();
        Vertex vertex3 = handle.getC();
        Handle handle2 = handle.getNeighborA();
        Vertex vertex4 = handle2.getC();
        handle.setB(vertex);
        handle2.setA(vertex);
        Handle handle3 = this.newTriangle(vertex2, vertex3, vertex);
        Handle handle4 = this.newTriangle(vertex4, vertex2, vertex);
        handle3.tri.color = handle.tri.color;
        handle4.tri.color = handle2.tri.color;
        this.bond(handle3, handle.getNeighborB());
        this.bond(handle4, handle2.getNeighborC());
        this.bond(handle2.getHandleC(), handle4.getHandleC());
        this.bond(handle.getHandleB(), handle3.getHandleB());
        this.bond(handle3.getHandleC(), handle4.getHandleB());
        handle3.getHandleC().setEdgeId(handle.getEdgeId());
        handle4.getHandleB().setEdgeId(handle2.getEdgeId());
        handle3.setEdgeId(handle.getHandleB().getEdgeId());
        handle4.setEdgeId(handle2.getHandleC().getEdgeId());
        handle.getHandleB().setUnconstrained();
        handle2.getHandleC().setUnconstrained();
        handleArray[0] = handle3;
        handleArray[1] = handle4;
    }

    public Triangle findTriangleSlow(Point2d point2d) {
        for (Triangle triangle : this.d_tris) {
            Point2d point2d2 = triangle.v[0].pt;
            Point2d point2d3 = triangle.v[1].pt;
            Point2d point2d4 = triangle.v[2].pt;
            if (!(GeomTests.orient2d(point2d2, point2d3, point2d) > 0.0) || !(GeomTests.orient2d(point2d3, point2d4, point2d) > 0.0) || !(GeomTests.orient2d(point2d4, point2d2, point2d) > 0.0)) continue;
            return triangle;
        }
        return null;
    }

    public int findOutputTriangle(double d, double d2) {
        Triangle triangle = this.findTriangle(new Point2d(d, d2));
        if (triangle == null) {
            return -1;
        }
        this.updateOutputTris();
        int n = Arrays.binarySearch(this.d_resultTris, triangle.id - 1);
        return n < 0 ? -1 : n;
    }

    private Triangle findTriangle(Point2d point2d) {
        if (this.d_tris.isEmpty()) {
            return null;
        }
        Handle handle = new Handle(this.d_tris.get(0), 0);
        this.findTriangle(point2d, this.d_outside.getNeighborA(), handle);
        return handle.tri;
    }

    public int find(Point2d point2d) {
        Triangle triangle = this.findTriangle(point2d);
        if (triangle == null) {
            return -1;
        }
        return triangle.id - 1;
    }

    public int findTriangle(Point2d point2d, Handle handle, Handle handle2) {
        double d;
        if (handle == null) {
            while (this.SAMPLES * this.SAMPLES * this.SAMPLES < this.d_tris.size()) {
                ++this.SAMPLES;
            }
            double d2 = Double.MAX_VALUE;
            int n = 0;
            for (int i = 0; i < this.SAMPLES; ++i) {
                int n2 = (int)(this.d_random.nextDouble() * (double)this.d_tris.size());
                Point2d point2d2 = this.d_tris.get((int)n2).v[0].pt;
                d = point2d2.distance(point2d);
                if (!(d < d2)) continue;
                d2 = d;
                n = n2;
            }
            handle = new Handle(this.d_tris.get(n), 0);
            if (handle.getA().pt.equals(point2d)) {
                handle2.tri = handle.tri;
                handle2.orient = handle.orient;
                return 3;
            }
            if (handle.getB().pt.equals(point2d)) {
                handle = handle.getHandleB();
                handle2.tri = handle.tri;
                handle2.orient = handle.orient;
                return 3;
            }
        }
        Handle handle3 = handle;
        if (GeomTests.orient2d(handle3.getA().pt, handle3.getB().pt, point2d) < 0.0) {
            handle3 = handle3.getNeighborA();
        }
        do {
            Point2d point2d3 = handle3.getA().pt;
            Point2d point2d4 = handle3.getB().pt;
            Point2d point2d5 = handle3.getC().pt;
            if (point2d5.x == point2d.x && point2d5.y == point2d.y) {
                handle3 = handle3.getHandleC();
                handle2.tri = handle3.tri;
                handle2.orient = handle3.orient;
                return 3;
            }
            double d3 = GeomTests.orient2d(point2d5, point2d4, point2d);
            d = GeomTests.orient2d(point2d3, point2d5, point2d);
            boolean bl = false;
            if (d3 > 0.0) {
                if (d > 0.0) {
                    double d4 = (point2d5.x - point2d.x) * (point2d4.x - point2d3.x) + (point2d5.y - point2d.y) * (point2d4.y - point2d3.y);
                    if (d4 > 0.0) {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            } else if (d > 0.0) {
                bl = true;
            } else {
                if (d3 == 0.0) {
                    Handle handle4 = handle3.getHandleB();
                    handle2.tri = handle4.tri;
                    handle2.orient = handle4.orient;
                    return 2;
                }
                if (d == 0.0) {
                    Handle handle5 = handle3.getHandleC();
                    handle2.tri = handle5.tri;
                    handle2.orient = handle5.orient;
                    return 2;
                }
                handle2.tri = handle3.tri;
                handle2.orient = handle3.orient;
                return 1;
            }
            handle3 = bl ? handle3.getNeighborC() : handle3.getNeighborB();
        } while (handle3.tri != this.d_outside.tri);
        return 4;
    }

    public Triangle getOutputTriangle(int n) {
        this.updateOutputTris();
        return this.d_tris.get(this.d_resultTris[n]);
    }

    private void updateOutputTris() {
        if (this.d_resultTris != null) {
            return;
        }
        int[] nArray = new int[this.d_tris.size()];
        int n = 0;
        for (int i = 0; i < this.d_tris.size(); ++i) {
            Triangle triangle = this.d_tris.get(i);
            if (triangle.color == 0) continue;
            nArray[n++] = i;
        }
        this.d_resultTris = Arrays.copyOfRange(nArray, 0, n);
    }

    public TriangulatorInfo getOutput() {
        return this.getOutput(0);
    }

    public TriangulatorInfo getOutput(int n) {
        int n2;
        int n3;
        Object object;
        int n4;
        Object object2;
        int n52;
        TriangulatorInfo triangulatorInfo = new TriangulatorInfo();
        this.updateOutputTris();
        Point2d[] point2dArray = new Point2d[this.d_verts.size()];
        for (int n52 : this.d_resultTris) {
            object2 = this.d_tris.get(n52);
            for (n4 = 0; n4 < 3; ++n4) {
                object = ((Triangle)object2).v[n4];
                point2dArray[((Vertex)object).id - 1] = ((Vertex)object).pt;
            }
        }
        int n6 = 0;
        Point2d[] point2dArray2 = point2dArray;
        int n7 = point2dArray2.length;
        for (n52 = 0; n52 < n7; ++n52) {
            object2 = point2dArray2[n52];
            if (object2 == null) continue;
            ++n6;
        }
        int n8 = 0;
        triangulatorInfo.points = new Point2d[n6];
        int[] nArray = new int[point2dArray.length];
        for (n52 = 0; n52 < point2dArray.length; ++n52) {
            object2 = point2dArray[n52];
            if (object2 == null) continue;
            nArray[n52] = n4 = n8++;
            triangulatorInfo.points[n4] = object2;
        }
        ToIntFunction<Vertex> toIntFunction = vertex -> nArray[vertex.id - 1];
        boolean bl = (n & 2) != 0;
        triangulatorInfo.triangles = new int[this.d_resultTris.length * 3];
        triangulatorInfo.colors = bl ? new int[this.d_resultTris.length] : null;
        n4 = 0;
        object = this.d_resultTris;
        int n9 = ((Object)object).length;
        for (n3 = 0; n3 < n9; ++n3) {
            Object object3 = object[n3];
            Triangle triangle = this.d_tris.get((int)object3);
            if (bl) {
                triangulatorInfo.colors[n4 / 3] = triangle.color2;
            }
            for (int i = 0; i < 3; ++i) {
                triangulatorInfo.triangles[n4++] = toIntFunction.applyAsInt(triangle.v[i]);
            }
        }
        if ((n & 1) != 0) {
            triangulatorInfo.adjTris = new int[this.d_resultTris.length * 3];
            int n10 = 0;
            for (n9 = 0; n9 < this.d_resultTris.length; ++n9) {
                n3 = this.d_resultTris[n9];
                Triangle triangle = this.d_tris.get(n3);
                for (int i = 0; i < 3; ++i) {
                    Triangle triangle2;
                    Handle handle = triangle.tri[i];
                    Triangle triangle3 = triangle2 = handle != null ? handle.tri : null;
                    if (triangle2 == null || triangle2.color == 0) {
                        triangulatorInfo.adjTris[n10++] = -1;
                        continue;
                    }
                    n2 = Arrays.binarySearch(this.d_resultTris, triangle2.id - 1);
                    assert (n2 >= 0);
                    triangulatorInfo.adjTris[n10++] = n2;
                }
            }
        }
        if ((n & 4) != 0) {
            LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
            for (int n11 : this.d_resultTris) {
                Triangle triangle = this.d_tris.get(n11);
                for (int i = 0; i < 3; ++i) {
                    if (!triangle.isConstrained(i)) continue;
                    n2 = triangle.edgeIds[i];
                    Vertex vertex2 = triangle.v[i];
                    Vertex vertex3 = triangle.v[Handle.plus1mod3[i]];
                    Edge edge = new Edge(toIntFunction.applyAsInt(vertex2), toIntFunction.applyAsInt(vertex3), n2);
                    linkedHashSet.add(edge);
                }
            }
            triangulatorInfo.edges = new int[linkedHashSet.size() * 2];
            triangulatorInfo.edgeIds = new int[linkedHashSet.size()];
            int n12 = 0;
            n3 = 0;
            for (Edge edge : linkedHashSet) {
                triangulatorInfo.edges[n12++] = edge.v1;
                triangulatorInfo.edges[n12++] = edge.v2;
                triangulatorInfo.edgeIds[n3++] = edge.id;
            }
        }
        return triangulatorInfo;
    }

    public static void main(String[] stringArray) {
        LOGGER.log(Level.FINE, "Mesh...");
        Mesh mesh = new Mesh();
        mesh.oldTest();
    }

    public void writeMesh() {
        int n = 0;
        for (Triangle iterator : this.d_tris) {
            if (iterator.color < 1) continue;
            ++n;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("triangle.data")));
            printWriter.println(this.d_verts.size());
            for (Vertex vertex : this.d_verts) {
                printWriter.println(vertex.pt.x + ", " + vertex.pt.y);
            }
            printWriter.println(n);
            for (Triangle triangle : this.d_tris) {
                if (triangle.color < 1) continue;
                short s = triangle.color;
                if (triangle.isConstrained(0) || triangle.isConstrained(1) || triangle.isConstrained(2)) {
                    s = 1;
                }
                printWriter.println(triangle.v[0].id - 1 + " " + (triangle.v[1].id - 1) + " " + (triangle.v[2].id - 1) + " " + s);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
        }
    }

    public boolean checkDelaunay() {
        int n = 0;
        int n2 = 0;
        for (Triangle triangle : this.d_tris) {
            Point2d point2d;
            Handle handle = new Handle(triangle, 0);
            Point2d point2d2 = handle.getA().pt;
            Point2d point2d3 = handle.getB().pt;
            Point2d point2d4 = handle.getC().pt;
            Handle handle2 = handle.getNeighborA();
            if (handle2.isConstrained()) {
                ++n2;
            }
            if (handle2.tri != this.d_outside.tri && !handle2.isConstrained() && GeomTests.inCircle(point2d2, point2d3, point2d4, point2d = handle2.getC().pt) > 0.0) {
                ++n;
                LOGGER.log(Level.FINER, "non D: " + handle.getA().id + " " + handle.getB().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(point2d2, point2d3, point2d4, point2d));
            }
            if ((handle2 = handle.getNeighborB()).isConstrained()) {
                ++n2;
            }
            if (handle2.tri != this.d_outside.tri && !handle2.isConstrained() && GeomTests.inCircle(point2d2, point2d3, point2d4, point2d = handle2.getC().pt) > 0.0) {
                ++n;
                LOGGER.log(Level.FINER, "non D: " + handle.getB().id + " " + handle.getC().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(point2d2, point2d3, point2d4, point2d));
            }
            if ((handle2 = handle.getNeighborC()).isConstrained()) {
                ++n2;
            }
            if (handle2.tri != this.d_outside.tri && !handle2.isConstrained() && GeomTests.inCircle(point2d2, point2d3, point2d4, point2d = handle2.getC().pt) > 0.0) {
                ++n;
                LOGGER.log(Level.FINER, "non D: " + handle.getC().id + " " + handle.getA().id);
                LOGGER.log(Level.FINER, "" + GeomTests.inCircle(point2d2, point2d3, point2d4, point2d));
            }
            if (!(GeomTests.orient2d(point2d2, point2d3, point2d4) <= 0.0) && !(GeomTests.orient2d(point2d3, point2d4, point2d2) <= 0.0) && !(GeomTests.orient2d(point2d4, point2d2, point2d3) <= 0.0)) continue;
            LOGGER.log(Level.WARNING, "***** NEGATIVE AREA TRIANGLE ****");
        }
        if (n > 0) {
            LOGGER.log(Level.FINE, "non-Delaunay: ");
        }
        LOGGER.log(Level.FINE, "Constraints: " + n2 / 2);
        return n == 0;
    }

    @Test
    public void testHandle() {
        Vertex vertex = new Vertex(0.0, 0.0);
        Vertex vertex2 = new Vertex(1.0, 0.0);
        Vertex vertex3 = new Vertex(1.0, 1.0);
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        Handle handle = new Handle(triangle, 1);
        Assert.assertEquals((Object)vertex2, (Object)handle.getA());
        Assert.assertEquals((Object)vertex3, (Object)handle.getB());
        Assert.assertEquals((Object)vertex, (Object)handle.getC());
        handle = new Handle(triangle, 2);
        Assert.assertEquals((Object)vertex3, (Object)handle.getA());
        Assert.assertEquals((Object)vertex, (Object)handle.getB());
        Assert.assertEquals((Object)vertex2, (Object)handle.getC());
    }

    @Test
    public void testInit() {
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(1.0, 1.0);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        Mesh mesh = new Mesh();
        mesh.addPoints(arrayList);
        mesh.init();
        Assert.assertTrue((GeomTests.orient2d(mesh.d_infV1.pt, mesh.d_infV2.pt, mesh.d_infV3.pt) > 0.0 ? 1 : 0) != 0);
        Handle handle = mesh.d_outside.getNeighborA();
        Assert.assertTrue((boolean)this.sameHandle(mesh.d_outside, handle.getNeighborA()));
    }

    @Test
    public void testBond() {
        Vertex vertex = new Vertex(0.0, 0.0);
        Vertex vertex2 = new Vertex(1.0, 0.0);
        Vertex vertex3 = new Vertex(1.0, 1.0);
        Vertex vertex4 = new Vertex(0.0, 1.0);
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        Triangle triangle2 = new Triangle(vertex3, vertex4, vertex);
        Handle handle = new Handle(triangle, 2);
        Handle handle2 = new Handle(triangle2, 2);
        this.bond(handle, handle2);
        Assert.assertTrue((boolean)this.sameHandle(handle, triangle2.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle2, triangle.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle, handle.getNeighborA().getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(handle2, handle2.getNeighborA().getNeighborA()));
    }

    @Test
    public void testSplit1() {
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(1.0, 1.0);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        this.addPoints(arrayList);
        this.init();
        Handle handle = this.d_outside.getNeighborC();
        Vertex vertex = this.newVertex(0.5, 0.5);
        Handle[] handleArray = new Handle[2];
        this.split(handle, vertex, handleArray);
        Vertex vertex2 = this.d_infV1;
        Vertex vertex3 = this.d_infV2;
        Vertex vertex4 = this.d_infV3;
        Assert.assertTrue((boolean)this.hasVerts(handle, vertex2, vertex3, vertex));
        Assert.assertTrue((boolean)this.hasVerts(handleArray[0], vertex3, vertex4, vertex));
        Assert.assertTrue((boolean)this.hasVerts(handleArray[1], vertex4, vertex2, vertex));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside.getHandleC(), handle.getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside.getNeighborC(), handle));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside.getHandleB(), handleArray[0].getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside.getNeighborB(), handleArray[0]));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside, handleArray[1].getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(this.d_outside.getNeighborA(), handleArray[1]));
        Assert.assertTrue((boolean)this.sameHandle(handle.getHandleB(), handleArray[0].getNeighborC()));
        Assert.assertTrue((boolean)this.sameHandle(handle.getNeighborB(), handleArray[0].getHandleC()));
        Assert.assertTrue((boolean)this.sameHandle(handle.getHandleC(), handleArray[1].getNeighborB()));
        Assert.assertTrue((boolean)this.sameHandle(handle.getNeighborC(), handleArray[1].getHandleB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getHandleB(), handleArray[1].getNeighborC()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getNeighborB(), handleArray[1].getHandleC()));
    }

    @Test
    public void testSplit2() {
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(1.0, 1.0);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        this.addPoints(arrayList);
        this.init();
        Handle handle = this.d_outside.getNeighborC();
        Vertex vertex = this.newVertex(0.5, 0.5);
        Handle[] handleArray = new Handle[2];
        this.split(handle, vertex, handleArray);
        Vertex vertex2 = this.d_infV1;
        Vertex vertex3 = this.d_infV2;
        Vertex vertex4 = this.d_infV3;
        Handle handle2 = handleArray[0];
        Handle handle3 = handleArray[1];
        Point2d point2d4 = new Point2d();
        point2d4.sub(vertex3.pt, vertex.pt);
        point2d4.scale(0.005);
        Point2d point2d5 = new Point2d();
        point2d5.add(vertex.pt, point2d4);
        double d = GeomTests.orient2d(vertex3.pt, vertex.pt, point2d5);
        Assert.assertEquals((double)0.0, (double)d, (double)1.0E-9);
        Vertex vertex5 = this.newVertex(point2d5.x, point2d5.y);
        handle = handle.getHandleB();
        Handle handle4 = handle.getNeighborA();
        this.splitEdge(handle, vertex5, handleArray);
        Assert.assertTrue((boolean)this.sameHandle(handle4, handle2.getHandleC()));
        Assert.assertTrue((boolean)this.hasVerts(handle, vertex3, vertex5, vertex2));
        Assert.assertTrue((boolean)this.hasVerts(handle4, vertex5, vertex3, vertex4));
        Assert.assertTrue((boolean)this.hasVerts(handleArray[0], vertex, vertex2, vertex5));
        Assert.assertTrue((boolean)this.hasVerts(handleArray[1], vertex4, vertex, vertex5));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getHandleB(), handle.getNeighborB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getNeighborB(), handle.getHandleB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0], handle3.getNeighborB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getNeighborA(), handle3.getHandleB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[1], handle3.getNeighborC()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[1].getNeighborA(), handle3.getHandleC()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[1].getHandleC(), handle4.getNeighborC()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[1].getNeighborC(), handle4.getHandleC()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getHandleC(), handleArray[1].getNeighborB()));
        Assert.assertTrue((boolean)this.sameHandle(handleArray[0].getNeighborC(), handleArray[1].getHandleB()));
    }

    @Test
    public void testUnSwap() {
        Vertex vertex = new Vertex(0.0, 0.0);
        Vertex vertex2 = new Vertex(1.0, 0.0);
        Vertex vertex3 = new Vertex(1.0, 1.0);
        Vertex vertex4 = new Vertex(0.0, 1.0);
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        Triangle triangle2 = new Triangle(vertex3, vertex4, vertex);
        Handle handle = new Handle(triangle, 2);
        Handle handle2 = new Handle(triangle2, 2);
        this.bond(handle, handle2);
        Vertex vertex5 = new Vertex(5.0, -4.0);
        Vertex vertex6 = new Vertex(-4.0, 5.0);
        Triangle triangle3 = new Triangle(vertex2, vertex, vertex5);
        Triangle triangle4 = new Triangle(vertex3, vertex2, vertex5);
        Triangle triangle5 = new Triangle(vertex4, vertex3, vertex6);
        Triangle triangle6 = new Triangle(vertex, vertex4, vertex6);
        this.bond(handle.getHandleB(), new Handle(triangle3, 0));
        this.bond(handle.getHandleC(), new Handle(triangle4, 0));
        this.bond(handle2.getHandleB(), new Handle(triangle5, 0));
        this.bond(handle2.getHandleC(), new Handle(triangle6, 0));
        Assert.assertTrue((boolean)this.sameHandle(handle, triangle2.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle2, triangle.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle, handle.getNeighborA().getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(handle2, handle2.getNeighborA().getNeighborA()));
        this.swap2(handle);
        Assert.assertTrue((boolean)this.sameHandle(handle, triangle2.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle2, triangle.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle, handle.getNeighborA().getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(handle2, handle2.getNeighborA().getNeighborA()));
        this.unswap(handle);
        Assert.assertTrue((boolean)this.sameHandle(handle, triangle2.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle2, triangle.tri[2]));
        Assert.assertTrue((boolean)this.sameHandle(handle, handle.getNeighborA().getNeighborA()));
        Assert.assertTrue((boolean)this.sameHandle(handle2, handle2.getNeighborA().getNeighborA()));
        Assert.assertTrue((triangle.v[0] == vertex ? 1 : 0) != 0);
        Assert.assertTrue((triangle.v[1] == vertex2 ? 1 : 0) != 0);
        Assert.assertTrue((triangle.v[2] == vertex3 ? 1 : 0) != 0);
        Assert.assertTrue((triangle2.v[0] == vertex3 ? 1 : 0) != 0);
        Assert.assertTrue((triangle2.v[1] == vertex4 ? 1 : 0) != 0);
        Assert.assertTrue((triangle2.v[2] == vertex ? 1 : 0) != 0);
    }

    @Test
    public void testFind() {
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(1.0, 1.0);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        this.addPoints(arrayList);
        this.init();
        Point2d point2d4 = new Point2d(0.6, 0.6);
        Triangle triangle = this.findTriangle(point2d4);
        Assert.assertEquals((long)1L, (long)triangle.id);
        Handle handle = this.d_outside.getNeighborC();
        Vertex vertex = this.newVertex(0.5, 0.5);
        Handle[] handleArray = new Handle[2];
        this.split(handle, vertex, handleArray);
        Vertex vertex2 = this.d_infV2;
        triangle = this.findTriangle(point2d4);
        Assert.assertEquals((long)2L, (long)triangle.id);
        Point2d point2d5 = new Point2d();
        point2d5.sub(vertex2.pt, vertex.pt);
        point2d5.scale(0.005);
        Point2d point2d6 = new Point2d();
        point2d6.add(vertex.pt, point2d5);
        double d = GeomTests.orient2d(vertex2.pt, vertex.pt, point2d6);
        Assert.assertEquals((double)0.0, (double)d, (double)1.0E-9);
        Vertex vertex3 = this.newVertex(point2d6.x, point2d6.y);
        handle = handle.getHandleB();
        this.splitEdge(handle, vertex3, handleArray);
        triangle = this.findTriangle(point2d4);
        Assert.assertEquals((long)5L, (long)triangle.id);
        Handle handle2 = new Handle(this.d_tris.get(0), 0);
        int n = this.findTriangle(point2d4, this.d_outside.getNeighborA(), handle2);
        Assert.assertEquals((long)1L, (long)n);
        Assert.assertEquals((long)5L, (long)handle2.tri.id);
        point2d4 = new Point2d(0.4, 0.6);
        triangle = this.findTriangle(point2d4);
        Assert.assertEquals((long)3L, (long)triangle.id);
        n = this.findTriangle(point2d4, this.d_outside.getNeighborA(), handle2);
        Assert.assertEquals((long)1L, (long)n);
        Assert.assertEquals((long)3L, (long)handle2.tri.id);
    }

    @Test
    public void testTriangulate() {
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(1.0, 1.0);
        Point2d point2d4 = new Point2d(0.5, 0.5);
        Point2d point2d5 = new Point2d(0.7525, 0.2975);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        arrayList.add(point2d4);
        arrayList.add(point2d5);
        this.addPoints(arrayList);
        this.triangulateConvexHull(2);
        this.writeMesh();
    }

    @Test
    public void testBadTriangulation() {
        Point2d point2d = new Point2d(17.6f, 8.6f);
        Point2d point2d2 = new Point2d(17.6f, 9.6f);
        Point2d point2d3 = new Point2d(17.8f, 9.6f);
        Point2d point2d4 = new Point2d(17.8f, 8.6f);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(point2d);
        arrayList.add(point2d2);
        arrayList.add(point2d3);
        arrayList.add(point2d4);
        this.addPoints(arrayList);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 0);
        this.triangulateEvenOdd(2);
        this.writeMesh();
    }

    @Test
    public void testRandomBig() {
        Random random = new Random(246L);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < 1000; ++i) {
            double d = random.nextDouble();
            double d2 = random.nextDouble();
            arrayList.add(new Point2d(d, d2));
        }
        this.addPoints(arrayList);
        long l = System.nanoTime();
        this.triangulateConvexHull(2);
        long l2 = System.nanoTime();
        this.writeMesh();
        this.writeVoronoi();
        LOGGER.log(Level.FINE, 2.0E12 / (double)(l2 - l) + " tris/sec");
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void testRandomBigger() {
        Random random = new Random(12L);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d2 = random.nextDouble();
            arrayList.add(new Point2d(d, d2));
        }
        this.addPoints(arrayList);
        this.addEdge(14, 8);
        this.addEdge(4, 74);
        long l = System.nanoTime();
        this.triangulateConvexHull(3);
        long l2 = System.nanoTime();
        LOGGER.log(Level.FINE, 2.0E11 / (double)(l2 - l) + " tris/sec");
        LOGGER.log(Level.FINE, (double)(l2 - l) / 1.0E9 + " secs");
        this.writeMesh();
        this.writeVoronoi();
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void oldTest() {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(new Point2d(0.0, 0.0));
        arrayList.add(new Point2d(1.0, 0.0));
        arrayList.add(new Point2d(1.0, 1.0));
        arrayList.add(new Point2d(0.6, 1.0));
        arrayList.add(new Point2d(0.6, 0.7));
        arrayList.add(new Point2d(0.2, 0.7));
        arrayList.add(new Point2d(0.2, 0.8));
        arrayList.add(new Point2d(0.5, 0.8));
        arrayList.add(new Point2d(0.5, 1.0));
        arrayList.add(new Point2d(0.0, 1.0));
        arrayList.add(new Point2d(0.35, 0.6));
        arrayList.add(new Point2d(0.3, 0.9));
        arrayList.add(new Point2d(0.33, 0.6));
        arrayList.add(new Point2d(0.33, 0.65));
        arrayList.add(new Point2d(0.33, 0.71));
        arrayList.add(new Point2d(0.33, 0.75));
        arrayList.add(new Point2d(0.33, 0.81));
        arrayList.add(new Point2d(0.33, 0.85));
        arrayList.add(new Point2d(0.33, 0.9));
        arrayList.add(new Point2d(0.15, 0.77));
        arrayList.add(new Point2d(0.25, 0.77));
        arrayList.add(new Point2d(0.35, 0.77));
        arrayList.add(new Point2d(0.45, 0.77));
        arrayList.add(new Point2d(0.55, 0.77));
        arrayList.add(new Point2d(0.65, 0.77));
        arrayList.add(new Point2d(0.75, 0.77));
        arrayList.add(new Point2d(0.19, 0.77));
        arrayList.add(new Point2d(0.29, 0.77));
        arrayList.add(new Point2d(0.39, 0.77));
        arrayList.add(new Point2d(0.49, 0.77));
        arrayList.add(new Point2d(0.59, 0.77));
        arrayList.add(new Point2d(0.69, 0.77));
        arrayList.add(new Point2d(0.79, 0.77));
        arrayList.add(new Point2d(0.1, 0.1));
        arrayList.add(new Point2d(0.2, 0.2));
        arrayList.add(new Point2d(0.3, 0.3));
        arrayList.add(new Point2d(0.4, 0.4));
        arrayList.add(new Point2d(0.5, 0.5));
        arrayList.add(new Point2d(0.6, 0.6));
        arrayList.add(new Point2d(0.7, 0.7));
        arrayList.add(new Point2d(0.8, 0.8));
        arrayList.add(new Point2d(0.9, 0.9));
        this.addPoints(arrayList);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 4);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 7);
        this.addEdge(7, 8);
        this.addEdge(8, 9);
        this.addEdge(9, 0);
        long l = System.nanoTime();
        this.triangulateConvexHull(2);
        long l2 = System.nanoTime();
        LOGGER.log(Level.FINE, (double)(l2 - l) / 1.0E9 + " secs");
        this.colorTriangles();
        this.writeMesh();
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void testSquares() {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < 20; ++i) {
            double d = (double)i * 1.0 / 20.0;
            for (int j = 0; j < 20; ++j) {
                double d2 = (double)j * 1.0 / 20.0;
                arrayList.add(new Point2d(d, d2));
            }
        }
        this.addPoints(arrayList);
        long l = System.nanoTime();
        this.triangulateConvexHull(2);
        long l2 = System.nanoTime();
        this.writeMesh();
        this.writeVoronoi();
        LOGGER.log(Level.FINE, (double)(l2 - l) / 1.0E9 + " secs");
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void testSquaresHard() {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                double d = (double)i * 1.0 / 21.0 * 0.5 - (double)j * 1.0 / 21.0 * 0.5;
                double d2 = (double)j * 1.0 / 21.0 * 0.5 + (double)i * 1.0 / 21.0 * 0.5;
                arrayList.add(new Point2d(d, d2));
            }
        }
        this.addPoints(arrayList);
        long l = System.nanoTime();
        this.triangulateConvexHull(2);
        long l2 = System.nanoTime();
        this.writeMesh();
        this.writeVoronoi();
        LOGGER.log(Level.FINE, (double)(l2 - l) / 1.0E9 + " secs");
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void testQualityCheck() {
        Vertex vertex = new Vertex(0.0, 0.0);
        Vertex vertex2 = new Vertex(1.0, 0.0);
        Vertex vertex3 = new Vertex(1.0, 0.363);
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        Handle handle = new Handle(triangle, 0);
        this.checkQuality(new PriorityQueue<QTri>(), handle);
    }

    @Test
    public void testEncroach() {
        Point2d point2d = new Point2d(-1.0, 0.0);
        Point2d point2d2 = new Point2d(1.0, 0.0);
        Point2d point2d3 = new Point2d(0.0, 1.1);
        Point2d point2d4 = new Point2d(0.0, 0.9);
        Assert.assertEquals((long)0L, (long)this.encroachSeg(point2d, point2d2, point2d3));
        Assert.assertEquals((long)1L, (long)this.encroachSeg(point2d, point2d2, point2d4));
    }

    public void testFindVertex() {
        for (int i = 0; i < 100; ++i) {
            Mesh mesh = new Mesh();
            Random random = new Random(12L);
            ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
            for (int j = 0; j < 100; ++j) {
                double d = random.nextDouble();
                double d2 = random.nextDouble();
                arrayList.add(new Point2d(d, d2));
            }
            mesh.addPoints(arrayList);
            mesh.triangulateEvenOdd(0);
            Handle handle = new Handle(mesh.d_tris.get(0), 0);
            Assert.assertEquals((long)3L, (long)mesh.findTriangle(mesh.d_verts.get((int)5).pt, null, handle));
        }
    }

    private boolean sameHandle(Handle handle, Handle handle2) {
        return handle.tri == handle2.tri && handle.orient == handle2.orient;
    }

    private boolean hasVerts(Handle handle, Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return handle.getA() == vertex && handle.getB() == vertex2 && handle.getC() == vertex3;
    }

    @Test
    public void testPathfinderCase() {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        arrayList.add(new Point2d(0.2999999999999999, 12.499999999999972));
        arrayList.add(new Point2d(7.19999999999999, 13.899999999999967));
        arrayList.add(new Point2d(7.0, 15.700000000000001));
        arrayList.add(new Point2d(6.9, 15.700000000000001));
        arrayList.add(new Point2d(6.9, 15.600000000000001));
        arrayList.add(new Point2d(6.800000000000001, 15.600000000000001));
        arrayList.add(new Point2d(6.800000000000001, 15.5));
        arrayList.add(new Point2d(6.7, 15.5));
        arrayList.add(new Point2d(6.7, 15.4));
        arrayList.add(new Point2d(6.5, 15.200000000000001));
        arrayList.add(new Point2d(6.4, 15.200000000000001));
        arrayList.add(new Point2d(6.4, 13.9));
        arrayList.add(new Point2d(6.0, 13.8));
        arrayList.add(new Point2d(4.300000000000001, 13.412974480139912));
        arrayList.add(new Point2d(1.1, 13.339647712875216));
        arrayList.add(new Point2d(1.1000000000000003, 13.799999999999967));
        arrayList.add(new Point2d(3.5000000000000018, 13.799999999999967));
        arrayList.add(new Point2d(5.800000000000001, 13.9));
        arrayList.add(new Point2d(0.09999999999999964, 13.9));
        this.addPoints(arrayList);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 4);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 7);
        this.addEdge(7, 8);
        this.addEdge(8, 9);
        this.addEdge(9, 10);
        this.addEdge(10, 11);
        this.addEdge(11, 12);
        this.addEdge(12, 13);
        this.addEdge(13, 14);
        this.addEdge(14, 15);
        this.addEdge(15, 16);
        this.addEdge(16, 17);
        this.addEdge(17, 18);
        this.addEdge(18, 0);
        Assert.assertTrue((boolean)this.triangulateConvexHull(2));
        this.writeMesh();
        this.writeVoronoi();
        Assert.assertTrue((boolean)this.checkDelaunay());
    }

    @Test
    public void testRefine() {
        Mesh mesh = new Mesh();
        mesh.addPoint(0.0, 0.0);
        mesh.addPoint(0.0, 0.1);
        mesh.addPoint(0.0, 0.25);
        mesh.addPoint(0.0, 0.5);
        mesh.addPoint(0.0, 1.0);
        mesh.addPoint(0.5, 1.0);
        mesh.addPoint(1.0, 1.0);
        mesh.addPoint(1.0, 0.5);
        mesh.addPoint(0.75, 0.25);
        mesh.addPoint(0.5, 0.0);
        mesh.addPoint(0.25, 0.0);
        mesh.addPoint(0.1, 0.0);
        mesh.addPoint(0.5, 0.5);
        mesh.addPoint(0.51, 0.5);
        mesh.addPoint(0.375, 0.075);
        mesh.addEdge(0, 1);
        mesh.addEdge(1, 2);
        mesh.addEdge(2, 3);
        mesh.addEdge(3, 4);
        mesh.addEdge(4, 5);
        mesh.addEdge(5, 6);
        mesh.addEdge(6, 7);
        mesh.addEdge(7, 8);
        mesh.addEdge(8, 9);
        mesh.addEdge(9, 10);
        mesh.addEdge(10, 11);
        mesh.addEdge(11, 0);
        mesh.setMinAngle(20.0);
        mesh.setMaxArea(0.01);
        mesh.triangulateConvexHull(3);
        mesh.writeMesh();
        Assert.assertTrue((boolean)mesh.checkDelaunay());
        mesh.writeVoronoi();
    }

    @Test
    public void testPetraSim01() {
        this.addPoint(652700.0, 5535000.0);
        this.addPoint(653510.0, 5535000.0);
        this.addPoint(653510.0, 5535890.0);
        this.addPoint(652700.0, 5535890.0);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 0);
        this.setMaxArea(1000.0);
        this.triangulateEvenOdd(3);
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeMesh();
        this.writeVoronoi();
    }

    @Test
    public void testPetraSim02() {
        this.addPoint(-500.0, 0.0);
        this.addPoint(500.0, 0.0);
        this.addPoint(500.0, 500.0);
        this.addPoint(320.0, 150.0);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 0);
        this.setMaxArea(500.0);
        this.setMinAngle(20.0);
        this.triangulateEvenOdd(3, 30.0);
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeMesh();
        this.writeVoronoi();
    }

    @Test
    public void testPetraSim03() {
        this.addPoint(-500.0, 0.0);
        this.addPoint(500.0, 0.0);
        this.addPoint(500.0, 500.0);
        this.addPoint(380.0, 110.0);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 0);
        this.setMinAngle(20.0);
        this.triangulateEvenOdd(3, 20.0);
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeMesh();
        this.writeVoronoi();
    }

    @Test
    public void testPetraSim04() {
        this.addPoint(-500.0, 0.0);
        this.addPoint(500.0, 0.0);
        this.addPoint(500.0, 500.0);
        this.addPoint(-110.0, 210.0);
        this.addPoint(-500.0, 500.0);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 4);
        this.addEdge(4, 0);
        this.setMaxArea(1000.0);
        this.setMinAngle(20.0);
        this.triangulateEvenOdd(3, 20.0);
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeMesh();
        this.writeVoronoi();
    }

    @Test
    public void testSmallAngles() {
        this.addPoint(-10.0, 0.0);
        this.addPoint(10.0, 0.0);
        this.addPoint(10.0, 1.0);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 0);
        this.triangulateEvenOdd(3, 1.0);
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeMesh();
        this.writeVoronoi();
    }

    @Test
    public void testEncroachSplit() {
        this.addPoint(0.0, 0.0);
        this.addPoint(0.2, 0.0);
        this.addPoint(0.4, 0.0);
        this.addPoint(0.6, 0.0);
        this.addPoint(0.8, 0.0);
        this.addPoint(0.0, 0.2);
        this.addPoint(0.2, 0.2);
        this.addPoint(0.4, 0.2);
        this.addPoint(0.6, 0.2);
        this.addPoint(0.8, 0.2);
        this.addPoint(0.0, 0.1);
        this.addPoint(0.8, 0.1);
        this.addEdge(10, 11);
        this.triangulateConvexHull(3);
        this.writeMesh();
        Assert.assertTrue((boolean)this.checkDelaunay());
        this.writeVoronoi();
    }

    private static class QEdge {
        public Handle tri;
        public Vertex a;
        public Vertex b;

        public QEdge(Handle handle, Vertex vertex, Vertex vertex2) {
            this.tri = handle;
            this.a = vertex;
            this.b = vertex2;
        }
    }

    private static class QTri
    implements Comparable {
        public Triangle tri;
        public Vertex a;
        public Vertex b;
        public Vertex c;
        public double key;

        public QTri(Triangle triangle, Vertex vertex, Vertex vertex2, Vertex vertex3, double d) {
            this.tri = triangle;
            this.a = vertex;
            this.b = vertex2;
            this.c = vertex3;
            this.key = d;
        }

        public int compareTo(Object object) {
            double d = this.key - ((QTri)object).key;
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static class Handle {
        static final int[] plus1mod3 = new int[]{1, 2, 0};
        static final int[] plus2mod3 = new int[]{2, 0, 1};
        public Triangle tri;
        public int orient;

        public Handle() {
            this(null, 0);
        }

        public Handle(Triangle triangle, int n) {
            this.tri = triangle;
            this.orient = n;
        }

        public Handle(Handle handle) {
            this.tri = handle.tri;
            this.orient = handle.orient;
        }

        public Vertex getA() {
            return this.tri.v[this.orient];
        }

        public Vertex getB() {
            return this.tri.v[plus1mod3[this.orient]];
        }

        public Vertex getC() {
            return this.tri.v[plus2mod3[this.orient]];
        }

        public void setA(Vertex vertex) {
            this.tri.v[this.orient] = vertex;
        }

        public void setB(Vertex vertex) {
            this.tri.v[Handle.plus1mod3[this.orient]] = vertex;
        }

        public void setC(Vertex vertex) {
            this.tri.v[Handle.plus2mod3[this.orient]] = vertex;
        }

        public Handle getNeighborA() {
            return this.tri.tri[this.orient];
        }

        public Handle getNeighborB() {
            return this.tri.tri[plus1mod3[this.orient]];
        }

        public Handle getNeighborC() {
            return this.tri.tri[plus2mod3[this.orient]];
        }

        public void setNeighborA(Handle handle) {
            this.tri.tri[this.orient] = new Handle(handle);
        }

        public void setNeighborB(Handle handle) {
            this.tri.tri[Handle.plus1mod3[this.orient]] = new Handle(handle);
        }

        public void setNeighborC(Handle handle) {
            this.tri.tri[Handle.plus2mod3[this.orient]] = new Handle(handle);
        }

        public Handle getHandleB() {
            return new Handle(this.tri, plus1mod3[this.orient]);
        }

        public Handle getHandleC() {
            return new Handle(this.tri, plus2mod3[this.orient]);
        }

        public void setEdgeId(int n) {
            this.tri.edgeIds[this.orient] = n;
        }

        public int getEdgeId() {
            return this.tri.edgeIds[this.orient];
        }

        public void setUnconstrained() {
            this.tri.edgeIds[this.orient] = 0;
        }

        public boolean isConstrained() {
            return this.getEdgeId() != 0;
        }
    }

    public static class Edge {
        public int v1;
        public int v2;
        public final int id;

        public Edge(int n, int n2, int n3) {
            this.v1 = n;
            this.v2 = n2;
            this.id = n3;
        }

        public int hashCode() {
            return 0x23498F ^ this.v1 + this.v2 + this.id;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.id == edge.id && (this.v1 == edge.v1 && this.v2 == edge.v2 || this.v1 == edge.v2 && this.v2 == edge.v1);
        }

        public String toString() {
            return "[Edge: " + (this.v1 - 1) + " -> " + (this.v2 - 1) + "]";
        }
    }

    public static class Triangle {
        public int id = -1;
        public Vertex[] v = new Vertex[3];
        public Handle[] tri = new Handle[3];
        public int[] edgeIds = new int[3];
        public short color = (short)-1;
        public int color2 = -1;

        public Triangle(Vertex vertex, Vertex vertex2, Vertex vertex3) {
            this.v[0] = vertex;
            this.v[1] = vertex2;
            this.v[2] = vertex3;
            Arrays.fill(this.edgeIds, 0);
        }

        public Point2d centroid() {
            return Mesh.centroid(this.v[0].pt, this.v[1].pt, this.v[2].pt);
        }

        public boolean isConstrained(int n) {
            return this.edgeIds[n] != 0;
        }
    }

    public static class Vertex {
        public int id = -1;
        public Point2d pt;
        public double maxArea;

        public Vertex(double d, double d2) {
            this(d, d2, Double.MAX_VALUE);
        }

        public Vertex(double d, double d2, double d3) {
            this.pt = new Point2d(d, d2);
            this.maxArea = d3;
        }

        public String toString() {
            return this.pt.toString();
        }
    }
}

