/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.out;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.DataOutputProxy;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.LinkedIdentityHashMap;

public class TeciGeomWriter {
    private static final Logger LOGGER = Logger.getLogger(TeciGeomWriter.class.getName());

    public static void writeVis(File file, Options options, Collection<? extends IObject> collection, Collection<? extends BGImage> collection2) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            dataOutputStream.writeInt(Version.curr().value());
            TeciGeomWriter.writeBGImages(file, dataOutputStream, collection2);
            TeciGeomWriter.writeGeom(file, dataOutputStream, options, collection);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static String writeImage(File file, String string, IImage iImage) {
        File file2 = new File(iImage.getFilename());
        String string2 = file2.getName();
        File file3 = new File(file, string2);
        int n = 1;
        if (!file3.exists()) {
            LOGGER.log(Level.INFO, String.format("Saving image %s...", string2));
            iImage.save(file3.getAbsolutePath(), n);
            LOGGER.log(Level.INFO, "Done");
        } else if (TeciGeomWriter.getWriteAlternateImage(iImage, file3)) {
            String string3 = String.format("%d-%dx%d.png", string.hashCode(), iImage.getWidth(), iImage.getHeight());
            file3 = new File(file, string3);
            LOGGER.log(Level.INFO, String.format("A file called \"%s\" already exists! Using alternate name \"%s\"%n", string2, string3));
            iImage.save(file3.getPath(), n);
            string2 = string3;
        }
        return string2;
    }

    private static boolean getWriteAlternateImage(IImage iImage, File file) {
        String string = file.getPath();
        IStreamSrc iStreamSrc = FileSystem.INSTANCE.getStreamSrc(string, 3);
        try {
            Image image = Image.load(string, iStreamSrc);
            if (new HashableImage(image).equals(image)) {
                LOGGER.log(Level.INFO, String.format("Image \"%s\" already exists and is equal. Write skipped.%n", file.getName()));
                return false;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
        }
        return true;
    }

    private static void writeBGImages(File file, DataOutputStream dataOutputStream, Collection<? extends BGImage> collection) throws IOException {
        File file2 = file.getParentFile();
        dataOutputStream.writeInt(collection.size());
        for (BGImage bGImage : collection) {
            String string = TeciGeomWriter.writeImage(file2, bGImage.getName(), bGImage.getImage());
            Matrix4d matrix4d = bGImage.getLWXform();
            TeciGeomWriter.writeString(dataOutputStream, string);
            dataOutputStream.writeFloat(bGImage.getOpacity());
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dataOutputStream.writeFloat((float)matrix4d.getElement(i, j));
                }
            }
        }
    }

    private static void writeGeom(File file, DataOutputStream dataOutputStream, Options options, Collection<? extends IObject> collection) throws IOException {
        Object object;
        Object object2;
        dataOutputStream.writeInt(GeomWriter.CURR_VERSION);
        LinkedIdentityHashMap<IMaterial, Integer> linkedIdentityHashMap = new LinkedIdentityHashMap<IMaterial, Integer>();
        IdentityHashMap<IObject, DisplayGeom> identityHashMap = new IdentityHashMap<IObject, DisplayGeom>();
        for (IObject object32 : collection) {
            object2 = identityHashMap.computeIfAbsent(object32, IObject::getDisplay);
            Iterator<? extends IObject> iterator = ((DisplayGeom)object2).node;
            IPropsSrc iPropsSrc = ((DisplayGeom)object2).props;
            int n = iterator.getNumPrims(7);
            for (int i = 0; i < n; ++i) {
                Integer n2;
                object = iPropsSrc.get(i);
                IMaterial iMaterial = object.getMaterial();
                if (iMaterial == null || (n2 = (Integer)linkedIdentityHashMap.get(iMaterial)) != null) continue;
                n2 = linkedIdentityHashMap.size();
                linkedIdentityHashMap.put(iMaterial, n2);
            }
        }
        File file2 = file.getParentFile();
        dataOutputStream.flush();
        MatlWriter matlWriter = new MatlWriter(dataOutputStream, file2);
        matlWriter.writeInt(linkedIdentityHashMap.size());
        for (Iterator<? extends IObject> iterator : linkedIdentityHashMap.keySet()) {
            GeomWriter.write((ObjectOutput)matlWriter, (IMaterial)((Object)iterator));
        }
        matlWriter.flush();
        dataOutputStream.flush();
        object2 = new MatlRefWriter(dataOutputStream, linkedIdentityHashMap);
        ((DataOutputProxy)object2).writeInt(identityHashMap.size());
        for (IObject iObject : collection) {
            DisplayGeom displayGeom = identityHashMap.computeIfAbsent(iObject, IObject::getDisplay);
            ((DataOutputProxy)object2).writeInt(iObject.getType().ordinal());
            TeciGeomWriter.writeString((DataOutput)object2, iObject.getName());
            Collection<Integer> collection2 = iObject.getFDSRepIds();
            ((DataOutputProxy)object2).writeInt(collection2.size());
            object = collection2.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                ((DataOutputProxy)object2).writeInt(n);
            }
            GeomWriter.write((ObjectOutput)object2, displayGeom.node, displayGeom.props, options.displayEdgeError, options.displayFaceError);
        }
        ((ObjectWriter)object2).flush();
    }

    private static void writeColor(DataOutput dataOutput, Color color) throws IOException {
        dataOutput.writeByte(color.getRed());
        dataOutput.writeByte(color.getGreen());
        dataOutput.writeByte(color.getBlue());
        dataOutput.writeByte(color.getAlpha());
    }

    private static void writeString(DataOutput dataOutput, String string) throws IOException {
        IOUtil.writeUTF8(dataOutput, string);
    }

    private static class MatlRefWriter
    extends ObjectWriter {
        private final Map<IMaterial, Integer> d_matIds;

        public MatlRefWriter(DataOutput dataOutput, Map<IMaterial, Integer> map) {
            super(dataOutput);
            this.d_matIds = map;
        }

        @Override
        public void writeObject(Object object) throws IOException {
            if (object == null) {
                this.writeInt(-1);
            } else {
                assert (object instanceof IMaterial);
                IMaterial iMaterial = (IMaterial)object;
                Integer n = this.d_matIds.get(iMaterial);
                assert (n != null);
                this.writeInt(n);
            }
        }
    }

    private static class MatlWriter
    extends ObjectWriter {
        private final File d_outDir;

        public MatlWriter(DataOutput dataOutput, File file) {
            super(dataOutput);
            this.d_outDir = file;
        }

        @Override
        public void writeObject(Object object) throws IOException {
            this.writeBoolean(object != null);
            if (object == null) {
                return;
            }
            if (object instanceof IMatAttrs) {
                GeomWriter.write((ObjectOutput)this, (IMatAttrs)object);
            } else if (object instanceof Texture) {
                GeomWriter.write((ObjectOutput)this, (Texture)object);
            } else if (object instanceof IImage) {
                IImage iImage = (IImage)object;
                String string = new File(iImage.getFilename()).getName();
                String string2 = TeciGeomWriter.writeImage(this.d_outDir, string, iImage);
                TeciGeomWriter.writeString(this.getOutput(), string2);
            } else assert (false);
        }
    }

    private static abstract class ObjectWriter
    extends DataOutputProxy
    implements ObjectOutput {
        public ObjectWriter(DataOutput dataOutput) {
            super(dataOutput);
        }

        @Override
        public void flush() throws IOException {
            if (this.getOutput() instanceof Flushable) {
                ((Flushable)((Object)this.getOutput())).flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.getOutput() instanceof Closeable) {
                ((Closeable)((Object)this.getOutput())).close();
            }
        }
    }

    public static class DefaultObj
    implements IObject {
        public final DisplayGeom geom;
        public final Type type;
        public final Collection<Integer> fdsRepIds;
        public final String name;

        public DefaultObj(Type type, String string, DisplayGeom displayGeom, Collection<Integer> collection) {
            this.geom = displayGeom;
            this.type = type;
            this.fdsRepIds = collection;
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DisplayGeom getDisplay() {
            return this.geom;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Collection<Integer> getFDSRepIds() {
            return this.fdsRepIds;
        }
    }

    public static interface IObject {
        public Type getType();

        public String getName();

        public DisplayGeom getDisplay();

        public Collection<Integer> getFDSRepIds();
    }

    public static enum Type {
        FDS_OBST(true),
        FDS_VENT(true),
        FDS_MESH(true),
        GENERIC(false);

        public final boolean fds;

        private Type(boolean bl) {
            this.fds = bl;
        }
    }

    public static interface BGImage {
        public Matrix4d getLWXform();

        public float getOpacity();

        public String getName();

        public IImage getImage();
    }

    public static class Options {
        public final double displayEdgeError;
        public final double displayFaceError;

        public Options(double d, double d2) {
            this.displayEdgeError = d;
            this.displayFaceError = d2;
        }
    }

    public static enum Version {
        V0001,
        V0002,
        V0003,
        V0004;


        static Version curr() {
            return Version.values()[Version.values().length - 1];
        }

        public int value() {
            return this.ordinal() + 1;
        }
    }
}

