/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.ImportConst;
import thunderheadeng.cad.in.UnitPanel;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class UnitsPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final IPropertySet.Prop<Supplier<AABox>> BOUNDS = new IPropertySet.Prop<Supplier<AABox>>("BoundsPnl.BOUNDS", () -> new AABox());
    public static final IPropertySet.Prop<Boolean> DEFER_BOUNDS = new IPropertySet.Prop<Boolean>("BoundsPnl.DEFER_BOUNDS", true);
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(BOUNDS, DEFER_BOUNDS, IGeomImportSession.SRC_LENGTH_UNIT);
    private final UnitPanel d_unitPnl;

    public UnitsPnl(IUnitSrc iUnitSrc, boolean bl) {
        this.d_unitPnl = new UnitPanel(bl, iUnitSrc, ImportConst.UNITS_VALUE.values());
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.addRow(this.d_unitPnl, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
    }

    public static void initProps(IPropertySet iPropertySet, String string, CadImporter cadImporter) {
        boolean bl = false;
        if (cadImporter.isBoundsSlow()) {
            long l = 0x500000L;
            long l2 = new File(string).length();
            bl = l2 > l;
        }
        Supplier<AABox> supplier = () -> {
            System.out.println("Calculating bounding box...");
            theTimer theTimer2 = new theTimer();
            AABox aABox = cadImporter.getModelBounds();
            System.out.printf("Done (%g s)%n", theTimer2.curr());
            return aABox;
        };
        supplier = theUtil.cached(supplier);
        iPropertySet.setIfNotDefault(DEFER_BOUNDS, bl);
        iPropertySet.set(BOUNDS, supplier);
        iPropertySet.setIfNotDefault(IGeomImportSession.SRC_LENGTH_UNIT, ImportConst.UNITS_VALUE.get(cadImporter.getLengthUnit()));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(IPropertySet iPropertySet) {
        this.d_unitPnl.load(iPropertySet.get(DEFER_BOUNDS), iPropertySet.get(BOUNDS));
        this.d_unitPnl.setUnit(iPropertySet.get(IGeomImportSession.SRC_LENGTH_UNIT));
    }

    @Override
    public IPropertySet commit(IPropertySet iPropertySet) {
        iPropertySet.setIfNotDefault(IGeomImportSession.SRC_LENGTH_UNIT, this.d_unitPnl.getUnit());
        return iPropertySet;
    }
}

