/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class UnitPanel
extends guiPanel {
    private static final Unit CUSTOM_UNIT = Unit.ONE.alternate(Intl.intl("Custom"));
    private final guiComboBox<Unit> d_unitsCB;
    private final guiLabel d_widthLbl;
    private final guiLabel d_heightLbl;
    private final guiLabel d_depthLbl;
    private final ValueField<UnitDouble> d_customUnitFld;
    private final HTMLLabel d_calcBoundsLbl;
    private boolean d_boundsCalculated;
    private AABox d_modelBounds;
    private final IUnitSrc d_displayLengthUnit;
    private Unit d_defUnit;
    private final guiPanel d_boundsPnl;

    public UnitPanel(boolean bl, IUnitSrc iUnitSrc, Collection<? extends Unit> collection) {
        super(new GridBagLayout());
        this.d_displayLengthUnit = iUnitSrc;
        this.d_boundsCalculated = false;
        this.d_modelBounds = new AABox();
        ArrayList<? extends Unit> arrayList = new ArrayList<Unit>(collection);
        arrayList.add(CUSTOM_UNIT);
        this.d_customUnitFld = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), SI.METER, iUnitSrc);
        final guiLabel guiLabel2 = new guiLabel(Intl.intl("1 model unit = "));
        this.d_widthLbl = new guiLabel();
        this.d_heightLbl = new guiLabel();
        this.d_depthLbl = new guiLabel();
        this.d_calcBoundsLbl = new HTMLLabel("<a href='calc'>" + Intl.intl("Calculate") + "</a>");
        this.d_calcBoundsLbl.setOpenLinksAsWebpages(false);
        this.d_calcBoundsLbl.setToolTipText(Intl.intl("[May be a long operation] This is useful for determining the length unit if <unknown>."));
        this.d_unitsCB = new guiComboBox<Unit>((Collection<? extends Unit>)arrayList);
        this.d_unitsCB.setRenderer(new DefaultListCellRenderer(){
            final Font plain = this.getFont();
            final Font bold = this.getFont().deriveFont(1);

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Unit unit = (Unit)object;
                Font font = this.plain;
                if (unit != null) {
                    string = unit.toString();
                    if (theUtil.equal(UnitPanel.this.d_defUnit, unit)) {
                        font = this.bold;
                    }
                } else {
                    string = Intl.intl("<unknown>");
                }
                this.setText(string);
                this.setFont(font);
                return this;
            }
        });
        this.d_unitsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1 && itemEvent.getItem() == CUSTOM_UNIT;
                guiLabel2.setVisible(bl);
                UnitPanel.this.d_customUnitFld.setVisible(bl);
                UnitPanel.this.updateBoundsLbl(UnitPanel.this.d_boundsCalculated, UnitPanel.this.d_modelBounds);
                if (bl) {
                    UnitPanel.this.repack();
                }
            }
        });
        this.d_customUnitFld.addValueChangeListener(propertyChangeEvent -> this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds));
        this.d_boundsPnl = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(this.d_boundsPnl);
        gridBagHelper.addRow(Intl.intl("[Model Bounds Preview]"));
        gridBagHelper.indent();
        gridBagHelper.addRow(this.d_calcBoundsLbl, 0);
        gridBagHelper.addRow(this.d_widthLbl, 0);
        gridBagHelper.addRow(this.d_depthLbl, 0);
        gridBagHelper.addRow(this.d_heightLbl, 0);
        gridBagHelper.unindent();
        gridBagHelper.finalizeRows();
        gridBagHelper = new GridBagHelper(this);
        String string = bl ? Intl.intl("What is the file's length unit?") : Intl.intl("Length Unit:");
        gridBagHelper.addRow(string, 0);
        gridBagHelper.addIdentRow(this.d_unitsCB, guiLabel2, this.d_customUnitFld, 1.0, 0);
        gridBagHelper.addFilledRow(this.d_boundsPnl);
        gridBagHelper.finalizeRows();
        this.setCustomVisible(false, guiLabel2, this.d_customUnitFld);
    }

    public void load(AABox aABox) {
        this.load(false, () -> aABox);
    }

    public void load(boolean bl, final Supplier<AABox> supplier) {
        if (bl) {
            final HTMLLabel hTMLLabel = this.d_calcBoundsLbl;
            hTMLLabel.setVisible(true);
            hTMLLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    UnitPanel.this.beginWaitCursor();
                    UnitPanel.this.d_modelBounds = (AABox)supplier.get();
                    UnitPanel.this.d_boundsCalculated = true;
                    UnitPanel.this.endWaitCursor();
                    UnitPanel.this.updateBoundsLbl(UnitPanel.this.d_boundsCalculated, UnitPanel.this.d_modelBounds);
                    hTMLLabel.setVisible(false);
                    UnitPanel.this.d_widthLbl.setVisible(true);
                    UnitPanel.this.d_depthLbl.setVisible(true);
                    UnitPanel.this.d_heightLbl.setVisible(true);
                    UnitPanel.this.repack();
                }
            });
            this.d_widthLbl.setVisible(false);
            this.d_depthLbl.setVisible(false);
            this.d_heightLbl.setVisible(false);
        } else {
            this.d_calcBoundsLbl.setVisible(false);
            this.d_modelBounds = supplier.get();
            this.d_boundsCalculated = true;
        }
        this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds);
    }

    private void repack() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.pack();
        }
    }

    private void setCustomVisible(boolean bl, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setVisible(bl);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_unitsCB.getSelectedItem() == null) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this), Intl.intl("Select a unit from the list."));
            }
            return false;
        }
        return true;
    }

    public void setUnit(Unit unit) {
        this.d_defUnit = unit;
        this.d_unitsCB.setSelectedItem(unit);
        this.updateBoundsLbl(this.d_boundsCalculated, this.d_modelBounds);
    }

    public Unit getUnit() {
        return this.getSourceLengthUnit();
    }

    private static String toString(double d, Unit unit, Unit unit2) {
        return Global.format(UnitDouble.convert(d, unit, unit2)) + " " + unit2.toString();
    }

    private void updateBoundsLbl(boolean bl, AABox aABox) {
        String string;
        String string2;
        String string3;
        if (aABox == null) {
            return;
        }
        if (bl && !aABox.isValid()) {
            this.d_boundsPnl.setVisible(false);
            return;
        }
        this.d_boundsPnl.setVisible(true);
        Unit unit = this.getSourceLengthUnit();
        Unit unit2 = this.d_displayLengthUnit.getUnit();
        if (unit == null) {
            string2 = string3 = "? " + unit2.toString();
            string = string3;
        } else {
            Point3d point3d = aABox.getMin();
            Point3d point3d2 = aABox.getMax();
            string = UnitPanel.toString(point3d2.x - point3d.x, unit, unit2);
            string2 = UnitPanel.toString(point3d2.y - point3d.y, unit, unit2);
            string3 = UnitPanel.toString(point3d2.z - point3d.z, unit, unit2);
        }
        this.d_widthLbl.setText(String.format(Intl.intl("Model Width:  %s"), string));
        this.d_depthLbl.setText(String.format(Intl.intl("Model Depth:  %s"), string2));
        this.d_heightLbl.setText(String.format(Intl.intl("Model Height: %s"), string3));
        this.repack();
    }

    private Unit getSourceLengthUnit() {
        Unit unit = this.d_unitsCB.getSelectedItem();
        if (unit != CUSTOM_UNIT) {
            return unit;
        }
        if (!this.d_customUnitFld.validateData(false, false)) {
            return null;
        }
        UnitDouble unitDouble = (UnitDouble)this.d_customUnitFld.getValue();
        return unitDouble.getUnit().multiply(unitDouble.getValueNoUnit()).alias(Intl.intl("Custom"));
    }
}

